/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import org.jscience.physics.units.SI;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AImprintTask;
import pyrosim.legacy_2006_2.domain.ASetNameTask;
import pyrosim.legacy_2006_2.domain.AbstractActivationEventList;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.ActivationEvent;
import pyrosim.legacy_2006_2.domain.ActivationEventList;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FireEventTask;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class AbstractFDSObject
extends KeyableObject
implements FDSObject,
Activatable,
Serializable,
Cloneable,
IDependent {
    static final long serialVersionUID = 1L;
    private String d_name;
    protected Vector<IFace> d_faces;
    private Color d_color = null;
    private boolean d_visible = true;
    private transient boolean d_selected;
    private transient ADomainObject<PyroMod> d_domainHelper = new ADomainObject();
    private Vector<ActivationEventList> d_vAllEvents = new Vector(0);
    private boolean d_bCanBeActivatedByAnyHeatDetector = false;
    private boolean d_bCanBeDeactivatedByAnyHeatDetector = false;
    private FDSComposite d_parent = null;

    public AbstractFDSObject() {
        this(null);
    }

    public AbstractFDSObject(String string) {
        this(string, null);
    }

    public AbstractFDSObject(String string, Color color) {
        this.d_name = string;
        this.d_selected = false;
        this.d_visible = true;
        this.d_color = color;
    }

    public Collection<FDSInputRecord> getInputRecords() {
        ArrayList<FDSInputRecord> arrayList = new ArrayList<FDSInputRecord>(1);
        this.getInputRecords(arrayList);
        return arrayList;
    }

    public static void fromLegacy(AbstractFDSObject abstractFDSObject, AbstractFDSObject abstractFDSObject2) {
        ActivationEvent[] activationEventArray;
        abstractFDSObject2.taskSetName(abstractFDSObject.getName()).run();
        abstractFDSObject2.setColor(abstractFDSObject.getColor());
        abstractFDSObject2.setVisible(abstractFDSObject.isVisible());
        for (int i = 0; i < abstractFDSObject2.getNumFaces(); ++i) {
            abstractFDSObject2.setMaterial(i, abstractFDSObject.getMaterial(i));
        }
        for (ActivationEvent activationEvent : activationEventArray = abstractFDSObject.getAllEvents()) {
            abstractFDSObject2.addEvent(activationEvent);
        }
        abstractFDSObject2.setCanBeTriggeredByAnyHeatDetector(abstractFDSObject.getCanBeTriggeredByAnyHeatDetector(0), 0);
        abstractFDSObject2.setCanBeTriggeredByAnyHeatDetector(abstractFDSObject.getCanBeTriggeredByAnyHeatDetector(1), 1);
    }

    @Override
    public Object clone() {
        AbstractFDSObject abstractFDSObject = (AbstractFDSObject)super.clone();
        abstractFDSObject.d_domainHelper = new ADomainObject();
        abstractFDSObject.d_selected = false;
        abstractFDSObject.imprint(this);
        return abstractFDSObject;
    }

    protected void imprint(Object object) {
        if (!(object instanceof AbstractFDSObject)) {
            return;
        }
        this.d_domainHelper.pauseUpdates(false);
        AbstractFDSObject abstractFDSObject = (AbstractFDSObject)object;
        this.d_faces = new Vector(abstractFDSObject.d_faces.size());
        for (int i = 0; i < abstractFDSObject.d_faces.size(); ++i) {
            this.d_faces.add((IFace)abstractFDSObject.d_faces.get(i).clone());
        }
        this.d_color = abstractFDSObject.d_color;
        this.d_name = abstractFDSObject.d_name;
        this.d_vAllEvents = new Vector(abstractFDSObject.d_vAllEvents.size());
        for (ActivationEventList activationEventList : abstractFDSObject.d_vAllEvents) {
            this.d_vAllEvents.add((ActivationEventList)activationEventList.clone());
        }
        this.d_bCanBeActivatedByAnyHeatDetector = abstractFDSObject.d_bCanBeActivatedByAnyHeatDetector;
        this.d_bCanBeDeactivatedByAnyHeatDetector = abstractFDSObject.d_bCanBeDeactivatedByAnyHeatDetector;
        this.d_domainHelper.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskImprint(Object object) {
        if (!(object instanceof AbstractFDSObject)) {
            return null;
        }
        return new AImprintTask<AbstractFDSObject>(this, (AbstractFDSObject)object, AbstractFDSObject.class){

            @Override
            protected void imprint(AbstractFDSObject abstractFDSObject, AbstractFDSObject abstractFDSObject2) {
                abstractFDSObject.imprint(abstractFDSObject2);
            }
        };
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        Vector vector;
        if (!(object instanceof AbstractFDSObject)) {
            return false;
        }
        AbstractFDSObject abstractFDSObject = (AbstractFDSObject)object;
        if (!this.d_faces.equals(abstractFDSObject.d_faces)) {
            return false;
        }
        Vector vector2 = this.getEventsSeparatedByType();
        if (!vector2.equals(vector = abstractFDSObject.getEventsSeparatedByType()) || !this.d_name.equals(abstractFDSObject.d_name)) {
            return false;
        }
        boolean bl2 = this.d_color == null ? abstractFDSObject.getColor() == null : (bl = this.d_color.equals(abstractFDSObject.getColor()));
        return bl;
    }

    @Override
    public FDSComposite getParent() {
        return this.d_parent;
    }

    @Override
    public void setParent(FDSComposite fDSComposite) {
        this.d_parent = fDSComposite;
    }

    @Override
    public IFace getFace(int n) {
        return this.d_faces.get(n);
    }

    @Override
    public String getPropertyHashString() {
        String string = "";
        Geometry geometry = new Geometry();
        for (int i = 0; i < this.d_faces.size(); ++i) {
            IFace iFace = this.d_faces.get(i);
            geometry.clear();
            iFace.getGeometry(geometry);
            Collection<Quad> collection = geometry.getQuads();
            for (Quad quad : collection) {
                string = string + quad.getPoint((int)0).x + "," + quad.getPoint((int)0).y + "," + quad.getPoint((int)0).z + ";";
                string = string + quad.getPoint((int)1).x + "," + quad.getPoint((int)1).y + "," + quad.getPoint((int)1).z + ";";
                string = string + quad.getPoint((int)2).x + "," + quad.getPoint((int)2).y + "," + quad.getPoint((int)2).z + ";";
                string = string + quad.getPoint((int)3).x + "," + quad.getPoint((int)3).y + "," + quad.getPoint((int)3).z + ";";
            }
            if (iFace.getMaterial() == null) continue;
            string = string + iFace.getMaterial().getName() + ";";
        }
        if (this.d_color != null) {
            string = string + this.d_color.getRed() + "," + this.d_color.getGreen() + "," + this.d_color.getBlue() + "," + this.d_color.getAlpha() + ";";
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_domainHelper = new ADomainObject();
        if (objectInputStream instanceof PyroSimObjectInputStream) {
            PyroSimObjectInputStream pyroSimObjectInputStream = (PyroSimObjectInputStream)objectInputStream;
            if (pyroSimObjectInputStream.getVersion() < 15) {
                this.ensureKeyed();
                ObjectInputStream.GetField getField = objectInputStream.readFields();
                this.d_name = (String)getField.get("d_name", null);
                this.d_visible = getField.get("d_visible", true);
                this.d_faces = (Vector)getField.get("d_faces", null);
                this.d_color = (Color)getField.get("d_color", null);
                this.d_vAllEvents = (Vector)getField.get("d_vAllEvents", new Vector());
                this.d_bCanBeActivatedByAnyHeatDetector = getField.get("d_bCanBeActivatedByAnyHeatDetector", false);
                this.d_bCanBeDeactivatedByAnyHeatDetector = getField.get("d_bCanBeDeactivatedByAnyHeatDetector", false);
            } else {
                objectInputStream.defaultReadObject();
            }
        } else {
            objectInputStream.defaultReadObject();
        }
        this.d_vAllEvents.trimToSize();
    }

    protected static void scalePoint(Point2D point2D, Point3d point3d, Tuple3d tuple3d) {
        Point3d point3d2 = new Point3d(point2D.getX(), point2D.getY(), 0.0);
        AbstractFDSObject.scalePoint(point3d2, point3d, tuple3d);
        point2D.setLocation(point3d2.x, point3d2.y);
    }

    protected static void scalePoint(Point3d point3d, Point3d point3d2, Tuple3d tuple3d) {
        point3d.sub(point3d2);
        point3d.x *= tuple3d.x;
        point3d.y *= tuple3d.y;
        point3d.z *= tuple3d.z;
        point3d.add(point3d2);
    }

    protected static void scaleVector(Vector3d vector3d, Point3d point3d, Tuple3d tuple3d) {
        vector3d.x *= tuple3d.x;
        vector3d.y *= tuple3d.y;
        vector3d.z *= tuple3d.z;
    }

    protected static void rotatePoint(Point2D point2D, Point3d point3d, Matrix3d matrix3d) {
        Point3d point3d2 = new Point3d(point2D.getX(), point2D.getY(), 0.0);
        AbstractFDSObject.rotatePoint(point3d2, point3d, matrix3d);
        point2D.setLocation(point3d2.x, point3d2.y);
    }

    protected static void rotatePoint(Point3d point3d, Point3d point3d2, Matrix3d matrix3d) {
        point3d.sub(point3d2);
        matrix3d.transform(point3d);
        point3d.add(point3d2);
    }

    protected static Matrix3d getRotateMat(Vector3d vector3d, UnitDouble unitDouble) {
        Matrix3d matrix3d = new Matrix3d();
        double d = unitDouble.getValue(SI.RADIAN);
        AxisAngle4d axisAngle4d = new AxisAngle4d(vector3d.x, vector3d.y, vector3d.z, d);
        matrix3d.set(axisAngle4d);
        return matrix3d;
    }

    protected static Vector4d getExternalPlane(int n, double d) {
        switch (n) {
            case 0: {
                return new Vector4d(1.0, 0.0, 0.0, -d);
            }
            case 1: {
                return new Vector4d(0.0, 1.0, 0.0, -d);
            }
            case 2: {
                return new Vector4d(0.0, 0.0, 1.0, -d);
            }
        }
        assert (false);
        return null;
    }

    protected static void mirrorPoint(Point3d point3d, Vector4d vector4d) {
        double d = vector4d.x * point3d.x + vector4d.y * point3d.y + vector4d.z * point3d.z + vector4d.w;
        Vector3d vector3d = new Vector3d(vector4d.x, vector4d.y, vector4d.z);
        vector3d.scale(d *= -2.0);
        point3d.add(vector3d);
    }

    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
    }

    protected void translate(UnitPoint3D unitPoint3D) {
    }

    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
    }

    protected void mirror(int n, UnitDouble unitDouble) {
    }

    protected Task taskSaveGeometry() {
        return null;
    }

    @Override
    public Task taskScaleObject(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        return new ScaleTask(this.taskSaveGeometry(), unitPoint3D, tuple3d);
    }

    @Override
    public Task taskTranslateObject(UnitPoint3D unitPoint3D) {
        return new TranslateTask(this.taskSaveGeometry(), unitPoint3D);
    }

    @Override
    public Task taskRotateObject(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        return new RotateTask(this.taskSaveGeometry(), unitPoint3D, vector3d, unitDouble);
    }

    @Override
    public Task taskMirrorObject(int n, UnitDouble unitDouble) {
        return new MirrorTask(this.taskSaveGeometry(), n, unitDouble);
    }

    protected Vector3d getClosestAxis(Vector3d vector3d) {
        Vector3d vector3d2 = Geometry.VEC3D_XNEG;
        double d = Double.MAX_VALUE;
        double d2 = vector3d.dot(Geometry.VEC3D_XPOS);
        double d3 = vector3d.dot(Geometry.VEC3D_YPOS);
        double d4 = vector3d.dot(Geometry.VEC3D_ZPOS);
        double d5 = Math.abs(Math.abs(d2) - 1.0);
        double d6 = Math.abs(Math.abs(d3) - 1.0);
        double d7 = Math.abs(Math.abs(d4) - 1.0);
        if (d5 < d) {
            d = d5;
            Vector3d vector3d3 = vector3d2 = d2 < 0.0 ? Geometry.VEC3D_XNEG : Geometry.VEC3D_XPOS;
        }
        if (d6 < d) {
            d = d6;
            Vector3d vector3d4 = vector3d2 = d3 < 0.0 ? Geometry.VEC3D_YNEG : Geometry.VEC3D_YPOS;
        }
        if (d7 < d) {
            d = d7;
            vector3d2 = d4 < 0.0 ? Geometry.VEC3D_ZNEG : Geometry.VEC3D_ZPOS;
        }
        return vector3d2;
    }

    protected void rectifyPoints(Point3d point3d, Point3d point3d2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        if (point3d.x <= point3d2.x) {
            d6 = point3d.x;
            d5 = point3d2.x;
        } else {
            d6 = point3d2.x;
            d5 = point3d.x;
        }
        if (point3d.y <= point3d2.y) {
            d4 = point3d.y;
            d3 = point3d2.y;
        } else {
            d4 = point3d2.y;
            d3 = point3d.y;
        }
        if (point3d.z <= point3d2.z) {
            d2 = point3d.z;
            d = point3d2.z;
        } else {
            d2 = point3d2.z;
            d = point3d.z;
        }
        point3d.set(d6, d4, d2);
        point3d2.set(d5, d3, d);
    }

    public Iterator<IFace> getFaceIterator() {
        return this.d_faces.iterator();
    }

    @Override
    public void getGeometry(Geometry geometry) {
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            IFace iFace = iterator.next();
            iFace.getGeometry(geometry);
        }
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry geometry = new Geometry();
        this.getGeometry(geometry);
        Point3D point3D = geometry.getMinPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry geometry = new Geometry();
        this.getGeometry(geometry);
        Point3D point3D = geometry.getMaxPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public String getName() {
        return this.d_name;
    }

    private void setName(String string) {
        this.d_name = string;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Task taskSetName(String string) {
        return new ASetNameTask(string){

            @Override
            protected void setName(String string) {
                AbstractFDSObject.this.setName(string);
            }

            @Override
            protected String getName() {
                return AbstractFDSObject.this.getName();
            }
        };
    }

    @Override
    public void setColor(Color color) {
        this.d_color = color;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Color getColor() {
        return this.d_color;
    }

    @Override
    public void setMaterial(Material material) {
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            IFace iFace = iterator.next();
            iFace.setMaterial(material);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Iterator<IFace> iterator = this.getFaceIterator();
        if (!this.isUniformMaterial() || !iterator.hasNext()) {
            return null;
        }
        return iterator.next().getMaterial();
    }

    @Override
    public boolean isUniformMaterial() {
        Material material = null;
        Iterator<IFace> iterator = this.getFaceIterator();
        if (!iterator.hasNext()) {
            return true;
        }
        IFace iFace = iterator.next();
        material = iFace.getMaterial();
        while (iterator.hasNext()) {
            iFace = iterator.next();
            if (iFace.getMaterial() == material) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addDomain(PyroMod pyroMod) {
        this.d_domainHelper.addDomain(pyroMod);
        for (ActivationEventList activationEventList : this.d_vAllEvents) {
            activationEventList.addDomain(pyroMod);
        }
    }

    @Override
    public Set<PyroMod> getDomains() {
        return this.d_domainHelper.getDomains();
    }

    @Override
    public void removeDomain(PyroMod pyroMod) {
        this.d_domainHelper.removeDomain(pyroMod);
        for (ActivationEventList activationEventList : this.d_vAllEvents) {
            activationEventList.removeDomain(pyroMod);
        }
    }

    public Icon getIcon() {
        return null;
    }

    @Override
    public void setSelected(boolean bl) {
        this.d_selected = bl;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 0));
    }

    @Override
    public boolean isSelected() {
        return this.d_selected;
    }

    @Override
    public void setVisible(boolean bl) {
        this.d_visible = bl;
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 1));
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public boolean addEvent(ActivationEvent activationEvent) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != activationEvent.getEventType()) continue;
            activationEventList.taskAddEvent(activationEvent).run();
            this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
            return true;
        }
        activationEventList = AbstractActivationEventList.createNewList(activationEvent.getEventType(), this.getDomains());
        activationEventList.taskAddEvent(activationEvent).run();
        this.d_vAllEvents.add(activationEventList);
        if (activationEvent.getEventType() == 1) {
            ((HeatActivationEventList)activationEventList).setCanBeTriggeredByAny(this.d_bCanBeActivatedByAnyHeatDetector, 0);
            ((HeatActivationEventList)activationEventList).setCanBeTriggeredByAny(this.d_bCanBeDeactivatedByAnyHeatDetector, 1);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
        return true;
    }

    @Override
    public boolean removeEvent(ActivationEvent activationEvent) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != activationEvent.getEventType()) continue;
            activationEventList.taskRemoveEvent(activationEvent).run();
            if (activationEventList.size() == 0) {
                this.d_vAllEvents.remove(i);
            }
            this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
            return true;
        }
        return false;
    }

    @Override
    public void removeEvents(int n) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != n) continue;
            this.d_vAllEvents.remove(i);
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public void removeAllEvents() {
        this.d_vAllEvents.clear();
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public ActivationEventList getEventsOfType(int n) {
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            if (activationEventList.getEventType() != n) continue;
            return activationEventList;
        }
        return AbstractActivationEventList.createNewList(n, this.getDomains());
    }

    @Override
    public ActivationEvent[] getAllEvents() {
        Vector<ActivationEvent> vector = new Vector<ActivationEvent>();
        ActivationEventList activationEventList = null;
        for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
            activationEventList = this.d_vAllEvents.get(i);
            vector.addAll(activationEventList.getAllEvents());
        }
        return vector.toArray(new ActivationEvent[vector.size()]);
    }

    @Override
    public Vector getEventsSeparatedByType() {
        return this.d_vAllEvents;
    }

    @Override
    public void setCanBeTriggeredByAnyHeatDetector(boolean bl, int n) {
        HeatActivationEventList heatActivationEventList = (HeatActivationEventList)this.getEventsOfType(1);
        heatActivationEventList.setCanBeTriggeredByAny(bl, n);
        if (n == 0) {
            this.d_bCanBeActivatedByAnyHeatDetector = bl;
        } else {
            this.d_bCanBeDeactivatedByAnyHeatDetector = bl;
        }
        this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean getCanBeTriggeredByAnyHeatDetector(int n) {
        if (n == 0) {
            return this.d_bCanBeActivatedByAnyHeatDetector;
        }
        return this.d_bCanBeDeactivatedByAnyHeatDetector;
    }

    protected void initEvents() {
        if (this.d_vAllEvents == null) {
            this.d_vAllEvents = new Vector();
        }
    }

    protected void initDomainHelper() {
        this.d_domainHelper = new ADomainObject();
    }

    @Override
    public Collection getEventInputRecords(FDSInputRecord fDSInputRecord) {
        Object object;
        Vector<FDSInputRecord> vector = new Vector<FDSInputRecord>();
        Map map = this.getEventInputRecordMap(1);
        if (this.getCanBeTriggeredByAnyHeatDetector(0)) {
            object = (String)map.get(new Integer(0));
            fDSInputRecord.setValue((String)object, "ALL");
            vector.add(fDSInputRecord);
            fDSInputRecord = (FDSInputRecord)fDSInputRecord.clone();
            fDSInputRecord.removeValue((String)object);
        }
        if (this.getCanBeTriggeredByAnyHeatDetector(1)) {
            object = (String)map.get(new Integer(1));
            fDSInputRecord.setValue((String)object, "ALL");
            vector.add(fDSInputRecord);
            fDSInputRecord = (FDSInputRecord)fDSInputRecord.clone();
            fDSInputRecord.removeValue((String)object);
        }
        object = null;
        Vector vector2 = this.getEventsSeparatedByType();
        for (int i = 0; i < vector2.size(); ++i) {
            object = (ActivationEventList)vector2.get(i);
            vector.addAll(object.getInputRecords(fDSInputRecord, this.getEventInputRecordMap(object.getEventType())));
        }
        return vector;
    }

    @Override
    public Map getEventInputRecordMap(int n) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        if (n == 0) {
            treeMap.put(new Integer(0), "T_CREATE");
            treeMap.put(new Integer(1), "T_REMOVE");
        } else if (n == 1) {
            treeMap.put(new Integer(0), "HEAT_CREATE");
            treeMap.put(new Integer(1), "HEAT_REMOVE");
        }
        return treeMap;
    }

    @Override
    public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
        Serializable serializable;
        int n;
        if (clazz.isAssignableFrom(Material.class)) {
            for (n = 0; n < this.getNumFaces(); ++n) {
                serializable = this.getMaterial(n);
                if (serializable == null) continue;
                set.add((IDependedOn)((Object)serializable));
            }
        }
        if (clazz.isAssignableFrom(HeatDetector.class)) {
            for (n = 0; n < this.d_vAllEvents.size(); ++n) {
                serializable = this.d_vAllEvents.get(n);
                if (serializable.getEventType() != 1) continue;
                Collection<ActivationEvent> collection = serializable.getAllEvents();
                for (HeatActivationEvent heatActivationEvent : collection) {
                    HeatDetector heatDetector = (HeatDetector)heatActivationEvent.getCriteria();
                    set.add(heatDetector);
                }
            }
        }
    }

    @Override
    public boolean dependsOnObject(IDependedOn iDependedOn) {
        block3: {
            block4: {
                if (!(iDependedOn instanceof Material)) break block4;
                for (int i = 0; i < this.getNumFaces(); ++i) {
                    if (!this.getMaterial(i).equals(iDependedOn)) continue;
                    return true;
                }
                break block3;
            }
            if (!(iDependedOn instanceof HeatDetector)) break block3;
            for (int i = 0; i < this.d_vAllEvents.size(); ++i) {
                ActivationEventList activationEventList = this.d_vAllEvents.get(i);
                if (activationEventList.getEventType() != 1) continue;
                Collection<ActivationEvent> collection = activationEventList.getAllEvents();
                for (HeatActivationEvent heatActivationEvent : collection) {
                    if (!heatActivationEvent.getCriteria().equals(iDependedOn)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    @Override
    public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
        if (iDependedOn instanceof Material) {
            return new ReplaceMaterialTask((Material)iDependedOn, (Material)iDependedOn2);
        }
        if (iDependedOn instanceof HeatDetector) {
            return new ReplaceHeatDetectorTask((HeatDetector)iDependedOn, (HeatDetector)iDependedOn2);
        }
        return null;
    }

    @Override
    public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
        return null;
    }

    @Override
    public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
        if (iDependedOn instanceof Material) {
            return new FireEventTask(this.getDomains(), new FDSObjectDomainEvent(this, 5));
        }
        return null;
    }

    private class ReplaceHeatDetectorTask
    extends CompositeTask<PyroMod> {
        private final HeatDetector d_old;
        private final HeatDetector d_new;

        public ReplaceHeatDetectorTask(HeatDetector heatDetector, HeatDetector heatDetector2) {
            super(AbstractFDSObject.this.getDomains());
            this.d_old = heatDetector;
            this.d_new = heatDetector2;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            for (int i = 0; i < AbstractFDSObject.this.d_vAllEvents.size(); ++i) {
                ActivationEventList activationEventList = (ActivationEventList)AbstractFDSObject.this.d_vAllEvents.get(i);
                if (activationEventList.getEventType() != 1) continue;
                this.queueReplaceTasks((HeatActivationEventList)activationEventList);
            }
        }

        private void queueReplaceTasks(HeatActivationEventList heatActivationEventList) {
            Collection collection = heatActivationEventList.getAllEvents();
            for (HeatActivationEvent heatActivationEvent : collection) {
                if (!heatActivationEvent.getCriteria().equals(this.d_old)) continue;
                this.addTask(heatActivationEventList.taskRemoveEvent(heatActivationEvent));
                if (this.d_new == null) continue;
                HeatActivationEvent heatActivationEvent2 = (HeatActivationEvent)heatActivationEvent.clone();
                heatActivationEvent2.setCriteria(this.d_new);
                this.addTask(heatActivationEventList.taskAddEvent(heatActivationEvent2));
            }
        }

        @Override
        public void undo() {
            super.undo();
            AbstractFDSObject.this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(AbstractFDSObject.this, 5));
        }

        @Override
        public void run() {
            super.run();
            AbstractFDSObject.this.d_domainHelper.fireDomainEvent(new FDSObjectDomainEvent(AbstractFDSObject.this, 5));
        }
    }

    private class ReplaceMaterialTask
    extends CompositeTask<PyroMod> {
        private final Material d_old;
        private final Material d_replacement;

        public ReplaceMaterialTask(Material material, Material material2) {
            super(AbstractFDSObject.this.getDomains());
            this.d_old = material;
            this.d_replacement = material2;
        }

        @Override
        protected void queueBeginRuntimeTasks() {
            for (int i = 0; i < AbstractFDSObject.this.getNumFaces(); ++i) {
                if (!AbstractFDSObject.this.getMaterial(i).equals(this.d_old)) continue;
                this.addTask(new SetMaterialTask(i, this.d_replacement));
            }
        }
    }

    private class SetMaterialTask
    extends ATask {
        private final Material d_mat;
        private final int d_face;
        private Material d_oldMat;

        public SetMaterialTask(int n, Material material) {
            super(0, true);
            this.d_face = n;
            this.d_mat = material;
        }

        @Override
        public void undo() {
            AbstractFDSObject.this.setMaterial(this.d_face, this.d_oldMat);
        }

        @Override
        public void run() {
            this.d_oldMat = AbstractFDSObject.this.getMaterial(this.d_face);
            AbstractFDSObject.this.setMaterial(this.d_face, this.d_mat);
        }
    }

    private class MirrorTask
    extends ATransformTask {
        private final int d_plane;
        private final UnitDouble d_value;

        public MirrorTask(Task task, int n, UnitDouble unitDouble) {
            super(task);
            this.d_plane = n;
            this.d_value = unitDouble;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.mirror(this.d_plane, this.d_value);
        }
    }

    private class RotateTask
    extends ATransformTask {
        private final UnitPoint3D d_base;
        private final Vector3d d_rotAxis;
        private final UnitDouble d_amount;

        public RotateTask(Task task, UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
            super(task);
            this.d_base = unitPoint3D;
            this.d_amount = unitDouble;
            this.d_rotAxis = vector3d;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.rotate(this.d_base, this.d_rotAxis, this.d_amount);
        }
    }

    protected class TranslateTask
    extends ATransformTask {
        private final UnitPoint3D d_delta;

        public TranslateTask(Task task, UnitPoint3D unitPoint3D) {
            super(task);
            this.d_delta = unitPoint3D;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.translate(this.d_delta);
        }
    }

    protected class ScaleTask
    extends ATransformTask {
        private final UnitPoint3D d_base;
        private final Tuple3d d_scale;

        public ScaleTask(Task task, UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
            super(task);
            this.d_base = unitPoint3D;
            this.d_scale = tuple3d;
        }

        @Override
        public void modify() {
            AbstractFDSObject.this.scale(this.d_base, this.d_scale);
        }
    }

    private static abstract class ATransformTask
    extends ATask {
        private final Task d_geomSaverTask;

        protected abstract void modify();

        public ATransformTask(Task task) {
            super(0, true);
            this.d_geomSaverTask = task;
        }

        @Override
        public boolean canUndo() {
            return this.d_geomSaverTask.canUndo();
        }

        @Override
        public void undo() {
            this.d_geomSaverTask.undo();
        }

        @Override
        public void run() {
            this.d_geomSaverTask.run();
            this.modify();
        }
    }
}

