/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.geom.Util;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class AUnalignedFDSObject
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final int NUM_FACES = 6;
    private static final String[] FDS_FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    public static final byte FACE_XMIN = 0;
    public static final byte FACE_XMAX = 1;
    public static final byte FACE_YMIN = 2;
    public static final byte FACE_YMAX = 3;
    public static final byte FACE_ZMIN = 4;
    public static final byte FACE_ZMAX = 5;
    public static final byte FACE_AB = 0;
    public static final byte FACE_ABP = 1;
    public static final byte FACE_A = 2;
    public static final byte FACE_B = 3;
    public static final byte FACE_BOTTOM = 4;
    public static final byte FACE_TOP = 5;
    private UnitPoint2D d_a;
    private UnitPoint2D d_b;
    private UnitDouble d_top;
    private UnitDouble d_bottom;
    private UnitDouble d_thickness;
    private transient Vector2d d_lastThicknessVector = null;

    public AUnalignedFDSObject(Material material) {
        this(null, material);
    }

    public AUnalignedFDSObject(String string, Material material) {
        this(new UnitPoint2D(0.0, 0.0, SI.METER), new UnitPoint2D(0.0, 0.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), string, material);
    }

    public AUnalignedFDSObject(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, Material material) {
        this(unitPoint2D, unitPoint2D2, unitDouble, unitDouble2, unitDouble3, "Obstruction", material);
    }

    public AUnalignedFDSObject(UnitPoint2D unitPoint2D, UnitPoint2D unitPoint2D2, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, String string, Material material) {
        super(string);
        assert (unitDouble == null || unitDouble2 == null || unitDouble.compareTo(unitDouble2) <= 0);
        this.d_a = unitPoint2D;
        this.d_b = unitPoint2D2;
        this.d_bottom = unitDouble;
        this.d_top = unitDouble2;
        this.d_thickness = unitDouble3;
        this.initFaces(new Material[]{material, material, material, material, material, material});
    }

    public static void fromLegacy(Wall wall, AUnalignedFDSObject aUnalignedFDSObject) {
        AbstractFDSObject.fromLegacy(wall, aUnalignedFDSObject);
        aUnalignedFDSObject.d_a = wall.getStartPoint();
        aUnalignedFDSObject.d_b = wall.getEndPoint();
        aUnalignedFDSObject.d_thickness = wall.getThickness();
        aUnalignedFDSObject.d_bottom = wall.getBottom();
        aUnalignedFDSObject.d_top = wall.getTop();
    }

    private void initFaces(Material[] materialArray) {
        this.d_faces = new Vector(6);
        for (byte by = 0; by < 6; by = (byte)(by + 1)) {
            int n = this.internalFaceIndexToFDSIndex(by);
            this.d_faces.add(this.createFace(by, materialArray[n]));
        }
    }

    protected IFace createFace(byte by, Material material) {
        return new BlockFace(this, by, material);
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof AUnalignedFDSObject)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        AUnalignedFDSObject aUnalignedFDSObject = (AUnalignedFDSObject)object;
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            BlockFace blockFace = (BlockFace)iterator.next();
            blockFace.d_block = this;
        }
        this.d_a = (UnitPoint2D)aUnalignedFDSObject.d_a.clone();
        this.d_b = (UnitPoint2D)aUnalignedFDSObject.d_b.clone();
        this.d_top = (UnitDouble)aUnalignedFDSObject.d_top.clone();
        this.d_bottom = (UnitDouble)aUnalignedFDSObject.d_bottom.clone();
        this.d_thickness = (UnitDouble)aUnalignedFDSObject.d_thickness.clone();
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AUnalignedFDSObject)) {
            return false;
        }
        AUnalignedFDSObject aUnalignedFDSObject = (AUnalignedFDSObject)object;
        boolean bl = this.d_a.equals(aUnalignedFDSObject.d_a) && this.d_b.equals(aUnalignedFDSObject.d_b) && this.d_top.equals(aUnalignedFDSObject.d_top) && this.d_bottom.equals(aUnalignedFDSObject.d_bottom) && this.d_thickness.equals(aUnalignedFDSObject.d_thickness);
        return bl;
    }

    public UnitPoint2D getStartPoint() {
        return this.d_a;
    }

    public void setStartPoint(UnitPoint2D unitPoint2D) {
        this.d_a = unitPoint2D;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitPoint2D getEndPoint() {
        return this.d_b;
    }

    public void setEndPoint(UnitPoint2D unitPoint2D) {
        this.d_b = unitPoint2D;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getBottom() {
        return this.d_bottom;
    }

    public void setBottom(UnitDouble unitDouble) {
        this.d_bottom = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getTop() {
        return this.d_top;
    }

    public void setTop(UnitDouble unitDouble) {
        this.d_top = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public UnitDouble getThickness() {
        return this.d_thickness;
    }

    public void setThickness(UnitDouble unitDouble) {
        this.d_thickness = unitDouble;
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D unitPoint3D) {
        this.d_a.x = this.d_a.x.add(unitPoint3D.xu());
        this.d_a.y = this.d_a.y.add(unitPoint3D.yu());
        this.d_b.x = this.d_b.x.add(unitPoint3D.xu());
        this.d_b.y = this.d_b.y.add(unitPoint3D.yu());
        this.d_top = this.d_top.add(unitPoint3D.zu());
        this.d_bottom = this.d_bottom.add(unitPoint3D.zu());
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        assert (tuple3d.x >= 0.0 && tuple3d.y >= 0.0 && tuple3d.z >= 0.0);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Point2D.Double double_ = this.getStartPoint().getValue(unit);
        Point2D.Double double_2 = this.getEndPoint().getValue(unit);
        Point3d point3d2 = new Point3d(0.0, 0.0, this.getTop().getValue(unit));
        Point3d point3d3 = new Point3d(0.0, 0.0, this.getBottom().getValue(unit));
        AUnalignedFDSObject.scalePoint(double_, point3d, tuple3d);
        AUnalignedFDSObject.scalePoint(double_2, point3d, tuple3d);
        AUnalignedFDSObject.scalePoint(point3d2, point3d, tuple3d);
        AUnalignedFDSObject.scalePoint(point3d3, point3d, tuple3d);
        ADomainObject.pauseUpdates(this, false);
        this.setStartPoint(new UnitPoint2D(double_, unit));
        this.setEndPoint(new UnitPoint2D(double_2, unit));
        this.setTop(new UnitDouble(point3d2.z, unit));
        this.setBottom(new UnitDouble(point3d3.z, unit));
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    private double scaleThickness(double d, UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        double d2 = Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y + tuple3d.z * tuple3d.z);
        return d * d2;
    }

    @Override
    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Matrix3d matrix3d = AUnalignedFDSObject.getRotateMat(vector3d, unitDouble);
        Point2D.Double double_ = this.getStartPoint().getValue(unit);
        Point2D.Double double_2 = this.getEndPoint().getValue(unit);
        AUnalignedFDSObject.rotatePoint(double_, point3d, matrix3d);
        AUnalignedFDSObject.rotatePoint(double_2, point3d, matrix3d);
        ADomainObject.pauseUpdates(this, false);
        this.setStartPoint(new UnitPoint2D(double_, unit));
        this.setEndPoint(new UnitPoint2D(double_2, unit));
        this.resumeUpdates(new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void mirror(int n, UnitDouble unitDouble) {
    }

    public UnitPoint2D getThicknessVector() {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Vector2d vector2d = this.getThicknessVector(this.d_thickness.getValue(unit), unit);
        return new UnitPoint2D(vector2d.x, vector2d.y, unit);
    }

    private Vector2d getThicknessVector(double d, Unit unit) {
        Vector2d vector2d;
        double d2 = this.d_b.x.getValue(unit) - this.d_a.x.getValue(unit);
        double d3 = this.d_b.y.getValue(unit) - this.d_a.y.getValue(unit);
        if (Math.abs(d2) < 1.0E-15 && Math.abs(d3) < 1.0E-15) {
            if (this.d_lastThicknessVector != null) {
                return this.d_lastThicknessVector;
            }
            vector2d = new Vector2d(1.0, 0.0);
        } else {
            vector2d = new Vector2d(-d3, d2);
            vector2d.normalize();
        }
        vector2d.scale(d);
        this.d_lastThicknessVector = new Vector2d(vector2d);
        return vector2d;
    }

    public boolean isAligned() {
        Serializable serializable;
        PyroMod pyroMod = null;
        Iterator<PyroMod> iterator = this.getDomains().iterator();
        if (iterator.hasNext()) {
            serializable = iterator.next();
            pyroMod = serializable;
        }
        if (pyroMod != null) {
            iterator = pyroMod.getAlignTol();
            serializable = this.d_a.x.diff(this.d_b.x);
            UnitDouble unitDouble = this.d_a.y.diff(this.d_b.y);
            return ((UnitDouble)serializable).compareTo(iterator) <= 0 || unitDouble.compareTo(iterator) <= 0;
        }
        return this.d_a.x.tolEquals(this.d_b.x) || this.d_a.y.tolEquals(this.d_b.y);
    }

    @Override
    public boolean isRasterizable() {
        return !this.isAligned();
    }

    @Override
    public UnitPoint3D getMinPoint() {
        Geometry geometry = new Geometry();
        super.getGeometry(geometry);
        Point3D point3D = geometry.getMinPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        Geometry geometry = new Geometry();
        super.getGeometry(geometry);
        Point3D point3D = geometry.getMaxPoint();
        return new UnitPoint3D(point3D.x, point3D.y, point3D.z, Geometry.GEOM_LENGTH_UNIT);
    }

    protected abstract IFDSFragGenerator getFaceFragGenerator(IFace var1);

    @Override
    public void getGeometry(Geometry geometry) {
        super.getGeometry(geometry);
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
    }

    protected abstract void fillExtraRecords(FDSInputRecord var1);

    protected void fillMaterialRecords(FDSInputRecord fDSInputRecord) {
        int[] nArray = new int[]{this.fdsFaceIndexToInternalIndex(0), this.fdsFaceIndexToInternalIndex(1), this.fdsFaceIndexToInternalIndex(2), this.fdsFaceIndexToInternalIndex(3), this.fdsFaceIndexToInternalIndex(4), this.fdsFaceIndexToInternalIndex(5)};
        if (this.isUniformMaterial()) {
            fDSInputRecord.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[1])).getMaterial() && ((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[2])).getMaterial() && ((IFace)this.d_faces.get(nArray[0])).getMaterial() == ((IFace)this.d_faces.get(nArray[3])).getMaterial()) {
            VectorFromArray<String> vectorFromArray = new VectorFromArray<String>(((IFace)this.d_faces.get(nArray[5])).getMaterial().getName(), ((IFace)this.d_faces.get(nArray[0])).getMaterial().getName(), ((IFace)this.d_faces.get(nArray[4])).getMaterial().getName());
            fDSInputRecord.setValue("SURF_IDS", vectorFromArray);
        } else {
            Vector<String> vector = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                BlockFace blockFace = (BlockFace)this.d_faces.get(nArray[i]);
                vector.add(blockFace.getMaterial().getName());
            }
            fDSInputRecord.setValue("SURF_ID6", vector);
        }
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    protected int fdsFaceIndexToInternalIndex(int n) {
        for (int i = 0; i < this.d_faces.size(); ++i) {
            int n2 = this.internalFaceIndexToFDSIndex(i);
            if (n != n2) continue;
            return i;
        }
        return -1;
    }

    private Vector3d getClosestAlignedAxisAB() {
        Vector3d[] vector3dArray;
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point2D.Double double_ = this.d_a.getValue(unit);
        Point2D.Double double_2 = this.d_b.getValue(unit);
        Point3d point3d = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), 0.0);
        Point3d point3d2 = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), 0.0);
        Vector3d vector3d = new Vector3d();
        vector3d.sub(point3d2, point3d);
        vector3d.normalize();
        Vector3d vector3d2 = Geometry.VEC3D_XPOS;
        double d = Double.MAX_VALUE;
        for (Vector3d vector3d3 : vector3dArray = new Vector3d[]{Geometry.VEC3D_XNEG, Geometry.VEC3D_XPOS, Geometry.VEC3D_YNEG, Geometry.VEC3D_YPOS, Geometry.VEC3D_ZNEG, Geometry.VEC3D_ZPOS}) {
            double d2 = vector3d.dot(vector3d3);
            double d3 = Math.abs(d2 - 1.0);
            if (!(d3 < d)) continue;
            d = d3;
            vector3d2 = vector3d3;
        }
        return vector3d2;
    }

    protected int internalFaceIndexToFDSIndex(int n) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        double d = this.getThickness().getValue(unit);
        Vector3d vector3d = this.getClosestAlignedAxisAB();
        int n2 = vector3d == Geometry.VEC3D_XPOS ? (d >= 0.0 ? 0 : 1) : (vector3d == Geometry.VEC3D_XNEG ? (d >= 0.0 ? 2 : 3) : (vector3d == Geometry.VEC3D_YPOS ? (d >= 0.0 ? 4 : 5) : (d >= 0.0 ? 6 : 7)));
        switch (n2) {
            case 0: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return n;
            }
            case 1: {
                switch (n) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        return 1;
                    }
                }
                return n;
            }
            case 2: {
                switch (n) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return n;
            }
            case 3: {
                switch (n) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
                return n;
            }
            case 4: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return n;
            }
            case 5: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        return 3;
                    }
                }
                return n;
            }
            case 6: {
                switch (n) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return n;
            }
            case 7: {
                switch (n) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                }
                return n;
            }
        }
        return n;
    }

    @Override
    public void setMaterial(int n, Material material) {
        int n2 = this.fdsFaceIndexToInternalIndex(n);
        ((IFace)this.d_faces.get(n2)).setMaterial(material);
        this.fireDomainEvent(new FDSObjectDomainEvent(this, 5));
    }

    public void fireDomainEvent(IDomainEvent iDomainEvent) {
        ADomainObject.fireDomainEvent(this, iDomainEvent);
    }

    public void resumeUpdates(IDomainEvent iDomainEvent) {
        ADomainObject.resumeUpdates(this, iDomainEvent);
    }

    @Override
    public Material getMaterial(int n) {
        int n2 = this.fdsFaceIndexToInternalIndex(n);
        return ((IFace)this.d_faces.get(n2)).getMaterial();
    }

    public static class BlockFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AUnalignedFDSObject d_block;
        private byte d_index;

        public BlockFace(AUnalignedFDSObject aUnalignedFDSObject, byte by, Material material) {
            super(material);
            this.d_block = aUnalignedFDSObject;
            this.d_index = by;
        }

        @Override
        public String getName() {
            return FDS_FACE_NAMES[this.d_index];
        }

        private Point3d[] getGeomVerts() {
            Point3d point3d;
            Point3d point3d2;
            Point3d point3d3;
            Point3d point3d4;
            Unit unit = Geometry.GEOM_LENGTH_UNIT;
            Point2D.Double double_ = this.d_block.d_a.getValue(unit);
            Point2D.Double double_2 = this.d_block.d_b.getValue(unit);
            double d = this.d_block.d_thickness.getValue(unit);
            Vector2d vector2d = this.d_block.getThicknessVector(d, unit);
            switch (this.d_index) {
                case 0: {
                    point3d4 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_top.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_bottom.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_bottom.getValue(unit));
                    point3d = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_top.getValue(unit));
                    break;
                }
                case 1: {
                    point3d4 = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    point3d = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    break;
                }
                case 2: {
                    point3d4 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_bottom.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_top.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    point3d = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    break;
                }
                case 3: {
                    point3d4 = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_top.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_bottom.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    point3d = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    break;
                }
                case 4: {
                    point3d4 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_bottom.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_bottom.getValue(unit));
                    point3d = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_bottom.getValue(unit));
                    break;
                }
                case 5: {
                    point3d4 = new Point3d(((Point2D)double_).getX(), ((Point2D)double_).getY(), this.d_block.d_top.getValue(unit));
                    point3d3 = new Point3d(((Point2D)double_2).getX(), ((Point2D)double_2).getY(), this.d_block.d_top.getValue(unit));
                    point3d2 = new Point3d(((Point2D)double_2).getX() + vector2d.x, ((Point2D)double_2).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    point3d = new Point3d(((Point2D)double_).getX() + vector2d.x, ((Point2D)double_).getY() + vector2d.y, this.d_block.d_top.getValue(unit));
                    break;
                }
                default: {
                    assert (false);
                    point3d = null;
                    point3d2 = null;
                    point3d3 = null;
                    point3d4 = null;
                }
            }
            if (d >= 0.0) {
                return new Point3d[]{point3d4, point3d3, point3d2, point3d};
            }
            return new Point3d[]{point3d, point3d2, point3d3, point3d4};
        }

        @Override
        public void getGeometry(Geometry geometry) {
            Point3d[] point3dArray = this.getGeomVerts();
            Vector3d vector3d = null;
            switch (this.d_index) {
                case 4: {
                    vector3d = Geometry.VEC3D_ZNEG;
                    break;
                }
                case 5: {
                    vector3d = Geometry.VEC3D_ZPOS;
                }
            }
            PrimProps primProps = new PrimProps(this.getMaterial(), this.getGeometryColor());
            Quad quad = new Quad(point3dArray, vector3d, primProps);
            geometry.addQuad(quad);
        }

        protected Color getGeometryColor() {
            return this.d_block.getColor();
        }

        protected AUnalignedFDSObject getBlock() {
            return this.d_block;
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object) || !(object instanceof BlockFace)) {
                return false;
            }
            BlockFace blockFace = (BlockFace)object;
            return this.d_index == blockFace.d_index;
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return Util.convertArray(Geometry.GEOM_LENGTH_UNIT, this.getGeomVerts());
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return this.d_block.getFaceFragGenerator(this);
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint2D d_pa;
        private UnitPoint2D d_pb;
        private UnitDouble d_top;
        private UnitDouble d_bottom;
        private UnitDouble d_thickness;
        private Material d_topMat;
        private Material d_bottomMat;

        public SaveGeomTask(int n) {
            super(n, true);
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AUnalignedFDSObject.this, false);
            AUnalignedFDSObject.this.setTop(this.d_top);
            AUnalignedFDSObject.this.setBottom(this.d_bottom);
            AUnalignedFDSObject.this.setStartPoint(this.d_pa);
            AUnalignedFDSObject.this.setEndPoint(this.d_pb);
            AUnalignedFDSObject.this.setThickness(this.d_thickness);
            AUnalignedFDSObject.this.setMaterial(5, this.d_topMat);
            AUnalignedFDSObject.this.setMaterial(4, this.d_bottomMat);
            AUnalignedFDSObject.this.resumeUpdates(new FDSObjectDomainEvent(AUnalignedFDSObject.this, 5));
        }

        @Override
        public void run() {
            this.d_pa = (UnitPoint2D)AUnalignedFDSObject.this.getStartPoint().clone();
            this.d_pb = (UnitPoint2D)AUnalignedFDSObject.this.getEndPoint().clone();
            this.d_top = (UnitDouble)AUnalignedFDSObject.this.getTop().clone();
            this.d_bottom = (UnitDouble)AUnalignedFDSObject.this.getBottom().clone();
            this.d_thickness = (UnitDouble)AUnalignedFDSObject.this.getThickness().clone();
            this.d_topMat = AUnalignedFDSObject.this.getMaterial(5);
            this.d_bottomMat = AUnalignedFDSObject.this.getMaterial(4);
        }
    }
}

