/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;

public abstract class ARemoveTask<E>
implements Task {
    private final Set<? extends Mediator> d_mediators;
    private final Collection<E> d_toDelete;
    private final Collection<E> d_actuallyRemoved;

    protected abstract boolean remove(E var1);

    protected abstract boolean add(E var1);

    public ARemoveTask(Set<? extends Mediator> set, Collection<E> collection) {
        this.d_toDelete = new ArrayList<E>(collection);
        this.d_actuallyRemoved = new ArrayList(collection.size());
        this.d_mediators = set;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        for (E e : this.d_actuallyRemoved) {
            this.add(e);
        }
        this.d_actuallyRemoved.clear();
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        for (E e : this.d_toDelete) {
            if (!this.remove(e)) continue;
            this.d_actuallyRemoved.add(e);
        }
        this.resumeUpdates();
    }

    private void pauseUpdates() {
        if (this.d_mediators != null) {
            for (Mediator mediator : this.d_mediators) {
                mediator.pauseUpdates();
            }
        }
    }

    private void resumeUpdates() {
        if (this.d_mediators != null) {
            for (Mediator mediator : this.d_mediators) {
                mediator.resumeUpdates();
            }
        }
    }
}

