/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class ARemoveAtIndexTask<K, V extends IPyroObject>
implements Task {
    final IPyroManager<K, V> d_manager;
    private final List<Integer> d_indexes;
    private final Map<Integer, V> d_removedObjects;

    public abstract V remove(int var1);

    public abstract void add(V var1, int var2);

    public ARemoveAtIndexTask(IPyroManager<K, V> iPyroManager, Collection<Integer> collection) {
        Object[] objectArray = collection.iterator();
        while (objectArray.hasNext()) {
            int n = objectArray.next();
            assert (n <= iPyroManager.size() && n >= 0);
        }
        this.d_manager = iPyroManager;
        objectArray = collection.toArray(new Integer[collection.size()]);
        Arrays.sort(objectArray);
        this.d_indexes = new VectorFromArray<Object>(objectArray);
        this.d_removedObjects = new TreeMap<Integer, V>();
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    protected Collection<V> getObjects() {
        return this.d_removedObjects.values();
    }

    @Override
    public void undo() {
        ADomainObject.pauseUpdates(this.d_manager);
        Iterator<Integer> iterator = this.d_indexes.iterator();
        for (IPyroObject iPyroObject : this.d_removedObjects.values()) {
            this.add(iPyroObject, iterator.next());
        }
        this.d_removedObjects.clear();
        ADomainObject.resumeUpdates(this.d_manager);
    }

    @Override
    public void run() {
        ADomainObject.pauseUpdates(this.d_manager);
        ListIterator<Integer> listIterator = this.d_indexes.listIterator(this.d_indexes.size());
        while (listIterator.hasPrevious()) {
            int n = listIterator.previous();
            V v = this.remove(n);
            if (v == null) continue;
            this.d_removedObjects.put(n, v);
        }
        ADomainObject.resumeUpdates(this.d_manager);
    }
}

