/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.Collection;
import pyrosim.legacy_2006_2.domain.APyroManOpTask;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;

public abstract class APyroManAddAtIndexTask<K, V extends IPyroObject>
extends APyroManOpTask<K, V> {
    private final Collection<V> d_actuallyAdded;
    private final int d_index;

    protected abstract void removeAll(Collection<? extends V> var1);

    protected abstract boolean add(V var1, int var2);

    public APyroManAddAtIndexTask(IPyroManager<K, V> iPyroManager, Collection<? extends V> collection, int n) {
        super(iPyroManager, collection);
        assert (n <= iPyroManager.size() && n >= 0);
        this.d_actuallyAdded = new ArrayList<V>(collection.size());
        this.d_index = n;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void undo() {
        this.removeAll(this.d_actuallyAdded);
        this.d_actuallyAdded.clear();
    }

    @Override
    public void run() {
        ADomainObject.pauseUpdates(this.getManager());
        int n = this.d_index;
        for (IPyroObject iPyroObject : this.getObjects()) {
            if (!this.add(iPyroObject, n)) continue;
            this.d_actuallyAdded.add(iPyroObject);
            ++n;
        }
        ADomainObject.resumeUpdates(this.getManager());
    }
}

