/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.IOrderedPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;

public abstract class AOrdPyroManReplaceTask<K, V extends IPyroObject>
extends CompositeTask<PyroMod> {
    private final IOrderedPyroManager<K, V> d_manager;
    private final Map<Integer, V> d_indexObjMap;
    private final Map<V, V> d_objReplMap;
    private final boolean d_replAvailable;

    protected abstract void remove(int var1);

    protected abstract void add(V var1, int var2);

    public AOrdPyroManReplaceTask(IOrderedPyroManager<K, V> iOrderedPyroManager, List<V> list, List<V> list2) {
        super(iOrderedPyroManager.getDomains());
        this.d_manager = iOrderedPyroManager;
        this.d_indexObjMap = new TreeMap<Integer, V>();
        this.d_replAvailable = list2 != null;
        this.d_objReplMap = new HashMap<V, V>(list.size(), 1.0f);
        if (this.d_replAvailable) {
            Iterator<V> iterator = list2.iterator();
            for (IPyroObject iPyroObject : list) {
                IPyroObject iPyroObject2 = (IPyroObject)iterator.next();
                this.d_objReplMap.put(iPyroObject, iPyroObject2);
            }
        } else {
            for (IPyroObject iPyroObject : list) {
                this.d_objReplMap.put(iPyroObject, null);
            }
        }
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    protected void queueBeginRuntimeTasks() {
        for (IPyroObject iPyroObject : this.d_objReplMap.keySet()) {
            int n = this.d_manager.indexOf(iPyroObject);
            assert (n != -1);
            this.d_indexObjMap.put(n, iPyroObject);
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        if (this.d_replAvailable) {
            this.removeIndexes();
        }
        for (Map.Entry<Integer, V> entry : this.d_indexObjMap.entrySet()) {
            this.add((IPyroObject)entry.getValue(), entry.getKey());
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        super.run();
        this.pauseUpdates();
        this.removeIndexes();
        if (this.d_replAvailable) {
            for (Map.Entry<Integer, V> entry : this.d_indexObjMap.entrySet()) {
                IPyroObject iPyroObject = (IPyroObject)this.d_objReplMap.get(entry.getValue());
                this.add(iPyroObject, entry.getKey());
            }
        }
        this.resumeUpdates();
    }

    private void removeIndexes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.d_indexObjMap.keySet());
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            int n = (Integer)listIterator.previous();
            this.remove(n);
        }
    }
}

