/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2.domain;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFace;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.IFace;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.rasterization.IFDSFragGenerator;
import pyrosim.legacy_2006_2.events.FDSObjectDomainEvent;
import pyrosim.legacy_2006_2.geom.Geometry;
import pyrosim.legacy_2006_2.geom.PrimProps;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.ATask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;

public abstract class AAlignedFDSObject
extends AbstractFDSObject
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    public static final byte MIN_X = 0;
    public static final byte MAX_X = 1;
    public static final byte MIN_Y = 2;
    public static final byte MAX_Y = 3;
    public static final byte MIN_Z = 4;
    public static final byte MAX_Z = 5;
    public static final int NUM_FACES = 6;
    private static final String[] FACE_NAMES = new String[]{"Min X", "Max X", "Min Y", "Max Y", "Min Z", "Max Z"};
    private static final byte X = 0;
    private static final byte Y = 1;
    private static final byte Z = 2;
    private static final int NUM_ROT_AXES = 3;
    private static final byte[][] FACE_INDEX_ROT_LU;

    public AAlignedFDSObject(String string, Material material) {
        this(new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), new UnitPoint3D(0.0, 0.0, 0.0, SI.METER), string, material);
    }

    public AAlignedFDSObject(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Material material) {
        this(unitPoint3D, unitPoint3D2, string, null, material);
    }

    public AAlignedFDSObject(UnitPoint3D unitPoint3D, UnitPoint3D unitPoint3D2, String string, Color color, Material material) {
        super(string);
        assert (unitPoint3D.xu().compareTo(unitPoint3D2.xu()) <= 0 && unitPoint3D.yu().compareTo(unitPoint3D2.yu()) <= 0 && unitPoint3D.zu().compareTo(unitPoint3D2.zu()) <= 0);
        this.d_minPoint = unitPoint3D;
        this.d_maxPoint = unitPoint3D2;
        this.d_faces = new Vector(6);
        for (byte by = 0; by <= 5; by = (byte)(by + 1)) {
            this.d_faces.add(new AAlignedFDSObjectFace(this, by, material));
        }
        this.setColor(color);
    }

    public static void fromLegacy(AlignedBlock alignedBlock, AAlignedFDSObject aAlignedFDSObject) {
        AbstractFDSObject.fromLegacy(alignedBlock, aAlignedFDSObject);
        aAlignedFDSObject.setMinPoint(alignedBlock.getMinPoint());
        aAlignedFDSObject.setMaxPoint(alignedBlock.getMaxPoint());
    }

    @Override
    protected void imprint(Object object) {
        if (!(object instanceof AAlignedFDSObject)) {
            return;
        }
        ADomainObject.pauseUpdates(this, false);
        super.imprint(object);
        AAlignedFDSObject aAlignedFDSObject = (AAlignedFDSObject)object;
        Iterator<IFace> iterator = this.getFaceIterator();
        while (iterator.hasNext()) {
            ((AAlignedFDSObjectFace)iterator.next()).d_block = this;
        }
        this.d_minPoint = (UnitPoint3D)aAlignedFDSObject.d_minPoint.clone();
        this.d_maxPoint = (UnitPoint3D)aAlignedFDSObject.d_maxPoint.clone();
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected Task taskSaveGeometry() {
        return new SaveGeomTask(0);
    }

    @Override
    protected void translate(UnitPoint3D unitPoint3D) {
    }

    @Override
    protected void scale(UnitPoint3D unitPoint3D, Tuple3d tuple3d) {
        assert (tuple3d.x >= 0.0 && tuple3d.y >= 0.0 && tuple3d.z >= 0.0);
        ADomainObject.pauseUpdates(this, false);
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Point3d point3d2 = this.getMinPoint().getPoint3dValue(unit);
        Point3d point3d3 = this.getMaxPoint().getPoint3dValue(unit);
        AAlignedFDSObject.scalePoint(point3d2, point3d, tuple3d);
        AAlignedFDSObject.scalePoint(point3d3, point3d, tuple3d);
        this.setMinPoint(new UnitPoint3D(point3d2, unit));
        this.setMaxPoint(new UnitPoint3D(point3d3, unit));
        ADomainObject.resumeUpdates(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    protected void rotate(UnitPoint3D unitPoint3D, Vector3d vector3d, UnitDouble unitDouble) {
        Unit unit = Geometry.GEOM_LENGTH_UNIT;
        Point3d point3d = unitPoint3D.getPoint3dValue(unit);
        Matrix3d matrix3d = AAlignedFDSObject.getRotateMat(vector3d, unitDouble);
        Point3d point3d2 = this.getMinPoint().getPoint3dValue(unit);
        Point3d point3d3 = this.getMaxPoint().getPoint3dValue(unit);
        AAlignedFDSObject.rotatePoint(point3d2, point3d, matrix3d);
        AAlignedFDSObject.rotatePoint(point3d3, point3d, matrix3d);
        this.rectifyPoints(point3d2, point3d3);
        ADomainObject.pauseUpdates(this);
        this.setMinPoint(new UnitPoint3D(point3d2, unit));
        this.setMaxPoint(new UnitPoint3D(point3d3, unit));
        this.rotateFaces(vector3d, unitDouble);
        ADomainObject.resumeUpdates(this);
    }

    protected void rotateFaces(Vector3d vector3d, UnitDouble unitDouble) {
        Vector3d vector3d2;
        double d = unitDouble.getValue(NonSI.DEGREE_ANGLE);
        int n = (int)(Math.round(Math.abs(d) / 90.0) % 4L);
        if (d < 0.0) {
            n = 4 - n;
        }
        int n2 = (vector3d2 = this.getClosestAxis(vector3d)).equals(Geometry.VEC3D_XPOS) ? 0 : (vector3d2.equals(Geometry.VEC3D_YPOS) ? 1 : 2);
        this.rotateFaces(n2, n);
    }

    protected void rotateFaces(int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.rotateFaces90(n);
        }
    }

    protected void rotateFaces90(int n) {
        int n2;
        Material[] materialArray = new Material[6];
        for (n2 = 0; n2 < 6; ++n2) {
            materialArray[n2] = ((IFace)this.d_faces.get(n2)).getMaterial();
        }
        for (n2 = 0; n2 < 6; ++n2) {
            byte by = FACE_INDEX_ROT_LU[n][n2];
            ((IFace)this.d_faces.get(by)).setMaterial(materialArray[n2]);
        }
    }

    @Override
    protected void mirror(int n, UnitDouble unitDouble) {
    }

    protected void mirrorFaces(int n, UnitDouble unitDouble) {
        if (n == 0) {
            Material material = this.getMaterial(0);
            this.setMaterial(0, this.getMaterial(1));
            this.setMaterial(1, material);
        } else if (n == 1) {
            Material material = this.getMaterial(2);
            this.setMaterial(2, this.getMaterial(3));
            this.setMaterial(3, material);
        } else {
            Material material = this.getMaterial(4);
            this.setMaterial(4, this.getMaterial(5));
            this.setMaterial(5, material);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AAlignedFDSObject)) {
            return false;
        }
        AAlignedFDSObject aAlignedFDSObject = (AAlignedFDSObject)object;
        boolean bl = (this.d_minPoint == null ? aAlignedFDSObject.d_minPoint == null : this.d_minPoint.equals(aAlignedFDSObject.d_minPoint)) && (this.d_maxPoint == null ? aAlignedFDSObject.d_maxPoint == null : this.d_maxPoint.equals(aAlignedFDSObject.d_maxPoint));
        return bl;
    }

    @Override
    public String getPropertyHashString() {
        BaseUnit baseUnit = SI.METER;
        String string = super.getPropertyHashString();
        if (this.d_minPoint != null) {
            string = string + this.d_minPoint.x(baseUnit) + "," + this.d_minPoint.y(baseUnit) + "," + this.d_minPoint.z(baseUnit) + ";";
        }
        if (this.d_maxPoint != null) {
            string = string + this.d_maxPoint.x(baseUnit) + "," + this.d_maxPoint.y(baseUnit) + "," + this.d_maxPoint.z(baseUnit) + ";";
        }
        return string;
    }

    public void setMinPoint(UnitPoint3D unitPoint3D) {
        this.d_minPoint = unitPoint3D;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    public void setMaxPoint(UnitPoint3D unitPoint3D) {
        this.d_maxPoint = unitPoint3D;
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    @Override
    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public String toString() {
        String string = "";
        String string2 = this.getName();
        if (string2 != null && !string2.equals("")) {
            string = string + " [" + string2 + "]";
        }
        return string;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public Material getMaterial(int n) {
        return ((IFace)this.d_faces.get(n)).getMaterial();
    }

    @Override
    public void setMaterial(int n, Material material) {
        ((IFace)this.d_faces.get(n)).setMaterial(material);
        ADomainObject.fireDomainEvent(this, new FDSObjectDomainEvent(this, 5));
    }

    @Override
    public Material getMaterial() {
        Material material = this.getMaterial(0);
        for (int i = 0; i < 6; ++i) {
            if (material == this.getMaterial(i)) continue;
            return null;
        }
        return material;
    }

    @Override
    public boolean isUniformMaterial() {
        return this.getMaterial() != null;
    }

    protected abstract void fillExtraRecords(FDSInputRecord var1);

    protected void fillMaterialRecords(FDSInputRecord fDSInputRecord) {
        if (this.isUniformMaterial()) {
            fDSInputRecord.setValue("SURF_ID", ((IFace)this.d_faces.get(0)).getMaterial().getName());
        } else if (((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(1)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(2)).getMaterial() && ((IFace)this.d_faces.get(0)).getMaterial() == ((IFace)this.d_faces.get(3)).getMaterial()) {
            VectorFromArray<String> vectorFromArray = new VectorFromArray<String>(((IFace)this.d_faces.get(5)).getMaterial().getName(), ((IFace)this.d_faces.get(0)).getMaterial().getName(), ((IFace)this.d_faces.get(4)).getMaterial().getName());
            fDSInputRecord.setValue("SURF_IDS", vectorFromArray);
        } else {
            Vector<String> vector = new Vector<String>(6);
            for (int i = 0; i < 6; ++i) {
                vector.add(((IFace)this.d_faces.get(i)).getMaterial().getName());
            }
            fDSInputRecord.setValue("SURF_ID6", vector);
        }
    }

    @Override
    public void getInputRecords(Collection<FDSInputRecord> collection) {
        Object object;
        FDSInputRecord fDSInputRecord = new FDSInputRecord();
        fDSInputRecord.setType(this.getFDSType());
        Vector<Double> vector = new Vector<Double>(6);
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        vector.add(new Double(this.d_minPoint.x(unit)));
        vector.add(new Double(this.d_maxPoint.x(unit)));
        vector.add(new Double(this.d_minPoint.y(unit)));
        vector.add(new Double(this.d_maxPoint.y(unit)));
        vector.add(new Double(this.d_minPoint.z(unit)));
        vector.add(new Double(this.d_maxPoint.z(unit)));
        fDSInputRecord.setValue("XB", vector);
        Color color = this.getColor();
        if (color != null) {
            object = color.getRGBComponents(null);
            Vector<Double> vector2 = new Vector<Double>(3);
            vector2.add(new Double(object[0]));
            vector2.add(new Double((double)object[1]));
            vector2.add(new Double((double)object[2]));
            fDSInputRecord.setValue("RGB", vector2);
        }
        if (this.getFDSType().equals("OBST") && !this.isVisible()) {
            fDSInputRecord.setValue("COLOR", "INVISIBLE");
        }
        fDSInputRecord.setComment(this.getName());
        this.fillMaterialRecords(fDSInputRecord);
        this.fillExtraRecords(fDSInputRecord);
        object = this.getEventInputRecords(fDSInputRecord);
        if (object.size() != 0) {
            collection.addAll((Collection<FDSInputRecord>)object);
        } else {
            collection.add(fDSInputRecord);
        }
    }

    static {
        byte[][] byArray = FACE_INDEX_ROT_LU = new byte[3][6];
        byArray[0][0] = 0;
        byArray[0][1] = 1;
        byArray[0][2] = 4;
        byArray[0][3] = 5;
        byArray[0][4] = 3;
        byArray[0][5] = 2;
        byArray[1][0] = 5;
        byArray[1][1] = 4;
        byArray[1][2] = 2;
        byArray[1][3] = 3;
        byArray[1][4] = 0;
        byArray[1][5] = 1;
        byArray[2][0] = 2;
        byArray[2][1] = 3;
        byArray[2][2] = 1;
        byArray[2][3] = 0;
        byArray[2][4] = 4;
        byArray[2][5] = 5;
    }

    static class AAlignedFDSObjectFace
    extends AbstractFace
    implements Serializable {
        static final long serialVersionUID = 1L;
        private AAlignedFDSObject d_block;
        private byte d_index;

        public AAlignedFDSObjectFace() {
        }

        public AAlignedFDSObjectFace(AAlignedFDSObject aAlignedFDSObject, byte by, Material material) {
            super(material);
            this.d_block = aAlignedFDSObject;
            this.d_index = by;
        }

        @Override
        public Object clone() {
            return super.clone();
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (!(object instanceof AAlignedFDSObjectFace)) {
                return false;
            }
            AAlignedFDSObjectFace aAlignedFDSObjectFace = (AAlignedFDSObjectFace)object;
            return this.d_index == aAlignedFDSObjectFace.d_index;
        }

        @Override
        public void setMaterial(Material material) {
            super.setMaterial(material);
        }

        @Override
        public String getName() {
            return FACE_NAMES[this.d_index];
        }

        @Override
        public void getGeometry(Geometry geometry) {
            Quad quad = Prism.getFaceForBox(this.d_block.getMinPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.d_block.getMaxPoint().getValue(Geometry.GEOM_LENGTH_UNIT), this.d_index, new PrimProps(this.getMaterial(), this.getGeometryColor()));
            geometry.addQuad(quad);
        }

        protected Color getGeometryColor() {
            return this.d_block.getColor();
        }

        @Override
        public UnitPoint3D[] getVerts() {
            return null;
        }

        @Override
        public FDSObject getAttachedObj() {
            return this.d_block;
        }

        @Override
        public IFDSFragGenerator getFDSFragGenerator() {
            return null;
        }
    }

    private class SaveGeomTask
    extends ATask {
        private UnitPoint3D d_min;
        private UnitPoint3D d_max;
        private final Material[] d_mats;

        public SaveGeomTask(int n) {
            super(n, true);
            this.d_mats = new Material[6];
        }

        @Override
        public void undo() {
            ADomainObject.pauseUpdates(AAlignedFDSObject.this);
            AAlignedFDSObject.this.setMinPoint(this.d_min);
            AAlignedFDSObject.this.setMaxPoint(this.d_max);
            for (int i = 0; i < 6; ++i) {
                ((IFace)AAlignedFDSObject.this.d_faces.get(i)).setMaterial(this.d_mats[i]);
            }
            ADomainObject.resumeUpdates(AAlignedFDSObject.this);
        }

        @Override
        public void run() {
            this.d_min = (UnitPoint3D)AAlignedFDSObject.this.getMinPoint().clone();
            this.d_max = (UnitPoint3D)AAlignedFDSObject.this.getMaxPoint().clone();
            for (int i = 0; i < 6; ++i) {
                this.d_mats[i] = ((IFace)AAlignedFDSObject.this.d_faces.get(i)).getMaterial();
            }
        }
    }
}

