/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.Point3D;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;

public class UnitPoint3D
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private double x;
    private double y;
    private double z;
    private Unit d_unit;

    public UnitPoint3D(Unit unit) {
        this.d_unit = unit;
    }

    public UnitPoint3D(double d, double d2, double d3, Unit unit) {
        this.set(d, d2, d3, unit);
    }

    public UnitPoint3D(double[] dArray, Unit unit) {
        assert (dArray.length >= 3);
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.d_unit = unit;
    }

    public UnitPoint3D(Point3D point3D, Unit unit) {
        this.set(point3D.x, point3D.y, point3D.z, unit);
    }

    public UnitPoint3D(Tuple3d tuple3d, Unit unit) {
        this.set(tuple3d.x, tuple3d.y, tuple3d.z, unit);
    }

    public void set(double d, double d2, double d3, Unit unit) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.d_unit = unit;
    }

    public static UnitPoint3D fromLegacy(pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D unitPoint3D) {
        Unit unit = unitPoint3D.x.getUnit();
        if (unit == null && (unit = unitPoint3D.y.getUnit()) == null && (unit = unitPoint3D.z.getUnit()) == null) {
            unit = SI.METER;
        }
        double d = unitPoint3D.x.getValue(unit);
        double d2 = unitPoint3D.y.getValue(unit);
        double d3 = unitPoint3D.z.getValue(unit);
        return new UnitPoint3D(d, d2, d3, unit);
    }

    public Point3D getValue(Unit unit) {
        assert (this.d_unit != null);
        if (unit.equals(this.d_unit)) {
            return new Point3D(this.x, this.y, this.z);
        }
        return new Point3D(UnitDouble.convert(this.x, this.d_unit, unit), UnitDouble.convert(this.y, this.d_unit, unit), UnitDouble.convert(this.z, this.d_unit, unit));
    }

    public Point3d getPoint3dValue(Unit unit) {
        assert (this.d_unit != null);
        if (unit.equals(this.d_unit)) {
            return new Point3d(this.x, this.y, this.z);
        }
        return new Point3d(UnitDouble.convert(this.x, this.d_unit, unit), UnitDouble.convert(this.y, this.d_unit, unit), UnitDouble.convert(this.z, this.d_unit, unit));
    }

    public Vector3d getVector3dValue(Unit unit) {
        assert (this.d_unit != null);
        if (unit.equals(this.d_unit)) {
            return new Vector3d(this.x, this.y, this.z);
        }
        return new Vector3d(UnitDouble.convert(this.x, this.d_unit, unit), UnitDouble.convert(this.y, this.d_unit, unit), UnitDouble.convert(this.z, this.d_unit, unit));
    }

    public void getData(double[] dArray, Unit unit) {
        assert (dArray.length >= 3);
        dArray[0] = this.x(unit);
        dArray[1] = this.y(unit);
        dArray[2] = this.z(unit);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public UnitDouble xu() {
        return new UnitDouble(this.x, this.d_unit);
    }

    public UnitDouble yu() {
        return new UnitDouble(this.y, this.d_unit);
    }

    public UnitDouble zu() {
        return new UnitDouble(this.z, this.d_unit);
    }

    public double x(Unit unit) {
        return UnitDouble.convert(this.x, this.d_unit, unit);
    }

    public double y(Unit unit) {
        return UnitDouble.convert(this.y, this.d_unit, unit);
    }

    public double z(Unit unit) {
        return UnitDouble.convert(this.z, this.d_unit, unit);
    }

    public void setX(UnitDouble unitDouble) {
        this.x = unitDouble.getValue(this.d_unit);
    }

    public void setY(UnitDouble unitDouble) {
        this.y = unitDouble.getValue(this.d_unit);
    }

    public void setZ(UnitDouble unitDouble) {
        this.z = unitDouble.getValue(this.d_unit);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public void setUnit(Unit unit) {
        this.d_unit = unit;
    }

    public void add(UnitPoint3D unitPoint3D) {
        this.x += unitPoint3D.x(this.d_unit);
        this.y += unitPoint3D.y(this.d_unit);
        this.z += unitPoint3D.z(this.d_unit);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnitPoint3D)) {
            return false;
        }
        UnitPoint3D unitPoint3D = (UnitPoint3D)object;
        if (this.d_unit.equals(unitPoint3D.d_unit)) {
            return this.x == unitPoint3D.x && this.y == unitPoint3D.y && this.z == unitPoint3D.z;
        }
        return this.xu().equals(unitPoint3D.xu()) && this.yu().equals(unitPoint3D.yu()) && this.zu().equals(unitPoint3D.zu());
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ") " + this.d_unit;
    }
}

