/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import pyrosim.legacy_2006_2.domain.Texture;
import pyrosim.legacy_2006_2.domain.TextureInfo;

public class TextureDB
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, TextureInfo> d_defaults = new HashMap<String, TextureInfo>();
    private Map<String, Texture> d_textures = new HashMap<String, Texture>();

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.d_textures = new HashMap<String, Texture>();
        this.d_defaults = new HashMap<String, TextureInfo>();
        objectInputStream.readInt();
        List list = (List)objectInputStream.readObject();
        for (TextureData textureData : list) {
            this.addToDB(textureData.id, textureData.img);
        }
    }

    public static TextureDB fromLegacy(pyrosim.legacy_2006_2.legacy.v17.TextureDB textureDB) {
        TextureDB textureDB2 = new TextureDB();
        for (String string : textureDB.keys()) {
            if (textureDB2.d_defaults.containsKey(string)) continue;
            System.out.println("importing legacy texture " + string + "...");
            pyrosim.legacy_2006_2.legacy.v17.TextureInfo textureInfo = textureDB.get(string);
            String string2 = textureInfo.getFileName();
            BufferedImage bufferedImage = textureInfo.getImage();
            textureDB2.addToDB(string2, bufferedImage);
        }
        return textureDB2;
    }

    public void addToDB(String string, BufferedImage bufferedImage) {
        Texture texture = new Texture(string, bufferedImage);
        this.d_textures.put(string, texture);
    }

    public TextureInfo addToDB(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage != null) {
                this.d_textures.put(file.getName(), new Texture(file.getName(), bufferedImage));
                TextureInfo textureInfo = new TextureInfo(file.getName());
                this.d_defaults.put(file.getName(), textureInfo);
                return textureInfo;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Set<String> names() {
        return this.d_textures.keySet();
    }

    public Texture getTexture(String string) {
        return this.d_textures.get(string);
    }

    public void setDefaultInfo(String string, TextureInfo textureInfo) {
        this.d_defaults.put(string, textureInfo);
    }

    public TextureInfo getDefaultInfo(String string) {
        return this.d_defaults.get(string);
    }

    private static class TextureData
    implements Serializable {
        static final long serialVersionUID = 8878324277380607853L;
        private static final int VERSION = 1;
        public String id;
        public BufferedImage img;

        public TextureData(String string, BufferedImage bufferedImage) {
            this.id = string;
            this.img = bufferedImage;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(this.id);
            if (this.img != null) {
                ImageIO.write((RenderedImage)this.img, "jpg", objectOutputStream);
            } else {
                objectOutputStream.writeObject(null);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.readInt();
            this.id = (String)objectInputStream.readObject();
            this.img = ImageIO.read(objectInputStream);
        }
    }
}

