/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.util.Set;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.MaterialDomainEvent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.events.ReactionDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.util.SetMetrics;

public class PyroSimSelectionModel {
    private final SetMetrics d_selData = new SetMetrics();
    private final PyroMod d_pyMod;

    public PyroSimSelectionModel(PyroMod pyroMod) {
        this.d_pyMod = pyroMod;
    }

    public void select(Object object) {
        if (object instanceof FDSObject) {
            throw new IllegalArgumentException("FDSObject selection is not handled here!");
        }
        this.d_selData.add(object);
        if (object instanceof Grid) {
            this.d_pyMod.fireDomainEvent(new GridDomainEvent((Grid)object, 0));
        } else if (object instanceof Material) {
            this.d_pyMod.fireDomainEvent(new MaterialDomainEvent((Material)object, 0));
        } else if (object instanceof Reaction) {
            this.d_pyMod.fireDomainEvent(new ReactionDomainEvent((Reaction)object, 0));
        } else {
            this.d_pyMod.fireDomainEvent(new PyroDomainEvent(object, object.getClass(), 0));
        }
    }

    public void deselect(Object object) {
        if (object instanceof FDSObject) {
            throw new IllegalArgumentException("FDSObject selection is not handled here!");
        }
        this.d_selData.remove(object);
        if (object instanceof Grid) {
            this.d_pyMod.fireDomainEvent(new GridDomainEvent((Grid)object, 0));
        } else if (object instanceof Material) {
            this.d_pyMod.fireDomainEvent(new MaterialDomainEvent((Material)object, 0));
        } else if (object instanceof Reaction) {
            this.d_pyMod.fireDomainEvent(new ReactionDomainEvent((Reaction)object, 0));
        } else {
            this.d_pyMod.fireDomainEvent(new PyroDomainEvent(object, object.getClass(), 0));
        }
    }

    public void clearSelection() {
        Set set = this.getSelected(Object.class);
        for (Object e : set) {
            this.deselect(e);
        }
    }

    public boolean isSelected(Object object) {
        return this.d_selData.contains(object);
    }

    public Set getSelected(Class clazz) {
        return this.d_selData.filter(clazz);
    }

    public boolean isExclusive(Class clazz) {
        return this.d_selData.isExclusive(clazz);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PyroSimSelectionModel:" + this.hashCode() + " {\n");
        stringBuffer.append("   Object.class       -->> " + this.d_selData.getNum(Object.class) + "\n");
        stringBuffer.append("   GridList.class     -->> " + this.d_selData.getNum(GridList.class) + "\n");
        stringBuffer.append("   Grid.class         -->> " + this.d_selData.getNum(Grid.class) + "\n");
        stringBuffer.append("   MaterialList.class -->> " + this.d_selData.getNum(MaterialList.class) + "\n");
        stringBuffer.append("   Material.class     -->> " + this.d_selData.getNum(Material.class) + "\n");
        stringBuffer.append("   ReactionList.class -->> " + this.d_selData.getNum(ReactionList.class) + "\n");
        stringBuffer.append("   Reaction.class     -->> " + this.d_selData.getNum(Reaction.class) + "\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

