/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.legacy_2006_2.FdsNonSISystem;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroMod;
import pyrosim.legacy_2006_2.Rectifier;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AAlignedFDSObject;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.AbstractFDSObject;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FileModelImage;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.Ramp;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.geom.Prism;
import pyrosim.legacy_2006_2.geom.Quad;
import pyrosim.legacy_2006_2.io.FDSInputFile;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.FDSParsingInfo;
import pyrosim.legacy_2006_2.legacy.BNDFList;
import pyrosim.legacy_2006_2.legacy.BNDFRecord;
import pyrosim.legacy_2006_2.legacy.MaterialList;
import pyrosim.legacy_2006_2.legacy.RampList;
import pyrosim.legacy_2006_2.legacy.ReactionList;
import pyrosim.legacy_2006_2.legacy.v16.AlignedBlock;
import pyrosim.legacy_2006_2.legacy.v16.AlignedHole;
import pyrosim.legacy_2006_2.legacy.v16.Hole;
import pyrosim.legacy_2006_2.legacy.v16.Wall;
import pyrosim.legacy_2006_2.legacy.v17.MVBackgroundImage;
import pyrosim.legacy_2006_2.legacy.v17.TextureInfo;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.util.Sets;
import pyrosim.legacy_2006_2.thunderheadeng.util.UnitDoubleRectifier;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class PyroSimObjectInputStream
extends ObjectInputStream {
    private int d_version;
    public static final byte[] FORMAT_CODE = new byte[]{80, 83, 77, 48, 48, 49, 57};
    private RampList d_legacyRampList = null;
    private final WarningReport<Warning> d_warnings = new WarningReport<Warning>(Warning.class, Warning.getWarningInfoTypes(), Warning.getWarningInfoDescriptions(), 0);

    public PyroSimObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        byte[] byArray = new byte[FORMAT_CODE.length];
        this.read(byArray);
        String string = new String(byArray);
        this.d_version = Integer.parseInt(string.substring(3));
        this.enableResolveObject(true);
    }

    public boolean canOpenVersion() {
        return this.d_version < 21;
    }

    public int getVersion() {
        return this.d_version;
    }

    public Serialized readModel() throws IOException, ClassNotFoundException {
        System.out.println("loading model (v " + this.d_version + ")");
        Serialized serialized = null;
        if (this.d_version == 1) {
            return null;
        }
        if (this.d_version <= 5) {
            serialized = new Serialized();
            serialized.d_materials = (pyrosim.legacy_2006_2.domain.MaterialList)this.readObject();
            serialized.d_walls = (FDSComposite)this.readObject();
            if (this.d_version == 2) {
                serialized.d_grids = new Vector();
                serialized.d_grids.add((Grid)this.readObject());
            } else {
                serialized.d_grids = (Vector)this.readObject();
            }
            serialized.d_floors = this.d_version <= 3 ? new Hashtable() : (Hashtable)this.readObject();
            if (this.d_version <= 4) {
                serialized.d_unprocessedRecords = new String();
            } else {
                Vector vector = (Vector)this.readObject();
                serialized.d_unprocessedRecords = FDSInputFile.renderRecords(vector);
            }
            serialized.d_simulationType = 0;
            serialized.d_reaction = null;
            serialized.d_ambientTemp = null;
            serialized.d_outsideTemp = null;
            serialized.d_initVel = null;
            serialized.d_numFrames = 1000;
        } else {
            serialized = (Serialized)this.readObject();
        }
        if (this.d_version < 13) {
            this.checkPre13ValueRanges(serialized);
            if (serialized.d_headRecord == null) {
                serialized.d_headRecord = new HeadRecord();
            }
            if (serialized.d_thcpList == null) {
                serialized.d_thcpList = new ThcpList();
            }
            if (serialized.d_bndfList == null) {
                serialized.d_bndfList = new pyrosim.legacy_2006_2.domain.BNDFList();
            }
            if (serialized.d_pl3dRecord == null) {
                serialized.d_pl3dRecord = new PL3DRecord(null);
            }
            if (serialized.d_isofList == null) {
                serialized.d_isofList = new IsofList();
            }
            if (serialized.d_slcfList == null) {
                serialized.d_slcfList = new SlcfList();
            }
            if (serialized.d_partList == null) {
                serialized.d_partList = new PartList();
            }
            if (serialized.d_sprkList == null) {
                serialized.d_sprkList = new SprkList();
            }
            if (serialized.d_pipeRecord == null) {
                serialized.d_pipeRecord = new PipeRecord(new UnitDouble(0.0, FdsSISystem.getInstance().getTimeUnit()), null);
            }
            if (serialized.d_reactions == null) {
                serialized.d_reactions = new pyrosim.legacy_2006_2.domain.ReactionList();
            }
            if (serialized.d_useAutoMixtureFractionAdjust == null) {
                serialized.d_useAutoMixtureFractionAdjust = new Boolean(true);
            }
            if (serialized.d_useGasPhaseFireSuppression == null) {
                serialized.d_useGasPhaseFireSuppression = new Boolean(true);
            }
            if (serialized.d_heatDetectors == null) {
                serialized.d_heatDetectors = new HeatDetectorList();
            }
            if (serialized.d_initVel != null) {
                if (serialized.d_initVel.getUnit().equals(SI.METER)) {
                    serialized.d_initVel.setUnit(FdsSISystem.getInstance().getVelocityUnit());
                } else if (serialized.d_initVel.getUnit().equals(NonSI.FOOT)) {
                    serialized.d_initVel.setUnit(FdsNonSISystem.getInstance().getVelocityUnit());
                }
            }
        }
        if (this.d_version < 14) {
            this.stripPre14FYIFromMaterials(serialized);
            this.replacePre14MaterialRamps(serialized);
            this.ensureUniquePre14GridNames(serialized);
        }
        if (this.d_version < 17) {
            if (serialized.d_smodList == null) {
                serialized.d_smodList = new SmodList();
            }
            this.updatePre17FloorImageLocations(serialized);
            this.mergePre17MaterialDuplicates(serialized);
            this.ensureCorrectPre17MinsAndMaxes(serialized);
            this.updatePre17Textures(serialized);
        }
        return serialized;
    }

    public WarningReport<Warning> getWarnings() {
        return this.d_warnings;
    }

    private void checkPre13ValueRanges(Serialized serialized) {
        if (!PyroMod.MiscRecord.getValueRange("NFRAMES").checkValue(serialized.d_numFrames)) {
            serialized.d_numFrames = 1000;
        }
        Unit unit = FdsSISystem.getInstance().getTimeUnit();
        if (serialized.d_partNpps != null && !PyroMod.MiscRecord.getValueRange("NPPS").checkValue((int)serialized.d_partNpps.getValue(unit))) {
            serialized.d_partNpps = FDSInputRecord.DEF_NPPS;
        }
        if (!PyroMod.MiscRecord.getValueRange("MAXIMUM_DROPLETS").checkValue(serialized.d_partMaxDrop)) {
            serialized.d_partMaxDrop = 500000;
        }
        if (serialized.d_dtcore != null && !PyroMod.MiscRecord.getValueRange("DTCORE").checkValue(serialized.d_dtcore)) {
            serialized.d_dtcore = null;
        }
        if (serialized.d_partDtsam != null && !PyroMod.MiscRecord.getValueRange("DTSAM_PART").checkValue(serialized.d_partDtsam)) {
            serialized.d_partDtsam = null;
        }
        if (serialized.d_initialTimeStep != null && !PyroMod.TimeRecord.getValueRange("DT").checkValue(serialized.d_initialTimeStep)) {
            serialized.d_initialTimeStep = null;
        }
        if (serialized.d_simulationEndTime != null && !PyroMod.TimeRecord.getValueRange("TWFIN").checkValue(serialized.d_simulationEndTime)) {
            serialized.d_simulationEndTime = FDSInputRecord.DEF_TWFIN;
        }
        if (serialized.d_partDtpar != null && !PyroMod.MiscRecord.getValueRange("DTPAR").checkValue(serialized.d_partDtpar)) {
            serialized.d_partDtpar = FDSInputRecord.DEF_DTPAR;
        }
        if (serialized.d_sprkDtspar != null && !PyroMod.MiscRecord.getValueRange("DTSPAR").checkValue(serialized.d_sprkDtspar)) {
            serialized.d_sprkDtspar = FDSInputRecord.DEF_DTSPAR;
        }
        if (serialized.d_ambientPressure != null && !PyroMod.MiscRecord.getValueRange("PINF").checkValue(serialized.d_ambientPressure)) {
            serialized.d_ambientPressure = FDSInputRecord.DEF_AMBIENT_PRESSURE;
        }
        if (!PyroMod.MiscRecord.getValueRange("SC").checkValue(serialized.d_schmidt)) {
            serialized.d_schmidt = 0.5;
        }
        if (!PyroMod.MiscRecord.getValueRange("PR").checkValue(serialized.d_prandtl)) {
            serialized.d_prandtl = 0.5;
        }
        if (!PyroMod.MiscRecord.getValueRange("CSMAG").checkValue(serialized.d_smag)) {
            serialized.d_smag = 0.2;
        }
    }

    private void stripPre14FYIFromMaterials(Serialized serialized) {
        for (Material material : serialized.d_materials) {
            material.setValue("FYI", null);
        }
    }

    private void replacePre14MaterialRamps(Serialized serialized) {
        System.out.println("Replacing Ramp strings with Ramp objects in pre-version 14 Materials...");
        if (this.d_legacyRampList == null) {
            try {
                System.out.println("Reprocessing ramps from unprocessed records...");
                String string = serialized.d_unprocessedRecords;
                FDSInputFile fDSInputFile = new FDSInputFile();
                PyroMod pyroMod = new PyroMod();
                pyroMod.pauseUpdates();
                pyroMod.getMaterials().taskAddAll((Collection<? extends Material>)serialized.d_materials.toCollection()).run();
                HashSet<String> hashSet = Sets.fromArrayHS("SURF");
                FDSParsingInfo fDSParsingInfo = new FDSParsingInfo(hashSet, pyroMod, new Vector<PyroMod>(), 1, false);
                fDSInputFile.parseRecords(string, "", fDSParsingInfo);
                serialized.d_materials = pyroMod.getMaterials();
                pyroMod.resumeUpdates();
                pyroMod.release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        Collection<String> collection = Material.getRampTypes();
        for (Material material : serialized.d_materials) {
            for (String string : collection) {
                String string2 = (String)material.getValue(string);
                if (string2 == null) continue;
                Ramp ramp = this.d_legacyRampList.getRamp(string2);
                if (ramp != null) {
                    Ramp ramp2 = this.createMaterialRampFromNewContext(ramp, string);
                    material.setValue(string, ramp2);
                    continue;
                }
                material.setValue(string, null);
            }
            material.recalcProfilePath();
        }
        this.d_legacyRampList = null;
    }

    private Ramp createMaterialRampFromNewContext(Ramp ramp, String string) {
        FdsSISystem fdsSISystem = FdsSISystem.getInstance();
        Material.RampInfo rampInfo = Material.getRampInfo(string);
        Collection<RampRecord> collection = ramp.getRecords();
        Vector<RampRecord> vector = new Vector<RampRecord>(collection.size());
        for (RampRecord rampRecord : collection) {
            UnitDouble unitDouble = rampRecord.getT();
            UnitDouble unitDouble2 = rampRecord.getF();
            UnitDouble unitDouble3 = unitDouble.getUnit() != null ? unitDouble : new UnitDouble(unitDouble.getValueNoUnit(), fdsSISystem.getUnit(rampInfo.d_tUnit));
            UnitDouble unitDouble4 = unitDouble2.getUnit() != null ? unitDouble2 : new UnitDouble(unitDouble2.getValueNoUnit(), fdsSISystem.getUnit(rampInfo.d_fUnit));
            RampRecord rampRecord2 = new RampRecord(rampRecord.getName(), unitDouble3, unitDouble4, rampInfo.d_tUnit, rampInfo.d_fUnit);
            vector.add(rampRecord2);
        }
        Ramp ramp2 = new Ramp(ramp.getName(), vector);
        return ramp2;
    }

    private void mergePre17MaterialDuplicates(Serialized serialized) {
        System.out.println("Merging duplicate materials for pre-version 17 obstructions...");
        pyrosim.legacy_2006_2.domain.MaterialList materialList = serialized.d_materials;
        HashMap<String, Material> hashMap = new HashMap<String, Material>(materialList.size(), 1.0f);
        for (IDependent iDependent : materialList) {
            hashMap.put(((Material)iDependent).getName(), (Material)iDependent);
        }
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(serialized.d_walls);
        while (deepFDSObjectIterator.hasNext()) {
            Material material;
            IDependent iDependent;
            iDependent = deepFDSObjectIterator.next();
            if (iDependent.isUniformMaterial()) {
                Material material2 = iDependent.getMaterial();
                if (material2 == null || (material = (Material)hashMap.get(material2.getName())) == material2) continue;
                iDependent.setMaterial(material);
                continue;
            }
            for (int i = 0; i < iDependent.getNumFaces(); ++i) {
                Material material3;
                material = iDependent.getMaterial(i);
                if (material == null || (material3 = (Material)hashMap.get(material.getName())) == material) continue;
                iDependent.setMaterial(i, material3);
            }
        }
    }

    private void ensureUniquePre14GridNames(Serialized serialized) {
        PyroMod pyroMod = new PyroMod();
        GridList gridList = pyroMod.getGridManager();
        for (Grid grid : gridList) {
            gridList.taskMakeUnique(grid).run();
        }
        pyroMod.release();
    }

    private void updatePre17FloorImageLocations(Serialized serialized) {
        PyroMod pyroMod = new PyroMod(serialized);
        pyroMod.pauseUpdates(false);
        for (Floor floor : pyroMod.getFloorManager()) {
            ModelImage modelImage = floor.getBgImage();
            if (modelImage == null) continue;
            modelImage.setZLocationModel(floor.getBottom());
        }
        pyroMod.resumeUpdates();
        pyroMod.release();
    }

    private void ensureCorrectPre17MinsAndMaxes(Serialized serialized) {
        UnitPoint3D unitPoint3D;
        Cloneable cloneable;
        Object object3;
        Object object2;
        PyroMod pyroMod = new PyroMod();
        pyroMod.pauseUpdates(false);
        Collection<AAlignedFDSObject> collection = serialized.d_walls.toCollection(AAlignedFDSObject.class, true);
        for (AAlignedFDSObject object32 : collection) {
            object2 = object32.getMinPoint();
            if (!Rectifier.rectify((UnitPoint3D)object2, (UnitPoint3D)(object3 = object32.getMaxPoint()))) continue;
            object32.setMinPoint((UnitPoint3D)object2);
            object32.setMaxPoint((UnitPoint3D)object3);
            this.addMinMaxWarning("Aligned Block", object32.getName());
        }
        Collection<AUnalignedFDSObject> collection2 = serialized.d_walls.toCollection(AUnalignedFDSObject.class, true);
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            object2 = (AUnalignedFDSObject)iterator.next();
            object3 = new UnitDoubleRectifier(((AUnalignedFDSObject)object2).getBottom(), ((AUnalignedFDSObject)object2).getTop());
            if (!((UnitDoubleRectifier)object3).rectify()) continue;
            ((AUnalignedFDSObject)object2).setBottom(((UnitDoubleRectifier)object3).d_p1);
            ((AUnalignedFDSObject)object2).setTop(((UnitDoubleRectifier)object3).d_p2);
            this.d_warnings.addWarning(new Warning("The bottom value for the Unaligned Obstruction, " + ((AbstractFDSObject)object2).getName() + ", was higher than the top value.", "Swapped the values so that the bottom is lower than the top."));
        }
        Collection<Vent> collection3 = serialized.d_walls.toCollection(Vent.class, true);
        for (Object object3 : collection3) {
            cloneable = ((Vent)object3).getMinPoint();
            if (Rectifier.rectify((UnitPoint3D)cloneable, unitPoint3D = ((Vent)object3).getMaxPoint())) {
                this.addMinMaxWarning("Vent", ((AbstractFDSObject)object3).getName());
            }
            ((Vent)object3).setActualGeometry((UnitPoint3D)cloneable, unitPoint3D);
        }
        object2 = pyroMod.getGridManager();
        object3 = ((GridList)object2).iterator();
        while (object3.hasNext()) {
            UnitPoint3D unitPoint3D2;
            cloneable = object3.next();
            unitPoint3D = ((Grid)cloneable).getMinPoint();
            if (!Rectifier.rectify(unitPoint3D, unitPoint3D2 = ((Grid)cloneable).getMaxPoint())) continue;
            Grid grid = new Grid(unitPoint3D, unitPoint3D2, ((Grid)cloneable).getXDivisions().length, ((Grid)cloneable).getYDivisions().length, ((Grid)cloneable).getZDivisions().length, ((Grid)cloneable).getName());
            ((Grid)cloneable).imprint(grid);
            this.addMinMaxWarning("Grid", ((Grid)cloneable).getName());
        }
        pyroMod.resumeUpdates();
        pyroMod.release();
    }

    private void addMinMaxWarning(String string, String string2) {
        this.d_warnings.addWarning(new Warning("The " + string + ", \"" + string2 + ",\" contained a minimum coordinate " + "that was greater than the corresponding maximum coordinate.", "Swapped the values so that the minimum is less than the maximum."));
    }

    private void updatePre17Textures(Serialized serialized) {
        for (Material material : serialized.d_materials) {
            material.updateTextureInfo(serialized.d_textures);
        }
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        Class clazz;
        String string = objectStreamClass.getName();
        long l = objectStreamClass.getSerialVersionUID();
        if (this.d_version < 12 && string.equals("pyrosim.domain.MaterialList")) {
            clazz = MaterialList.class;
        } else if (this.d_version < 12 && string.equals("pyrosim.domain.ReactionList")) {
            clazz = ReactionList.class;
        } else if (this.d_version < 13 && string.equals("pyrosim.domain.BNDFList")) {
            clazz = BNDFList.class;
        } else if (string.equals("pyrosim.domain.BNDFRecord$ExtraParam") && l == -3787083572685316498L) {
            clazz = BNDFRecord.ExtraParam.class;
        } else if (this.d_version < 13 && string.equals("pyrosim.domain.HeatDetectorList")) {
            clazz = pyrosim.legacy_2006_2.legacy.HeatDetectorList.class;
        } else if (this.d_version < 14 && string.equals("pyrosim.domain.RampList")) {
            clazz = RampList.class;
        } else if (this.d_version < 15 && string.equals("pyrosim.domain.Hole")) {
            clazz = pyrosim.legacy_2006_2.legacy.v15.Hole.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.AlignedHole")) {
            clazz = AlignedHole.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.AlignedBlock")) {
            clazz = pyrosim.legacy_2006_2.legacy.v16.AlignedBlock.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.AlignedBlock$AlignedBlockFace")) {
            clazz = AlignedBlock.AlignedBlockFace.class;
        } else if (this.d_version < 16 && string.equals("[Lpyrosim.domain.AlignedBlock$AlignedBlockFace;")) {
            clazz = AlignedBlock.AlignedBlockFace[].class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.Wall")) {
            clazz = pyrosim.legacy_2006_2.legacy.v16.Wall.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.Hole")) {
            clazz = Hole.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.Wall$BlockFace")) {
            clazz = Wall.BlockFace.class;
        } else if (this.d_version < 16 && string.equals("pyrosim.domain.Hole$BlockFace")) {
            clazz = Hole.BlockFace.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.mv.MVBackgroundImage")) {
            clazz = MVBackgroundImage.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.geom.Quad")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.Quad.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.geom.Prism")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.Prism.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.domain.TextureInfo")) {
            clazz = TextureInfo.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.TextureDB")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.TextureDB.class;
        } else if (this.d_version < 17 && string.equals("pyrosim.UnitPoint3D")) {
            clazz = pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D.class;
        } else if (this.d_version < 21 && string.equals("thunderheadeng.units.UnitPoint3D")) {
            clazz = UnitPoint3D.class;
        } else if (this.d_version < 21 && string.equals("[Lthunderheadeng.units.UnitPoint3D;")) {
            clazz = new UnitPoint3D[0].getClass();
        } else if (this.d_version < 21 && string.equals("thunderheadeng.units.UnitPoint2D")) {
            clazz = UnitPoint2D.class;
        } else if (this.d_version < 21 && string.equals("[Lthunderheadeng.units.UnitPoint2D;")) {
            clazz = new UnitPoint2D[0].getClass();
        } else {
            String string2 = string;
            string2 = string2.replaceFirst("pyrosim.", "pyrosim.legacy_2006_2.");
            string2 = string2.replaceFirst("thunderheadeng.", "pyrosim.legacy_2006_2.thunderheadeng.");
            return Class.forName(string2);
        }
        return clazz;
    }

    @Override
    protected Object resolveObject(Object object) {
        if (object instanceof MaterialList) {
            return pyrosim.legacy_2006_2.domain.MaterialList.fromLegacy((MaterialList)object);
        }
        if (object instanceof ReactionList) {
            return pyrosim.legacy_2006_2.domain.ReactionList.fromLegacy((ReactionList)object);
        }
        if (object instanceof BNDFList) {
            return pyrosim.legacy_2006_2.domain.BNDFList.fromLegacy((BNDFList)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.HeatDetectorList) {
            return HeatDetectorList.fromLegacy((pyrosim.legacy_2006_2.legacy.HeatDetectorList)object);
        }
        if (object instanceof RampList) {
            this.d_legacyRampList = (RampList)object;
            return object;
        }
        if (object instanceof BNDFRecord.ExtraParam) {
            return object;
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v15.Hole) {
            return pyrosim.legacy_2006_2.domain.AlignedHole.fromLegacy(AlignedHole.fromLegacy((pyrosim.legacy_2006_2.legacy.v15.Hole)object));
        }
        if (object instanceof AlignedHole) {
            return pyrosim.legacy_2006_2.domain.AlignedHole.fromLegacy((AlignedHole)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v16.AlignedBlock) {
            return AlignedBlock.fromLegacy((pyrosim.legacy_2006_2.legacy.v16.AlignedBlock)object);
        }
        if (object instanceof Hole) {
            return pyrosim.legacy_2006_2.domain.Hole.fromLegacy((Hole)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v16.Wall) {
            return Wall.fromLegacy((pyrosim.legacy_2006_2.legacy.v16.Wall)object);
        }
        if (object instanceof MVBackgroundImage) {
            return FileModelImage.fromLegacy((MVBackgroundImage)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v17.Quad) {
            return Quad.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.Quad)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v17.Prism) {
            return Prism.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.Prism)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v17.TextureDB) {
            return TextureDB.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.TextureDB)object);
        }
        if (object instanceof pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D) {
            return UnitPoint3D.fromLegacy((pyrosim.legacy_2006_2.legacy.v17.UnitPoint3D)object);
        }
        return object;
    }

    @Override
    public String readUTF() throws IOException {
        String string;
        String string2 = string = super.readUTF();
        if (this.d_version < 8) {
            if ("pyrosim.domain.Block".equals(string)) {
                string2 = "pyrosim.domain.AlignedBlock";
                System.out.println("Replaced \"" + string + "\" with \"" + string2 + "\"");
            } else if ("pyrosim/domain/Block".equals(string)) {
                string2 = "pyrosim/domain/AlignedBlock";
                System.out.println("Replaced \"" + string + "\" with \"" + string2 + "\"");
            }
        }
        return string2;
    }
}

