/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2006_2;

import java.awt.Color;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JFrame;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.legacy_2006_2.FdsSISystem;
import pyrosim.legacy_2006_2.PyroSimObjectInputStream;
import pyrosim.legacy_2006_2.PyroSimSelectionModel;
import pyrosim.legacy_2006_2.PyroTaskManager;
import pyrosim.legacy_2006_2.ReplaceDlg;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitPoint3D;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.DeepFDSObjectIterator;
import pyrosim.legacy_2006_2.domain.DisplayablePointObject;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FDSObject;
import pyrosim.legacy_2006_2.domain.FDSObjectManager;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.FloorManager;
import pyrosim.legacy_2006_2.domain.Grid;
import pyrosim.legacy_2006_2.domain.GridList;
import pyrosim.legacy_2006_2.domain.HeadManager;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IFDSRenderable;
import pyrosim.legacy_2006_2.domain.IPyroManager;
import pyrosim.legacy_2006_2.domain.IPyroObject;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.MiscManager;
import pyrosim.legacy_2006_2.domain.PL3DManager;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PipeManager;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RadiManager;
import pyrosim.legacy_2006_2.domain.RadiRecord;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.ReactionList;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.TimeManager;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.domain.dependencies.ADependencyManager;
import pyrosim.legacy_2006_2.domain.dependencies.FDSDependencyMap;
import pyrosim.legacy_2006_2.domain.dependencies.IDependedOn;
import pyrosim.legacy_2006_2.domain.dependencies.IDependent;
import pyrosim.legacy_2006_2.domain.dependencies.IPyroDependedOn;
import pyrosim.legacy_2006_2.domain.rasterization.FDSRasterization;
import pyrosim.legacy_2006_2.events.FDSRasterDomainEvent;
import pyrosim.legacy_2006_2.events.GridDomainEvent;
import pyrosim.legacy_2006_2.events.PyroDomainEvent;
import pyrosim.legacy_2006_2.events.PyroModDomainEvent;
import pyrosim.legacy_2006_2.io.FDSInputFile;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.io.ReacProcessor;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainEvent;
import pyrosim.legacy_2006_2.thunderheadeng.gui.IDomainListener;
import pyrosim.legacy_2006_2.thunderheadeng.gui.Mediator;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2006_2.thunderheadeng.units.UnitDoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.CompositeTask;
import pyrosim.legacy_2006_2.thunderheadeng.util.Disposable;
import pyrosim.legacy_2006_2.thunderheadeng.util.DisposableCounter;
import pyrosim.legacy_2006_2.thunderheadeng.util.DoubleValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.IntValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.Keyable;
import pyrosim.legacy_2006_2.thunderheadeng.util.KeyableObject;
import pyrosim.legacy_2006_2.thunderheadeng.util.Task;
import pyrosim.legacy_2006_2.thunderheadeng.util.TaskManager;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypedCollection;
import pyrosim.legacy_2006_2.thunderheadeng.util.TypedList;
import pyrosim.legacy_2006_2.thunderheadeng.util.ValueRange;
import pyrosim.legacy_2006_2.thunderheadeng.util.VectorFromArray;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class PyroMod
extends Mediator
implements Serializable,
Disposable {
    static final long serialVersionUID = 1L;
    public static final String DEF_DATABASE_FILENAME = "database4.data";
    public static final String DEF_DATABASE_FILEPATH = "no longer used!";
    public static final String NEWMODELPREF_DATABASE_FILE = "DatabaseFile";
    public static final String PREF_RESTART = "RestartPreviousCalculation";
    public static final String NEWMODELPREF_DTCORE = "SaveRestartFiles";
    public static final String NEWMODELPREF_SIM_END_TIME = "NewModelSimEndTime";
    public static final String NEWMODELPREF_SIM_TIME_STEP = "NewModelSimTimeStep";
    public static final String NEWMODELPREF_SIM_SYNC = "NewModelSimSync";
    public static final String NEWMODELPREF_SIM_NUM_FRAMES = "NewModelSimNumFrames";
    public static final String NEWMODELPREF_ATM_TEMP_LAPSE = "NewModelAtmosphericTempLapseRate";
    public static final String NEWMODELPREF_SIM_TMPA = "NewModelSimAmbientTemp";
    public static final String NEWMODELPREF_SIM_PRESSAMB = "NewModelSimAmbientPressure";
    public static final String NEWMODELPREF_SIM_TMPO = "NewModelSimOutsideTemp";
    public static final String NEWMODELPREF_SIM_U0 = "NewModelSimU0";
    public static final String NEWMODELPREF_SIM_V0 = "NewModelSimV0";
    public static final String NEWMODELPREF_SIM_W0 = "NewModelSimW0";
    public static final String NEWMODELPREF_AUTOMFADJUST = "NewModelAutoMixFracAdj";
    public static final String NEWMODELPREF_GPFSUPPRESS = "NewModelGasPhaseFireSup";
    public static final String NEWMODELPREF_SIM_GVECX = "NewModelSimGvecX";
    public static final String NEWMODELPREF_SIM_GVECY = "NewModelSimGvecY";
    public static final String NEWMODELPREF_SIM_GVECZ = "NewModelSimGvecZ";
    public static final String NEWMODELPREF_NULLVALUE = "null";
    public static final String NEWMODELPREF_SIM_SMAG = "SmagorinskyConstant";
    public static final String NEWMODELPREF_SIM_SCHMIDT = "SchmidtNumber";
    public static final String NEWMODELPREF_SIM_PRANDTL = "PrandtlNumber";
    public static final String PREF_ISOTHERMAL = "IsothermalCalcuation";
    public static final String PREF_INCOMPRESSIBLE = "IncompressibleCalculation";
    public static final String PREF_RADSOLVER = "RadiationSolver";
    public static final String PREF_SMOKEOFF = "3DSmokeVisualization";
    public static final String PREF_SIMTYPE = "SimulationType";
    public static final String PREF_BAROCLINIC = "BaroclinicTorque";
    public static final String PREF_LASTMATLIBRARY = "LastMaterialLib";
    public static final String PREF_LASTREACLIBRARY = "LastReactionLib";
    public static final String PREF_FDSLOCATION = "FDSLocation";
    public static final String PREF_SVLOCATION = "SVLocation";
    public static final String PREF_DXFLOCATION = "DXFLocation";
    public static final String PREF_RUNSV = "RunSV";
    public static final String PREF_DRAWCOLORBUFFER = "EnableColorBufferDrawing";
    public static final String PREF_DRAWDEPTHBUFFER = "EnableDepthBufferDrawing";
    public static final String PREF_USEVERTEXBUFFERS = "UseVertexBuffers";
    public static final String NEWMODELPREF_SPRK_POROUSFLOOR = "PorousFloor";
    public static final String NEWMODELPREF_SPRK_DTSPAR = "NewModelSprinklerDtspar";
    public static final String NEWMODELPREF_PART_DTSAM = "NewModelParticleDtsam";
    public static final String NEWMODELPREF_PART_DTPAR = "NewModelParticleDtpar";
    public static final String NEWMODELPREF_PART_NPPS = "NewModelParticleNumPartsPerSec";
    public static final String NEWMODELPREF_PART_MAXDROP = "NewModelParticleMaxDroplets";
    public static final String PREF_ANGLE_INCREMENT = "AngleIncrement";
    public static final String PREF_CH4_BANDS = "CH4Bands";
    public static final String PREF_KAPPA0 = "Kappa0";
    public static final String PREF_NMIEANG = "NMIEAng";
    public static final String PREF_NUMBER_RADIATION_ANGLES = "NumberRadAngles";
    public static final String PREF_PATH = "RadiPath";
    public static final String PREF_RADTMP = "RadSrcTemp";
    public static final String PREF_TIME_STEP_INCREMENT = "TimeStepIncrement";
    public static final String PREF_WIDE_BAND_MODEL = "WideBandModel";
    private DisposableCounter d_dc = new DisposableCounter();
    public Serialized ser;
    private final transient PyroModDependencyManager d_dependencyManager;
    private final transient TaskManager d_taskMan;
    private transient boolean d_rasterPreview = false;
    private final transient File d_sprkDir;
    private transient UnitDouble d_alignTol;
    private transient PyroSimSelectionModel d_selModel;
    private final transient FDSRasterization d_rasterizations = new FDSRasterization(this);
    private final transient HeadManager d_headManager = new HeadManager(this);
    private final transient GridList d_gridList = new GridList(this);
    private final transient TimeManager d_timeManager = new TimeManager(this);
    private final transient FloorManager d_floorManager = new FloorManager(this);
    private final transient MiscManager d_miscManager = new MiscManager(this);
    private final transient RadiManager d_radiManager = new RadiManager(this);
    private final transient PL3DManager d_pl3dManager = new PL3DManager(this);
    private final transient PipeManager d_pipeManager = new PipeManager(this);

    public PyroMod() {
        this(null, false);
    }

    public PyroMod(Serialized serialized) {
        this(serialized, false);
    }

    public PyroMod(boolean bl) {
        this(null, bl);
    }

    public PyroMod(Serialized serialized, boolean bl) {
        this.d_selModel = new PyroSimSelectionModel(this);
        this.d_dependencyManager = new PyroModDependencyManager();
        this.d_taskMan = new PyroTaskManager(this);
        this.d_sprkDir = PyroSim.getApp() != null ? PyroSim.getApp().getDatabaseDir() : null;
        if (serialized == null) {
            this.ser = new Serialized();
            this.resetModel();
        } else {
            this.ser = serialized;
            this.updateManagersForLegacyStorage();
        }
        this.initializeListeners();
        this.d_alignTol = null;
        this.addListener(new IDomainListener(){

            public void domainChanged(List list, Mediator mediator) {
                for (Object e : list) {
                    if (!(e instanceof GridDomainEvent) && !(e instanceof PyroDomainEvent) && !(e instanceof PyroModDomainEvent)) continue;
                    PyroMod.this.d_alignTol = null;
                }
            }
        });
    }

    public UnitDouble getAlignTol() {
        if (this.d_alignTol == null) {
            this.d_alignTol = this.calcAlignTol();
        }
        return this.d_alignTol;
    }

    private UnitDouble calcAlignTol() {
        if (!this.d_gridList.isEmpty()) {
            Iterator<Grid> iterator = this.d_gridList.iterator();
            UnitDouble unitDouble = new UnitDouble(Double.MAX_VALUE, SI.METER);
            while (iterator.hasNext()) {
                Grid grid = iterator.next();
                unitDouble = UnitDouble.min(unitDouble, grid.getMinXYDim());
            }
            return new UnitDouble(unitDouble.getValue(unitDouble.getUnit()) / 4.0, unitDouble.getUnit());
        }
        Unit unit = FdsSISystem.getInstance().getLengthUnit();
        return new UnitDouble(Double.MIN_VALUE, unit);
    }

    public void resetModel() {
        this.pauseUpdates(false);
        this.setPreviewMode(false);
        this.d_selModel.clearSelection();
        this.ser.d_headRecord = new HeadRecord();
        this.ser.d_walls = new FDSComposite();
        this.ser.d_walls.taskSetName("Model").run();
        this.ser.d_materials = new MaterialList(new MaterialList());
        this.ser.d_grids = new Vector();
        this.ser.d_floors = new Hashtable();
        this.ser.d_unprocessedRecords = new String();
        this.ser.d_reaction = null;
        this.ser.d_reactions = new ReactionList();
        this.ser.d_simulationEndTime = null;
        this.ser.d_restart = false;
        this.ser.d_dtcore = null;
        this.ser.d_initialTimeStep = null;
        this.ser.d_synchronized = false;
        this.ser.d_numFrames = 1000;
        this.ser.d_atmTempLapse = null;
        this.ser.d_ambientTemp = null;
        this.ser.d_ambientPressure = null;
        this.ser.d_outsideTemp = null;
        this.ser.d_initVel = null;
        this.ser.d_notPorousFloor = false;
        this.ser.d_sprkDtspar = null;
        this.ser.d_partDtpar = null;
        this.ser.d_partDtsam = null;
        this.ser.d_partNpps = null;
        this.ser.d_partMaxDrop = 500000;
        this.ser.d_useAutoMixtureFractionAdjust = new Boolean(true);
        this.ser.d_useGasPhaseFireSuppression = new Boolean(true);
        this.ser.d_gvec = null;
        this.ser.d_smag = 0.2;
        this.ser.d_schmidt = 0.5;
        this.ser.d_prandtl = 0.5;
        this.ser.d_isothermal = false;
        this.ser.d_incompressible = false;
        this.ser.d_radSolverOff = false;
        this.ser.d_radi = new RadiRecord(RadiRecord.DEFAULT);
        this.ser.d_smokeOff = false;
        this.ser.d_simulationType = 0;
        this.ser.d_baroclinic = this.ser.d_simulationType == 1 ? 1 : 0;
        this.ser.d_charVel = null;
        this.ser.d_gaugeTemp = null;
        this.ser.d_thcpList = new ThcpList();
        this.ser.d_isofList = new IsofList();
        this.ser.d_slcfList = new SlcfList();
        this.ser.d_bndfList = new BNDFList();
        this.ser.d_pl3dRecord = new PL3DRecord(null);
        this.ser.d_partList = new PartList();
        this.ser.d_sprkList = new SprkList();
        this.ser.d_pipeRecord = new PipeRecord(new UnitDouble(0.0, FdsSISystem.getInstance().getTimeUnit()), null);
        this.ser.d_heatDetectors = new HeatDetectorList();
        this.ser.d_smodList = new SmodList();
        this.ser.d_textures = new TextureDB();
        this.updateManagersForLegacyStorage();
        this.getFloorManager().taskAddDefaultFloor().run();
        this.initializeListeners();
        this.resumeUpdates(PyroModDomainEvent.newOpenInstance());
    }

    public File getDBDir() {
        return this.d_sprkDir;
    }

    @Override
    protected void fireEvents(List<IDomainEvent> list) {
        Object object = list.iterator();
        while (object.hasNext()) {
            PyroDomainEvent pyroDomainEvent;
            IDomainEvent iDomainEvent = object.next();
            if (iDomainEvent instanceof PyroDomainEvent && (pyroDomainEvent = (PyroDomainEvent)iDomainEvent).getEventType() == 4) {
                this.pauseUpdates(false);
                this.deselect(pyroDomainEvent.getObjects());
                this.resumeUpdates();
            }
            this.d_rasterizations.respondToEvents(iDomainEvent);
        }
        if (this.d_rasterPreview) {
            this.d_rasterizations.rasterizeObjects();
        }
        if (((FDSRasterDomainEvent)(object = this.d_rasterizations.getEvents())).hasChanges()) {
            list.add((IDomainEvent)object);
            list = super.mergeEvents(list);
        }
        super.fireEvents(list);
    }

    public FDSRasterization getRasterizations() {
        return this.d_rasterizations;
    }

    public void setPreviewMode(boolean bl) {
    }

    public boolean isPreviewMode() {
        return this.d_rasterPreview;
    }

    public TaskManager getTaskManager() {
        return this.d_taskMan;
    }

    public PyroSimSelectionModel getSelectionModel() {
        return this.d_selModel;
    }

    @Override
    public void acquire() {
        this.d_dc.acquire(this);
    }

    @Override
    public void release() {
        this.d_dc.release(this);
    }

    @Override
    public void dispose() {
        this.removeListeners();
    }

    public void initializeListeners() {
        Set<Class> set = PyroMod.getAllPyroObjectTypes();
        for (Class clazz : set) {
            IPyroManager<?, PyroMod> iPyroManager = this.getPyroSimManager(clazz);
            iPyroManager.addDomain(this);
        }
    }

    public void removeListeners() {
        Set<Class> set = PyroMod.getAllPyroObjectTypes();
        for (Class clazz : set) {
            IPyroManager<?, PyroMod> iPyroManager = this.getPyroSimManager(clazz);
            iPyroManager.removeDomain(this);
        }
    }

    public void initDemoData() {
        AlignedBlock alignedBlock;
        this.ser.d_materials.taskAdd(new Material("Carpet", new Color(0.1f, 0.2f, 0.3f))).run();
        this.ser.d_materials.taskAdd(new Material("Wood", new Color(0.8f, 0.8f, 0.6f))).run();
        this.ser.d_materials.taskAdd(new Material("Upholstery", new Color(0.4f, 0.5f, 0.6f))).run();
        BaseUnit baseUnit = SI.METER;
        for (int i = -1; i < 4; ++i) {
            alignedBlock = new AlignedBlock(new UnitPoint3D(i, i, i, baseUnit), new UnitPoint3D(i + 1, i + 1, i + 1, baseUnit), this.getDefaultMaterial());
            alignedBlock.taskSetName("Obstruction " + i).run();
            this.ser.d_walls.taskAdd(alignedBlock).run();
        }
        ((AlignedBlock)this.ser.d_walls.get(1)).setMaterial(this.ser.d_materials.get("Carpet"));
        ((AlignedBlock)this.ser.d_walls.get(3)).setMaterial(this.ser.d_materials.get("Wood"));
        FDSComposite fDSComposite = new FDSComposite();
        fDSComposite.taskSetName("Chair").run();
        alignedBlock = new AlignedBlock(new UnitPoint3D(10.0, 10.0, 10.0, baseUnit), new UnitPoint3D(15.0, 12.0, 11.0, baseUnit), "Seat", this.getDefaultMaterial());
        alignedBlock.setMaterial(this.ser.d_materials.get("Upholstery"));
        fDSComposite.taskAdd(alignedBlock).run();
        FDSComposite fDSComposite2 = new FDSComposite();
        fDSComposite2.taskSetName("Arms").run();
        alignedBlock = new AlignedBlock(new UnitPoint3D(10.0, 10.0, 11.0, baseUnit), new UnitPoint3D(11.0, 12.0, 14.0, baseUnit), "Left Arm", this.getDefaultMaterial());
        alignedBlock.setMaterial(this.ser.d_materials.get("Upholstery"));
        fDSComposite2.taskAdd(alignedBlock).run();
        alignedBlock = new AlignedBlock(new UnitPoint3D(14.0, 10.0, 11.0, baseUnit), new UnitPoint3D(15.0, 12.0, 14.0, baseUnit), "Right Arm", this.getDefaultMaterial());
        alignedBlock.setMaterial(this.ser.d_materials.get("Upholstery"));
        fDSComposite2.taskAdd(alignedBlock).run();
        fDSComposite.taskAdd(fDSComposite2).run();
        this.ser.d_walls.taskAdd(fDSComposite).run();
        this.fireDomainEvent(PyroModDomainEvent.newOpenInstance());
    }

    public FDSComposite getObstructions() {
        return this.ser.d_walls;
    }

    public FDSObjectManager<FDSObject> getFDSObjectManager() {
        return new FDSObjectManager<FDSObject>(this.ser.d_walls, true, FDSObject.class);
    }

    public FDSObject[] getSelectedObstructionsArray() {
        Vector vector = new Vector();
        this.getSelection(this.ser.d_walls, vector);
        return vector.toArray(new FDSObject[vector.size()]);
    }

    public List<FDSObject> getSelectedObstructions() {
        Vector<FDSObject> vector = new Vector<FDSObject>();
        this.getSelection(this.ser.d_walls, vector);
        return vector;
    }

    public Collection<Grid> getSelectedGrids() {
        return this.getSelectionModel().getSelected(Grid.class);
    }

    public Collection<Material> getSelectedMaterials() {
        return this.getSelectionModel().getSelected(Material.class);
    }

    public Collection<Reaction> getSelectedReactions() {
        return this.getSelectionModel().getSelected(Reaction.class);
    }

    public List getObstructionsUsing(Material material) {
        ArrayList<FDSObject> arrayList = new ArrayList<FDSObject>();
        DeepFDSObjectIterator deepFDSObjectIterator = new DeepFDSObjectIterator(this.getObstructions());
        while (deepFDSObjectIterator.hasNext()) {
            FDSObject fDSObject = deepFDSObjectIterator.next();
            if (!this.objectUses(fDSObject, material)) continue;
            arrayList.add(fDSObject);
        }
        return arrayList;
    }

    private boolean objectUses(FDSObject fDSObject, Material material) {
        for (int i = 0; i < fDSObject.getNumFaces(); ++i) {
            if (fDSObject.getMaterial(i) != material) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectedDecendent(FDSObject fDSObject) {
        FDSObject[] fDSObjectArray = this.getSelectedObstructionsArray();
        for (int i = 0; i < fDSObjectArray.length; ++i) {
            if (fDSObjectArray[i] == fDSObject) {
                return true;
            }
            if (!(fDSObjectArray[i] instanceof FDSComposite) || !((FDSComposite)fDSObjectArray[i]).isDecendent(fDSObject)) continue;
            return true;
        }
        return false;
    }

    private void getSelection(FDSObject fDSObject, List list) {
        if (fDSObject.isSelected()) {
            list.add(fDSObject);
            return;
        }
        if (fDSObject instanceof FDSComposite) {
            FDSComposite fDSComposite = (FDSComposite)fDSObject;
            int n = fDSComposite.size();
            for (int i = 0; i < n; ++i) {
                this.getSelection(fDSComposite.get(i), list);
            }
        }
    }

    public void setFDSObjectsSelected(Collection<? extends FDSObject> collection, boolean bl) {
        this.pauseUpdates();
        for (FDSObject fDSObject : collection) {
            fDSObject.setSelected(bl);
        }
        this.resumeUpdates();
    }

    public void unselectFDSObjects() {
        this.setFDSObjectsSelected(this.getSelectedObstructions(), false);
    }

    public void setSelectedFDSObjects(Collection<? extends FDSObject> collection) {
        this.pauseUpdates();
        List<FDSObject> list = this.getSelectedObstructions();
        this.setFDSObjectsSelected(list, false);
        this.setFDSObjectsSelected(collection, true);
        this.resumeUpdates();
    }

    public void clearSelection() {
        this.pauseUpdates();
        this.unselectFDSObjects();
        this.getSelectionModel().clearSelection();
        this.resumeUpdates();
    }

    public void select(Collection collection) {
        this.pauseUpdates();
        for (Object e : collection) {
            this.select(e);
        }
        this.resumeUpdates();
    }

    public void select(Object object) {
        if (object instanceof FDSObject) {
            ((FDSObject)object).setSelected(true);
        } else {
            this.getSelectionModel().select(object);
        }
    }

    public void deselect(Collection collection) {
        this.pauseUpdates();
        for (Object e : collection) {
            this.deselect(e);
        }
        this.resumeUpdates();
    }

    public void deselect(Object object) {
        if (object instanceof FDSObject) {
            ((FDSObject)object).setSelected(false);
        } else {
            this.getSelectionModel().deselect(object);
        }
    }

    public void setSelection(Collection collection) {
        this.pauseUpdates();
        this.clearSelection();
        this.select(collection);
        this.resumeUpdates();
    }

    public MaterialList getMaterials() {
        return this.ser.d_materials;
    }

    public ReactionList getReactions() {
        return this.ser.d_reactions;
    }

    public Task taskReorderGrids(final List<Grid> list, int n) {
        CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this){

            @Override
            public void undo() {
                PyroMod.this.pauseUpdates(false);
                super.undo();
                PyroMod.this.resumeUpdates(new GridDomainEvent(list, 2));
            }

            @Override
            public void run() {
                PyroMod.this.pauseUpdates(false);
                super.run();
                PyroMod.this.resumeUpdates(new GridDomainEvent(list, 2));
            }

            @Override
            protected void queueBeginRuntimeTasks() {
                this.addTask(PyroMod.this.getGridManager().taskRemoveAll(list, (List<Grid>)null));
            }
        };
        int n2 = n;
        for (Grid grid : list) {
            int n3 = this.getGridManager().indexOf(grid);
            if (n3 >= n) continue;
            --n2;
        }
        compositeTask.addTask(this.getGridManager().taskAddAll((Collection<? extends Grid>)list, n2));
        return compositeTask;
    }

    public String getUnprocessedRecords() {
        return this.ser.d_unprocessedRecords;
    }

    public void setUnprocessedRecords(String string) {
        this.ser.d_unprocessedRecords = string;
    }

    public Object getObjectForKey(int n) {
        return KeyableObject.KEY_GENERATOR.getFirstObjectWithKey(new Integer(n));
    }

    public Set<?> getObjectsForKeys(Collection<Integer> collection) {
        HashSet<Keyable> hashSet = new HashSet<Keyable>(collection.size(), 1.0f);
        for (Integer n : collection) {
            Keyable keyable = KeyableObject.KEY_GENERATOR.getFirstObjectWithKey(n);
            if (keyable == null) {
                System.err.println("No object returned for key, " + n);
                continue;
            }
            hashSet.add(keyable);
        }
        return hashSet;
    }

    private static void showWarnings(WarningReport<Warning> warningReport, boolean bl) {
        if (!warningReport.isEmpty()) {
            if (!bl) {
                JFrame jFrame = null;
                if (Application.getApp() != null) {
                    jFrame = Application.getApp().getMainFrame();
                }
                WarningDlg<Warning> warningDlg = new WarningDlg<Warning>((Window)jFrame, Intl.intl("PSM Warnings"), Intl.intl("There were some problems reading the PyroSim file.  The following table lists the problems and how they were resolved."), warningReport);
                warningDlg.doModal();
            } else {
                System.out.println("Warnings:\n" + warningReport.prepareReport());
            }
        }
    }

    public void openModel(PyroSimObjectInputStream pyroSimObjectInputStream, boolean bl) throws IOException, ClassNotFoundException, Exception {
        Serialized serialized = null;
        serialized = pyroSimObjectInputStream.readModel();
        if (serialized.d_textures == null) {
            serialized.d_textures = new TextureDB();
        }
        if (serialized.d_radi == null) {
            serialized.d_radi = new RadiRecord(RadiRecord.DEFAULT);
        }
        this.setSerialized(serialized);
        if (this.ser.d_floors.size() == 0) {
            this.getFloorManager().taskAddDefaultFloor().run();
        }
        this.setPreviewMode(false);
    }

    public boolean saveModel(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.ser);
        return true;
    }

    public boolean readFDS4File(String string) throws Exception {
        this.pauseUpdates(false);
        try {
            PyroMod pyroMod = new PyroMod();
            FDSInputFile fDSInputFile = new FDSInputFile();
            fDSInputFile.parseFile(string, pyroMod);
            pyroMod.ser.d_floors = new Hashtable();
            this.setSerialized(pyroMod.ser);
            this.getFloorManager().taskAddDefaultFloor().run();
            this.setPreviewMode(false);
            ReactionList reactionList = pyroMod.getReactions();
            MiscRecord miscRecord = this.getMiscManager().getMiscRecord();
            if (miscRecord.getReaction() == null && reactionList.size() > 0) {
                miscRecord.setReaction(ReacProcessor.last.getName());
            }
            pyroMod.release();
            pyroMod = null;
            this.resumeUpdates(PyroModDomainEvent.newOpenInstance());
            return true;
        }
        catch (Exception exception) {
            this.resumeUpdates();
            throw exception;
        }
    }

    public Collection<DisplayablePointObject> getDisplayablePoints() {
        ThcpList thcpList = this.ser.d_thcpList;
        HeatDetectorList heatDetectorList = this.ser.d_heatDetectors;
        SprkList sprkList = this.ser.d_sprkList;
        SmodList smodList = this.ser.d_smodList;
        Vector<DisplayablePointObject> vector = new Vector<DisplayablePointObject>(thcpList.size() + heatDetectorList.size() + sprkList.size());
        for (ADomainObject aDomainObject : thcpList) {
            vector.add((DisplayablePointObject)((Object)aDomainObject));
        }
        for (ADomainObject aDomainObject : heatDetectorList) {
            vector.add((DisplayablePointObject)((Object)aDomainObject));
        }
        for (ADomainObject aDomainObject : sprkList) {
            vector.add((DisplayablePointObject)((Object)aDomainObject));
        }
        for (ADomainObject aDomainObject : smodList) {
            vector.add((DisplayablePointObject)((Object)aDomainObject));
        }
        return vector;
    }

    public void setSerialized(Serialized serialized) {
        this.removeListeners();
        this.ser = serialized;
        this.updateManagersForLegacyStorage();
        this.initializeListeners();
        this.d_selModel.clearSelection();
    }

    private void updateManagersForLegacyStorage() {
        this.d_headManager.setHeadRecord(this.ser.d_headRecord);
        this.d_gridList.setGrids(this.ser.d_grids);
        this.d_floorManager.setFloors(this.ser.d_floors);
        this.d_radiManager.setRadiRecord(this.ser.d_radi);
        this.d_pl3dManager.setPL3DRecord(this.ser.d_pl3dRecord);
        this.d_pipeManager.setPipeRecord(this.ser.d_pipeRecord);
    }

    public HeadManager getHeadManager() {
        return this.d_headManager;
    }

    public void setHeadRecord(HeadRecord headRecord) {
        this.ser.d_headRecord = headRecord;
        this.d_headManager.setHeadRecord(headRecord);
    }

    public GridList getGridManager() {
        return this.d_gridList;
    }

    public TimeManager getTimeManager() {
        return this.d_timeManager;
    }

    public FloorManager getFloorManager() {
        return this.d_floorManager;
    }

    public MiscManager getMiscManager() {
        return this.d_miscManager;
    }

    public RadiManager getRadiManager() {
        return this.d_radiManager;
    }

    public PL3DManager getPL3DManager() {
        return this.d_pl3dManager;
    }

    public void setPL3DRecord(PL3DRecord pL3DRecord) {
        this.ser.d_pl3dRecord = pL3DRecord;
        this.d_pl3dManager.setPL3DRecord(pL3DRecord);
    }

    public PipeManager getPipeManager() {
        return this.d_pipeManager;
    }

    public void setPipeRecord(PipeRecord pipeRecord) {
        this.ser.d_pipeRecord = pipeRecord;
        this.d_pipeManager.setPipeRecord(pipeRecord);
    }

    public ThcpList getThcpList() {
        return this.ser.d_thcpList;
    }

    public BNDFList getBNDFList() {
        return this.ser.d_bndfList;
    }

    public IsofList getIsofList() {
        return this.ser.d_isofList;
    }

    public SlcfList getSlcfList() {
        return this.ser.d_slcfList;
    }

    public PartList getPartList() {
        return this.ser.d_partList;
    }

    public SprkList getSprkList() {
        return this.ser.d_sprkList;
    }

    public HeatDetectorList getHeatDetectors() {
        return this.ser.d_heatDetectors;
    }

    public SmodList getSmokeDetectors() {
        return this.ser.d_smodList;
    }

    public TextureDB getTextureDB() {
        return this.ser.d_textures;
    }

    public Collection<TypedCollection<? extends IPyroObject>> collectAllPyroObjectsByType(Set<Class> set) {
        Vector<TypedCollection<? extends IPyroObject>> vector = new Vector<TypedCollection<? extends IPyroObject>>(set.size());
        for (Class clazz : set) {
            Collection collection = this.getPyroSimManager(clazz).toCollection();
            vector.add(new TypedCollection(collection, clazz));
        }
        return vector;
    }

    public Set<IPyroObject> collectAllPyroObjects(Set<Class> set) {
        int n = 0;
        for (Class object : set) {
            Collection collection = this.getPyroSimManager(object).toCollection();
            n += collection.size();
        }
        HashSet hashSet = new HashSet(n);
        for (Class clazz : set) {
            Collection collection = this.getPyroSimManager(clazz).toCollection();
            hashSet.addAll(collection);
        }
        return hashSet;
    }

    public static Set<Class> getAllPyroObjectTypes() {
        Set<Class> set = PyroMod.getAllPyroObjectTypesNotDependedOn();
        Set<Class> set2 = PyroMod.getAllPyroObjectTypesDependedOn();
        HashSet<Class> hashSet = new HashSet<Class>(set.size() + set2.size());
        hashSet.addAll(set);
        hashSet.addAll(set2);
        return hashSet;
    }

    public static Set<Class> getAllPyroObjectTypesDependedOn() {
        Class[] classArray = new Class[]{SmodRecord.class, HeatDetector.class, Material.class, PartRecord.class, Reaction.class};
        return new HashSet<Class>(new VectorFromArray<Class>(classArray));
    }

    public static Set<Class> getAllPyroObjectTypesNotDependedOn() {
        Class[] classArray = new Class[]{FDSComposite.class, AlignedBlock.class, Wall.class, Slab.class, FDSConvexPoly.class, AlignedHole.class, Hole.class, Vent.class, BNDFRecord.class, Grid.class, HeadRecord.class, IsofRecord.class, MiscRecord.class, RadiRecord.class, PipeRecord.class, PL3DRecord.class, SlcfRecord.class, SprkRecord.class, ThcpRecord.class, TimeRecord.class, Floor.class};
        return new HashSet<Class>(new VectorFromArray<Class>(classArray));
    }

    public <T extends IPyroObject> IPyroManager<?, T> getPyroSimManager(Class<T> clazz) {
        if (clazz.equals(BNDFRecord.class)) {
            return this.getBNDFList();
        }
        if (FDSObject.class.isAssignableFrom(clazz)) {
            return new FDSObjectManager<T>(this.getObstructions(), true, clazz);
        }
        if (clazz.equals(Grid.class)) {
            return this.getGridManager();
        }
        if (clazz.equals(HeadRecord.class)) {
            return this.getHeadManager();
        }
        if (clazz.equals(HeatDetector.class)) {
            return this.getHeatDetectors();
        }
        if (clazz.equals(SmodRecord.class)) {
            return this.getSmokeDetectors();
        }
        if (clazz.equals(IsofRecord.class)) {
            return this.getIsofList();
        }
        if (clazz.equals(Material.class)) {
            return this.getMaterials();
        }
        if (clazz.equals(MiscRecord.class)) {
            return this.getMiscManager();
        }
        if (clazz.equals(RadiRecord.class)) {
            return this.getRadiManager();
        }
        if (clazz.equals(PartRecord.class)) {
            return this.getPartList();
        }
        if (clazz.equals(PipeRecord.class)) {
            return this.getPipeManager();
        }
        if (clazz.equals(PL3DRecord.class)) {
            return this.getPL3DManager();
        }
        if (clazz.equals(Reaction.class)) {
            return this.getReactions();
        }
        if (clazz.equals(SlcfRecord.class)) {
            return this.getSlcfList();
        }
        if (clazz.equals(SprkRecord.class)) {
            return this.getSprkList();
        }
        if (clazz.equals(ThcpRecord.class)) {
            return this.getThcpList();
        }
        if (clazz.equals(TimeRecord.class)) {
            return this.getTimeManager();
        }
        if (clazz.equals(Floor.class)) {
            return this.getFloorManager();
        }
        return null;
    }

    public <T> T getDefaultReplacementForObjectType(Class<T> clazz) {
        if (clazz.isAssignableFrom(Material.class)) {
            Material material = this.getDefaultMaterial();
            return clazz.cast(material);
        }
        return null;
    }

    public Material getDefaultMaterial() {
        return this.getMaterials().get("INERT");
    }

    public <T extends IPyroDependedOn> List<T> getReplacementsFor(TypedList<T> typedList) {
        Vector<IPyroDependedOn> vector = new Vector<IPyroDependedOn>(typedList.size());
        LinkedList<T> linkedList = new LinkedList<T>();
        for (Object object : this.getPyroSimManager(typedList.getType())) {
            linkedList.add(typedList.getType().cast(object));
        }
        linkedList.removeAll(typedList);
        assert (linkedList.size() == this.getPyroSimManager(typedList.getType()).size() - typedList.size());
        IPyroDependedOn iPyroDependedOn = (IPyroDependedOn)this.getDefaultReplacementForObjectType(typedList.getType());
        for (IPyroDependedOn iPyroDependedOn2 : typedList) {
            if (this.getDependencyManager().getDependentsOf(iPyroDependedOn2).size() == 0) {
                vector.add(null);
                continue;
            }
            ReplaceDlg<Object> replaceDlg = new ReplaceDlg<Object>("Replace " + iPyroDependedOn2.getTypeDescription(), iPyroDependedOn2, linkedList, iPyroDependedOn, typedList.getType());
            int n = replaceDlg.doModal();
            if (n == 1) {
                IPyroDependedOn iPyroDependedOn3 = (IPyroDependedOn)replaceDlg.getReplacer();
                vector.add(iPyroDependedOn3);
                continue;
            }
            return null;
        }
        return vector;
    }

    public PyroModDependencyManager getDependencyManager() {
        return this.d_dependencyManager;
    }

    public Object getLockObj() {
        return this.ser;
    }

    public static class TimeRecord
    extends ADomainObject<PyroMod>
    implements IFDSRenderable,
    IPyroObject {
        private PyroMod d_pyroMod;
        private static final Hashtable<String, ValueRange> d_ranges;

        public TimeRecord(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
        }

        public static ValueRange getValueRange(String string) {
            return d_ranges.get(string);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof TimeRecord)) {
                return false;
            }
            TimeRecord timeRecord = (TimeRecord)object;
            boolean bl = (this.getSimulationStopTime() == null ? timeRecord.getSimulationStopTime() == null : this.getSimulationStopTime().equals(timeRecord.getSimulationStopTime())) && (this.getInitialTimeStep() == null ? timeRecord.getInitialTimeStep() == null : this.getInitialTimeStep().equals(timeRecord.getInitialTimeStep())) && this.getSyncFlag() == timeRecord.getSyncFlag();
            return bl;
        }

        @Override
        public Object clone() {
            assert (false);
            return null;
        }

        public void imprint(TimeRecord timeRecord) {
            this.pauseUpdates(false);
            this.setInitialTimeStep(timeRecord.getInitialTimeStep() != null ? (UnitDouble)timeRecord.getInitialTimeStep().clone() : null);
            this.setSimulationStopTime(timeRecord.getSimulationStopTime() != null ? (UnitDouble)timeRecord.getSimulationStopTime().clone() : null);
            this.setSyncFlag(timeRecord.getSyncFlag());
            this.resumeUpdates(new PyroDomainEvent(this, TimeRecord.class, 5));
        }

        public boolean getSyncFlag() {
            return this.d_pyroMod.ser.d_synchronized;
        }

        public void setSyncFlag(boolean bl) {
            this.d_pyroMod.ser.d_synchronized = bl;
            this.fireChangedEvt();
        }

        public UnitDouble getSimulationStopTime() {
            return this.d_pyroMod.ser.d_simulationEndTime;
        }

        public void setSimulationStopTime(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_simulationEndTime = unitDouble;
            this.fireChangedEvt();
        }

        public UnitDouble getInitialTimeStep() {
            return this.d_pyroMod.ser.d_initialTimeStep;
        }

        public void setInitialTimeStep(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_initialTimeStep = unitDouble;
            this.fireChangedEvt();
        }

        private void fireChangedEvt() {
            this.fireDomainEvent(new PyroDomainEvent(this, TimeRecord.class, 5));
        }

        @Override
        public String getFDSType() {
            return "TIME";
        }

        @Override
        public void getInputRecords(Collection<FDSInputRecord> collection) {
            UnitDouble unitDouble;
            FDSInputRecord fDSInputRecord = new FDSInputRecord();
            fDSInputRecord.setType("TIME");
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            UnitDouble unitDouble2 = this.getSimulationStopTime();
            if (unitDouble2 != null && !unitDouble2.equals(FDSInputRecord.DEF_TWFIN)) {
                fDSInputRecord.setValue("TWFIN", new Double(unitDouble2.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((unitDouble = this.getInitialTimeStep()) != null) {
                fDSInputRecord.setValue("DT", new Double(unitDouble.getValue(fdsSISystem.getTimeUnit())));
            }
            if (this.getSyncFlag()) {
                fDSInputRecord.setValue("SYNCHRONIZE", Boolean.TRUE);
            }
            if (fDSInputRecord.getKeys().length > 0) {
                collection.add(fDSInputRecord);
            }
        }

        @Override
        public String getTypeDescription() {
            return "Time Record";
        }

        static {
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            d_ranges = new Hashtable(2);
            d_ranges.put("TWFIN", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), true));
            d_ranges.put("DT", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
        }
    }

    public static class MiscRecord
    extends ADomainObject<PyroMod>
    implements IDependent,
    IFDSRenderable,
    IPyroObject {
        private PyroMod d_pyroMod;
        private static final Hashtable<String, ValueRange> d_ranges;

        public MiscRecord(PyroMod pyroMod) {
            this.d_pyroMod = pyroMod;
        }

        public static ValueRange getValueRange(String string) {
            return d_ranges.get(string);
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof MiscRecord)) {
                return false;
            }
            MiscRecord miscRecord = (MiscRecord)object;
            boolean bl = (this.getDtcore() != null ? this.getDtcore().equals(miscRecord.getDtcore()) : miscRecord.getDtcore() == null) && (this.getAmbientTemp() != null ? this.getAmbientTemp().equals(miscRecord.getAmbientTemp()) : miscRecord.getAmbientTemp() == null) && (this.getAmbientPressure() != null ? this.getAmbientPressure().equals(miscRecord.getAmbientPressure()) : miscRecord.getAmbientPressure() == null) && (this.getInitVel() != null ? this.getInitVel().equals(miscRecord.getInitVel()) : miscRecord.getInitVel() == null) && (this.getCharVel() != null ? this.getCharVel().equals(miscRecord.getCharVel()) : miscRecord.getCharVel() == null) && (this.getGaugeTemp() != null ? this.getGaugeTemp().equals(miscRecord.getGaugeTemp()) : miscRecord.getGaugeTemp() == null) && (this.getAtmTempLapse() != null ? this.getAtmTempLapse().equals(miscRecord.getAtmTempLapse()) : miscRecord.getAtmTempLapse() == null) && (this.getOutsideTemp() != null ? this.getOutsideTemp().equals(miscRecord.getOutsideTemp()) : miscRecord.getOutsideTemp() == null) && (this.getSprkDtspar() != null ? this.getSprkDtspar().equals(miscRecord.getSprkDtspar()) : miscRecord.getSprkDtspar() == null) && (this.getPartDtsam() != null ? this.getPartDtsam().equals(miscRecord.getPartDtsam()) : miscRecord.getPartDtsam() == null) && (this.getPartDtpar() != null ? this.getPartDtpar().equals(miscRecord.getPartDtpar()) : miscRecord.getPartDtpar() == null) && (this.getPartNpps() != null ? this.getPartNpps().equals(miscRecord.getPartNpps()) : miscRecord.getPartNpps() == null) && (this.getReaction() != null ? this.getReaction().equals(miscRecord.getReaction()) : miscRecord.getReaction() == null) && (this.getGvec() != null ? this.getGvec().equals(miscRecord.getGvec()) : miscRecord.getGvec() == null) && this.getRestart() == miscRecord.getRestart() && this.getNumFrames() == miscRecord.getNumFrames() && this.getPorousFloor() == miscRecord.getPorousFloor() && this.getPartMaxDrop() == miscRecord.getPartMaxDrop() && this.getAutoMFAdjust() == miscRecord.getAutoMFAdjust() && this.getGPFSuppress() == miscRecord.getGPFSuppress() && this.getSimulationType() == miscRecord.getSimulationType() && this.getSmag() == miscRecord.getSmag() && this.getSchmidt() == miscRecord.getSchmidt() && this.getPrandtl() == miscRecord.getPrandtl() && this.getIsothermal() == miscRecord.getIsothermal() && this.getIncompressible() == miscRecord.getIncompressible() && this.getRadSolverOff() == miscRecord.getRadSolverOff() && this.getSmokeOff() == miscRecord.getSmokeOff() && this.getBaroclinic() == miscRecord.getBaroclinic();
            return bl;
        }

        @Override
        public Object clone() {
            assert (false);
            return null;
        }

        public void imprint(MiscRecord miscRecord) {
            this.pauseUpdates(false);
            this.setDtcore(miscRecord.getDtcore() != null ? (UnitDouble)miscRecord.getDtcore().clone() : null);
            this.setAmbientTemp(miscRecord.getAmbientTemp() != null ? (UnitDouble)miscRecord.getAmbientTemp().clone() : null);
            this.setAmbientPressure(miscRecord.getAmbientPressure() != null ? (UnitDouble)miscRecord.getAmbientPressure().clone() : null);
            this.setInitVel(miscRecord.getInitVel() != null ? (UnitPoint3D)miscRecord.getInitVel().clone() : null);
            this.setCharVel(miscRecord.getCharVel() != null ? (UnitDouble)miscRecord.getCharVel().clone() : null);
            this.setGaugeTemp(miscRecord.getGaugeTemp() != null ? (UnitDouble)miscRecord.getGaugeTemp().clone() : null);
            this.setAtmTempLapse(miscRecord.getAtmTempLapse() != null ? (UnitDouble)miscRecord.getAtmTempLapse().clone() : null);
            this.setOutsideTemp(miscRecord.getOutsideTemp() != null ? (UnitDouble)miscRecord.getOutsideTemp().clone() : null);
            this.setSprkDtspar(miscRecord.getSprkDtspar() != null ? (UnitDouble)miscRecord.getSprkDtspar().clone() : null);
            this.setPartDtsam(miscRecord.getPartDtsam() != null ? (UnitDouble)miscRecord.getPartDtsam().clone() : null);
            this.setPartDtpar(miscRecord.getPartDtpar() != null ? (UnitDouble)miscRecord.getPartDtpar().clone() : null);
            this.setPartNpps(miscRecord.getPartNpps() != null ? (UnitDouble)miscRecord.getPartNpps().clone() : null);
            this.setGvec(miscRecord.getGvec() != null ? (UnitPoint3D)miscRecord.getGvec().clone() : null);
            this.setRestart(miscRecord.getRestart());
            this.setNumFrames(miscRecord.getNumFrames());
            this.setPorousFloor(miscRecord.getPorousFloor());
            this.setPartMaxDrop(miscRecord.getPartMaxDrop());
            this.setReaction(miscRecord.getReaction());
            this.setAutoMFAdjust(miscRecord.getAutoMFAdjust());
            this.setGPFSuppress(miscRecord.getGPFSuppress());
            this.setSimulationType(miscRecord.getSimulationType());
            this.setSmag(miscRecord.getSmag());
            this.setSchmidt(miscRecord.getSchmidt());
            this.setPrandtl(miscRecord.getPrandtl());
            this.setIsothermal(miscRecord.getIsothermal());
            this.setIncompressible(miscRecord.getIncompressible());
            this.setRadSolverOff(miscRecord.getRadSolverOff());
            this.setSmokeOff(miscRecord.getSmokeOff());
            this.setBaroclinic(miscRecord.getBaroclinic());
            this.resumeWithEvent();
        }

        public boolean getRestart() {
            return this.d_pyroMod.ser.d_restart;
        }

        public void setRestart(boolean bl) {
            this.d_pyroMod.ser.d_restart = bl;
            this.fireChangeEvent();
        }

        public UnitDouble getDtcore() {
            return this.d_pyroMod.ser.d_dtcore;
        }

        public void setDtcore(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_dtcore = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getAmbientTemp() {
            return this.d_pyroMod.ser.d_ambientTemp;
        }

        public void setAmbientTemp(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_ambientTemp = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getAmbientPressure() {
            return this.d_pyroMod.ser.d_ambientPressure;
        }

        public void setAmbientPressure(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_ambientPressure = unitDouble;
            this.fireChangeEvent();
        }

        public UnitPoint3D getInitVel() {
            return this.d_pyroMod.ser.d_initVel;
        }

        public void setInitVel(UnitPoint3D unitPoint3D) {
            this.d_pyroMod.ser.d_initVel = unitPoint3D;
            this.fireChangeEvent();
        }

        public int getNumFrames() {
            return this.d_pyroMod.ser.d_numFrames;
        }

        public void setNumFrames(int n) {
            this.d_pyroMod.ser.d_numFrames = n;
            this.fireChangeEvent();
        }

        public void setCharVel(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_charVel = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getCharVel() {
            return this.d_pyroMod.ser.d_charVel;
        }

        public void setGaugeTemp(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_gaugeTemp = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getGaugeTemp() {
            return this.d_pyroMod.ser.d_gaugeTemp;
        }

        public void setAtmTempLapse(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_atmTempLapse = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getAtmTempLapse() {
            return this.d_pyroMod.ser.d_atmTempLapse;
        }

        public UnitDouble getOutsideTemp() {
            return this.d_pyroMod.ser.d_outsideTemp;
        }

        public void setOutsideTemp(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_outsideTemp = unitDouble;
            this.fireChangeEvent();
        }

        public boolean getPorousFloor() {
            return !this.d_pyroMod.ser.d_notPorousFloor;
        }

        public void setPorousFloor(boolean bl) {
            this.d_pyroMod.ser.d_notPorousFloor = !bl;
            this.fireChangeEvent();
        }

        public UnitDouble getSprkDtspar() {
            return this.d_pyroMod.ser.d_sprkDtspar;
        }

        public void setSprkDtspar(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_sprkDtspar = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getPartDtsam() {
            return this.d_pyroMod.ser.d_partDtsam;
        }

        public void setPartDtsam(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_partDtsam = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getPartDtpar() {
            return this.d_pyroMod.ser.d_partDtpar;
        }

        public void setPartDtpar(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_partDtpar = unitDouble;
            this.fireChangeEvent();
        }

        public UnitDouble getPartNpps() {
            return this.d_pyroMod.ser.d_partNpps;
        }

        public void setPartNpps(UnitDouble unitDouble) {
            this.d_pyroMod.ser.d_partNpps = unitDouble;
            this.fireChangeEvent();
        }

        public int getPartMaxDrop() {
            return this.d_pyroMod.ser.d_partMaxDrop;
        }

        public void setPartMaxDrop(int n) {
            this.d_pyroMod.ser.d_partMaxDrop = n;
            this.fireChangeEvent();
        }

        public String getReaction() {
            return this.d_pyroMod.ser.d_reaction;
        }

        public void setReaction(String string) {
            this.d_pyroMod.ser.d_reaction = string;
            this.fireChangeEvent();
        }

        public boolean getAutoMFAdjust() {
            return this.d_pyroMod.ser.d_useAutoMixtureFractionAdjust;
        }

        public void setAutoMFAdjust(boolean bl) {
            this.d_pyroMod.ser.d_useAutoMixtureFractionAdjust = new Boolean(bl);
            this.fireChangeEvent();
        }

        public boolean getGPFSuppress() {
            return this.d_pyroMod.ser.d_useGasPhaseFireSuppression;
        }

        public void setGPFSuppress(boolean bl) {
            this.d_pyroMod.ser.d_useGasPhaseFireSuppression = new Boolean(bl);
            this.fireChangeEvent();
        }

        public int getSimulationType() {
            return this.d_pyroMod.ser.d_simulationType;
        }

        public void setSimulationType(int n) {
            this.d_pyroMod.ser.d_simulationType = n;
            this.fireChangeEvent();
        }

        public double getSmag() {
            return this.d_pyroMod.ser.d_smag;
        }

        public void setSmag(double d) {
            this.d_pyroMod.ser.d_smag = d;
            this.fireChangeEvent();
        }

        public double getSchmidt() {
            return this.d_pyroMod.ser.d_schmidt;
        }

        public void setSchmidt(double d) {
            this.d_pyroMod.ser.d_schmidt = d;
            this.fireChangeEvent();
        }

        public double getPrandtl() {
            return this.d_pyroMod.ser.d_prandtl;
        }

        public void setPrandtl(double d) {
            this.d_pyroMod.ser.d_prandtl = d;
            this.fireChangeEvent();
        }

        public boolean getIsothermal() {
            return this.d_pyroMod.ser.d_isothermal;
        }

        public void setIsothermal(boolean bl) {
            this.d_pyroMod.ser.d_isothermal = bl;
            this.fireChangeEvent();
        }

        public boolean getIncompressible() {
            return this.d_pyroMod.ser.d_incompressible;
        }

        public void setIncompressible(boolean bl) {
            this.d_pyroMod.ser.d_incompressible = bl;
            this.fireChangeEvent();
        }

        public boolean getRadSolverOff() {
            return this.d_pyroMod.ser.d_radSolverOff;
        }

        public void setRadSolverOff(boolean bl) {
            this.d_pyroMod.ser.d_radSolverOff = bl;
            this.fireChangeEvent();
        }

        public RadiRecord getRadiParams() {
            return this.d_pyroMod.ser.d_radi;
        }

        public boolean getSmokeOff() {
            return this.d_pyroMod.ser.d_smokeOff;
        }

        public void setSmokeOff(boolean bl) {
            this.d_pyroMod.ser.d_smokeOff = bl;
            this.fireChangeEvent();
        }

        public int getBaroclinic() {
            return this.d_pyroMod.ser.d_baroclinic;
        }

        public void setBaroclinic(int n) {
            this.d_pyroMod.ser.d_baroclinic = n;
            this.fireChangeEvent();
        }

        public UnitPoint3D getGvec() {
            return this.d_pyroMod.ser.d_gvec;
        }

        public void setGvec(UnitPoint3D unitPoint3D) {
            this.d_pyroMod.ser.d_gvec = unitPoint3D;
            this.fireChangeEvent();
        }

        public void setRenderFile(String string) {
            this.d_pyroMod.ser.d_renderFile = string;
            this.fireChangeEvent();
        }

        public String getRenderFile() {
            return this.d_pyroMod.ser.d_renderFile;
        }

        @Override
        public String getFDSType() {
            return "MISC";
        }

        @Override
        public void getInputRecords(Collection<FDSInputRecord> collection) {
            String string;
            UnitPoint3D unitPoint3D;
            boolean bl;
            double d;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n;
            UnitDouble unitDouble;
            UnitDouble unitDouble2;
            UnitDouble unitDouble3;
            UnitDouble unitDouble4;
            boolean bl5;
            int n2;
            UnitPoint3D unitPoint3D2;
            UnitDouble unitDouble5;
            UnitDouble unitDouble6;
            UnitDouble unitDouble7;
            UnitDouble unitDouble8;
            UnitDouble unitDouble9;
            UnitDouble unitDouble10;
            UnitDouble unitDouble11;
            Boolean bl6;
            Boolean bl7;
            String string2;
            int n3;
            FDSInputRecord fDSInputRecord = new FDSInputRecord();
            fDSInputRecord.setType("MISC");
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            int n4 = this.getSimulationType();
            if (n4 != 0) {
                fDSInputRecord.setValue("DNS", Boolean.TRUE);
            } else {
                n3 = this.getBaroclinic();
                if (n3) {
                    fDSInputRecord.setValue("BAROCLINIC", Boolean.TRUE);
                }
            }
            n3 = this.getRestart() ? 1 : 0;
            if (n3) {
                fDSInputRecord.setValue("RESTART", new Boolean(n3 != 0));
            }
            if ((string2 = this.getReaction()) != null) {
                fDSInputRecord.setValue("REACTION", string2);
            }
            if (!(bl7 = new Boolean(this.getAutoMFAdjust())).booleanValue()) {
                fDSInputRecord.setValue("AUTOMATIC_Z", bl7);
            }
            if (!(bl6 = new Boolean(this.getGPFSuppress())).booleanValue()) {
                fDSInputRecord.setValue("SUPPRESSION", bl6);
            }
            if ((unitDouble11 = this.getDtcore()) != null) {
                fDSInputRecord.setValue("DTCORE", new Double(unitDouble11.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((unitDouble10 = this.getCharVel()) != null) {
                fDSInputRecord.setValue("CHARACTERISTIC_VELOCITY", new Double(unitDouble10.getValue(fdsSISystem.getVelocityUnit())));
            }
            if ((unitDouble9 = this.getGaugeTemp()) != null) {
                fDSInputRecord.setValue("GAUGE_TEMPERATURE", new Double(unitDouble9.getValue(fdsSISystem.getTempUnit())));
            }
            if ((unitDouble8 = this.getAtmTempLapse()) != null && !unitDouble8.equals(FDSInputRecord.DEF_DT0DZ)) {
                fDSInputRecord.setValue("DT0DZ", new Double(unitDouble8.getValue(fdsSISystem.getAtmGradUnit())));
            }
            if ((unitDouble7 = this.getAmbientTemp()) != null && !unitDouble7.equals(FDSInputRecord.DEF_AMBIENT_TEMP)) {
                fDSInputRecord.setValue("TMPA", new Double(unitDouble7.getValue(fdsSISystem.getTempUnit())));
            }
            if ((unitDouble6 = this.getAmbientPressure()) != null && !unitDouble6.equals(FDSInputRecord.DEF_AMBIENT_PRESSURE)) {
                fDSInputRecord.setValue("PINF", new Double(unitDouble6.getValue(fdsSISystem.getAmbientPressureUnit())));
            }
            if ((unitDouble5 = this.getOutsideTemp()) != null && !unitDouble5.equals(FDSInputRecord.DEF_OUTSIDE_TEMP)) {
                fDSInputRecord.setValue("TMPO", new Double(unitDouble5.getValue(fdsSISystem.getTempUnit())));
            }
            if ((unitPoint3D2 = this.getInitVel()) != null) {
                if (!unitPoint3D2.xu().equals(FDSInputRecord.DEF_INIT_VEL.xu())) {
                    fDSInputRecord.setValue("U0", new Double(unitPoint3D2.x(fdsSISystem.getVelocityUnit())));
                }
                if (!unitPoint3D2.yu().equals(FDSInputRecord.DEF_INIT_VEL.yu())) {
                    fDSInputRecord.setValue("V0", new Double(unitPoint3D2.y(fdsSISystem.getVelocityUnit())));
                }
                if (!unitPoint3D2.zu().equals(FDSInputRecord.DEF_INIT_VEL.zu())) {
                    fDSInputRecord.setValue("W0", new Double(unitPoint3D2.z(fdsSISystem.getVelocityUnit())));
                }
            }
            if ((n2 = this.getNumFrames()) != 1000) {
                fDSInputRecord.setValue("NFRAMES", new Integer(n2));
            }
            if (!(bl5 = this.getPorousFloor())) {
                fDSInputRecord.setValue("POROUS_FLOOR", new Boolean(bl5));
            }
            if ((unitDouble4 = this.getSprkDtspar()) != null && !unitDouble4.equals(FDSInputRecord.DEF_DTSPAR)) {
                fDSInputRecord.setValue("DTSPAR", new Double(unitDouble4.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((unitDouble3 = this.getPartDtpar()) != null && !unitDouble3.equals(FDSInputRecord.DEF_DTPAR)) {
                fDSInputRecord.setValue("DTPAR", new Double(unitDouble3.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((unitDouble2 = this.getPartDtsam()) != null && unitDouble2.getValue(fdsSISystem.getTimeUnit()) > 0.0) {
                fDSInputRecord.setValue("DTSAM_PART", new Double(unitDouble2.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((unitDouble = this.getPartNpps()) != null && !unitDouble.equals(FDSInputRecord.DEF_NPPS)) {
                fDSInputRecord.setValue("NPPS", new Double(unitDouble.getValue(fdsSISystem.getTimeUnit())));
            }
            if ((n = this.getPartMaxDrop()) != 0 && n != 500000) {
                fDSInputRecord.setValue("MAXIMUM_DROPLETS", new Integer(n));
            }
            if (bl4 = this.getIsothermal()) {
                fDSInputRecord.setValue("ISOTHERMAL", new Boolean(bl4));
            }
            if (bl3 = this.getIncompressible()) {
                fDSInputRecord.setValue("INCOMPRESSIBLE", new Boolean(bl3));
            }
            boolean bl8 = bl2 = !this.getRadSolverOff();
            if (!bl2) {
                fDSInputRecord.setValue("RADIATION", new Boolean(bl2));
            }
            if ((d = this.getSmag()) != 0.2) {
                fDSInputRecord.setValue("CSMAG", new Double(d));
            }
            if (n4 == 0) {
                double d2;
                double d3 = this.getSchmidt();
                if (d3 != 0.5) {
                    fDSInputRecord.setValue("SC", new Double(d3));
                }
                if ((d2 = this.getPrandtl()) != 0.5) {
                    fDSInputRecord.setValue("PR", new Double(d2));
                }
            }
            if (bl = this.getSmokeOff()) {
                fDSInputRecord.setValue("SMOKE3D", new Boolean(!bl));
            }
            if ((unitPoint3D = this.getGvec()) != null && !unitPoint3D.equals(FDSInputRecord.DEF_GVEC)) {
                Vector<Double> vector = new Vector<Double>(3);
                vector.add(new Double(unitPoint3D.x(fdsSISystem.getAccelUnit())));
                vector.add(new Double(unitPoint3D.y(fdsSISystem.getAccelUnit())));
                vector.add(new Double(unitPoint3D.z(fdsSISystem.getAccelUnit())));
                fDSInputRecord.setValue("GVEC", vector);
            }
            if ((string = this.getRenderFile()) != null) {
                fDSInputRecord.setValue("RENDER_FILE", string);
            }
            if (fDSInputRecord.getKeys().length > 0) {
                collection.add(fDSInputRecord);
            }
        }

        private void fireChangeEvent() {
            if (this.belongsToADomain()) {
                this.fireDomainEvent(new PyroDomainEvent(this, MiscRecord.class, 5));
            }
        }

        private void resumeWithEvent() {
            if (this.belongsToADomain()) {
                this.resumeUpdates(new PyroDomainEvent(this, MiscRecord.class, 5));
            }
        }

        @Override
        public String getTypeDescription() {
            return "Miscellaneous Record";
        }

        @Override
        public void getObjectsDependedOn(Set<IDependedOn> set, Class<IDependedOn> clazz) {
            Reaction reaction;
            String string;
            if (clazz.isAssignableFrom(Reaction.class) && (string = this.getReaction()) != null && (reaction = this.d_pyroMod.getReactions().get(string)) != null) {
                set.add(reaction);
            }
        }

        @Override
        public boolean dependsOnObject(IDependedOn iDependedOn) {
            if (iDependedOn instanceof Reaction) {
                Reaction reaction = (Reaction)iDependedOn;
                String string = this.getReaction();
                if (string != null && string.equals(reaction.getName())) {
                    return true;
                }
            }
            return false;
        }

        public Task taskSetReaction(String string) {
            return new ReplaceReactionTask(this, this.getReaction(), string);
        }

        @Override
        public Task taskUpdateAfterDependedOnReplaced(IDependedOn iDependedOn, IDependedOn iDependedOn2) {
            assert (iDependedOn instanceof Reaction);
            Reaction reaction = (Reaction)iDependedOn2;
            return this.taskUpdateBeforeDependedOnRenamed(iDependedOn, reaction != null ? reaction.getName() : null);
        }

        @Override
        public Task taskUpdateBeforeDependedOnRenamed(IDependedOn iDependedOn, String string) {
            assert (iDependedOn instanceof Reaction);
            Reaction reaction = (Reaction)iDependedOn;
            assert (iDependedOn == null ? reaction == null : this.getReaction().equals(reaction.getName()));
            return this.taskSetReaction(string);
        }

        @Override
        public Task taskUpdateAfterDependedOnChanged(IDependedOn iDependedOn, Object object) {
            return null;
        }

        static {
            FdsSISystem fdsSISystem = FdsSISystem.getInstance();
            d_ranges = new Hashtable(2);
            d_ranges.put("NFRAMES", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("NPPS", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("MAXIMUM_DROPLETS", IntValueRange.createCheckedMin(1, true));
            d_ranges.put("DTCORE", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
            d_ranges.put("DTSAM_PART", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), true));
            d_ranges.put("DTSPAR", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
            d_ranges.put("DTPAR", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getTimeUnit(), false));
            d_ranges.put("SC", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("PR", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("CSMAG", DoubleValueRange.createCheckedMin(0.0, false));
            d_ranges.put("PINF", UnitDoubleValueRange.createCheckedMin(0.0, fdsSISystem.getAmbientPressureUnit(), false));
        }

        private static class ReplaceReactionTask
        implements Task {
            private final MiscRecord d_owner;
            private final String d_obj;
            private final String d_replacement;

            public ReplaceReactionTask(MiscRecord miscRecord, String string, String string2) {
                this.d_owner = miscRecord;
                this.d_obj = string;
                this.d_replacement = string2;
            }

            @Override
            public boolean canUndo() {
                return true;
            }

            @Override
            public int getEst() {
                return 0;
            }

            @Override
            public void undo() {
                this.d_owner.setReaction(this.d_obj);
            }

            @Override
            public void run() {
                this.d_owner.setReaction(this.d_replacement);
            }
        }
    }

    public class PyroModDependencyManager
    extends ADependencyManager {
        @Override
        public Map<Class, Set<Class>> getPossibleDepedentsForDependedOns() {
            return FDSDependencyMap.getPossibleDependenciesForObjectsDependedOn();
        }

        @Override
        public Map<Class, Set<Class>> getPossibleDependedOnsForDependents() {
            return FDSDependencyMap.getPossibleDependenciesForDependentObjects();
        }

        @Override
        public <T extends IDependent> Iterator<T> getDependentObjectsIteratorForType(Class<T> clazz) {
            if (IPyroObject.class.isAssignableFrom(clazz)) {
                return PyroMod.this.getPyroSimManager(clazz).iterator();
            }
            return null;
        }

        @Override
        public <T extends IDependedOn> List<T> getReplacementsFor(TypedList<T> typedList) {
            if (IPyroDependedOn.class.isAssignableFrom(typedList.getType())) {
                return PyroMod.this.getReplacementsFor(typedList);
            }
            return null;
        }
    }
}

