/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy.v109.domain.devices.hvac;

import java.io.ObjectStreamException;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public abstract class HvacDevice
extends ADevice {
    static final long serialVersionUID = 1L;
    private IQuantity d_msr;

    public HvacDevice(String string, IQuantity iQuantity) {
        super(string);
        this.d_msr = iQuantity;
    }

    public IQuantity getQuantity() {
        return this.d_msr;
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDevcGeom());
    }

    @Override
    public void setGeom(IGeomNode iGeomNode) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps iDisplayProps) {
        return DisplayGeom.EMPTY;
    }

    protected abstract IGeom getDevcGeom();

    private static Point3d getPointForNode(HvacNode hvacNode) {
        if (hvacNode != null && hvacNode.getProp("XYZ") != null) {
            return ((UnitPoint3D)hvacNode.getProp("XYZ")).getPoint3dValue(SI.METER);
        }
        return null;
    }

    public static class DuctDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public DuctDevice(String string, IQuantity iQuantity) {
            super(string, iQuantity);
        }

        @Override
        public IGeom getDevcGeom() {
            ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
            IFilteredCollection<HvacDuct> iFilteredCollection = theUtil.filter(Arrays.asList(objectQuantity.objects), HvacDuct.class);
            if (iFilteredCollection.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            HvacDuct hvacDuct = (HvacDuct)iFilteredCollection.iterator().next();
            List list = (List)hvacDuct.getProp("NODE_ID");
            if (list == null || list.isEmpty() || list.get(0) == null) {
                System.err.printf("[x] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
                return EmptyGeom.INSTANCE;
            }
            if (list.size() < 2) {
                Point3d point3d = HvacDevice.getPointForNode((HvacNode)list.get(0));
                if (point3d != null) {
                    return new Point(point3d);
                }
                System.err.printf("[xx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
            } else {
                Point3d point3d = HvacDevice.getPointForNode((HvacNode)list.get(0));
                Point3d point3d2 = HvacDevice.getPointForNode((HvacNode)list.get(1));
                if (point3d != null && point3d2 != null) {
                    Point3d point3d3 = Util3D.getMidPoint(point3d, point3d2);
                    return new Point(point3d3);
                }
                System.err.printf("[xxx] Unable to find location for DUCT (%s)%n", hvacDuct.getName());
            }
            return EmptyGeom.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            pyrosim.domain.devices.hvac.DuctDevice ductDevice = new pyrosim.domain.devices.hvac.DuctDevice(this.getName(), this.getQuantity());
            ductDevice.setGeom(this.getGeom());
            return ductDevice;
        }
    }

    public static class NodeDevice
    extends HvacDevice {
        static final long serialVersionUID = 1L;

        public NodeDevice(String string, IQuantity iQuantity) {
            super(string, iQuantity);
        }

        @Override
        public IGeom getDevcGeom() {
            ObjectQuantity objectQuantity = (ObjectQuantity)this.getQuantity();
            IFilteredCollection<HvacNode> iFilteredCollection = theUtil.filter(Arrays.asList(objectQuantity.objects), HvacNode.class);
            if (iFilteredCollection.isEmpty()) {
                return EmptyGeom.INSTANCE;
            }
            if (objectQuantity.get() == Quantity.HVAC_NODE_PRESSURE_DIFFERENCE) {
                assert (iFilteredCollection.size() == 2);
            } else {
                HvacNode hvacNode = (HvacNode)iFilteredCollection.iterator().next();
                Point3d point3d = HvacDevice.getPointForNode(hvacNode);
                if (point3d != null) {
                    return new Point(point3d);
                }
                System.err.printf("[x] Unable to find location for NodeDevice (%s)%n", hvacNode.getName());
            }
            return EmptyGeom.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            pyrosim.domain.devices.hvac.NodeDevice nodeDevice = new pyrosim.domain.devices.hvac.NodeDevice(this.getName(), this.getQuantity());
            nodeDevice.setGeom(this.getGeom());
            return nodeDevice;
        }
    }
}

