/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV5V6;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point2d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.FDSClusterOptions;
import pyrosim.domain.FDSRun;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.Grid;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.INamed;
import pyrosim.domain.ResultsArchive;
import pyrosim.domain.Serialized;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.MaterialCache;
import pyrosim.domain.appearance.MaterialDB;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.controls.AndOp;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.DblGreaterThanOp;
import pyrosim.domain.controls.DblLessThanOp;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.IntGreaterThanOp;
import pyrosim.domain.controls.TimeDelayCtrl;
import pyrosim.domain.devices.ADevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.APointDetector;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.Timer;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.Clock;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.KillDevice;
import pyrosim.domain.devices.simctrl.RestartFileDevc;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.evac.Corr;
import pyrosim.domain.evac.Door;
import pyrosim.domain.evac.DoorList;
import pyrosim.domain.evac.EvhoList;
import pyrosim.domain.evac.Evss;
import pyrosim.domain.evac.EvssList;
import pyrosim.domain.evac.ExitList;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacList;
import pyrosim.domain.output.AMsrStat;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.GridBoundarySlice;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.SliceList;
import pyrosim.domain.output.StatGeom;
import pyrosim.domain.output.StatisticMgr;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.particle.ParticleList;
import pyrosim.domain.quantity.VelocitySign;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.reaction.PredefReac;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.pyrosimV5V6.ConvertUtil;
import pyrosim.io.pyrosimV5V6.DelayedArrayLoader;
import pyrosim.io.pyrosimV5V6.DelayedLoader;
import pyrosim.io.pyrosimV5V6.DelayedObjectLoader;
import pyrosim.io.pyrosimV5V6.DelayedRef;
import pyrosim.legacy_2012_1.ILegacy_2012_1;
import pyrosim.legacy_2012_1.LegacyDictionary_2012_1;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.CustomFDSProps;
import pyrosim.legacy_2012_1.domain.ExSpec;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FDSRun;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.NamedPyroObject;
import pyrosim.legacy_2012_1.domain.ResultsArchive;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.Variant;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.FanSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpeciesInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ZonePath;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.controls.DeadbandCtrl;
import pyrosim.legacy_2012_1.domain.controls.IntEqualOp;
import pyrosim.legacy_2012_1.domain.controls.IntLessThanOp;
import pyrosim.legacy_2012_1.domain.controls.IntNotEqualOp;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.ManualCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.controls.SumOp;
import pyrosim.legacy_2012_1.domain.dependencies.DepSnapshot;
import pyrosim.legacy_2012_1.domain.devices.APointSrcDevc;
import pyrosim.legacy_2012_1.domain.devices.AlarmInfo;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator;
import pyrosim.legacy_2012_1.domain.devices.detectors.CableFailDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLink;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.hvac.HvacDevice;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.ABeamMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.ASprayer;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Nozzle;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.evac.CorrList;
import pyrosim.legacy_2012_1.domain.evac.Entr;
import pyrosim.legacy_2012_1.domain.evac.EntrList;
import pyrosim.legacy_2012_1.domain.evac.Evac;
import pyrosim.legacy_2012_1.domain.evac.EvacList;
import pyrosim.legacy_2012_1.domain.evac.Evho;
import pyrosim.legacy_2012_1.domain.evac.Exit;
import pyrosim.legacy_2012_1.domain.evac.PersList;
import pyrosim.legacy_2012_1.domain.geom.AFDSObject;
import pyrosim.legacy_2012_1.domain.geom.AttachedPointLoc;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.GenericGeomSrc;
import pyrosim.legacy_2012_1.domain.geom.IModelObj;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.geom.Vent;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.ProfList;
import pyrosim.legacy_2012_1.domain.output.SolidMsrStat;
import pyrosim.legacy_2012_1.domain.output.StatGeom;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.domain.rasterization.RasterizationOptions;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.domain.signals.ISignalSource;
import pyrosim.legacy_2012_1.domain.texture.ModelImage;
import pyrosim.legacy_2012_1.domain.texture.TextureDB;
import pyrosim.legacy_2012_1.domain.texture.TextureInfo;
import pyrosim.legacy_2012_1.domain.zones.LeakMgr;
import pyrosim.legacy_2012_1.domain.zones.ZoneMgr;
import pyrosim.legacy_2012_1.io.fds.FDSRenderer;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.IGeom;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.IPropsSrc;
import pyrosim.legacy_2012_1.thunderheadeng.scene3d.geom.ITexCoordGenerator;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.util.Util;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.image.IImage;
import thunderheadeng.image.Image;
import thunderheadeng.scene3d.geom.IMatAttrs;
import thunderheadeng.scene3d.geom.MatAttrs;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class Convert {
    private WarningReport<Warning> d_warnings;
    private final File d_dbDir;
    private Map<Object, DelayedRef> d_delayLoadMap;
    private Collection<DelayedLoader> d_delayLoaders;
    private Map<ISignalSource, pyrosim.domain.signals.ISignalSource> d_signalSources;
    private Map<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink> d_signalSinks;
    private Map<SignalInput, ISignalSource> d_rampSignalInputs;
    private Map<pyrosim.legacy_2012_1.domain.signals.IOutPin, IOutPin> d_outputPins;
    private Map<NamedPyroObject, pyrosim.domain.NamedPyroObject> d_evacMap;
    private Map<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>> d_matResMap;
    private Map<ExSpec, pyrosim.domain.ExSpec> d_mixFracMap;
    private Map<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion> d_initRegions;
    private final LegacyDictionary_2012_1 d_dictionary;
    private final MaterialCache d_appearanceCache;
    private pyrosim.domain.ExSpecList d_specList;
    private final Set<PartCloud> d_staticPartClouds;

    public Convert(File file, WarningReport warningReport) {
        this.d_dbDir = file;
        this.d_warnings = warningReport;
        this.d_delayLoadMap = new LinkedHashMap<Object, DelayedRef>();
        this.d_delayLoaders = new ArrayDeque<DelayedLoader>();
        this.d_signalSources = new LinkedHashMap<ISignalSource, pyrosim.domain.signals.ISignalSource>();
        this.d_signalSinks = new LinkedHashMap<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink>();
        this.d_rampSignalInputs = new LinkedHashMap<SignalInput, ISignalSource>();
        this.d_evacMap = new HashMap<NamedPyroObject, pyrosim.domain.NamedPyroObject>();
        this.d_matResMap = new LinkedHashMap<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>>();
        this.d_mixFracMap = new HashMap<ExSpec, pyrosim.domain.ExSpec>();
        this.d_initRegions = new LinkedHashMap<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion>();
        this.d_dictionary = new LegacyDictionary_2012_1();
        this.d_appearanceCache = new MaterialCache(Collections.EMPTY_LIST);
        this.d_staticPartClouds = new LinkedIdentityHashSet<PartCloud>();
        this.d_specList = null;
        this.makeAvailableForDelayLoad(null, null);
    }

    private File getAppearanceDBDir() {
        return new File(this.d_dbDir, "textures");
    }

    private void registerForDelayLoad(Object object, Field field, Object object2) {
        DelayedRef delayedRef = null;
        if (!this.d_delayLoadMap.containsKey(object2)) {
            delayedRef = new DelayedRef();
            this.d_delayLoadMap.put(object2, delayedRef);
            this.d_delayLoaders.add(new DelayedObjectLoader(object, field, delayedRef));
        } else {
            this.d_delayLoaders.add(new DelayedObjectLoader(object, field, this.d_delayLoadMap.get(object2)));
        }
    }

    private void registerArrayForDelayLoad(Object[] objectArray, Object[] objectArray2, Object object, Method method, int n) {
        DelayedRef[] delayedRefArray = new DelayedRef[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            DelayedRef delayedRef = null;
            if (!this.d_delayLoadMap.containsKey(objectArray[i])) {
                delayedRef = new DelayedRef();
                this.d_delayLoadMap.put(objectArray[i], delayedRef);
            } else {
                delayedRef = this.d_delayLoadMap.get(objectArray[i]);
            }
            delayedRefArray[i] = delayedRef;
        }
        this.d_delayLoaders.add(new DelayedArrayLoader(objectArray2, delayedRefArray));
    }

    private void makeAvailableForDelayLoad(Object object, Object object2) {
        if (!this.d_delayLoadMap.containsKey(object2)) {
            this.d_delayLoadMap.put(object2, new DelayedRef());
        }
        this.d_delayLoadMap.get(object2).set(object);
    }

    public Serialized fromLegacy(Serialized serialized, pyrosim.legacy_2012_1.domain.Serialized serialized2, MaterialDB materialDB) {
        this.fromLegacyGridList(serialized2.grids, serialized.grids);
        this.fromLegacyZoneMgr(serialized2.zones, serialized.zones);
        this.fromLegacyBridgeList(serialized2.zoneLeaks, serialized.bridges);
        this.fromLegacyFloorMgr(serialized2.floors, serialized.floors);
        this.fromLegacyPartList(serialized2.particles, serialized.particles, serialized.exSpecs);
        this.fromLegacyMatMgr(serialized2.matmgr, serialized.matmgr);
        this.fromLegacySurfMgr(serialized2.surfmgr, serialized.surfmgr, true, serialized2.textures, serialized.matmgr, materialDB);
        this.d_specList = this.fromLegacySpecList(serialized2.exSpecs, serialized.exSpecs, serialized, true);
        this.addResidues(serialized);
        this.fromLegacyReacList(serialized2.reactions, serialized.reactions, serialized.simParams, serialized.exSpecs);
        this.fromLegacyHvacList(serialized2.hvacSystem, serialized.hvacSystem);
        this.fromLegacyModelComp(serialized2.obstructions, serialized.obstructions);
        this.fromLegacySimParams(serialized2.simParams, serialized.simParams, this.d_specList);
        this.warnOnMixFrac(serialized2);
        serialized.enableFdsEvac = serialized2.enableFdsEvac;
        this.fromLegacy(serialized2.perss, serialized.perss);
        this.fromLegacy(serialized2.exits, serialized.exits);
        this.fromLegacy(serialized2.evacs, serialized.evacs);
        this.fromLegacy(serialized2.entrs, serialized.entrs);
        this.fromLegacy(serialized2.evhos, serialized.evhos);
        this.fromLegacy(serialized2.corrs, serialized.corrs);
        this.fromLegacy(serialized2.evsss, serialized.evsss);
        this.fromLegacy(serialized2.doors, serialized.doors);
        this.setEvacProps(serialized2, serialized);
        this.fromLegacy(serialized2.controls, serialized.controls);
        this.fromLegacyHeatLinkMgr(serialized2.heatLinkModels, serialized.heatLinkModels);
        this.fromLegacySmokeLinkMgr(serialized2.smokeLinkModels, serialized.smokeLinkModels);
        this.fromLegacySprinklerLinkMgr(serialized2.sprkLinkModels, serialized.sprkLinkModels);
        this.fromLegacySprayMgr(serialized2.sprayModels, serialized.sprayModels);
        this.fromLegacyDevcMgr(serialized2.devices, serialized.devices, serialized);
        serialized.boundaryOutput = this.fromLegacyBound(serialized2.boundaryOutput, serialized.boundaryOutput);
        this.fromLegacyIsoMgr(serialized2.isosurfaces, serialized.isosurfaces);
        this.fromLegacyPl3d(serialized2.plot3d, serialized.plot3d);
        this.fromLegacySlcfList(serialized2.slices, serialized.slices);
        this.fromLegacyProfList(serialized2.profs, serialized.profs);
        this.fromLegacyStatMgr(serialized2.msrStats, serialized.msrStats);
        this.fromLegacyMatlDB(serialized2.textures, serialized.appearances);
        this.fromLegacyRaster(serialized2.rastProps, serialized.rastProps);
        serialized.unprocessedRecords = serialized2.unprocessedRecords;
        serialized.lastFDSRun = this.fromLegacyRunConfig(serialized2.lastFDSRun, serialized.lastFDSRun);
        this.fromLegacyClusterConfig(serialized2.clusterOptions, serialized.clusterOptions);
        this.fromLegacyResultArch(serialized2.resultsArchive, serialized.resultsArchive);
        serialized.d_protect = serialized2.d_protect;
        serialized.d_protectPassHash = serialized2.d_protectPassHash;
        for (DelayedLoader delayedLoader : this.d_delayLoaders) {
            delayedLoader.run();
        }
        PyroSimObjectInputStream.addPeriodicSurface(serialized, this.d_warnings);
        serialized.initDefaults();
        this.linkAspiratorLines(serialized.devices);
        this.loadInitRegionSpecies();
        this.connectPins();
        this.updateEnabled(serialized2);
        PyroSimObjectInputStream.removePre52deprecatedQuants(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre52ThermocoupleQuants(serialized, this.d_warnings);
        PyroSimObjectInputStream.removePre54HRRPUA(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre54DefaultSurfs(serialized, this.d_warnings);
        PyroSimObjectInputStream.updatePre63Surfs(serialized, this.d_warnings);
        PyroSimObjectInputStream.updatePre69Adiabatic(serialized, this.d_warnings);
        PyroSimObjectInputStream.updatePre65Surfs(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre68SprayModels(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre72ClonedPins(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre73SprayModels(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre75FireSpreadVents(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre76SliceDuplicates(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre82FanCurves(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre84Evac(serialized, this.d_warnings);
        PyroSimObjectInputStream.fds_6_3_update(serialized, this.d_warnings);
        PyroSimObjectInputStream.manuallyConvertPre86AtmGradUnits(serialized, this.d_warnings);
        PyroSimObjectInputStream.generatePre87Elements(serialized, this.d_warnings);
        PyroSimObjectInputStream.warnPre91SingleSprkDryPipe(serialized, this.d_warnings);
        PyroSimObjectInputStream.warnPre94OutflowSurfs(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixPre95MultipleReacs(serialized, this.d_warnings);
        PyroSimObjectInputStream.bakePre99Transforms(serialized, this.d_warnings);
        this.updateStaticPartClouds(serialized);
        PyroSimObjectInputStream.fixMissingJets(serialized, this.d_warnings);
        PyroSimObjectInputStream.fds_6_3_update(serialized, this.d_warnings);
        PyroSimObjectInputStream.fixBadDeviceRefs(serialized);
        return serialized;
    }

    private void updateStaticPartClouds(Serialized serialized) {
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        for (PartCloud cloneable2 : this.d_staticPartClouds) {
            linkedIdentityHashSet.add(cloneable2.getParticle());
        }
        if (linkedIdentityHashSet.isEmpty()) {
            return;
        }
        PyroMod pyroMod = new PyroMod(serialized, false, false);
        NameGenerator nameGenerator = pyroMod.getNames(Particle.class);
        pyrosim.domain.dependencies.DepSnapshot depSnapshot = pyroMod.getDependencies(linkedIdentityHashSet);
        for (Particle particle : linkedIdentityHashSet) {
            Set<pyrosim.domain.IPyroObject> set = depSnapshot.findAllDependents(pyrosim.domain.IPyroObject.class, (Object)particle);
            if (set.isEmpty()) {
                assert (false);
                continue;
            }
            Boolean bl = null;
            for (pyrosim.domain.IPyroObject iPyroObject : set) {
                boolean bl2;
                boolean bl3 = bl2 = iPyroObject instanceof PartCloud && this.d_staticPartClouds.contains(iPyroObject);
                if (bl == null) {
                    bl = bl2;
                    continue;
                }
                if (bl == bl2) continue;
                bl = null;
                break;
            }
            if (bl == null) {
                Particle particle2 = (Particle)particle.clone();
                particle2.setStatic(true);
                String string = String.format(Intl.intl("%s [static]"), particle.getName());
                particle2.setName(nameGenerator.generateValidName(string));
                serialized.particles.add(particle2);
                nameGenerator.registerName(string);
                for (PartCloud partCloud : theUtil.filter(set, PartCloud.class, Filters.accept(this.d_staticPartClouds))) {
                    partCloud.setParticle(particle2);
                }
                continue;
            }
            if (!bl.booleanValue()) continue;
            particle.setStatic(true);
        }
    }

    private void updateEnabled(pyrosim.legacy_2012_1.domain.Serialized serialized) {
        IObjectFilter<IPyroObject> iObjectFilter = new IObjectFilter<IPyroObject>(){

            @Override
            public boolean shouldFilter(IPyroObject iPyroObject) {
                return iPyroObject.isEnabled();
            }
        };
        Collection<IPyroObject> collection = pyrosim.legacy_2012_1.domain.Hierarchy.flatten(pyrosim.legacy_2012_1.PyroMod.getMembers(serialized, true), IPyroObject.class, iObjectFilter);
        for (IPyroObject iPyroObject : collection) {
            Object object;
            assert (!iPyroObject.isEnabled());
            if (iPyroObject.isEnabled()) continue;
            if (this.d_delayLoadMap.containsKey(iPyroObject)) {
                object = (APyroObject)this.d_delayLoadMap.get(iPyroObject).get();
                ((APyroObject)object).setEnabled(false);
                continue;
            }
            object = iPyroObject instanceof NamedPyroObject ? ((NamedPyroObject)iPyroObject).getName() : "" + iPyroObject.hashCode();
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to maintain disabled status on %s: %s"), iPyroObject.getClass().getSimpleName(), object), Intl.intl("Updated value must be disabled manually.")));
        }
    }

    private void addResidues(Serialized serialized) {
        for (Map.Entry<Pair<pyrosim.domain.boundcond.mat.ReacByproducts, NamedPyroObject>, Pair<String, Double>> entry : this.d_matResMap.entrySet()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            pyrosim.domain.boundcond.mat.ReacByproducts reacByproducts = (pyrosim.domain.boundcond.mat.ReacByproducts)entry.getKey().v1;
            String string = (String)entry.getValue().v1;
            double d = (Double)entry.getValue().v2;
            if (entry.getKey().v2 instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.Material) {
                namedPyroObject = (Material)serialized.matmgr.get(string);
                if (namedPyroObject == null) continue;
                reacByproducts.addResidue(namedPyroObject, d);
                continue;
            }
            if (!(entry.getKey().v2 instanceof ExSpec)) continue;
            if (ExSpecList.isPredefinedSpecies(string) && serialized.exSpecs.get("WATER VAPOR") == null) {
                namedPyroObject = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies("WATER VAPOR"));
                this.d_specList.add(namedPyroObject);
            }
            if ((namedPyroObject = serialized.exSpecs.get(string)) == null) continue;
            reacByproducts.addResidue(namedPyroObject, d);
        }
    }

    private void linkAspiratorLines(pyrosim.domain.devices.DeviceManager deviceManager) {
        for (IDevice iDevice : deviceManager.flatten()) {
            if (!(iDevice instanceof Aspirator)) continue;
            Aspirator aspirator = (Aspirator)iDevice;
            ArrayList<Aspirator.SamplerLine> arrayList = new ArrayList<Aspirator.SamplerLine>();
            arrayList.addAll(aspirator.getSamplerLines());
            aspirator.setSamplerLines(arrayList);
        }
    }

    private void loadInitRegionSpecies() {
        for (Map.Entry<pyrosim.legacy_2012_1.domain.geom.InitRegion, InitRegion> entry : this.d_initRegions.entrySet()) {
            if (entry.getKey().getExtraSpecies().size() == 0) continue;
            LinkedHashMap<pyrosim.domain.ExSpec, UnitDouble> linkedHashMap = new LinkedHashMap<pyrosim.domain.ExSpec, UnitDouble>();
            for (Map.Entry<ExSpec, pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble> entry2 : entry.getKey().getExtraSpecies().entrySet()) {
                pyrosim.domain.ExSpec exSpec = (pyrosim.domain.ExSpec)this.d_delayLoadMap.get(entry2.getKey()).get();
                linkedHashMap.put(exSpec, ConvertUtil.c(entry2.getValue()));
            }
            entry.getValue().setExtraSpecies(linkedHashMap, InitRegion.SpecFractionType.MASS_FRACTION);
        }
    }

    private pyrosim.domain.quantity.IQuantity quantRefsObject(pyrosim.domain.quantity.IQuantity iQuantity, Object object) {
        if (iQuantity instanceof pyrosim.domain.quantity.ObjectQuantity) {
            pyrosim.domain.quantity.ObjectQuantity objectQuantity = (pyrosim.domain.quantity.ObjectQuantity)iQuantity;
            for (Object t : objectQuantity.objects) {
                if (t != object) continue;
                return objectQuantity;
            }
        }
        return null;
    }

    private Object fromLegacyEvacProp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof NamedPyroObject) {
            if (object instanceof pyrosim.legacy_2012_1.domain.Grid) {
                return this.d_delayLoadMap.get(object).get();
            }
            return this.d_evacMap.get(object);
        }
        if (object instanceof ILegacy_2012_1) {
            return this.d_dictionary.get((ILegacy_2012_1)object);
        }
        if (object instanceof pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble[]) {
            return ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble[])object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            LinkedIdentityHashMap<Object, Object> linkedIdentityHashMap = new LinkedIdentityHashMap<Object, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                linkedIdentityHashMap.put(this.fromLegacyEvacProp(entry.getKey()), this.fromLegacyEvacProp(entry.getValue()));
            }
            return linkedIdentityHashMap;
        }
        return object;
    }

    private void setEvacProps(pyrosim.legacy_2012_1.domain.Serialized serialized, Serialized serialized2) {
        pyrosim.domain.NamedPyroObject namedPyroObject;
        for (NamedPyroObject namedPyroObject2 : serialized.perss.flatten()) {
            namedPyroObject = (Pers)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((pyrosim.legacy_2012_1.domain.evac.Pers)namedPyroObject2).getProps().entrySet()) {
                ((Pers)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.exits.flatten()) {
            namedPyroObject = (pyrosim.domain.evac.Exit)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((Exit)namedPyroObject2).getProps().entrySet()) {
                ((pyrosim.domain.evac.Exit)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.evacs.flatten()) {
            namedPyroObject = (pyrosim.domain.evac.Evac)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((Evac)namedPyroObject2).getProps().entrySet()) {
                ((pyrosim.domain.evac.Evac)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.entrs.flatten()) {
            namedPyroObject = (pyrosim.domain.evac.Entr)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((Entr)namedPyroObject2).getProps().entrySet()) {
                ((pyrosim.domain.evac.Entr)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.evhos.flatten()) {
            namedPyroObject = (pyrosim.domain.evac.Evho)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((Evho)namedPyroObject2).getProps().entrySet()) {
                ((pyrosim.domain.evac.Evho)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.corrs.flatten()) {
            namedPyroObject = (Corr)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((pyrosim.legacy_2012_1.domain.evac.Corr)namedPyroObject2).getProps().entrySet()) {
                ((Corr)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.evsss.flatten()) {
            namedPyroObject = (Evss)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((pyrosim.legacy_2012_1.domain.evac.Evss)namedPyroObject2).getProps().entrySet()) {
                ((Evss)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
        for (NamedPyroObject namedPyroObject2 : serialized.doors.flatten()) {
            namedPyroObject = (Door)this.d_evacMap.get(namedPyroObject2);
            for (Map.Entry<String, Object> entry : ((pyrosim.legacy_2012_1.domain.evac.Door)namedPyroObject2).getProps().entrySet()) {
                ((Door)namedPyroObject).setProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
            }
        }
    }

    private void addToConnectionsMap(Object object, Object object2) {
        if (object2 instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
            object = Clock.INSTANCE;
        }
        if (object2 instanceof ISignalSource && !this.d_signalSources.containsKey(object2)) {
            this.d_signalSources.put((ISignalSource)object2, (pyrosim.domain.signals.ISignalSource)object);
        }
        if (object2 instanceof pyrosim.legacy_2012_1.domain.signals.ISignalSink) {
            Set<ISignalSource> set = ((pyrosim.legacy_2012_1.domain.signals.ISignalSink)object2).getInputPin().getConnectedSources();
            if (set.isEmpty()) {
                return;
            }
            for (ISignalSource iSignalSource : set) {
                INamed iNamed = null;
                if (iSignalSource instanceof pyrosim.legacy_2012_1.domain.controls.IControl && !(iSignalSource instanceof pyrosim.legacy_2012_1.domain.controls.ControlBridge)) {
                    if (this.d_delayLoadMap.containsKey(iSignalSource)) continue;
                    iNamed = this.fromLegacyIControl((pyrosim.legacy_2012_1.domain.controls.IControl)iSignalSource);
                } else if (iSignalSource instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
                    iNamed = this.fromLegacyDevc((pyrosim.legacy_2012_1.domain.devices.IDevice)((Object)iSignalSource), null);
                } else if (iSignalSource instanceof pyrosim.legacy_2012_1.domain.devices.detectors.Timer && !this.d_delayLoadMap.containsKey(iSignalSource)) {
                    iNamed = this.fromLegacyDevc((pyrosim.legacy_2012_1.domain.devices.detectors.Timer)iSignalSource, null);
                }
                if (iNamed == null) continue;
                this.addToConnectionsMap(iNamed, iSignalSource);
            }
            if (!this.d_signalSinks.containsKey(object2)) {
                this.d_signalSinks.put((pyrosim.legacy_2012_1.domain.signals.ISignalSink)object2, (ISignalSink)object);
            }
        }
    }

    private void connectPins() {
        pyrosim.domain.IPyroObject iPyroObject;
        for (Map.Entry<pyrosim.legacy_2012_1.domain.signals.ISignalSink, ISignalSink> entry : this.d_signalSinks.entrySet()) {
            block3: for (ISignalSource iSignalSource : entry.getKey().getInputPin().getConnectedSources()) {
                iPyroObject = this.d_signalSources.get(iSignalSource);
                ISignalSink iSignalSink = entry.getValue();
                if (iPyroObject == null) continue;
                for (IOutPin iOutPin : iPyroObject.getOutputPins()) {
                    if (!iSignalSink.getInputPin().isCompatible(iOutPin)) continue;
                    iSignalSink.getInputPin().connect(iOutPin);
                    continue block3;
                }
            }
        }
        for (Map.Entry<Serializable, Cloneable> entry : this.d_rampSignalInputs.entrySet()) {
            pyrosim.domain.signals.ISignalSource iSignalSource = this.d_signalSources.get(entry.getValue());
            Iterator<? extends IOutPin> iterator = iSignalSource.getOutputPins().iterator();
            if (!iterator.hasNext()) continue;
            iPyroObject = iterator.next();
            try {
                pyrosim.util.Util.assignFinalField(entry.getKey(), "input", iPyroObject);
            }
            catch (Exception exception) {
                assert (false);
            }
        }
    }

    private IControl fromLegacyIControl(pyrosim.legacy_2012_1.domain.controls.IControl iControl) {
        pyrosim.domain.controls.AControl aControl = null;
        if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.DblGreaterThanOp) {
            aControl = new DblGreaterThanOp(ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.DblGreaterThanOp)iControl).getN()));
        } else if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.DblLessThanOp) {
            aControl = new DblLessThanOp(ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.DblLessThanOp)iControl).getN()));
        } else if (iControl instanceof IntLessThanOp) {
            aControl = new pyrosim.domain.controls.IntLessThanOp(((IntLessThanOp)iControl).getN());
        } else if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.IntGreaterThanOp) {
            aControl = new IntGreaterThanOp(((pyrosim.legacy_2012_1.domain.controls.IntGreaterThanOp)iControl).getN());
        } else if (iControl instanceof IntEqualOp) {
            aControl = new pyrosim.domain.controls.IntEqualOp(((IntEqualOp)iControl).getN());
        } else if (iControl instanceof IntNotEqualOp) {
            aControl = new pyrosim.domain.controls.IntNotEqualOp(((IntNotEqualOp)iControl).getN());
        } else if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.AndOp) {
            aControl = new AndOp();
        } else if (iControl instanceof OrOp) {
            aControl = new pyrosim.domain.controls.OrOp();
        } else if (iControl instanceof NotOp) {
            aControl = new pyrosim.domain.controls.NotOp();
        } else if (iControl instanceof SumOp) {
            aControl = new pyrosim.domain.controls.SumOp();
        } else if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.CustomCtrl) {
            aControl = new CustomCtrl(iControl.isEnabled(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.CustomCtrl)iControl).getTripValues()));
        } else if (iControl instanceof DeadbandCtrl) {
            DeadbandCtrl deadbandCtrl = (DeadbandCtrl)iControl;
            aControl = new pyrosim.domain.controls.DeadbandCtrl(deadbandCtrl.getTripDirection(), ConvertUtil.c(deadbandCtrl.getLowerBound()), ConvertUtil.c(deadbandCtrl.getUpperBound()));
        } else if (iControl instanceof LatchCtrl) {
            aControl = new pyrosim.domain.controls.LatchCtrl();
        } else if (iControl instanceof ManualCtrl) {
            ManualCtrl manualCtrl = (ManualCtrl)iControl;
            aControl = new pyrosim.domain.controls.ManualCtrl(manualCtrl.getFDSText(), manualCtrl.getName());
        } else if (iControl instanceof pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl) {
            aControl = new TimeDelayCtrl(ConvertUtil.c(((pyrosim.legacy_2012_1.domain.controls.TimeDelayCtrl)iControl).getTimeDelay()));
        }
        return aControl;
    }

    private pyrosim.domain.SimParams fromLegacySimParams(SimParams simParams, pyrosim.domain.SimParams simParams2, pyrosim.domain.ExSpecList exSpecList) {
        simParams2.setJobTitle(simParams.getJobTitle());
        this.fromLegacySPTime(simParams.getTime(), simParams2.getTime());
        this.fromLegacySPCalc(simParams.getCalculations(), simParams2.getCalculations());
        this.fromLegacySPEnv(simParams.getEnvironment(), simParams2.getEnvironment());
        this.fromLegacySPWind(simParams.getEnvironment(), simParams2.getWind());
        this.fromLegacySPRad(simParams.getRadiTransport(), simParams2.getRadiTransport());
        this.fromLegacySPFile(simParams.getFileOutput(), simParams2.getFileOutput());
        this.fromLegacySPPart(simParams.getParticles(), simParams2.getParticles());
        this.fromLegacySPMisc(simParams.getMisc(), simParams2.getMisc(), exSpecList);
        simParams2.setCustomFDSProps("TIME", this.fromLegacyCustomFDS(simParams.getCustomFDSProps("TIME")));
        simParams2.setCustomFDSProps("DUMP", this.fromLegacyCustomFDS(simParams.getCustomFDSProps("DUMP")));
        simParams2.setCustomFDSProps("RADI", this.fromLegacyCustomFDS(simParams.getCustomFDSProps("RADI")));
        simParams2.setCustomFDSProps("MISC", this.fromLegacyCustomFDS(simParams.getCustomFDSProps("MISC")));
        return simParams2;
    }

    private void fromLegacySPTime(SimParams.Time time, SimParams.Time time2) {
        time2.setInitTimeStep(ConvertUtil.c(time.getInitTimeStep()));
        time2.setWallIncrement(time.getWallIncrement());
        time2.setStartTime(ConvertUtil.c(time.getStartTime()));
        time2.setStopTime(ConvertUtil.c(time.getStopTime()));
        time2.setTimeStepLocks(time.lockTimeSteps(), time.restrictTimeSteps());
        Map<String, Object> map = time.getEvacProps();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            time2.setEvacProp(entry.getKey(), this.fromLegacyEvacProp(entry.getValue()));
        }
    }

    private void fromLegacySPCalc(SimParams.Calculations calculations, SimParams.Calculations calculations2) {
        if (calculations.getUseMLTurbulentModel()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("FDS no longer supports the H_EDDY parameter in the MISC namelist (Moinuddin and Li Turbulent Model)."), Intl.intl("Moinuddin and Li Turbulent Model dropped from MISC record.")));
        }
        if (calculations.calcDNS()) {
            calculations2.setSimMode(SimParams.Calculations.SimulationMode.DNS);
            calculations2.setBaroclinicState(SimParams.Calculations.BaroclinicState.AUTO);
        } else {
            calculations2.setSimMode(SimParams.Calculations.SimulationMode.VLES);
            if (calculations.isCorrectBaroclinicTorque()) {
                calculations2.setBaroclinicState(SimParams.Calculations.BaroclinicState.AUTO);
            } else {
                calculations2.setBaroclinicState(SimParams.Calculations.BaroclinicState.FALSE);
            }
        }
        calculations2.setCflRange(calculations.getCflRange()[0], calculations.getCflRange()[1]);
        calculations2.setVnRange(calculations.getVnRange()[0], calculations.getVnRange()[1]);
        calculations2.setCsmag(calculations.getCsmag());
        calculations2.setPrandtlNum(calculations.getPrandtlNum());
        calculations2.setSchmidtNum(calculations.getSchmidtNum());
        SimParams.Calculations calculations3 = new SimParams.Calculations();
        if (calculations.getCForced() != calculations3.getCForced()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Forced convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_FORCED", calculations.getCForced())));
        }
        if (calculations.getCHorizontal() != calculations3.getCHorizontal()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Horizontal convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_HORIZONTAL", calculations.getCHorizontal())));
        }
        if (calculations.getCVertical() != calculations3.getCVertical()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Vertical convection coefficient now set individually for surfaces."), String.format(Intl.intl("%s=%.3f dropped from MISC record."), "C_VERTICAL", calculations.getCVertical())));
        }
    }

    private void fromLegacySPEnv(SimParams.Environment environment, SimParams.Environment environment2) {
        environment2.setRelHumidity(new UnitDouble(environment.getRelHumidity(), NonSI.PERCENT));
        environment2.setAmbTemp(ConvertUtil.c(environment.getAmbTemp()));
        environment2.setAmbPressure(ConvertUtil.c(environment.getAmbPressure()));
        environment2.setGroundLevel(ConvertUtil.c(environment.getGroundLevel()));
        environment2.setGravityAccel(this.fromLegacyVariant(environment.getGravityX(), environment2.getGravityX()), this.fromLegacyVariant(environment.getGravityY(), environment2.getGravityY()), this.fromLegacyVariant(environment.getGravityZ(), environment2.getGravityZ()));
    }

    private Variant fromLegacyVariant(pyrosim.legacy_2012_1.domain.Variant variant, Variant variant2) {
        if (variant instanceof Variant.UnitDoubleVar) {
            variant2 = Variant.constant(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)variant.val));
        } else if (variant instanceof Variant.DefaultVar) {
            variant2 = Variant.DEFAULT;
        } else if (variant instanceof Variant.RampVar) {
            Variant.RampVar rampVar = (Variant.RampVar)variant;
            variant2 = Variant.ramp(this.fromLegacyRamp((Ramp)rampVar.val));
        }
        return variant2;
    }

    private void fromLegacySPRad(SimParams.RadiationTransport radiationTransport, SimParams.RadiationTransport radiationTransport2) {
        radiationTransport2.setRadiationOn(radiationTransport.isRadiationOn());
        radiationTransport2.setAngleIncrement(radiationTransport.getAngleIncrement());
        if (radiationTransport.isIncludeExtraFuelBands()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports CH4_BANDS parameter in the MISC namelist."), Intl.intl("Use Additional Fuel Bands dropped from MISC record.")));
        }
        UnitDouble unitDouble = ConvertUtil.c(this.d_warnings, Intl.intl("Radiation Absorption Coefficient"), 13, radiationTransport.getConstAbsorptionCoef());
        radiationTransport2.setConstAbsorptionCoef(unitDouble);
        radiationTransport2.setNumPolarAngles(radiationTransport.getNumPolarAngles());
        radiationTransport2.setNumSolidAngles(radiationTransport.getNumSolidAngles());
        radiationTransport2.setRadCalcPathLen(ConvertUtil.c(radiationTransport.getRadCalcPathLen()));
        radiationTransport2.setRadiativeLossFraction(radiationTransport.getRadiativeLossFraction());
        radiationTransport2.setAssumedRadSourceTemp(ConvertUtil.c(radiationTransport.getAssumedRadSourceTemp()));
        radiationTransport2.setTimeStepInc(radiationTransport.getTimeStepInc());
        radiationTransport2.setNonGrayGasAssumption(radiationTransport.isNonGrayGasAssumption());
    }

    private void fromLegacySPFile(SimParams.FileOutput fileOutput, SimParams.FileOutput fileOutput2) {
        fileOutput2.setLimitCSVColumns(fileOutput.isLimitCSVColumns());
        fileOutput2.setDtBoundaryFile(ConvertUtil.c(fileOutput.getDtBoundaryFile()));
        fileOutput2.setDtDeviceFiles(ConvertUtil.c(fileOutput.getDtDeviceFiles()));
        fileOutput2.setDtHeatReleaseRateFiles(ConvertUtil.c(fileOutput.getDtHeatReleaseRateFiles()));
        fileOutput2.setDtIsofFiles(ConvertUtil.c(fileOutput.getDtIsofFiles()));
        fileOutput2.setDtParticleFiles(ConvertUtil.c(fileOutput.getDtParticleFiles()));
        fileOutput2.setDtRestartFile(ConvertUtil.c(fileOutput.getDtRestartFile()));
        fileOutput2.setDtSliceFiles(ConvertUtil.c(fileOutput.getDtSliceFiles()));
        fileOutput2.setDtMassFiles(ConvertUtil.c(fileOutput.getDtMassFiles()));
        fileOutput2.setDtPlot3dFile(ConvertUtil.c(fileOutput.getDtPlot3dFile()));
        fileOutput2.setDtProfileDumpInterval(ConvertUtil.c(fileOutput.getDtProfileDumpInterval()));
        fileOutput2.setNumOutputFrames(fileOutput.getNumOutputFrames());
        fileOutput2.setVisualize3dSmoke(fileOutput.isVisualize3dSmoke());
        fileOutput2.setWriteSpeciesMassFile(fileOutput.isWriteSpeciesMassFile());
    }

    private void fromLegacySPPart(SimParams.Particles particles, SimParams.Particles particles2) {
        particles2.setPourousFloor(particles.isPourousFloor());
        particles2.setAllowUndersideDroplets(particles.getAllowUndersideDroplets());
        particles2.setMaxParticlesPerMesh(particles.getMaxParticlesPerMesh());
    }

    private void setBGSpec(pyrosim.domain.ExSpecList exSpecList, String string) {
        pyrosim.domain.ExSpec exSpec = exSpecList.get(string);
        if (exSpec == null) {
            if (pyrosim.domain.ExSpecList.isPredefinedSpecies(string)) {
                if (string.equals(ExSpecList.Predefined.AIR.getName())) {
                    return;
                }
                exSpecList.add(new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(string)));
                exSpec = exSpecList.get(string);
            } else {
                return;
            }
        }
        pyrosim.domain.CustomFDSProps customFDSProps = exSpec.getCustomFDSProps();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FDSRecordSpec fDSRecordSpec = FDS6Const.getRecordSpecs().get("SPEC");
        FDSRenderProps fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        this.addPropIfNotDefault(hashMap, fDSRenderProps, fDSRecordSpec, "BACKGROUND", true);
        exSpec.setCustomFDSProps(pyrosim.domain.CustomFDSProps.union(customFDSProps, pyrosim.domain.CustomFDSProps.get(hashMap)));
        this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports the BACKGROUND parameter in the SPEC namelist."), String.format(Intl.intl("%s moved to %s Advanced Parameters."), "BACKGROUND", string)));
    }

    private void fromLegacySPWind(SimParams.Environment environment, SimParams.Wind wind) {
        SimParams.Environment environment2 = new SimParams.Environment();
        if (!environment2.getAmbVel().equals(environment.getAmbVel())) {
            UnitPoint3D unitPoint3D = ConvertUtil.c(environment.getAmbVel());
            wind.set(SimParams.Wind.INITSPEEDOPT, SimParams.Wind.InitSpeedOptions.UV);
            wind.set(SimParams.Wind.U0, unitPoint3D.xu());
            wind.set(SimParams.Wind.V0, unitPoint3D.yu());
            wind.set(SimParams.Wind.W0, unitPoint3D.zu());
        }
        if (environment.getAtmLapseRate() != null) {
            wind.set(SimParams.Wind.LAPSE_RATE, ConvertUtil.c(environment.getAtmLapseRate()));
        }
    }

    private void fromLegacySPMisc(SimParams.Misc misc, SimParams.Misc misc2, pyrosim.domain.ExSpecList exSpecList) {
        String string = misc.getBackgroundSpecies();
        this.setBGSpec(exSpecList, string);
        try {
            this.registerForDelayLoad(misc2, SimParams.Misc.class.getDeclaredField("d_surfDefault"), misc.getSurfDefault());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        misc2.setTextureOrigin(ConvertUtil.c(misc.getTextureOrigin()));
        if (misc.predictCOProd()) {
            this.d_warnings.addWarning(new Warning(Intl.intl("CO Production now handled by finite element reactions."), Intl.intl("CO Production dropped from MISC record.")));
        }
        for (Map.Entry<String, Object> entry : misc.getEvacProps().entrySet()) {
            if (entry.getValue() instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.Surface) {
                String string2 = entry.getKey();
                pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface = (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)entry.getValue();
                DelayedRef delayedRef = this.d_delayLoadMap.get(surface);
                if (delayedRef == null) {
                    this.d_warnings.addWarning(new Warning(Intl.intl("SURF: Problem converting field EVAC_DEFAULT."), Intl.intl("Surface INERT set as default.")));
                    continue;
                }
                Surface surface2 = (Surface)delayedRef.get();
                misc2.setEvacProp(string2, surface2);
                continue;
            }
            misc2.setEvacProp(entry.getKey(), entry.getValue());
        }
    }

    private ModelComposite fromLegacyModelComp(pyrosim.legacy_2012_1.domain.geom.ModelComposite modelComposite, ModelComposite modelComposite2) {
        modelComposite2.setName(modelComposite.getName());
        for (IPyroObject iPyroObject : modelComposite.getMembers()) {
            INamed iNamed;
            pyrosim.legacy_2012_1.domain.INamed iNamed2;
            if (iPyroObject instanceof Composite) {
                iNamed2 = (pyrosim.legacy_2012_1.domain.geom.ModelComposite)iPyroObject;
                iNamed = new ModelComposite(((NamedPyroObject)iNamed2).getName());
                modelComposite2.add(this.fromLegacyModelComp((pyrosim.legacy_2012_1.domain.geom.ModelComposite)iNamed2, (ModelComposite)iNamed));
                continue;
            }
            iNamed2 = (IModelObj)iPyroObject;
            iNamed = this.fromLegacyModelObj((IModelObj)iNamed2);
            assert (iNamed != null);
            if (iNamed != null) {
                modelComposite2.add(iNamed);
                continue;
            }
            this.addUnableToLoadWarn(iNamed2.getName(), Intl.intl("geometry object"));
        }
        return modelComposite2;
    }

    private pyrosim.domain.geom.IModelObj fromLegacyModelObj(IModelObj iModelObj) {
        pyrosim.domain.NamedPyroObject namedPyroObject = null;
        if (iModelObj instanceof GenericGeomSrc) {
            GenericGeomSrc genericGeomSrc = (GenericGeomSrc)iModelObj;
            namedPyroObject = new pyrosim.domain.geom.GenericGeomSrc(genericGeomSrc.getName(), this.fromLegacyNode(genericGeomSrc.getGeom(), genericGeomSrc.getTexCoordGen()), this.fromLegacyProp(genericGeomSrc.getDisplayProps()));
        } else if (iModelObj instanceof pyrosim.legacy_2012_1.domain.geom.Hole) {
            pyrosim.legacy_2012_1.domain.geom.Hole hole = (pyrosim.legacy_2012_1.domain.geom.Hole)iModelObj;
            namedPyroObject = new Hole(hole.getName(), this.fromLegacyNode(hole.getGeom()));
            this.setFDSObjectProps(hole, (pyrosim.domain.geom.FDSObject)((Object)namedPyroObject));
        } else if (iModelObj instanceof Obstruction) {
            Obstruction obstruction = (Obstruction)iModelObj;
            ArrayList<Surface> arrayList = new ArrayList<Surface>();
            for (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface : obstruction.getSurfaces()) {
                arrayList.add((Surface)this.d_delayLoadMap.get(surface).get());
            }
            Cloneable[] cloneableArray = arrayList.toArray(new Surface[arrayList.size()]);
            pyrosim.domain.geom.Obstruction obstruction2 = new pyrosim.domain.geom.Obstruction(obstruction.getName(), this.fromLegacyNode(obstruction.getGeom()), (Surface[])cloneableArray);
            obstruction2.setBulkDensity(ConvertUtil.c(obstruction.getBulkDensity()));
            obstruction2.setOptions(253, false);
            if ((obstruction.getSetOptions() & 2) != 0) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Smooth surfaces."), String.format(Intl.intl("Smooth option removed from obstruction, %s."), obstruction.getName())));
            }
            obstruction2.setOptions(obstruction.getSetOptions() & 0xFFFFFFFD, true);
            namedPyroObject = obstruction2;
            this.setFDSObjectProps(obstruction, (pyrosim.domain.geom.FDSObject)((Object)namedPyroObject));
        } else if (iModelObj instanceof pyrosim.legacy_2012_1.domain.geom.InitRegion) {
            pyrosim.legacy_2012_1.domain.geom.InitRegion initRegion = (pyrosim.legacy_2012_1.domain.geom.InitRegion)iModelObj;
            namedPyroObject = new InitRegion(initRegion.getName(), (AABoxGeom)this.fromLegacyNode(initRegion.getGeom()).flatten().getLocalGeom());
            ((InitRegion)namedPyroObject).setDensity(ConvertUtil.c(initRegion.getDensity()));
            ((InitRegion)namedPyroObject).setTemperature(ConvertUtil.c(initRegion.getTemperature()));
            this.d_initRegions.put(initRegion, (InitRegion)namedPyroObject);
            this.setFDSObjectProps(initRegion, (pyrosim.domain.geom.FDSObject)((Object)namedPyroObject));
        } else if (iModelObj instanceof pyrosim.legacy_2012_1.domain.geom.PartCloud) {
            pyrosim.legacy_2012_1.domain.geom.PartCloud partCloud = (pyrosim.legacy_2012_1.domain.geom.PartCloud)iModelObj;
            PartCloud partCloud2 = new PartCloud(partCloud.getName(), null, (AABoxGeom)this.fromLegacyNode(partCloud.getGeom()).flatten().getLocalGeom());
            namedPyroObject = partCloud2;
            partCloud2.setInitDrops(this.fromLegacyPCDropCount(partCloud.getInitDrops()));
            partCloud2.setInsertion(this.fromLegacyPCInsert(partCloud.getInsertion()));
            if (partCloud.isStatic()) {
                this.d_staticPartClouds.add(partCloud2);
            }
            try {
                this.registerForDelayLoad(namedPyroObject, PartCloud.class.getDeclaredField("d_particle"), partCloud.getParticle());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            this.setFDSObjectProps(partCloud, (pyrosim.domain.geom.FDSObject)((Object)namedPyroObject));
        } else if (iModelObj instanceof pyrosim.legacy_2012_1.domain.geom.Vent) {
            pyrosim.legacy_2012_1.domain.geom.Vent vent = (pyrosim.legacy_2012_1.domain.geom.Vent)iModelObj;
            Vent.VentGeom ventGeom = vent.getGeom();
            AARectangle aARectangle = new AARectangle(ventGeom.d_plane, ventGeom.d_planeVal, ventGeom.d_minx, ventGeom.d_miny, ventGeom.d_maxx, ventGeom.d_maxy, false);
            UnitPoint3D unitPoint3D = null;
            UnitDouble unitDouble = null;
            if (vent.getFireSpread() != null) {
                unitPoint3D = vent.getFireSpread().d_source.fromLegacy(this.d_dictionary);
                unitDouble = vent.getFireSpread().d_spreadRate.fromLegacy(this.d_dictionary);
            }
            namedPyroObject = new Vent(vent.getName(), null, aARectangle, unitDouble, unitPoint3D);
            try {
                this.registerForDelayLoad(namedPyroObject, Vent.class.getDeclaredField("d_surf"), vent.getSurface());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            if (vent.getOpenProps() != null) {
                if (!vent.getOpenProps().species.isEmpty()) {
                    this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Open Vent Species Mixture Fractions."), String.format(Intl.intl("%s dropped from Vent %s."), "MASS_FRACTION", vent.getName())));
                }
                ((Vent)namedPyroObject).setOpenProps(new Vent.OpenProps(ConvertUtil.c(vent.getOpenProps().temp), this.fromLegacyTBV(vent.getOpenProps().pressure)));
            }
            this.setFDSObjectProps(vent, (pyrosim.domain.geom.FDSObject)((Object)namedPyroObject));
        }
        if (iModelObj instanceof AFDSObject) {
            this.addToConnectionsMap(namedPyroObject, iModelObj);
        }
        if (namedPyroObject != null) {
            namedPyroObject.setVisible(iModelObj.isVisible());
            namedPyroObject.setEnabled(iModelObj.isEnabled());
            this.makeAvailableForDelayLoad(namedPyroObject, iModelObj);
        }
        return namedPyroObject;
    }

    private PartCloud.IDropletCount fromLegacyPCDropCount(PartCloud.IDropletCount iDropletCount) {
        if (iDropletCount instanceof PartCloud.ConstDropletCount) {
            PartCloud.ConstDropletCount constDropletCount = (PartCloud.ConstDropletCount)iDropletCount;
            return new PartCloud.ConstDropletCount(constDropletCount.d_dropCount);
        }
        assert (iDropletCount instanceof PartCloud.DropDensityCount);
        PartCloud.DropDensityCount dropDensityCount = (PartCloud.DropDensityCount)iDropletCount;
        return new PartCloud.DropDensityCount(ConvertUtil.c(dropDensityCount.d_density));
    }

    private PartCloud.IInsertion fromLegacyPCInsert(PartCloud.IInsertion iInsertion) {
        if (iInsertion instanceof PartCloud.InsertOnce) {
            PartCloud.InsertOnce insertOnce = (PartCloud.InsertOnce)iInsertion;
            return new PartCloud.InsertOnce(ConvertUtil.c(insertOnce.massPerVolume));
        }
        assert (iInsertion instanceof PartCloud.InsertPeriodically);
        PartCloud.InsertPeriodically insertPeriodically = (PartCloud.InsertPeriodically)iInsertion;
        return new PartCloud.InsertPeriodically(ConvertUtil.c(insertPeriodically.dt), ConvertUtil.c(insertPeriodically.massPerTime));
    }

    private void setFDSObjectProps(FDSObject fDSObject, pyrosim.domain.geom.FDSObject fDSObject2) {
        fDSObject2.setColors(fDSObject.getColors());
        fDSObject2.setEvac(EvacProps.get(fDSObject.getEvac().evacuation, (Grid)this.d_delayLoadMap.get(fDSObject.getEvac().mesh).get()));
    }

    private pyrosim.domain.GridList fromLegacyGridList(GridList gridList, pyrosim.domain.GridList gridList2) {
        for (IPyroObject iPyroObject : gridList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (GridList)iPyroObject;
                namedPyroObject = new pyrosim.domain.GridList(namedPyroObject2.getName());
                gridList2.add(this.fromLegacyGridList((GridList)namedPyroObject2, (pyrosim.domain.GridList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.Grid)iPyroObject;
            namedPyroObject = this.fromLegacyGrid((pyrosim.legacy_2012_1.domain.Grid)namedPyroObject2);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                gridList2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("mesh"));
        }
        return gridList2;
    }

    public Grid fromLegacyGrid(pyrosim.legacy_2012_1.domain.Grid grid) {
        if (grid == null) {
            return null;
        }
        Grid grid2 = new Grid(grid.getName(), ConvertUtil.c(grid.getMinPoint()), ConvertUtil.c(grid.getMaxPoint()), ConvertUtil.c(grid.getXDivisions()), ConvertUtil.c(grid.getYDivisions()), ConvertUtil.c(grid.getZDivisions()));
        grid2.setFYI(grid.getFYI());
        if (grid.getColor() != null) {
            grid2.setColor(new Color(grid.getColor().getRed(), grid.getColor().getGreen(), grid.getColor().getBlue(), 255));
            if (grid.getColor().getAlpha() < 255) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports transparency for MESHES."), String.format(Intl.intl("Parameter Alpha dropped from MESH %s"), grid.getName())));
            }
        }
        grid2.setSyncTimeStep(grid.syncTimeStep());
        grid2.setVisible(true);
        grid2.setEvacuation(grid.getEvacuation());
        grid2.setEvacHumans(grid.getEvacHumans());
        grid2.setEvacZOffset(ConvertUtil.c(grid.getEvacZOffset()));
        this.makeAvailableForDelayLoad(grid2, grid);
        return grid2;
    }

    private pyrosim.domain.zones.ZoneMgr fromLegacyZoneMgr(ZoneMgr zoneMgr, pyrosim.domain.zones.ZoneMgr zoneMgr2) {
        this.makeAvailableForDelayLoad(zoneMgr2.getOuter(), zoneMgr.getOuter());
        for (IPyroObject iPyroObject : zoneMgr.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (ZoneMgr)iPyroObject;
                namedPyroObject = new pyrosim.domain.zones.ZoneMgr(namedPyroObject2.getName());
                zoneMgr2.add(this.fromLegacyZoneMgr((ZoneMgr)namedPyroObject2, (pyrosim.domain.zones.ZoneMgr)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.zones.Zone)iPyroObject;
            if (((pyrosim.legacy_2012_1.domain.zones.Zone)namedPyroObject2).isOuter()) continue;
            namedPyroObject = this.fromLegacyZone((pyrosim.legacy_2012_1.domain.zones.Zone)namedPyroObject2);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                zoneMgr2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("zone"));
        }
        return zoneMgr2;
    }

    private Zone fromLegacyZone(pyrosim.legacy_2012_1.domain.zones.Zone zone) {
        if (zone == null) {
            return null;
        }
        if (this.d_delayLoadMap.containsKey(zone)) {
            return (Zone)this.d_delayLoadMap.get(zone).get();
        }
        Zone zone2 = new Zone(zone.getName(), ConvertUtil.c(zone.getBox()));
        zone2.setVisible(zone.isVisible());
        zone2.setColor(zone.getColor());
        this.makeAvailableForDelayLoad(zone2, zone);
        return zone2;
    }

    private BridgeList fromLegacyBridgeList(LeakMgr leakMgr, BridgeList bridgeList) {
        for (IPyroObject iPyroObject : leakMgr.getMembers()) {
            APyroObject aPyroObject;
            pyrosim.legacy_2012_1.domain.APyroObject aPyroObject2;
            if (iPyroObject instanceof LeakMgr) {
                aPyroObject2 = (LeakMgr)iPyroObject;
                aPyroObject = new BridgeList(((NamedPyroObject)aPyroObject2).getName());
                bridgeList.add(this.fromLegacyBridgeList((LeakMgr)aPyroObject2, (BridgeList)aPyroObject));
                continue;
            }
            aPyroObject2 = (pyrosim.legacy_2012_1.domain.zones.Leak)iPyroObject;
            aPyroObject = this.fromLegacyLeak((pyrosim.legacy_2012_1.domain.zones.Leak)aPyroObject2);
            assert (aPyroObject != null);
            bridgeList.add(aPyroObject);
        }
        assert (leakMgr.flatten().size() == bridgeList.flatten().size());
        return bridgeList;
    }

    private Leak fromLegacyLeak(pyrosim.legacy_2012_1.domain.zones.Leak leak) {
        Leak leak2 = new Leak(null, null, ConvertUtil.c(leak.area));
        try {
            this.registerForDelayLoad(leak2, Leak.class.getDeclaredField("zone1"), leak.zone1);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        try {
            this.registerForDelayLoad(leak2, Leak.class.getDeclaredField("zone2"), leak.zone2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        this.addToConnectionsMap(leak2, leak);
        return leak2;
    }

    private FloorManager fromLegacyFloorMgr(pyrosim.legacy_2012_1.domain.FloorManager floorManager, FloorManager floorManager2) {
        floorManager2.clear();
        for (IPyroObject iPyroObject : floorManager.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.FloorManager)iPyroObject;
                namedPyroObject = new FloorManager(namedPyroObject2.getName());
                floorManager2.add(this.fromLegacyFloorMgr((pyrosim.legacy_2012_1.domain.FloorManager)namedPyroObject2, (FloorManager)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.Floor)iPyroObject;
            namedPyroObject = this.fromLegacyFloor((pyrosim.legacy_2012_1.domain.Floor)namedPyroObject2);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                floorManager2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("floor"));
        }
        return floorManager2;
    }

    private Floor fromLegacyFloor(pyrosim.legacy_2012_1.domain.Floor floor) {
        Floor floor2 = new Floor(floor.getName(), ConvertUtil.c(floor.getElevation()), ConvertUtil.c(floor.getSlabThickness()), ConvertUtil.c(floor.getWallHeight()), this.fromLegacyImg(floor.getBgImage()), Floor.DEFAULT_COLOR);
        return floor2;
    }

    private pyrosim.domain.ModelImage fromLegacyImg(ModelImage modelImage) {
        return modelImage != null ? new pyrosim.domain.ModelImage(this.fromLegacyImage(modelImage.getImage()), ConvertUtil.c(modelImage.getLWTransform()), modelImage.getOpacity()) : null;
    }

    private ParticleList fromLegacyPartList(pyrosim.legacy_2012_1.domain.particle.ParticleList particleList, ParticleList particleList2, pyrosim.domain.ExSpecList exSpecList) {
        pyrosim.legacy_2012_1.domain.particle.ParticleList particleList3 = new pyrosim.legacy_2012_1.domain.particle.ParticleList();
        particleList3.addDefaults();
        for (IPyroObject iPyroObject : particleList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.particle.ParticleList)iPyroObject;
                namedPyroObject = new ParticleList(namedPyroObject2.getName());
                particleList2.add(this.fromLegacyPartList((pyrosim.legacy_2012_1.domain.particle.ParticleList)namedPyroObject2, (ParticleList)namedPyroObject, exSpecList));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.particle.Particle)iPyroObject;
            namedPyroObject = this.fromLegacyParticle((pyrosim.legacy_2012_1.domain.particle.Particle)namedPyroObject2, particleList2, exSpecList);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                particleList2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("particle"));
        }
        return particleList2;
    }

    private Particle fromLegacyParticle(pyrosim.legacy_2012_1.domain.particle.Particle particle, ParticleList particleList, pyrosim.domain.ExSpecList exSpecList) {
        Output output = new Output(ConvertUtil.c(particle.getDescription().getOutput().d_age), particle.getDescription().getOutput().d_samplingFactor);
        IColoring iColoring = this.createColoringFromLegacyPartDesc(particle.getDescription());
        Particle particle2 = new Particle(particle.getName(), Particle.Type.LIQUID, output, iColoring);
        this.setTypeFromLegacyPartDesc(particle.getDescription(), particle2);
        pyrosim.domain.ExSpec exSpec = this.createSpeciesFromLegacyPartDesc(particle, particle.getDescription());
        if (exSpec != null) {
            exSpecList.add(exSpec);
            particle2.setSpecies(exSpec);
        }
        pyrosim.domain.CustomFDSProps customFDSProps = pyrosim.domain.CustomFDSProps.get(this.convertDataFromLegacyPartDesc(particle.getDescription(), particle2));
        particle2.setCustomFDSProps(pyrosim.domain.CustomFDSProps.union(this.fromLegacyCustomFDS(particle.getCustomFDSProps()), customFDSProps));
        particle2.setFYI(particle.getFYI());
        String string = particle2.getName();
        Particle particle3 = (Particle)particleList.get(string);
        if (particle3 != null) {
            particle3.setName(string + "_1");
        }
        this.makeAvailableForDelayLoad(particle2, particle);
        return particle2;
    }

    private void setSizeDistFromLegacyPartSize(SizeDistribution sizeDistribution, Particle particle) {
        particle.setDiameter(ConvertUtil.c(sizeDistribution.d_medianDiameter));
        if (sizeDistribution.d_type instanceof SizeDistribution.RosinRammler) {
            SizeDistribution.RosinRammler rosinRammler = (SizeDistribution.RosinRammler)sizeDistribution.d_type;
            particle.setGammaD(rosinRammler.d_gammaD);
            particle.setMinDiameter(ConvertUtil.c(rosinRammler.d_minDiameter));
            particle.setMaxDiameter(ConvertUtil.c(rosinRammler.d_maxDiameter));
            if (rosinRammler.d_sigma != null) {
                particle.setSigmaD(rosinRammler.d_sigma);
            }
            particle.setDistribution(Particle.Distribution.ROSIN);
        } else {
            particle.setDistribution(Particle.Distribution.CONST);
        }
    }

    private void setTypeFromLegacyPartDesc(IParticleDesc iParticleDesc, Particle particle) {
        if (iParticleDesc instanceof FuelPartDesc) {
            particle.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((FuelPartDesc)iParticleDesc).d_sizeDist, particle);
        } else if (iParticleDesc instanceof TracerPartDesc) {
            particle.setType(Particle.Type.TRACER);
        } else if (iParticleDesc instanceof WaterPartDesc) {
            particle.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((WaterPartDesc)iParticleDesc).d_sizeDist, particle);
        } else if (iParticleDesc instanceof GenericPartDesc) {
            particle.setType(Particle.Type.LIQUID);
            this.setSizeDistFromLegacyPartSize(((GenericPartDesc)iParticleDesc).d_sizeDist, particle);
        } else {
            throw new RuntimeException("Unknown particle description class: " + iParticleDesc.getClass().getName());
        }
    }

    private Map<String, String> convertDataFromLegacyPartDesc(IParticleDesc iParticleDesc, Particle particle) {
        FDSRenderProps fDSRenderProps;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        FDSRecordSpec fDSRecordSpec = FDS6Const.getRecordSpecs().get("PART");
        FDSRenderProps fDSRenderProps2 = fDSRenderProps = PyroSim.getApp() != null ? PyroSim.getApp().getFDSRenderProps() : new FDSRenderProps();
        if (iParticleDesc instanceof TracerPartDesc) {
            return hashMap;
        }
        GenericPartDesc genericPartDesc = (GenericPartDesc)iParticleDesc;
        if (genericPartDesc.d_thermalProps.d_initTemp != null) {
            this.addPropIfNotDefault(hashMap, fDSRenderProps, fDSRecordSpec, "INITIAL_TEMPERATURE", ConvertUtil.c(genericPartDesc.d_thermalProps.d_initTemp));
        }
        if (genericPartDesc instanceof FuelPartDesc) {
            FuelPartDesc fuelPartDesc = (FuelPartDesc)iParticleDesc;
            UnitDouble unitDouble = ConvertUtil.c(((FuelPyrolysis)fuelPartDesc.d_pyrolysis).d_heatOfCombustion);
            this.addPropIfNotDefault(hashMap, fDSRenderProps, fDSRecordSpec, "HEAT_OF_COMBUSTION", unitDouble);
        }
        return hashMap;
    }

    private void convertDataFromLegacySizeDist(pyrosim.legacy_2012_1.domain.particle.Particle particle, Particle particle2) {
        Serializable serializable;
        IParticleDesc iParticleDesc = particle.getDescription();
        SizeDistribution sizeDistribution = null;
        if (iParticleDesc instanceof FuelPartDesc) {
            serializable = (FuelPartDesc)iParticleDesc;
            sizeDistribution = serializable.d_sizeDist;
        } else if (iParticleDesc instanceof WaterPartDesc) {
            serializable = (WaterPartDesc)iParticleDesc;
            sizeDistribution = ((WaterPartDesc)serializable).d_sizeDist;
        } else if (iParticleDesc instanceof GenericPartDesc) {
            serializable = (GenericPartDesc)iParticleDesc;
            sizeDistribution = serializable.d_sizeDist;
        }
        if (sizeDistribution == null) {
            return;
        }
        particle2.setDiameter(ConvertUtil.c(sizeDistribution.d_medianDiameter));
        if (sizeDistribution.d_type instanceof SizeDistribution.Constant) {
            particle2.setDistribution(Particle.Distribution.CONST);
            return;
        }
        serializable = (SizeDistribution.RosinRammler)sizeDistribution.d_type;
        particle2.setMaxDiameter(ConvertUtil.c(((SizeDistribution.RosinRammler)serializable).d_maxDiameter));
        particle2.setMinDiameter(ConvertUtil.c(((SizeDistribution.RosinRammler)serializable).d_minDiameter));
        particle2.setGammaD(((SizeDistribution.RosinRammler)serializable).d_gammaD);
        particle2.setSigmaD(((SizeDistribution.RosinRammler)serializable).d_sigma);
        particle2.setDistribution(Particle.Distribution.ROSIN);
    }

    private pyrosim.domain.ExSpec createSpeciesFromLegacyPartDesc(pyrosim.legacy_2012_1.domain.particle.Particle particle, IParticleDesc iParticleDesc) {
        if (iParticleDesc instanceof FuelPartDesc) {
            FuelPartDesc fuelPartDesc = (FuelPartDesc)iParticleDesc;
            pyrosim.domain.ExSpec exSpec = new pyrosim.domain.ExSpec(particle.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(particle, exSpec, fuelPartDesc.d_thermalProps, fuelPartDesc.d_pyrolysis, fuelPartDesc.d_sizeDist);
            return exSpec;
        }
        if (iParticleDesc instanceof TracerPartDesc) {
            return null;
        }
        if (iParticleDesc instanceof WaterPartDesc) {
            WaterPartDesc waterPartDesc = (WaterPartDesc)iParticleDesc;
            pyrosim.domain.ExSpec exSpec = new pyrosim.domain.ExSpec(particle.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(particle, exSpec, waterPartDesc.d_thermalProps, waterPartDesc.d_pyrolysis, waterPartDesc.d_sizeDist);
            return exSpec;
        }
        if (iParticleDesc instanceof GenericPartDesc) {
            GenericPartDesc genericPartDesc = (GenericPartDesc)iParticleDesc;
            pyrosim.domain.ExSpec exSpec = new pyrosim.domain.ExSpec(particle.getName() + "_SPEC", 1);
            this.setSpeciesParamsFromLegacyParticle(particle, exSpec, genericPartDesc.d_thermalProps, genericPartDesc.d_pyrolysis, genericPartDesc.d_sizeDist);
            return exSpec;
        }
        throw new RuntimeException("Unknown particle description class: " + iParticleDesc.getClass().getName());
    }

    private void setSpeciesParamsFromLegacyParticle(pyrosim.legacy_2012_1.domain.particle.Particle particle, pyrosim.domain.ExSpec exSpec, ThermalProps thermalProps, Pyrolysis pyrolysis, SizeDistribution sizeDistribution) {
        ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
        primitiveParams.setMeltingTemp(ConvertUtil.c(pyrolysis.d_meltingTemp));
        if (pyrolysis.evaporates()) {
            primitiveParams.setVapTemp(ConvertUtil.c(pyrolysis.d_vapTemp));
            primitiveParams.setHoVaporization(ConvertUtil.c(pyrolysis.d_heatOfVap));
            if (pyrolysis.getVaporizationSpecies() != null) {
                this.d_warnings.addWarning(new Warning(Intl.intl("No FDS6 equivalent exists for Particle Vaporization Species."), String.format(Intl.intl("Vaporization Species dropped from Particle %s."), particle.getName())));
            }
        }
        primitiveParams.setDensityLiquid(ConvertUtil.c(thermalProps.d_density));
        primitiveParams.setSpecHeatLiquid(Variant.constant(ConvertUtil.c(thermalProps.d_specificHeat)));
        primitiveParams.setMeanDiameter(ConvertUtil.c(sizeDistribution.d_medianDiameter));
    }

    private IColoring createColoringFromLegacyPartDesc(IParticleDesc iParticleDesc) {
        if (iParticleDesc instanceof FuelPartDesc) {
            FuelPartDesc fuelPartDesc = (FuelPartDesc)iParticleDesc;
            if (fuelPartDesc.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
            }
            return this.fromLegacyIColor(fuelPartDesc.d_coloring);
        }
        if (iParticleDesc instanceof TracerPartDesc) {
            TracerPartDesc tracerPartDesc = (TracerPartDesc)iParticleDesc;
            return new pyrosim.domain.particle.ConstColoring(tracerPartDesc.d_color);
        }
        if (iParticleDesc instanceof WaterPartDesc) {
            WaterPartDesc waterPartDesc = (WaterPartDesc)iParticleDesc;
            if (waterPartDesc.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.BLUE);
            }
            return this.fromLegacyIColor(waterPartDesc.d_coloring);
        }
        if (iParticleDesc instanceof GenericPartDesc) {
            GenericPartDesc genericPartDesc = (GenericPartDesc)iParticleDesc;
            if (genericPartDesc.d_coloring == null) {
                return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
            }
            return this.fromLegacyIColor(genericPartDesc.d_coloring);
        }
        throw new RuntimeException("Unknown particle description class: " + iParticleDesc.getClass().getName());
    }

    private void addPropIfNotDefault(Map<String, String> map, FDSRenderProps fDSRenderProps, FDSRecordSpec fDSRecordSpec, String string, Object object) {
        if (!fDSRecordSpec.isDefault(string, object)) {
            Pair<String, String> pair = fDSRecordSpec.renderField(fDSRenderProps, string, object);
            map.put((String)pair.v1, (String)pair.v2);
        }
    }

    private pyrosim.domain.CustomFDSProps fromLegacyCustomFDS(CustomFDSProps customFDSProps) {
        return pyrosim.domain.CustomFDSProps.get(customFDSProps.getProps());
    }

    private IColoring fromLegacyIColor(pyrosim.legacy_2012_1.domain.particle.IColoring iColoring) {
        if (iColoring == null) {
            return new pyrosim.domain.particle.ConstColoring(Color.YELLOW);
        }
        if (iColoring instanceof ConstColoring) {
            return new pyrosim.domain.particle.ConstColoring(((ConstColoring)iColoring).d_color);
        }
        return new DropletColoring(((pyrosim.legacy_2012_1.domain.particle.DropletColoring)iColoring).d_properties);
    }

    private MaterialManager fromLegacyMatMgr(pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager materialManager, MaterialManager materialManager2) {
        for (IPyroObject iPyroObject : materialManager.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager)iPyroObject;
                namedPyroObject = new MaterialManager(namedPyroObject2.getName());
                materialManager2.add(this.fromLegacyMatMgr((pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager)namedPyroObject2, (MaterialManager)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.boundcond.mat.Material)iPyroObject;
            namedPyroObject = this.fromLegacyMatl((pyrosim.legacy_2012_1.domain.boundcond.mat.Material)namedPyroObject2);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                materialManager2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("material"));
        }
        return materialManager2;
    }

    private Material fromLegacyMatl(pyrosim.legacy_2012_1.domain.boundcond.mat.Material material) {
        Material material2 = new Material(material.getName(), this.fromLegacyPyrolysis(material.getPyrolysis()), this.fromLegacyMatlThermal(material.getThermalProps()));
        material2.setFYI(material.getFYI());
        this.makeAvailableForDelayLoad(material2, material);
        pyrosim.domain.CustomFDSProps customFDSProps = this.fromLegacyCustomFDS(material.getCustomFDSProps());
        if (material.getPyrolysis() instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis) {
            UnitDouble unitDouble = ConvertUtil.c(((pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis)material.getPyrolysis()).d_iniVaporFlux);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("INITIAL_VAPOR_FLUX", Double.toString(unitDouble.getValue(SIUS.unit(73))));
            customFDSProps = pyrosim.domain.CustomFDSProps.union(customFDSProps, pyrosim.domain.CustomFDSProps.get(hashMap));
            this.d_warnings.addWarning(new Warning("The variable Initial Vapor Flux is no longer supported.", String.format(Intl.intl("INITIAL_VAPOR_FLUX for material %s moved to Advanced Parameters."), material.getName())));
        }
        material2.setCustomFDSProps(customFDSProps);
        return material2;
    }

    private IPyrolysis fromLegacyPyrolysis(pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis iPyrolysis) {
        if (iPyrolysis instanceof pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis) {
            pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis liquidPyrolysis = (pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis)iPyrolysis;
            LiquidReaction liquidReaction = liquidPyrolysis.d_reaction;
            return new LiquidPyrolysis(ConvertUtil.c(liquidPyrolysis.d_heatOfCombust), new pyrosim.domain.boundcond.mat.LiquidReaction(new LiquidReaction.Rate(ConvertUtil.c(liquidReaction.d_rate.d_boilingTemp)), this.fromLegacyMatlReac(liquidReaction.d_byproducts)));
        }
        SolidPyrolysis solidPyrolysis = (SolidPyrolysis)iPyrolysis;
        ArrayList<SolidReaction> arrayList = new ArrayList<SolidReaction>();
        for (pyrosim.legacy_2012_1.domain.boundcond.mat.Reaction reaction : solidPyrolysis.getReactions()) {
            SolidReaction.Rate.ISpecification iSpecification;
            pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction solidReaction = (pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction)reaction;
            if (solidReaction.d_rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                iSpecification = (SolidReaction.Rate.AESpec)solidReaction.d_rate.d_spec;
                arrayList.add(new SolidReaction(new SolidReaction.Rate(solidReaction.d_rate.d_massFracExponent, solidReaction.d_rate.d_tempExponent, ConvertUtil.c(solidReaction.d_rate.d_thresholdTemp), new SolidReaction.Rate.AESpec(ConvertUtil.c(iSpecification.d_a), ConvertUtil.c(iSpecification.d_e))), this.fromLegacyMatlReac(solidReaction.d_byproducts)));
                continue;
            }
            iSpecification = (SolidReaction.Rate.RefSpec)solidReaction.d_rate.d_spec;
            arrayList.add(new SolidReaction(new SolidReaction.Rate(solidReaction.d_rate.d_massFracExponent, solidReaction.d_rate.d_tempExponent, ConvertUtil.c(solidReaction.d_rate.d_thresholdTemp), new SolidReaction.Rate.RefSpec(ConvertUtil.c(((SolidReaction.Rate.RefSpec)iSpecification).d_refTemp), ConvertUtil.c(((SolidReaction.Rate.RefSpec)iSpecification).d_pyrolysisRange), ConvertUtil.c(((SolidReaction.Rate.RefSpec)iSpecification).d_heatingRate))), this.fromLegacyMatlReac(solidReaction.d_byproducts)));
        }
        return new pyrosim.domain.boundcond.mat.SolidPyrolysis(ConvertUtil.c(solidPyrolysis.d_heatOfCombustion), arrayList);
    }

    private pyrosim.domain.boundcond.mat.ReacByproducts fromLegacyMatlReac(ReacByproducts reacByproducts) {
        if (reacByproducts == null) {
            return null;
        }
        pyrosim.domain.boundcond.mat.ReacByproducts reacByproducts2 = new pyrosim.domain.boundcond.mat.ReacByproducts();
        if (reacByproducts.d_nuWater > 0.0) {
            this.d_matResMap.put(new Pair<pyrosim.domain.boundcond.mat.ReacByproducts, ExSpec>(reacByproducts2, ExSpecList.getPredefinedSpecies("WATER VAPOR")), new Pair<String, Double>("WATER VAPOR", reacByproducts.d_nuWater));
        }
        if (reacByproducts.d_nuResidue > 0.0) {
            this.d_matResMap.put(new Pair<pyrosim.domain.boundcond.mat.ReacByproducts, pyrosim.legacy_2012_1.domain.boundcond.mat.Material>(reacByproducts2, reacByproducts.getResidue()), new Pair<String, Double>(reacByproducts.getResidue().getName(), reacByproducts.d_nuResidue));
        }
        if (reacByproducts.d_nuFuel > 0.0) {
            this.d_warnings.addWarning(new Warning(Intl.intl("MATL: NU_FUEL now requires a paired SPEC_ID. "), Intl.intl("Value removed")));
        }
        if (reacByproducts.d_heat != null) {
            reacByproducts2.d_heat = ConvertUtil.c(reacByproducts.d_heat);
        }
        return reacByproducts2;
    }

    private pyrosim.domain.boundcond.mat.ThermalProps fromLegacyMatlThermal(pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps thermalProps) {
        return new pyrosim.domain.boundcond.mat.ThermalProps(this.fromLegacyHBV(thermalProps.d_conductivity), ConvertUtil.c(thermalProps.d_density), this.fromLegacyHBV(thermalProps.d_specificHeat), thermalProps.d_emissivity, ConvertUtil.c(thermalProps.d_absorptionCoeff));
    }

    private IHeatBasedValue fromLegacyHBV(pyrosim.legacy_2012_1.domain.IHeatBasedValue iHeatBasedValue) {
        if (iHeatBasedValue instanceof IHeatBasedValue.Constant) {
            return new IHeatBasedValue.Constant(ConvertUtil.c(((IHeatBasedValue.Constant)iHeatBasedValue).value));
        }
        if (iHeatBasedValue instanceof IHeatBasedValue.Custom) {
            return new IHeatBasedValue.Custom(this.fromLegacyRamp(((IHeatBasedValue.Custom)iHeatBasedValue).value));
        }
        return null;
    }

    private pyrosim.domain.ramp.Ramp fromLegacyRamp(Ramp ramp) {
        pyrosim.domain.ramp.IRampInput iRampInput = this.fromLegacyRampInput(ramp.getDefaultInput());
        pyrosim.domain.ramp.IRampInput iRampInput2 = this.fromLegacyRampInput(ramp.getInput());
        ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>();
        for (Ramp.Entry entry : ramp.getRecords()) {
            arrayList.add(new Ramp.Entry(ConvertUtil.c(entry.t), ConvertUtil.c(entry.f)));
        }
        return new pyrosim.domain.ramp.Ramp(arrayList, iRampInput, iRampInput2, ramp.getFUnitType());
    }

    private pyrosim.domain.ramp.IRampInput fromLegacyRampInput(IRampInput iRampInput) {
        if (iRampInput instanceof RampInputs.HeatInput) {
            return RampInputs.HEAT;
        }
        if (iRampInput instanceof RampInputs.PressureInput) {
            return RampInputs.PRESSURE;
        }
        if (iRampInput instanceof RampInputs.TimeInput) {
            return RampInputs.TIME;
        }
        if (iRampInput instanceof RampInputs.XPositionInput) {
            return RampInputs.XPOS;
        }
        if (iRampInput instanceof pyrosim.legacy_2012_1.domain.ramp.SignalInput) {
            return this.fromLegacySignalInput((pyrosim.legacy_2012_1.domain.ramp.SignalInput)iRampInput);
        }
        return null;
    }

    private SignalInput fromLegacySignalInput(pyrosim.legacy_2012_1.domain.ramp.SignalInput signalInput) {
        SignalInput signalInput2 = new SignalInput(null);
        ISignalSource iSignalSource = signalInput.input.getAttachedSource();
        if (iSignalSource instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
            Iterator<? extends IOutPin> iterator = Clock.INSTANCE.getOutputPins().iterator();
            if (iterator.hasNext()) {
                IOutPin iOutPin = iterator.next();
                signalInput2 = new SignalInput((IDoubleOutPin)iOutPin);
            }
        } else {
            this.d_rampSignalInputs.put(signalInput2, iSignalSource);
        }
        return signalInput2;
    }

    private SurfaceManager fromLegacySurfMgr(pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager surfaceManager, SurfaceManager surfaceManager2, boolean bl, TextureDB textureDB, MaterialManager materialManager, MaterialDB materialDB) {
        Surface surface = (Surface)surfaceManager2.get(PredefSurf.PERIODIC.toString());
        if (surface != null) {
            surfaceManager2.remove(surface);
        }
        if (bl) {
            this.makeAvailableForDelayLoad(surfaceManager2.get(PredefSurf.INERT), surfaceManager.get(PredefSurf.INERT.name()));
            this.makeAvailableForDelayLoad(surfaceManager2.get(PredefSurf.OPEN), surfaceManager.get(PredefSurf.OPEN.name()));
            this.makeAvailableForDelayLoad(surfaceManager2.get(PredefSurf.MIRROR), surfaceManager.get(PredefSurf.MIRROR.name()));
            this.makeAvailableForDelayLoad(surfaceManager2.get(PredefSurf.HVAC), surfaceManager.get(PredefSurf.HVAC.name()));
            if (surfaceManager2.get("ADIABATIC") != null && surfaceManager.get("ADIABATIC") != null) {
                this.makeAvailableForDelayLoad(surfaceManager2.get("ADIABATIC"), surfaceManager.get("ADIABATIC"));
            }
        }
        for (IPyroObject iPyroObject : surfaceManager.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager)iPyroObject;
                namedPyroObject = new SurfaceManager(namedPyroObject2.getName());
                surfaceManager2.add(this.fromLegacySurfMgr((pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager)namedPyroObject2, (SurfaceManager)namedPyroObject, false, textureDB, materialManager, materialDB));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)iPyroObject;
            if (namedPyroObject2.getName().equals("ADIABATIC")) {
                namedPyroObject = (Surface)surfaceManager2.get(Intl.intl("ADIABATIC"));
                if (namedPyroObject == null) {
                    namedPyroObject = (Surface)surfaceManager2.get("ADIABATIC");
                }
                ((Surface)namedPyroObject).setAppearance(this.toMaterial(materialDB, textureDB, (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2));
                ((Surface)namedPyroObject).setSurfDesc(this.fromLegacySurfDesc(((pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2).getSurfDesc(), (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2, materialManager));
                namedPyroObject.setCustomFDSProps(this.fromLegacyCustomFDS(((pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2).getCustomFDSProps()));
                continue;
            }
            if (((pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2).isPredefined()) continue;
            namedPyroObject = this.fromLegacySurface(materialDB, textureDB, (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface)namedPyroObject2, materialManager);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                surfaceManager2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("surface"));
        }
        return surfaceManager2;
    }

    private Surface fromLegacySurface(MaterialDB materialDB, TextureDB textureDB, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface, MaterialManager materialManager) {
        Surface surface2 = new Surface(surface.getName(), surface.getColor(), this.toMaterial(materialDB, textureDB, surface), this.fromLegacySurfDesc(surface.getSurfDesc(), surface, materialManager));
        surface2.setFYI(surface.getFYI());
        surface2.setCustomFDSProps(this.fromLegacyCustomFDS(surface.getCustomFDSProps()));
        this.makeAvailableForDelayLoad(surface2, surface);
        return surface2;
    }

    private pyrosim.domain.appearance.Material toMaterial(MaterialDB materialDB, TextureDB textureDB, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface) {
        Color color = surface.getColor().getAlpha() == 255 ? Color.WHITE : new Color(255, 255, 255, surface.getColor().getAlpha());
        TextureInfo textureInfo = surface.getTextureInfo();
        if (textureInfo == null) {
            return null;
        }
        pyrosim.legacy_2012_1.domain.texture.Texture texture = textureDB.getTexture(textureInfo.getTexID());
        if (texture == null) {
            Object object2;
            for (Object object2 : materialDB.flatten()) {
                Texture texture2;
                if (!((pyrosim.domain.NamedPyroObject)object2).getName().equals(textureInfo.getTexID()) || (texture2 = ((pyrosim.domain.appearance.Material)object2).getAttributes().getTexture(MatChannel.DIFFUSE)) == null) continue;
                return this.toMaterial(color, texture2.image, textureInfo);
            }
            String string = String.format(Intl.intl("Could not find texture for SURF, %1$s: %2$s"), surface.getName(), textureInfo.getTexID());
            object2 = Intl.intl("Removed texture from SURF.");
            this.d_warnings.addWarning(new Warning(string, (String)object2));
            return null;
        }
        return this.toMaterial(color, texture, textureInfo);
    }

    private ISurfDesc fromLegacySurfDesc(pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc iSurfDesc, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface, MaterialManager materialManager) {
        if (iSurfDesc instanceof BlowerSurfDesc) {
            BlowerSurfDesc blowerSurfDesc = (BlowerSurfDesc)iSurfDesc;
            return new pyrosim.domain.boundcond.surf.BlowerSurfDesc(this.fromLegacyTempReg(blowerSurfDesc.d_tempReg), this.fromLegacySurfAirflow(blowerSurfDesc.d_airFlow, surface), this.fromLegacySurfPartInj(blowerSurfDesc.d_partInj), IGeometry.DEFAULT);
        }
        if (iSurfDesc instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc) {
            pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc burnerSurfDesc = (pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc)iSurfDesc;
            BurnerSurfDesc burnerSurfDesc2 = new BurnerSurfDesc(this.fromLegacySurfHeatRelease(burnerSurfDesc.d_heatRelease), this.fromLegacySurfPartInj(burnerSurfDesc.d_partInj), this.fromLegacyTempReg(burnerSurfDesc.d_temperature), IGeometry.DEFAULT);
            return burnerSurfDesc2;
        }
        if (iSurfDesc instanceof pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc) {
            pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc constantTempSurfDesc = (pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc)iSurfDesc;
            return new ConstantTempSurfDesc(this.fromLegacyTempReg(constantTempSurfDesc.d_tempReg), this.fromLegacySurfPartInj(constantTempSurfDesc.d_partInj), IGeometry.DEFAULT);
        }
        if (iSurfDesc instanceof FanSurfDesc) {
            FanSurfDesc fanSurfDesc = (FanSurfDesc)iSurfDesc;
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports surfaces of type Fan."), String.format(Intl.intl("Surface %s converted to type Exhaust."), surface.getName())));
            return new pyrosim.domain.boundcond.surf.InFlowSurfDesc(this.fromLegacySurfAirflow(fanSurfDesc.d_airFlow, surface), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (iSurfDesc instanceof InFlowSurfDesc) {
            InFlowSurfDesc inFlowSurfDesc = (InFlowSurfDesc)iSurfDesc;
            return new pyrosim.domain.boundcond.surf.InFlowSurfDesc(this.fromLegacySurfAirflow(inFlowSurfDesc.d_airFlow, surface), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (iSurfDesc instanceof LayeredSurfDesc) {
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)iSurfDesc;
            if (layeredSurfDesc.d_surfDensity != null) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Surface Density for Layered Surfaces."), String.format(Intl.intl("Surface Density dropped from Surface %s."), surface.getName())));
            }
            IGeometry iGeometry = null;
            if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.FLAT)) {
                iGeometry = new IGeometry.Cartesian(new UnitDouble(0.0, SI.METER), new UnitDouble(0.0, SI.METER), null);
            } else if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.SPHERICAL)) {
                iGeometry = new IGeometry.Spherical(new UnitDouble(0.0, SI.METER), null);
            } else if (layeredSurfDesc.d_geom.equals((Object)LayeredSurfDesc.Geometry.CYLINDRICAL)) {
                iGeometry = new IGeometry.Cylindrical(new UnitDouble(0.0, SI.METER), null, Variant.constant(new UnitDouble(0.0, SI.METER)));
            }
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unknown geometry data for legacy surface, %s."), surface.getName()), String.format(Intl.intl("Generic geometry dimensions added to surface, %s."), surface.getName())));
            return new pyrosim.domain.boundcond.surf.LayeredSurfDesc(iGeometry, this.fromLegacySurfSlip(layeredSurfDesc.d_slip), this.fromLegacySurfReac(layeredSurfDesc.d_iReac), this.fromLegacySurfComp(layeredSurfDesc.d_surfComp, materialManager), this.fromLegacySurfSpecInjList(layeredSurfDesc.d_specInj), this.fromLegacySurfPartInj(layeredSurfDesc.d_partInj), layeredSurfDesc.d_burnAway, this.fromLegacySurfZonePath(layeredSurfDesc.d_leakPath), pyrosim.domain.boundcond.surf.TempRegulation.newDefault());
        }
        if (iSurfDesc instanceof LeakSurfDesc) {
            LeakSurfDesc leakSurfDesc = (LeakSurfDesc)iSurfDesc;
            if (leakSurfDesc.d_porous) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports the Surface parameter, Porous"), String.format(Intl.intl("Porous dropped from Surface %s."), surface.getName())));
            }
            return new pyrosim.domain.boundcond.surf.LeakSurfDesc(this.fromLegacySurfZonePath(leakSurfDesc.d_leak));
        }
        if (iSurfDesc instanceof SurfDescStatic.Adiabatic) {
            return new SurfDescStatic.Adiabatic(this.fromLegacySurfSlip(((SurfDescStatic.Adiabatic)iSurfDesc).slip));
        }
        if (iSurfDesc instanceof SurfDescStatic.Hvac) {
            return new SurfDescStatic.Hvac();
        }
        if (iSurfDesc instanceof SurfDescStatic.Inert) {
            return new SurfDescStatic.Inert();
        }
        if (iSurfDesc instanceof SurfDescStatic.Mirror) {
            return new SurfDescStatic.Mirror();
        }
        if (iSurfDesc instanceof SurfDescStatic.Open) {
            return new SurfDescStatic.Open();
        }
        return null;
    }

    private Fuel.IReaction fromLegacySurfReac(Fuel.IReaction iReaction) {
        if (iReaction instanceof Fuel.MaterialReac) {
            return new Fuel.MaterialReac();
        }
        if (iReaction instanceof Fuel.ManualReac) {
            Fuel.ManualReac manualReac = (Fuel.ManualReac)iReaction;
            return new Fuel.ManualReac(this.fromLegacySurfHeatRelease(manualReac.d_heatRelease), ConvertUtil.c(manualReac.d_heatOfVap), this.fromLegacySurfIgnition(manualReac.d_ignition));
        }
        return null;
    }

    private Fuel.ManualReac.IIgnition fromLegacySurfIgnition(Fuel.ManualReac.IIgnition iIgnition) {
        if (iIgnition instanceof Fuel.ManualReac.ImmediateIgnite) {
            return new Fuel.ManualReac.ImmediateIgnite();
        }
        if (iIgnition instanceof Fuel.ManualReac.TemperatureIgnite) {
            return new Fuel.ManualReac.TemperatureIgnite(ConvertUtil.c(((Fuel.ManualReac.TemperatureIgnite)iIgnition).d_temperature));
        }
        return null;
    }

    private pyrosim.domain.boundcond.surf.TempRegulation fromLegacyTempReg(TempRegulation tempRegulation) {
        if (tempRegulation.isNetHeatFluxTR()) {
            return pyrosim.domain.boundcond.surf.TempRegulation.newNetHeatFluxTR(ConvertUtil.c(tempRegulation.d_netHeatFlux), 0.9, null, false);
        }
        return pyrosim.domain.boundcond.surf.TempRegulation.newFixedHeatFluxTR(ConvertUtil.c(tempRegulation.d_temperature), ConvertUtil.c(tempRegulation.d_heatFlux), this.fromLegacyTimeFunc(tempRegulation.d_rampup), tempRegulation.d_emissivity, null, false);
    }

    private pyrosim.domain.TimeFunction fromLegacyTimeFunc(TimeFunction timeFunction) {
        if (timeFunction instanceof TimeFunction.TanH) {
            return new TimeFunction.TanH(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)((TimeFunction.TanH)timeFunction).val));
        }
        if (timeFunction instanceof TimeFunction.TSquared) {
            return new TimeFunction.TSquared(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)((TimeFunction.TSquared)timeFunction).val));
        }
        if (timeFunction instanceof TimeFunction.Custom) {
            return new TimeFunction.Custom(this.fromLegacyRamp((Ramp)((TimeFunction.Custom)timeFunction).val));
        }
        return null;
    }

    private AirFlow fromLegacySurfAirflow(pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow airFlow, pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface) {
        if (airFlow.d_duct != null) {
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Surface Air Ducts."), String.format(Intl.intl("Air Duct dropped from Surface %s."), surface.getName())));
        }
        return new AirFlow(this.fromLegacySurfAirflowRate(airFlow.d_rate), this.fromLegacySurfAirflowProf(airFlow.d_profile));
    }

    private pyrosim.domain.boundcond.surf.ZonePath fromLegacySurfZonePath(ZonePath zonePath) {
        return zonePath == null ? null : new pyrosim.domain.boundcond.surf.ZonePath(this.fromLegacyZone(zonePath.getZones()[0]), this.fromLegacyZone(zonePath.getZones()[1]));
    }

    private AirFlow.Rate fromLegacySurfAirflowRate(AirFlow.Rate rate) {
        AirFlow.ValRate valRate;
        AirFlow.Rate rate2 = null;
        if (rate instanceof AirFlow.NormalVel) {
            valRate = (AirFlow.NormalVel)rate;
            rate2 = new AirFlow.NormalVel(ConvertUtil.c(valRate.val), ConvertUtil.c(valRate.tanVelU), ConvertUtil.c(valRate.tanVelV), this.fromLegacyTimeFunc(valRate.func), this.fromLegacySurfSpecInjList(valRate.specInj));
        }
        if (rate instanceof AirFlow.VolumeFlux) {
            valRate = (AirFlow.VolumeFlux)rate;
            rate2 = new AirFlow.VolumeFlux(ConvertUtil.c(((AirFlow.VolumeFlux)valRate).val), ConvertUtil.c(((AirFlow.VolumeFlux)valRate).tanVelU), ConvertUtil.c(((AirFlow.VolumeFlux)valRate).tanVelV), this.fromLegacyTimeFunc(((AirFlow.VolumeFlux)valRate).func), this.fromLegacySurfSpecInjList(((AirFlow.VolumeFlux)valRate).specInj));
        }
        if (rate instanceof AirFlow.TotalMassFlux) {
            valRate = (AirFlow.TotalMassFlux)rate;
            rate2 = new AirFlow.TotalMassFlux(ConvertUtil.c(((AirFlow.TotalMassFlux)valRate).val), ConvertUtil.c(((AirFlow.TotalMassFlux)valRate).tanVelU), ConvertUtil.c(((AirFlow.TotalMassFlux)valRate).tanVelV), this.fromLegacyTimeFunc(((AirFlow.TotalMassFlux)valRate).func), this.fromLegacySurfSpecInjList(((AirFlow.TotalMassFlux)valRate).specInj));
        }
        if (rate instanceof AirFlow.ExSpecMassFlux) {
            rate2 = new AirFlow.ExSpecMassFlux(ConvertUtil.c(rate.tanVelU), ConvertUtil.c(rate.tanVelV), this.fromLegacyTimeFunc(rate.func), this.fromLegacySurfSpecInjList(rate.specInj));
        }
        return rate2;
    }

    private SpecInjList fromLegacySurfSpecInjList(pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList specInjList) {
        if (specInjList == null) {
            return null;
        }
        ArrayList<pyrosim.domain.boundcond.surf.SpeciesInjection> arrayList = new ArrayList<pyrosim.domain.boundcond.surf.SpeciesInjection>();
        for (SpeciesInjection speciesInjection : specInjList.getInjections()) {
            arrayList.add(this.fromLegacySurfSpecInj(speciesInjection));
        }
        return new SpecInjList(specInjList.injType, arrayList);
    }

    private pyrosim.domain.boundcond.surf.SpeciesInjection fromLegacySurfSpecInj(SpeciesInjection speciesInjection) {
        Comparable comparable;
        if (speciesInjection.val instanceof pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble) {
            comparable = ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)speciesInjection.val);
        } else {
            assert (speciesInjection.val instanceof Double);
            comparable = (Double)speciesInjection.val;
        }
        pyrosim.domain.boundcond.surf.SpeciesInjection speciesInjection2 = new pyrosim.domain.boundcond.surf.SpeciesInjection(null, comparable, this.fromLegacyTimeFunc(speciesInjection.func));
        try {
            this.registerForDelayLoad(speciesInjection2, pyrosim.domain.boundcond.surf.SpeciesInjection.class.getDeclaredField("species"), speciesInjection.species);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return speciesInjection2;
    }

    private AirFlow.IProfile fromLegacySurfAirflowProf(AirFlow.IProfile iProfile) {
        if (iProfile instanceof AirFlow.AtmosphericProf) {
            return new AirFlow.AtmosphericProf(((AirFlow.AtmosphericProf)iProfile).d_exponent, ConvertUtil.c(((AirFlow.AtmosphericProf)iProfile).d_origin));
        }
        if (iProfile instanceof AirFlow.ParabolicProf) {
            return new AirFlow.ParabolicProf();
        }
        if (iProfile instanceof AirFlow.TopHatProf) {
            return new AirFlow.TopHatProf();
        }
        return null;
    }

    private ParticleInjection fromLegacySurfPartInj(pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection particleInjection) {
        if (particleInjection == null) {
            return null;
        }
        ParticleInjection particleInjection2 = new ParticleInjection(null, particleInjection.d_numPartsPerCell, this.fromLegacyTBV(particleInjection.getMassFlux()), ConvertUtil.c(particleInjection.d_dtInsert));
        try {
            this.registerForDelayLoad(particleInjection2, ParticleInjection.class.getDeclaredField("d_particle"), particleInjection.getParticle());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return particleInjection2;
    }

    private HeatRelease fromLegacySurfHeatRelease(pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease heatRelease) {
        HeatRelease.Type type = heatRelease.d_type;
        UnitDouble unitDouble = ConvertUtil.c(heatRelease.d_extingCoeff);
        if (unitDouble.getUnit() == SI.SECOND.pow(-1)) {
            unitDouble = new UnitDouble(unitDouble.getValue(SI.SECOND.pow(-1)), SI.METER.multiply(SI.METER.multiply(SI.SECOND)).divide(SI.KILOGRAM));
        }
        if (type instanceof HeatRelease.HRRType) {
            return new HeatRelease(new HeatRelease.HRRType(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)type.val), this.fromLegacyTimeFunc(type.func)), unitDouble);
        }
        if (type instanceof HeatRelease.MLRType) {
            return new HeatRelease(new HeatRelease.MLRType(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)type.val), this.fromLegacyTimeFunc(type.func)), unitDouble);
        }
        return null;
    }

    private pyrosim.domain.boundcond.surf.ISlip fromLegacySurfSlip(ISlip iSlip) {
        if (iSlip instanceof ISlip.FreeSlip) {
            return pyrosim.domain.boundcond.surf.ISlip.FREE_SLIP;
        }
        if (iSlip instanceof ISlip.NoSlip) {
            return pyrosim.domain.boundcond.surf.ISlip.NO_SLIP;
        }
        if (iSlip instanceof ISlip.RoughSlip) {
            return new ISlip.RoughSlip(ConvertUtil.c(((ISlip.RoughSlip)iSlip).roughness));
        }
        return new ISlip.RoughSlip(new UnitDouble(0.0, SI.METER));
    }

    private SurfComposition fromLegacySurfComp(pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition surfComposition, MaterialManager materialManager) {
        ArrayList<SurfComposition.SurfLayer> arrayList = new ArrayList<SurfComposition.SurfLayer>();
        for (SurfComposition.SurfLayer surfLayer : surfComposition.d_layers) {
            arrayList.add(this.fromLegacySurfLayer(surfLayer, materialManager));
        }
        return new SurfComposition(ConvertUtil.c(surfComposition.d_initInnerTemp), this.fromLegacyTimeFunc(surfComposition.d_tempRamp), this.fromLegacySurfBacking(surfComposition.d_backing), surfComposition.d_layerDivide, arrayList);
    }

    private Backing fromLegacySurfBacking(pyrosim.legacy_2012_1.domain.boundcond.surf.Backing backing) {
        if (backing instanceof Backing.Exposed) {
            return Backing.EXPOSED;
        }
        if (backing instanceof Backing.Insulated) {
            return Backing.INSULATED;
        }
        if (backing instanceof Backing.AirGap) {
            return new Backing.AirGap(ConvertUtil.c(((Backing.AirGap)backing).d_airTemp));
        }
        return null;
    }

    private SurfComposition.SurfLayer fromLegacySurfLayer(SurfComposition.SurfLayer surfLayer, MaterialManager materialManager) {
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        for (SurfComposition.SurfLayer.SurfComponent surfComponent : surfLayer.getComponents()) {
            DelayedRef delayedRef = this.d_delayLoadMap.get(surfComponent.d_material);
            if (delayedRef == null) {
                Material material2;
                NameGenerator nameGenerator = new NameGenerator(Intl.intl("Materials"));
                for (Material material2 : materialManager.flatten()) {
                    nameGenerator.registerName(material2.getName());
                }
                String string = nameGenerator.generateValidName(surfComponent.d_material.getName());
                material2 = this.fromLegacyMatl(surfComponent.d_material);
                material2.setName(string);
                materialManager.add(material2);
                arrayList.add(new SurfComposition.SurfLayer.SurfComponent(surfComponent.d_massFraction, material2));
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("The material %s could not be found."), surfComponent.d_material.getName()), String.format(Intl.intl("Generated a new material called %s."), string)));
                continue;
            }
            arrayList.add(new SurfComposition.SurfLayer.SurfComponent(surfComponent.d_massFraction, (Material)this.d_delayLoadMap.get(surfComponent.d_material).get()));
        }
        return new SurfComposition.SurfLayer(ConvertUtil.c(surfLayer.d_thickness), arrayList);
    }

    private TimeBasedValue<UnitDouble> fromLegacyTBV(pyrosim.legacy_2012_1.domain.TimeBasedValue<pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble> timeBasedValue) {
        return timeBasedValue == null ? null : new TimeBasedValue<UnitDouble>(ConvertUtil.c((pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble)timeBasedValue.val), this.fromLegacyTimeFunc(timeBasedValue.func));
    }

    /*
     * WARNING - void declaration
     */
    private ReactionList fromLegacyReacList(pyrosim.legacy_2012_1.domain.reaction.ReactionList reactionList, ReactionList reactionList2, pyrosim.domain.SimParams simParams, pyrosim.domain.ExSpecList exSpecList) {
        for (IPyroObject cloneable : reactionList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (cloneable instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.reaction.ReactionList)cloneable;
                namedPyroObject = new ReactionList(namedPyroObject2.getName());
                reactionList2.add(this.fromLegacyReacList((pyrosim.legacy_2012_1.domain.reaction.ReactionList)namedPyroObject2, (ReactionList)namedPyroObject, simParams, exSpecList));
                continue;
            }
            namedPyroObject2 = (Reaction)cloneable;
            namedPyroObject = this.fromLegacyReaction((Reaction)namedPyroObject2, simParams, exSpecList);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                boolean bl = ((pyrosim.domain.reaction.Reaction)namedPyroObject).isActive();
                reactionList2.add(namedPyroObject);
                ((pyrosim.domain.reaction.Reaction)namedPyroObject).setActive(bl);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("reaction"));
        }
        if (reactionList2.isEmpty()) {
            void var6_9;
            pyrosim.domain.reaction.Reaction reaction = new pyrosim.domain.reaction.Reaction(PredefReac.PROPANE.name() + "_REAC", true, Reaction.ReacType.SIMPLE);
            reaction.setFYI(Intl.intl("SFPE Handbook"));
            pyrosim.domain.ExSpec exSpec = exSpecList.get("PROPANE");
            if (exSpec == null) {
                pyrosim.domain.ExSpec exSpec2 = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies("PROPANE"));
                exSpec2.setType(1);
                exSpecList.add(exSpec2);
            }
            reaction.setFuel((pyrosim.domain.ExSpec)var6_9);
            reaction.setSootYield(0.024);
            reaction.setCOYield(0.005);
            reactionList2.add(reaction);
            reaction.setActive(true);
        }
        return reactionList2;
    }

    private pyrosim.domain.reaction.Reaction fromLegacyReaction(Reaction reaction, pyrosim.domain.SimParams simParams, pyrosim.domain.ExSpecList exSpecList) {
        Serializable serializable2;
        pyrosim.domain.reaction.Reaction reaction2 = new pyrosim.domain.reaction.Reaction(reaction.getName(), Reaction.ReacType.SIMPLE);
        reaction2.setFYI(reaction.getFYI());
        reaction2.setActive(reaction.isActive());
        NameGenerator nameGenerator = new NameGenerator(Intl.intl("Species"));
        for (Serializable serializable2 : exSpecList.flatten()) {
            nameGenerator.registerName(serializable2.getName());
        }
        reaction2.setFuel(pyrosim.domain.ExSpecList.getDefaultFuel(exSpecList, nameGenerator, true));
        Soot soot = reaction.getByproducts().d_soot;
        if (reaction2.isActive()) {
            simParams.getEnvironment().setAmbMFO2(SIUS.newud(reaction.getFuel().d_ambMassFracO2, 18));
            if (soot == null) {
                simParams.getEnvironment().setMaxVisibility(new UnitDouble(30.0, SI.METER));
                simParams.getEnvironment().setVisibilityFactor(3.0);
            } else {
                simParams.getEnvironment().setMaxVisibility(ConvertUtil.c(soot.d_maxVisibility));
                simParams.getEnvironment().setVisibilityFactor(soot.d_visFactor);
            }
        }
        reaction2.setFuelComp(reaction.getFuel().d_hydrogen, reaction.getFuel().d_carbon, reaction.getFuel().d_oxygen, reaction.getFuel().d_nitrogen);
        if (reaction.getSuppression() != null) {
            reaction2.setCritFlameTemp(ConvertUtil.c(reaction.getSuppression().d_criticalFlameTemp));
            reaction2.setSuppression(reaction.getSuppression().d_limitingOxygenIndex > 0.0);
        }
        reaction2.setHrrpuaSheet(ConvertUtil.c(reaction.getHRR().hrrpuaUpperLimit));
        reaction2.setHrrpuvAvg(ConvertUtil.c(reaction.getHRR().hrrpuvUpperLimit));
        serializable2 = reaction.getByproducts().d_energy;
        reaction2.setIdeal(reaction.getByproducts().d_energy.d_ideal);
        if (serializable2 instanceof Byproducts.FuelEnergy) {
            reaction2.setHeatOfCombustion(ConvertUtil.c(((Byproducts.FuelEnergy)serializable2).d_heatOfCombustion));
            reaction2.setEnergyType(Reaction.EnergyRelease.HEAT_OF_COMBUSTION);
        } else {
            reaction2.setEpumo2(ConvertUtil.c(((Byproducts.OxygenEnergy)serializable2).d_epumo2));
            reaction2.setEnergyType(Reaction.EnergyRelease.EPUMO2);
        }
        reaction2.setYields(reaction.getByproducts().d_coYield, reaction.getByproducts().d_sootYield);
        if (soot == null) {
            reaction2.setSootHFraction(0.1);
        } else {
            reaction2.setSootHFraction(soot.d_hydrogenFrac);
        }
        reaction2.setCustomFDSProps(this.fromLegacyCustomFDS(reaction.getCustomFDSProps()));
        return reaction2;
    }

    private void addMixFracDelayLoad(int n, pyrosim.domain.ExSpec exSpec) {
        ExSpec exSpec2 = ExSpecList.MIXFRAC_EXSPECS[n];
        this.d_mixFracMap.put(exSpec2, exSpec);
        this.makeAvailableForDelayLoad(exSpec, exSpec2);
    }

    private void addMixFracDelayLoad(int n, String string) {
        pyrosim.domain.ExSpec exSpec = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(string));
        this.addMixFracDelayLoad(n, exSpec);
    }

    private pyrosim.domain.ExSpecList fromLegacySpecList(ExSpecList exSpecList, pyrosim.domain.ExSpecList exSpecList2, Serialized serialized, boolean bl) {
        if (bl) {
            PyroMod pyroMod = new PyroMod(serialized, false, false);
            NameGenerator cloneable = pyroMod.getNames(pyrosim.domain.ExSpec.class);
            this.addMixFracDelayLoad(0, pyrosim.domain.ExSpecList.getDefaultFuel(exSpecList2, cloneable, true));
            this.addMixFracDelayLoad(1, "OXYGEN");
            this.addMixFracDelayLoad(2, "NITROGEN");
            this.addMixFracDelayLoad(3, "WATER VAPOR");
            this.addMixFracDelayLoad(4, "CARBON DIOXIDE");
            this.addMixFracDelayLoad(5, "CARBON MONOXIDE");
            this.addMixFracDelayLoad(6, "HYDROGEN");
            this.addMixFracDelayLoad(7, "SOOT");
            for (ExSpec exSpec : ExSpecList.PREDEFINED.values()) {
                pyrosim.domain.ExSpec exSpec2 = pyrosim.domain.ExSpecList.getPredefinedSpecies(exSpec.getName());
                exSpec2.setType(0);
                this.makeAvailableForDelayLoad(exSpec2, exSpec);
            }
        }
        for (IPyroObject iPyroObject : exSpecList.getMembers()) {
            Object object;
            if (iPyroObject instanceof Composite) {
                object = (ExSpecList)iPyroObject;
                pyrosim.domain.ExSpecList exSpecList3 = new pyrosim.domain.ExSpecList(((NamedPyroObject)object).getName());
                exSpecList2.add(this.fromLegacySpecList((ExSpecList)object, exSpecList3, serialized, false));
                continue;
            }
            object = (ExSpec)iPyroObject;
            pyrosim.domain.ExSpec exSpec = this.fromLegacySpecies((ExSpec)object);
            assert (exSpec != null);
            if (exSpec != null) {
                exSpecList2.add(exSpec);
                continue;
            }
            this.addUnableToLoadWarn(((ExSpec)object).getName(), "species");
        }
        return exSpecList2;
    }

    private pyrosim.domain.ExSpec fromLegacySpecies(ExSpec exSpec) {
        if (exSpec == null) {
            return null;
        }
        pyrosim.domain.ExSpec exSpec2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (ExSpecList.isPredefinedSpecies(exSpec.getName())) {
            exSpec2 = new pyrosim.domain.ExSpec(pyrosim.domain.ExSpecList.getPredefinedSpecies(exSpec.getName()));
            exSpec2.setType(0);
        } else {
            exSpec2 = new pyrosim.domain.ExSpec(exSpec.getName(), 1);
            exSpec2.setMolecularWeight(ConvertUtil.c(exSpec.getMolWt()));
            if (exSpec.getDNSType() == 1) {
                exSpec2.getPrimParams().setSigmaLJ(exSpec.getSigma().getValueNoUnit(), true);
                exSpec2.getPrimParams().setEpsilonKLJ(exSpec.getEpsilonK().getValueNoUnit(), true);
            } else if (exSpec.getDNSType() == 2) {
                exSpec2.getPrimParams().setDiffusivity(Variant.constant(ConvertUtil.c(exSpec.getDiffusivity())));
                exSpec2.getPrimParams().setViscosity(Variant.constant(ConvertUtil.c(exSpec.getViscosity())));
                this.d_warnings.addWarning(new Warning(Intl.intl("Meaning of FDS5 parameter CONDUCTIVITY has changed."), String.format(Intl.intl("Conductivity dropped from species %s"), exSpec2.getName())));
            }
        }
        exSpec2.setFYI(exSpec.getFYI());
        exSpec2.setMassFrac0(exSpec.getMassFrac0());
        if (exSpec.getAbsorb() && !pyrosim.domain.ExSpecList.isPredefinedSpecies(exSpec.getName())) {
            this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 parameter ABSORBING removed."), String.format(Intl.intl("Default RADCAL_ID, METHANE, added to species %s"), exSpec2.getName())));
            exSpec2.getPrimParams().setRadCalSurrogate("METHANE");
        }
        FDSRecordSpec fDSRecordSpec = FDS6Const.getRecordSpecs().get("SPEC");
        if (exSpec.getMassExtinctionCoeff() != null && !fDSRecordSpec.isDefault("MASS_EXTINCTION_COEFFICIENT", exSpec.getMassExtinctionCoeff())) {
            hashMap.put("MASS_EXTINCTION_COEFFICIENT", Double.toString(exSpec.getMassExtinctionCoeff().getValueNoUnit()));
            this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Mass Extinction Coefficient."), String.format(Intl.intl("%s moved to %s Advanced Parameters."), "MASS_EXTINCTION_COEFFICIENT", exSpec2.getName())));
        }
        exSpec2.setCustomFDSProps(pyrosim.domain.CustomFDSProps.get(hashMap));
        this.makeAvailableForDelayLoad(exSpec2, exSpec);
        return exSpec2;
    }

    private HvacList fromLegacyHvacList(pyrosim.legacy_2012_1.domain.hvac.HvacList hvacList, HvacList hvacList2) {
        if (!hvacList.flatten().isEmpty()) {
            String string = Intl.intl("HVAC objects from PyroSim 2012 are not supported.");
            String string2 = Intl.intl("Skipping all PyroSim 2012 HVAC objects.");
            this.d_warnings.addWarning(new Warning(string, string2));
        }
        return hvacList2;
    }

    private pyrosim.domain.evac.PersList fromLegacy(PersList persList, pyrosim.domain.evac.PersList persList2) {
        for (IPyroObject iPyroObject : persList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (PersList)iPyroObject;
                namedPyroObject = new pyrosim.domain.evac.PersList(namedPyroObject2.getName());
                persList2.add(this.fromLegacy((PersList)namedPyroObject2, (pyrosim.domain.evac.PersList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.Pers)iPyroObject;
            namedPyroObject = new Pers(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            persList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return persList2;
    }

    private ExitList fromLegacy(pyrosim.legacy_2012_1.domain.evac.ExitList exitList, ExitList exitList2) {
        for (IPyroObject iPyroObject : exitList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.ExitList)iPyroObject;
                namedPyroObject = new ExitList(namedPyroObject2.getName());
                exitList2.add(this.fromLegacy((pyrosim.legacy_2012_1.domain.evac.ExitList)namedPyroObject2, (ExitList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (Exit)iPyroObject;
            namedPyroObject = new pyrosim.domain.evac.Exit(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            exitList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return exitList2;
    }

    private pyrosim.domain.evac.EvacList fromLegacy(EvacList evacList, pyrosim.domain.evac.EvacList evacList2) {
        for (IPyroObject iPyroObject : evacList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (EvacList)iPyroObject;
                namedPyroObject = new pyrosim.domain.evac.EvacList(namedPyroObject2.getName());
                evacList2.add(this.fromLegacy((EvacList)namedPyroObject2, (pyrosim.domain.evac.EvacList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (Evac)iPyroObject;
            namedPyroObject = new pyrosim.domain.evac.Evac(namedPyroObject2.getName(), null);
            assert (namedPyroObject != null);
            evacList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return evacList2;
    }

    private pyrosim.domain.evac.EntrList fromLegacy(EntrList entrList, pyrosim.domain.evac.EntrList entrList2) {
        for (IPyroObject iPyroObject : entrList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (EntrList)iPyroObject;
                namedPyroObject = new pyrosim.domain.evac.EntrList(namedPyroObject2.getName());
                entrList2.add(this.fromLegacy((EntrList)namedPyroObject2, (pyrosim.domain.evac.EntrList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (Entr)iPyroObject;
            namedPyroObject = new pyrosim.domain.evac.Entr(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            entrList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return entrList2;
    }

    private EvhoList fromLegacy(pyrosim.legacy_2012_1.domain.evac.EvhoList evhoList, EvhoList evhoList2) {
        for (IPyroObject iPyroObject : evhoList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.EvhoList)iPyroObject;
                namedPyroObject = new EvhoList(namedPyroObject2.getName());
                evhoList2.add(this.fromLegacy((pyrosim.legacy_2012_1.domain.evac.EvhoList)namedPyroObject2, (EvhoList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (Evho)iPyroObject;
            namedPyroObject = new pyrosim.domain.evac.Evho(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            evhoList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return evhoList2;
    }

    private pyrosim.domain.evac.CorrList fromLegacy(CorrList corrList, pyrosim.domain.evac.CorrList corrList2) {
        for (IPyroObject iPyroObject : corrList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (CorrList)iPyroObject;
                namedPyroObject = new pyrosim.domain.evac.CorrList(namedPyroObject2.getName());
                corrList2.add(this.fromLegacy((CorrList)namedPyroObject2, (pyrosim.domain.evac.CorrList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.Corr)iPyroObject;
            namedPyroObject = new Corr(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            corrList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return corrList2;
    }

    private EvssList fromLegacy(pyrosim.legacy_2012_1.domain.evac.EvssList evssList, EvssList evssList2) {
        for (IPyroObject iPyroObject : evssList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.EvssList)iPyroObject;
                namedPyroObject = new EvssList(namedPyroObject2.getName());
                evssList2.add(this.fromLegacy((pyrosim.legacy_2012_1.domain.evac.EvssList)namedPyroObject2, (EvssList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.Evss)iPyroObject;
            namedPyroObject = new Evss(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            evssList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return evssList2;
    }

    private DoorList fromLegacy(pyrosim.legacy_2012_1.domain.evac.DoorList doorList, DoorList doorList2) {
        for (IPyroObject iPyroObject : doorList.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.DoorList)iPyroObject;
                namedPyroObject = new DoorList(namedPyroObject2.getName());
                doorList2.add(this.fromLegacy((pyrosim.legacy_2012_1.domain.evac.DoorList)namedPyroObject2, (DoorList)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.evac.Door)iPyroObject;
            namedPyroObject = new Door(namedPyroObject2.getName());
            assert (namedPyroObject != null);
            doorList2.add(namedPyroObject);
            this.d_evacMap.put(namedPyroObject2, namedPyroObject);
        }
        return doorList2;
    }

    private pyrosim.domain.controls.ControlMgr fromLegacy(ControlMgr controlMgr, pyrosim.domain.controls.ControlMgr controlMgr2) {
        for (IPyroObject iPyroObject : controlMgr.getMembers()) {
            APyroObject aPyroObject;
            pyrosim.legacy_2012_1.domain.APyroObject aPyroObject2;
            if (iPyroObject instanceof Composite) {
                aPyroObject2 = (ControlMgr)iPyroObject;
                aPyroObject = new pyrosim.domain.controls.ControlMgr(((NamedPyroObject)aPyroObject2).getName());
                controlMgr2.add(this.fromLegacy((ControlMgr)aPyroObject2, (pyrosim.domain.controls.ControlMgr)aPyroObject));
                continue;
            }
            aPyroObject2 = (pyrosim.legacy_2012_1.domain.controls.ControlBridge)iPyroObject;
            aPyroObject = this.fromLegacyControl((pyrosim.legacy_2012_1.domain.controls.ControlBridge)aPyroObject2);
            assert (aPyroObject != null);
            if (aPyroObject != null) {
                controlMgr2.add(aPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(((AControl)aPyroObject2).getName(), Intl.intl("control"));
        }
        return controlMgr2;
    }

    private ControlBridge fromLegacyControl(pyrosim.legacy_2012_1.domain.controls.ControlBridge controlBridge) {
        ControlBridge controlBridge2 = new ControlBridge(controlBridge.getName());
        this.addToConnectionsMap(controlBridge2, controlBridge);
        return controlBridge2;
    }

    private HeatLinkModelMgr fromLegacyHeatLinkMgr(pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr heatLinkModelMgr, HeatLinkModelMgr heatLinkModelMgr2) {
        for (IPyroObject iPyroObject : heatLinkModelMgr.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr)iPyroObject;
                namedPyroObject = new HeatLinkModelMgr(namedPyroObject2.getName());
                heatLinkModelMgr2.add(this.fromLegacyHeatLinkMgr((pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr)namedPyroObject2, (HeatLinkModelMgr)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel)iPyroObject;
            namedPyroObject = new HeatLinkModel(namedPyroObject2.getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel)namedPyroObject2).getRti()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel)namedPyroObject2).getInitialTemp()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel)namedPyroObject2).getActivationTemp()));
            assert (namedPyroObject != null);
            this.makeAvailableForDelayLoad(namedPyroObject, namedPyroObject2);
            heatLinkModelMgr2.add(namedPyroObject);
        }
        return heatLinkModelMgr2;
    }

    private SmokeLinkModelMgr fromLegacySmokeLinkMgr(pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr smokeLinkModelMgr, SmokeLinkModelMgr smokeLinkModelMgr2) {
        for (IPyroObject iPyroObject : smokeLinkModelMgr.getMembers()) {
            pyrosim.domain.NamedPyroObject namedPyroObject;
            NamedPyroObject namedPyroObject2;
            if (iPyroObject instanceof Composite) {
                namedPyroObject2 = (pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr)iPyroObject;
                namedPyroObject = new SmokeLinkModelMgr(namedPyroObject2.getName());
                smokeLinkModelMgr2.add(this.fromLegacySmokeLinkMgr((pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr)namedPyroObject2, (SmokeLinkModelMgr)namedPyroObject));
                continue;
            }
            namedPyroObject2 = (pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel)iPyroObject;
            namedPyroObject = this.fromLegacySmokeLink((pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel)namedPyroObject2);
            assert (namedPyroObject != null);
            if (namedPyroObject != null) {
                smokeLinkModelMgr2.add(namedPyroObject);
                continue;
            }
            this.addUnableToLoadWarn(namedPyroObject2.getName(), Intl.intl("smoke link model"));
        }
        return smokeLinkModelMgr2;
    }

    private SmokeLinkModel fromLegacySmokeLink(pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel smokeLinkModel) {
        SmokeLinkModel smokeLinkModel2 = new SmokeLinkModel(smokeLinkModel.getName(), ConvertUtil.c(smokeLinkModel.getActivationObscuration()), null, this.fromLegacySmokeLinkSpec(smokeLinkModel.getSpec()));
        try {
            this.registerForDelayLoad(smokeLinkModel2, SmokeLinkModel.class.getDeclaredField("d_smokeSpecies"), smokeLinkModel.getSmokeSpecies());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        smokeLinkModel2.setFYI(smokeLinkModel.getFYI());
        this.makeAvailableForDelayLoad(smokeLinkModel2, smokeLinkModel);
        return smokeLinkModel2;
    }

    private SmokeLinkModel.ISpec fromLegacySmokeLinkSpec(SmokeLinkModel.ISpec iSpec) {
        if (iSpec instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary cleary = (SmokeLinkModel.Cleary)iSpec;
            return new SmokeLinkModel.Cleary(cleary.d_cAlpha, cleary.d_cBeta, cleary.d_eAlpha, cleary.d_eBeta);
        }
        if (iSpec instanceof SmokeLinkModel.Heskestad) {
            return new SmokeLinkModel.Heskestad(ConvertUtil.c(((SmokeLinkModel.Heskestad)iSpec).d_length));
        }
        return null;
    }

    private pyrosim.domain.devices.detectors.SprinklerLinkModelMgr fromLegacySprinklerLinkMgr(SprinklerLinkModelMgr sprinklerLinkModelMgr, pyrosim.domain.devices.detectors.SprinklerLinkModelMgr sprinklerLinkModelMgr2) {
        for (IPyroObject iPyroObject : sprinklerLinkModelMgr.getMembers()) {
            Object object;
            NamedPyroObject namedPyroObject;
            if (iPyroObject instanceof Composite) {
                namedPyroObject = (SprinklerLinkModelMgr)iPyroObject;
                object = new pyrosim.domain.devices.detectors.SprinklerLinkModelMgr(namedPyroObject.getName());
                sprinklerLinkModelMgr2.add(this.fromLegacySprinklerLinkMgr((SprinklerLinkModelMgr)namedPyroObject, (pyrosim.domain.devices.detectors.SprinklerLinkModelMgr)object));
                continue;
            }
            namedPyroObject = (pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)iPyroObject;
            if (namedPyroObject.getName() == "Water Spray") {
                for (SprinklerLinkModel sprinklerLinkModel : sprinklerLinkModelMgr2.flatten()) {
                    if (!sprinklerLinkModel.getName().equals("Water Spray")) continue;
                    sprinklerLinkModelMgr2.remove(sprinklerLinkModel);
                    break;
                }
            }
            object = new SprinklerLinkModel(namedPyroObject.getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)namedPyroObject).getRti()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)namedPyroObject).getInitialTemp()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)namedPyroObject).getActivationTemp()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)namedPyroObject).getCFactor()));
            ((SprinklerLinkModel)object).setFYI(((pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel)namedPyroObject).getFYI());
            assert (object != null);
            this.makeAvailableForDelayLoad(object, namedPyroObject);
            sprinklerLinkModelMgr2.add((pyrosim.domain.IPyroObject)object);
        }
        return sprinklerLinkModelMgr2;
    }

    private pyrosim.domain.devices.sprayers.SprayModelMgr fromLegacySprayMgr(SprayModelMgr sprayModelMgr, pyrosim.domain.devices.sprayers.SprayModelMgr sprayModelMgr2) {
        for (pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel sprayModel : sprayModelMgr.flatten()) {
            ArrayList<SprayModel.Jet> arrayList = new ArrayList<SprayModel.Jet>();
            for (SprayModel.Jet jet : sprayModel.getJets()) {
                arrayList.add(new SprayModel.Jet(ConvertUtil.c(jet.d_velocity), ConvertUtil.c(jet.d_orificeDiam), jet.d_flowFrac, ConvertUtil.c(jet.d_long1), ConvertUtil.c(jet.d_long2), ConvertUtil.c(jet.d_lat1), ConvertUtil.c(jet.d_lat2)));
            }
            pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel sprayModel2 = new pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel(null, null);
            if (sprayModel2.getDtInsert() == sprayModel.getDtInsert()) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Insertion Interval for Spray Models."), String.format(Intl.intl("Insertion Interval removed from Spray Model, %s."), sprayModel.getName())));
            }
            SprayModel serializable2 = new SprayModel(sprayModel.getName(), null, ConvertUtil.c(sprayModel.getSprayOffset()), this.fromLegacySprayFlow(sprayModel, sprayModel.getFlowRate()), sprayModel.getDropsPerSecond(), arrayList);
            try {
                this.registerForDelayLoad(serializable2, SprayModel.class.getDeclaredField("d_particle"), sprayModel.getParticle());
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            serializable2.setFYI(sprayModel.getFYI());
            this.makeAvailableForDelayLoad(serializable2, sprayModel);
            sprayModelMgr2.add(serializable2);
        }
        return sprayModelMgr2;
    }

    private SprayModel.FlowRate fromLegacySprayFlow(pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel sprayModel, SprayModel.FlowRate flowRate) {
        if (flowRate instanceof SprayModel.ExplicitFlowRate) {
            SprayModel.ExplicitFlowRate explicitFlowRate = (SprayModel.ExplicitFlowRate)flowRate;
            return new SprayModel.ExplicitFlowRate(ConvertUtil.c(explicitFlowRate.d_rate), this.fromLegacyTimeFunc(explicitFlowRate.d_ramp));
        }
        if (flowRate instanceof SprayModel.PressurizedFlowRate) {
            SprayModel.PressurizedFlowRate pressurizedFlowRate = (SprayModel.PressurizedFlowRate)flowRate;
            return new SprayModel.PressurizedFlowRate(ConvertUtil.c(pressurizedFlowRate.d_opPressure), ConvertUtil.c(pressurizedFlowRate.d_kFactor), this.fromLegacyTimeFunc(pressurizedFlowRate.d_ramp));
        }
        if (flowRate instanceof SprayModel.VaryingFlowRate) {
            SprayModel.VaryingFlowRate varyingFlowRate = (SprayModel.VaryingFlowRate)flowRate;
            pyrosim.domain.ramp.IRampInput iRampInput = varyingFlowRate.d_pressureRamp.getDefaultInput().equals(SprayModel.VaryingFlowRate.DEF_RAMP_INPUT) ? SprayModel.VaryingFlowRate.DEF_RAMP_INPUT : this.fromLegacyRampInput(varyingFlowRate.d_pressureRamp.getDefaultInput());
            pyrosim.domain.ramp.IRampInput iRampInput2 = varyingFlowRate.d_pressureRamp.getInput().equals(SprayModel.VaryingFlowRate.DEF_RAMP_INPUT) ? SprayModel.VaryingFlowRate.DEF_RAMP_INPUT : this.fromLegacyRampInput(varyingFlowRate.d_pressureRamp.getDefaultInput());
            boolean bl = false;
            ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>();
            for (Ramp.Entry entry : varyingFlowRate.d_pressureRamp.getRecords()) {
                UnitDouble unitDouble;
                if (entry.f.getUnit().equals(SI.PASCAL)) {
                    unitDouble = new UnitDouble(entry.f.getValueNoUnit(), NonSI.ATMOSPHERE);
                    bl = true;
                } else if (entry.f.getUnit().equals(NonSI.BAR)) {
                    double d = entry.f.getValue(SI.PASCAL);
                    unitDouble = new UnitDouble(d, NonSI.ATMOSPHERE);
                    bl = true;
                } else {
                    unitDouble = ConvertUtil.c(entry.f);
                }
                arrayList.add(new Ramp.Entry(ConvertUtil.c(entry.t), unitDouble));
            }
            if (bl) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Spray Model, %s, contained incorrectly stored Pipe Pressure Ramp units."), sprayModel.getName()), String.format(Intl.intl("Attempted to auto-correct. Verify values for %s are correct."), sprayModel.getName())));
            }
            return new SprayModel.VaryingFlowRate(new pyrosim.domain.ramp.Ramp(arrayList, iRampInput, iRampInput2, 12), ConvertUtil.c(varyingFlowRate.d_opPressure), ConvertUtil.c(varyingFlowRate.d_kFactor), ConvertUtil.c(varyingFlowRate.d_rate), this.fromLegacyTimeFunc(varyingFlowRate.d_ramp));
        }
        return null;
    }

    private pyrosim.domain.devices.DeviceManager fromLegacyDevcMgr(DeviceManager deviceManager, pyrosim.domain.devices.DeviceManager deviceManager2, Serialized serialized) {
        for (IPyroObject iPyroObject : deviceManager.getMembers()) {
            INamed iNamed;
            pyrosim.legacy_2012_1.domain.INamed iNamed2;
            if (iPyroObject instanceof Composite) {
                iNamed2 = (DeviceManager)iPyroObject;
                iNamed = new pyrosim.domain.devices.DeviceManager(((NamedPyroObject)iNamed2).getName());
                deviceManager2.add(this.fromLegacyDevcMgr((DeviceManager)iNamed2, (pyrosim.domain.devices.DeviceManager)iNamed, serialized));
                continue;
            }
            iNamed2 = (pyrosim.legacy_2012_1.domain.devices.IDevice)iPyroObject;
            iNamed = this.fromLegacyDevc((pyrosim.legacy_2012_1.domain.devices.IDevice)iNamed2, serialized);
            if (iNamed != null) {
                deviceManager2.add(iNamed);
                continue;
            }
            this.addUnableToLoadWarn(iNamed2.getName(), Intl.intl("device"));
        }
        return deviceManager2;
    }

    private IDevice fromLegacyDevc(pyrosim.legacy_2012_1.domain.devices.IDevice iDevice, Serialized serialized) {
        Serializable serializable;
        ADevice aDevice = null;
        if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator) {
            serializable = (pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator)iDevice;
            aDevice = new Aspirator(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator)serializable).getBypassFlowrate()), this.fromLegacyFreePoint(((APointSrcDevc)serializable).getLocation()));
            for (Aspirator.SamplerLine samplerLine : ((pyrosim.legacy_2012_1.domain.devices.aspiration.Aspirator)serializable).getSamplerLines()) {
                ((Aspirator)aDevice).setSamplerLine(this.fromLegacySampler(samplerLine));
            }
        } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler) {
            aDevice = new AspiratorSampler(iDevice.getName(), this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.aspiration.AspiratorSampler)iDevice).getLocation()));
        } else {
            if (iDevice instanceof CableFailDetector) {
                this.d_warnings.addWarning(new Warning(Intl.intl("PyroSim no longer supports Cable Failure Detectors."), String.format(Intl.intl("Device %s removed. See FDS6 User's Guide section 15.3.8."), iDevice.getName())));
                return null;
            }
            if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)iDevice;
                aDevice = new HeatDetector(((NamedPyroObject)serializable).getName(), null, this.fromLegacyFreePoint(((APointSrcDevc)serializable).getLocation()));
                try {
                    this.registerForDelayLoad(aDevice, HeatDetector.class.getDeclaredField("d_link"), ((pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)serializable).getModel());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            if (iDevice instanceof SmokeDetector) {
                serializable = (SmokeDetector)iDevice;
                aDevice = new pyrosim.domain.devices.detectors.SmokeDetector(((NamedPyroObject)serializable).getName(), null, this.fromLegacyFreePoint(((APointSrcDevc)serializable).getLocation()));
                try {
                    this.registerForDelayLoad(aDevice, pyrosim.domain.devices.detectors.SmokeDetector.class.getDeclaredField("d_model"), ((SmokeDetector)serializable).getModel());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            if (iDevice instanceof SprinklerLink) {
                serializable = (SprinklerLink)iDevice;
                aDevice = new pyrosim.domain.devices.detectors.SprinklerLink(((NamedPyroObject)serializable).getName(), null, this.fromLegacyFreePoint(((APointSrcDevc)serializable).getLocation()));
                try {
                    this.registerForDelayLoad(aDevice, pyrosim.domain.devices.detectors.SprinklerLink.class.getDeclaredField("d_linkDesc"), ((SprinklerLink)serializable).getModel());
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.detectors.Timer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.detectors.Timer)iDevice;
                aDevice = new Timer(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.detectors.Timer)serializable).getAlarmInfo().setpoint), TripFlags.initiallyOn(((pyrosim.legacy_2012_1.domain.devices.detectors.Timer)serializable).getAlarmInfo().tripFlags));
            } else if (iDevice instanceof HvacDevice) {
                pyrosim.domain.quantity.IQuantity iQuantity;
                serializable = (HvacDevice)iDevice;
                if (iDevice instanceof HvacDevice.DuctDevice) {
                    pyrosim.domain.quantity.IQuantity iQuantity2 = this.fromLegacyIQuant(((HvacDevice)serializable).getQuantity());
                    if (iQuantity2 != null) {
                        aDevice = new DuctDevice(((NamedPyroObject)serializable).getName(), iQuantity2);
                    }
                } else if (iDevice instanceof HvacDevice.NodeDevice && (iQuantity = this.fromLegacyIQuant(((HvacDevice)serializable).getQuantity())) != null) {
                    aDevice = new NodeDevice(((NamedPyroObject)serializable).getName(), iQuantity);
                }
            } else if (iDevice instanceof AABoxMeasurer) {
                serializable = (AABoxMeasurer)iDevice;
                pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)serializable).getQuantity());
                if (iQuantity != null) {
                    aDevice = new pyrosim.domain.devices.measurers.AABoxMeasurer(((NamedPyroObject)serializable).getName(), iQuantity, ConvertUtil.c(((AABoxMeasurer)serializable).getBox()));
                }
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)iDevice;
                pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)serializable).getQuantity());
                if (iQuantity != null) {
                    aDevice = new FlowMeasurer(((NamedPyroObject)serializable).getName(), iQuantity, (AARectangle)this.fromLegacyNode(((pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)serializable).getRect()).flatten().getLocalGeom(), ((pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer)serializable).getFlowDir());
                }
            } else if (iDevice instanceof GaugeHeatFluxMeasurer) {
                serializable = (GaugeHeatFluxMeasurer)iDevice;
                aDevice = new pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((GaugeHeatFluxMeasurer)serializable).getGaugeTemperature()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)serializable).getAttachedLocation()));
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer)iDevice;
                aDevice = new InnerTempMeasurer(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.InnerTempMeasurer)serializable).getDepth()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)serializable).getAttachedLocation()));
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)iDevice;
                aDevice = new LayerMeasurer(((NamedPyroObject)serializable).getName(), ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getHeightInfo().isEnabled(), ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getUpperTempInfo().isEnabled(), ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getLowerTempInfo().isEnabled(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getBeam()));
                for (int i = 0; i < ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getNumMeasurements(); ++i) {
                    AlarmInfo alarmInfo = ((pyrosim.legacy_2012_1.domain.devices.measurers.LayerMeasurer)serializable).getMsrInfo(i).getAlarmInfo();
                    if (alarmInfo == null) continue;
                    ((LayerMeasurer)aDevice).getMsrInfo(i).setAlarmInfo(this.fromLegacyAlarm(alarmInfo));
                }
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.PathObscurationMeasurer)iDevice;
                aDevice = new PathObscurationMeasurer(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((ABeamMeasurer)serializable).getBeam()));
            } else if (iDevice instanceof PressureCoeffMeasurer) {
                serializable = (PressureCoeffMeasurer)iDevice;
                aDevice = new pyrosim.domain.devices.measurers.PressureCoeffMeasurer(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((PressureCoeffMeasurer)serializable).getCharacteristicVel()), this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)serializable).getAttachedLocation()));
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.SolidDensityMeasurer)iDevice;
                pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)serializable).getQuantity());
                if (iQuantity != null) {
                    aDevice = new SolidDensityMeasurer(((NamedPyroObject)serializable).getName(), (pyrosim.domain.quantity.ObjectQuantity)iQuantity, this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)serializable).getAttachedLocation()));
                }
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)iDevice;
                pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)serializable).getQuantity());
                if (iQuantity != null) {
                    aDevice = new SolidPointMeasurer(((NamedPyroObject)serializable).getName(), iQuantity, this.fromLegacyAttachPoint(((pyrosim.legacy_2012_1.domain.devices.measurers.SolidPointMeasurer)serializable).getAttachedLocation()));
                }
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)iDevice;
                aDevice = new Thermocouple(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)serializable).getBeadDiameter()), ((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)serializable).getEmissivity(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)serializable).getBeadDensity()), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple)serializable).getBeadSpecHeat()), this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)serializable).getLocation()));
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.Clock) {
                aDevice = Clock.INSTANCE;
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer) {
                serializable = (pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)iDevice;
                pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)serializable).getQuantity());
                if (iQuantity != null) {
                    aDevice = new GasPointMeasurer(((NamedPyroObject)serializable).getName(), iQuantity, this.fromLegacyFreePoint(((pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer)serializable).getLocation()));
                } else {
                    this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 Extra Species, Other, cannot be converted."), String.format(Intl.intl("Gas-phase Device %s removed from model."), ((NamedPyroObject)serializable).getName())));
                }
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.simctrl.KillDevice) {
                aDevice = new KillDevice(iDevice.getName());
            } else if (iDevice instanceof pyrosim.legacy_2012_1.domain.devices.simctrl.RestartFileDevc) {
                aDevice = new RestartFileDevc(iDevice.getName());
            } else if (iDevice instanceof DryPipe) {
                serializable = (DryPipe)iDevice;
                aDevice = new pyrosim.domain.devices.sprayers.DryPipe(((NamedPyroObject)serializable).getName(), ConvertUtil.c(((DryPipe)serializable).getDelay()));
            } else {
                if (iDevice instanceof Nozzle) {
                    serializable = (Nozzle)iDevice;
                    aDevice = new pyrosim.domain.devices.sprayers.Nozzle(((NamedPyroObject)serializable).getName(), null, this.fromLegacyFreePoint(((ASprayer)serializable).getLocation()));
                    try {
                        this.registerForDelayLoad(aDevice, pyrosim.domain.devices.sprayers.Nozzle.class.getSuperclass().getDeclaredField("d_sprayDescription"), ((ASprayer)serializable).getSprayModel());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
                if (iDevice instanceof Sprinkler) {
                    serializable = (Sprinkler)iDevice;
                    Sprinkler.LinkModel linkModel = this.fromLegacySprinklerLink(((Sprinkler)serializable).getLinkModel());
                    if (linkModel == null) {
                        this.d_warnings.addWarning(new Warning(Intl.intl("FDS5 Extra Species, Other, cannot be converted."), String.format(Intl.intl("Sprinkler %s activation set to the default Sprinkler Link Model."), ((NamedPyroObject)serializable).getName())));
                        SprinklerLinkModel sprinklerLinkModel = serialized.sprkLinkModels.find("Default", SprinklerLinkModel.class, true);
                        if (sprinklerLinkModel == null) {
                            sprinklerLinkModel = new SprinklerLinkModel(Intl.intl("Legacy Default"));
                            serialized.sprkLinkModels.add(sprinklerLinkModel);
                        }
                        linkModel = new Sprinkler.TraditionalModel(sprinklerLinkModel, false, true);
                    }
                    aDevice = new pyrosim.domain.devices.sprayers.Sprinkler(((NamedPyroObject)serializable).getName(), null, linkModel, this.fromLegacyFreePoint(((ASprayer)serializable).getLocation()));
                    try {
                        this.registerForDelayLoad(aDevice, pyrosim.domain.devices.sprayers.Sprinkler.class.getDeclaredField("d_dryPipe"), ((Sprinkler)serializable).getDryPipe());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                    try {
                        this.registerForDelayLoad(aDevice, pyrosim.domain.devices.sprayers.Sprinkler.class.getSuperclass().getDeclaredField("d_sprayDescription"), ((ASprayer)serializable).getSprayModel());
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
        if (aDevice instanceof AMeasuringDevc && (serializable = ((pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc)iDevice).getMsrInfo().getAlarmInfo()) != null) {
            ((AMeasuringDevc)aDevice).getMsrInfo().setAlarmInfo(this.fromLegacyAlarm((AlarmInfo)serializable));
        }
        if (aDevice instanceof APointDetector) {
            ((APointDetector)aDevice).setTripFlags(((pyrosim.legacy_2012_1.domain.devices.detectors.APointDetector)iDevice).getTripFlags());
        }
        this.addToConnectionsMap(aDevice, iDevice);
        this.makeAvailableForDelayLoad(aDevice, iDevice);
        return aDevice;
    }

    private Aspirator.SamplerLine fromLegacySampler(Aspirator.SamplerLine samplerLine) {
        Aspirator.SamplerLine samplerLine2 = new Aspirator.SamplerLine(new AspiratorSampler(null, null), ConvertUtil.c(samplerLine.d_flowrate), ConvertUtil.c(samplerLine.d_delay));
        try {
            this.registerForDelayLoad(samplerLine2, Aspirator.SamplerLine.class.getDeclaredField("d_sampler"), samplerLine.d_sampler);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return samplerLine2;
    }

    private pyrosim.domain.devices.AlarmInfo fromLegacyAlarm(AlarmInfo alarmInfo) {
        return new pyrosim.domain.devices.AlarmInfo(ConvertUtil.c(alarmInfo.setpoint), alarmInfo.tripFlags);
    }

    private Sprinkler.LinkModel fromLegacySprinklerLink(Sprinkler.LinkModel linkModel) {
        if (linkModel instanceof Sprinkler.TraditionalModel) {
            Sprinkler.TraditionalModel traditionalModel = (Sprinkler.TraditionalModel)linkModel;
            Sprinkler.TraditionalModel traditionalModel2 = new Sprinkler.TraditionalModel(null, traditionalModel.d_initState, traditionalModel.d_latch);
            try {
                this.registerForDelayLoad(traditionalModel2, Sprinkler.TraditionalModel.class.getDeclaredField("d_link"), traditionalModel.d_link);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return traditionalModel2;
        }
        if (linkModel instanceof Sprinkler.QuantityModel) {
            Sprinkler.QuantityModel quantityModel = (Sprinkler.QuantityModel)linkModel;
            pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(quantityModel.d_quantity);
            if (iQuantity != null) {
                Sprinkler.QuantityModel quantityModel2 = new Sprinkler.QuantityModel(this.fromLegacyIQuant(quantityModel.d_quantity), ConvertUtil.c(quantityModel.d_setPoint), quantityModel.d_initState, quantityModel.d_latch);
                return quantityModel2;
            }
        }
        return null;
    }

    private pyrosim.domain.geom.AttachedPointLoc fromLegacyAttachPoint(AttachedPointLoc attachedPointLoc) {
        return attachedPointLoc.fromLegacy(this.d_dictionary);
    }

    private FreePointLoc fromLegacyFreePoint(pyrosim.legacy_2012_1.domain.geom.FreePointLoc freePointLoc) {
        return freePointLoc.fromLegacy(this.d_dictionary);
    }

    private pyrosim.domain.output.Boundaries fromLegacyBound(Boundaries boundaries, pyrosim.domain.output.Boundaries boundaries2) {
        ArrayList<pyrosim.domain.quantity.IQuantity> arrayList = new ArrayList<pyrosim.domain.quantity.IQuantity>();
        for (IQuantity iQuantity : boundaries.getQuantities()) {
            pyrosim.domain.quantity.IQuantity iQuantity2 = this.fromLegacyIQuant(iQuantity);
            if (iQuantity2 == null) continue;
            arrayList.add(this.fromLegacyIQuant(iQuantity));
        }
        pyrosim.domain.quantity.IQuantity[] iQuantityArray = arrayList.toArray(new pyrosim.domain.quantity.IQuantity[arrayList.size()]);
        boundaries2 = new pyrosim.domain.output.Boundaries(iQuantityArray);
        boundaries2.setGaugeTemperature(ConvertUtil.c(boundaries.getGaugeTemperature()));
        boundaries2.setPressCoeffCharVel(ConvertUtil.c(boundaries.getPressCoeffCharVel()));
        boundaries2.setVelocitySign(this.fromLegacyVeloSign(boundaries.getVelocitySign()));
        this.makeAvailableForDelayLoad(boundaries2, boundaries);
        return boundaries2;
    }

    private pyrosim.domain.output.IsosurfaceMgr fromLegacyIsoMgr(IsosurfaceMgr isosurfaceMgr, pyrosim.domain.output.IsosurfaceMgr isosurfaceMgr2) {
        for (IPyroObject iPyroObject : isosurfaceMgr.getMembers()) {
            Cloneable cloneable;
            if (iPyroObject instanceof Composite) {
                cloneable = (IsosurfaceMgr)iPyroObject;
                pyrosim.domain.output.IsosurfaceMgr isosurfaceMgr3 = new pyrosim.domain.output.IsosurfaceMgr(((NamedPyroObject)cloneable).getName());
                isosurfaceMgr2.add(this.fromLegacyIsoMgr((IsosurfaceMgr)cloneable, isosurfaceMgr3));
                continue;
            }
            cloneable = this.fromLegacyIsosurf((Isosurface)iPyroObject);
            assert (cloneable != null);
            if (cloneable == null) continue;
            isosurfaceMgr2.add(this.fromLegacyIsosurf((Isosurface)iPyroObject));
        }
        return isosurfaceMgr2;
    }

    private pyrosim.domain.output.Isosurface fromLegacyIsosurf(Isosurface isosurface) {
        pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(isosurface.getQuantity());
        if (iQuantity == null) {
            return null;
        }
        pyrosim.domain.output.Isosurface isosurface2 = new pyrosim.domain.output.Isosurface(this.fromLegacyIQuant(isosurface.getQuantity()), ConvertUtil.c(isosurface.getContours()));
        isosurface2.setVelocitySign(this.fromLegacyVeloSign(isosurface.getVelocitySign()));
        return isosurface2;
    }

    private void addPredefSpecToDomain(pyrosim.domain.ExSpec exSpec) {
        if (!this.d_specList.contains(exSpec)) {
            this.d_specList.add(exSpec);
        }
    }

    private pyrosim.domain.quantity.IQuantity fromLegacyIQuant(IQuantity iQuantity) {
        if (iQuantity instanceof StaticQuantity) {
            Quantity quantity = iQuantity.get();
            pyrosim.domain.quantity.Quantity quantity2 = this.fromLegacyQuant(quantity);
            ArrayList<pyrosim.domain.IPyroObject> arrayList = new ArrayList<pyrosim.domain.IPyroObject>();
            if (iQuantity instanceof ObjectQuantity) {
                ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
                for (Object t : objectQuantity.objects) {
                    ExSpec exSpec;
                    DelayedRef delayedRef;
                    if (t instanceof ExSpec && t.isMixFracOnly()) {
                        if (t.equals(ExSpecList.MixFrac.OTHER.spec)) continue;
                        this.addPredefSpecToDomain((pyrosim.domain.ExSpec)this.d_delayLoadMap.get(t).get());
                    }
                    if ((delayedRef = this.d_delayLoadMap.get(t)) != null) {
                        arrayList.add((pyrosim.domain.IPyroObject)this.d_delayLoadMap.get(t).get());
                        continue;
                    }
                    if (!(t instanceof ExSpec) || !(exSpec = (ExSpec)t).isPredefined() || this.d_specList.get(exSpec.getName()) == null) continue;
                    arrayList.add(this.d_specList.get(exSpec.getName()));
                }
                if (!arrayList.isEmpty()) {
                    return quantity2.create(arrayList);
                }
            }
            if (quantity2 != null && quantity2.requiredTypes.length == 0) {
                return quantity2.create();
            }
        }
        return null;
    }

    private pyrosim.domain.quantity.Quantity fromLegacyQuant(Quantity quantity) {
        if (quantity.equals((Object)Quantity.ABSORPTION_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.ABSORPTION_COEFFICIENT;
        }
        if (quantity.equals((Object)Quantity.ASPIRATION)) {
            return pyrosim.domain.quantity.Quantity.ASPIRATION;
        }
        if (quantity.equals((Object)Quantity.AVERAGE_SPECIFIC_HEAT)) {
            return pyrosim.domain.quantity.Quantity.AVERAGE_SPECIFIC_HEAT;
        }
        if (quantity.equals((Object)Quantity.CABLE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.CABLE_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.CONDUCTIVITY)) {
            return pyrosim.domain.quantity.Quantity.CONDUCTIVITY;
        }
        if (quantity.equals((Object)Quantity.DENSITY)) {
            return pyrosim.domain.quantity.Quantity.DENSITY;
        }
        if (quantity.equals((Object)Quantity.DIVERGENCE)) {
            return pyrosim.domain.quantity.Quantity.DIVERGENCE;
        }
        if (quantity.equals((Object)Quantity.ENTHALPY)) {
            return pyrosim.domain.quantity.Quantity.ENTHALPY;
        }
        if (quantity.equals((Object)Quantity.EXTINCTION_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.EXTINCTION_COEFFICIENT;
        }
        if (quantity.equals((Object)Quantity.FED)) {
            return pyrosim.domain.quantity.Quantity.FED;
        }
        if (quantity.equals((Object)Quantity.H)) {
            return pyrosim.domain.quantity.Quantity.H;
        }
        if (quantity.equals((Object)Quantity.HRRPUV)) {
            return pyrosim.domain.quantity.Quantity.HRRPUV;
        }
        if (quantity.equals((Object)Quantity.MIXTURE_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.MIXTURE_FRACTION;
        }
        if (quantity.equals((Object)Quantity.OPTICAL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.OPTICAL_DENSITY;
        }
        if (quantity.equals((Object)Quantity.PRESSURE)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE;
        }
        if (quantity.equals((Object)Quantity.RADIATIVE_HEAT_FLUX_GAS)) {
            return pyrosim.domain.quantity.Quantity.RADIATIVE_HEAT_FLUX_GAS;
        }
        if (quantity.equals((Object)Quantity.RELATIVE_HUMIDITY)) {
            return pyrosim.domain.quantity.Quantity.RELATIVE_HUMIDITY;
        }
        if (quantity.equals((Object)Quantity.SPECIFIC_ENTHALPY)) {
            return pyrosim.domain.quantity.Quantity.SPECIFIC_ENTHALPY;
        }
        if (quantity.equals((Object)Quantity.SPECIFIC_HEAT)) {
            return pyrosim.domain.quantity.Quantity.SPECIFIC_HEAT;
        }
        if (quantity.equals((Object)Quantity.TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.THERMOCOUPLE)) {
            return pyrosim.domain.quantity.Quantity.THERMOCOUPLE;
        }
        if (quantity.equals((Object)Quantity.U_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.U_VELOCITY;
        }
        if (quantity.equals((Object)Quantity.V_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.V_VELOCITY;
        }
        if (quantity.equals((Object)Quantity.W_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.W_VELOCITY;
        }
        if (quantity.equals((Object)Quantity.VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.VELOCITY;
        }
        if (quantity.equals((Object)Quantity.VISCOSITY)) {
            return pyrosim.domain.quantity.Quantity.VISCOSITY;
        }
        if (quantity.equals((Object)Quantity.VISIBILITY)) {
            return pyrosim.domain.quantity.Quantity.VISIBILITY;
        }
        if (quantity.equals((Object)Quantity.ADIABATIC_SURFACE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.ADIABATIC_SURFACE_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.BACK_WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.BACK_WALL_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.BURNING_RATE)) {
            return pyrosim.domain.quantity.Quantity.BURNING_RATE;
        }
        if (quantity.equals((Object)Quantity.CONVECTIVE_FLUX)) {
            return pyrosim.domain.quantity.Quantity.CONVECTIVE_FLUX;
        }
        if (quantity.equals((Object)Quantity.GAS_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.GAS_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.GAUGE_HEAT_FLUX;
        }
        if (quantity.equals((Object)Quantity.HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.HEAT_FLUX;
        }
        if (quantity.equals((Object)Quantity.HEAT_TRANSFER_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.HEAT_TRANSFER_COEFFICIENT;
        }
        if (quantity.equals((Object)Quantity.INCIDENT_HEAT_FLUX)) {
            return pyrosim.domain.quantity.Quantity.INCIDENT_HEAT_FLUX;
        }
        if (quantity.equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.INSIDE_WALL_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.MASS_LOSS)) {
            this.d_warnings.addWarning(new Warning(Intl.intl("The quantity MASS_LOSS no longer exists."), Intl.intl("Quantity removed from record.")));
            return null;
        }
        if (quantity.equals((Object)Quantity.NORMAL_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.NORMAL_VELOCITY;
        }
        if (quantity.equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE_COEFFICIENT;
        }
        if (quantity.equals((Object)Quantity.RADIATIVE_FLUX)) {
            return pyrosim.domain.quantity.Quantity.RADIATIVE_FLUX;
        }
        if (quantity.equals((Object)Quantity.RADIOMETER)) {
            return pyrosim.domain.quantity.Quantity.RADIOMETER;
        }
        if (quantity.equals((Object)Quantity.SURFACE_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SURFACE_DENSITY;
        }
        if (quantity.equals((Object)Quantity.WALL_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.WALL_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.WALL_THICKNESS)) {
            return pyrosim.domain.quantity.Quantity.WALL_THICKNESS;
        }
        if (quantity.equals((Object)Quantity.HEAT_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HEAT_FLOW;
        }
        if (quantity.equals((Object)Quantity.HRR)) {
            return pyrosim.domain.quantity.Quantity.HRR;
        }
        if (quantity.equals((Object)Quantity.MASS_FLOW)) {
            return pyrosim.domain.quantity.Quantity.MASS_FLOW;
        }
        if (quantity.equals((Object)Quantity.VOLUME_FLOW)) {
            return pyrosim.domain.quantity.Quantity.VOLUME_FLOW;
        }
        if (quantity.equals((Object)Quantity.LAYER_HEIGHT)) {
            return pyrosim.domain.quantity.Quantity.LAYER_HEIGHT;
        }
        if (quantity.equals((Object)Quantity.LOWER_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.LOWER_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.PATH_OBSCURATION)) {
            return pyrosim.domain.quantity.Quantity.PATH_OBSCURATION;
        }
        if (quantity.equals((Object)Quantity.UPPER_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.UPPER_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.ACTUATED_SPRINKLERS)) {
            return pyrosim.domain.quantity.Quantity.ACTUATED_SPRINKLERS;
        }
        if (quantity.equals((Object)Quantity.CPU_TIME)) {
            return pyrosim.domain.quantity.Quantity.CPU_TIME;
        }
        if (quantity.equals((Object)Quantity.ITERATION)) {
            return pyrosim.domain.quantity.Quantity.ITERATION;
        }
        if (quantity.equals((Object)Quantity.OPEN_NOZZLES)) {
            return pyrosim.domain.quantity.Quantity.OPEN_NOZZLES;
        }
        if (quantity.equals((Object)Quantity.PRESSURE_ZONE)) {
            return pyrosim.domain.quantity.Quantity.PRESSURE_ZONE;
        }
        if (quantity.equals((Object)Quantity.TIME)) {
            return pyrosim.domain.quantity.Quantity.TIME;
        }
        if (quantity.equals((Object)Quantity.TIME_STEP)) {
            return pyrosim.domain.quantity.Quantity.TIME_STEP;
        }
        if (quantity.equals((Object)Quantity.TURBULENCE_RESOLUTION)) {
            return pyrosim.domain.quantity.Quantity.TURBULENCE_RESOLUTION;
        }
        if (quantity.equals((Object)Quantity.WALL_CLOCK_TIME)) {
            return pyrosim.domain.quantity.Quantity.WALL_CLOCK_TIME;
        }
        if (quantity.equals((Object)Quantity.SPEC_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FRACTION;
        }
        if (quantity.equals((Object)Quantity.SPEC_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.SPEC_VOLUME_FRACTION;
        }
        if (quantity.equals((Object)Quantity.SPEC_MASS_FLUX_X)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_X;
        }
        if (quantity.equals((Object)Quantity.SPEC_MASS_FLUX_Y)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_Y;
        }
        if (quantity.equals((Object)Quantity.SPEC_MASS_FLUX_Z)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX_Z;
        }
        if (quantity.equals((Object)Quantity.SPEC_MASS_FLUX)) {
            return pyrosim.domain.quantity.Quantity.SPEC_MASS_FLUX;
        }
        if (quantity.equals((Object)Quantity.SPEC_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_DENSITY;
        }
        if (quantity.equals((Object)Quantity.SPEC_VISIBILITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_VISIBILITY;
        }
        if (quantity.equals((Object)Quantity.SPEC_OPTICAL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.SPEC_OPTICAL_DENSITY;
        }
        if (quantity.equals((Object)Quantity.MATL_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.MATL_DENSITY;
        }
        if (quantity.equals((Object)Quantity.MATL_SOLID_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.MATL_SOLID_DENSITY;
        }
        if (quantity.equals((Object)Quantity.PART_ACMPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_ACMPUA;
        }
        if (quantity.equals((Object)Quantity.PART_CPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_CPUA;
        }
        if (quantity.equals((Object)Quantity.PART_MASS_FLUX_X)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_X;
        }
        if (quantity.equals((Object)Quantity.PART_MASS_FLUX_Y)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_Y;
        }
        if (quantity.equals((Object)Quantity.PART_MASS_FLUX_Z)) {
            return pyrosim.domain.quantity.Quantity.PART_MASS_FLUX_Z;
        }
        if (quantity.equals((Object)Quantity.PART_MPUA)) {
            return pyrosim.domain.quantity.Quantity.PART_MPUA;
        }
        if (quantity.equals((Object)Quantity.PART_MPUV)) {
            return pyrosim.domain.quantity.Quantity.PART_MPUV;
        }
        if (quantity.equals((Object)Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_AIRCOIL_HEAT_EXCHANGE;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_DENSITY;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_MASS_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_MASS_FLOW;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_MASS_FRACTION;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_VELOCITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VELOCITY;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_VOLUME_FLOW)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VOLUME_FLOW;
        }
        if (quantity.equals((Object)Quantity.HVAC_DUCT_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_DUCT_VOLUME_FRACTION;
        }
        if (quantity.equals((Object)Quantity.HVAC_FILTER_LOADING)) {
            return pyrosim.domain.quantity.Quantity.HVAC_FILTER_LOADING;
        }
        if (quantity.equals((Object)Quantity.HVAC_FILTER_LOSS)) {
            return pyrosim.domain.quantity.Quantity.HVAC_FILTER_LOSS;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_DENSITY)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_DENSITY;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_MASS_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_MASS_FRACTION;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_PRESSURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_PRESSURE;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_TEMPERATURE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_TEMPERATURE;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_VOLUME_FRACTION)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_VOLUME_FRACTION;
        }
        if (quantity.equals((Object)Quantity.HVAC_NODE_PRESSURE_DIFFERENCE)) {
            return pyrosim.domain.quantity.Quantity.HVAC_NODE_PRESSURE_DIFFERENCE;
        }
        return null;
    }

    private VelocitySign fromLegacyVeloSign(pyrosim.legacy_2012_1.domain.quantity.VelocitySign velocitySign) {
        if (velocitySign == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.ALWAYS_POSITIVE) {
            return VelocitySign.ALWAYS_POSITIVE;
        }
        if (velocitySign == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_U) {
            return VelocitySign.MATCH_U;
        }
        if (velocitySign == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_V) {
            return VelocitySign.MATCH_V;
        }
        if (velocitySign == pyrosim.legacy_2012_1.domain.quantity.VelocitySign.MATCH_W) {
            return VelocitySign.MATCH_W;
        }
        return null;
    }

    private pyrosim.domain.output.Plot3d fromLegacyPl3d(Plot3d plot3d, pyrosim.domain.output.Plot3d plot3d2) {
        ArrayList<pyrosim.domain.quantity.IQuantity> arrayList = new ArrayList<pyrosim.domain.quantity.IQuantity>();
        for (IQuantity iQuantity : plot3d.getQuantities()) {
            pyrosim.domain.quantity.IQuantity iQuantity2 = this.fromLegacyIQuant(iQuantity);
            if (iQuantity2 == null) continue;
            arrayList.add(iQuantity2);
        }
        plot3d2.setQuantities(arrayList);
        plot3d2.setVelocitySign(this.fromLegacyVeloSign(plot3d.getVelocitySign()));
        return plot3d2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private SliceList fromLegacySlcfList(pyrosim.legacy_2012_1.domain.output.SliceList sliceList, SliceList sliceList2) {
        Iterator<IPyroObject> iterator = sliceList.getMembers().iterator();
        while (true) {
            void var5_12;
            block15: {
                pyrosim.domain.quantity.IQuantity iQuantity;
                Cloneable cloneable;
                if (!iterator.hasNext()) {
                    return sliceList2;
                }
                IPyroObject iPyroObject = iterator.next();
                if (iPyroObject instanceof Composite) {
                    pyrosim.legacy_2012_1.domain.output.SliceList sliceList3 = (pyrosim.legacy_2012_1.domain.output.SliceList)iPyroObject;
                    cloneable = new SliceList(sliceList3.getName());
                    sliceList2.add(this.fromLegacySlcfList(sliceList3, (SliceList)cloneable));
                    continue;
                }
                Object var5_7 = null;
                if (iPyroObject instanceof pyrosim.legacy_2012_1.domain.output.PlanarSlice) {
                    cloneable = (pyrosim.legacy_2012_1.domain.output.PlanarSlice)iPyroObject;
                    iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).getQuantity());
                    if (iQuantity != null) {
                        PlanarSlice planarSlice = new PlanarSlice(((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getPlane(), ConvertUtil.c(((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getLocation()), iQuantity, ((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).includeFlowVector(), false);
                        break block15;
                    } else {
                        int n = ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getPlane();
                        String string = null;
                        switch (n) {
                            case 0: {
                                string = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getLocation().toString());
                                break;
                            }
                            case 1: {
                                string = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getLocation().toString());
                                break;
                            }
                            case 2: {
                                string = String.format(Intl.intl("X = %s"), ((pyrosim.legacy_2012_1.domain.output.PlanarSlice)cloneable).getLocation().toString());
                                break;
                            }
                        }
                        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to convert quantity %s"), ((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).getQuantity().getDescription()), String.format(Intl.intl("Slice %s at %s dropped."), ((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).getQuantity().getDescription(), string)));
                        continue;
                    }
                }
                if (iPyroObject instanceof pyrosim.legacy_2012_1.domain.output.GridBoundarySlice) {
                    cloneable = (pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)iPyroObject;
                    iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).getQuantity());
                    if (iQuantity != null) {
                        GridBoundarySlice gridBoundarySlice = new GridBoundarySlice(this.fromLegacyGrid(((pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)cloneable).getGrid()), ((pyrosim.legacy_2012_1.domain.output.GridBoundarySlice)cloneable).getGridFace(), iQuantity, ((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).includeFlowVector(), false);
                    }
                } else {
                    cloneable = (pyrosim.legacy_2012_1.domain.output.Slice)iPyroObject;
                    iQuantity = this.fromLegacyIQuant(((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).getQuantity());
                    if (iQuantity != null) {
                        Slice slice = new Slice(iQuantity, ((pyrosim.legacy_2012_1.domain.output.Slice)cloneable).includeFlowVector(), false);
                    }
                }
            }
            if (var5_12 == null) continue;
            sliceList2.add((pyrosim.domain.IPyroObject)var5_12);
        }
    }

    private pyrosim.domain.output.ProfList fromLegacyProfList(ProfList profList, pyrosim.domain.output.ProfList profList2) {
        for (IPyroObject iPyroObject : profList.getMembers()) {
            Cloneable cloneable;
            if (iPyroObject instanceof Composite) {
                cloneable = (ProfList)iPyroObject;
                pyrosim.domain.output.ProfList profList3 = new pyrosim.domain.output.ProfList(((NamedPyroObject)cloneable).getName());
                profList2.add(this.fromLegacyProfList((ProfList)cloneable, profList3));
                continue;
            }
            cloneable = this.fromLegacyProf((pyrosim.legacy_2012_1.domain.output.ProfRec)iPyroObject);
            assert (cloneable != null);
            profList2.add((pyrosim.domain.IPyroObject)cloneable);
        }
        return profList2;
    }

    private ProfRec fromLegacyProf(pyrosim.legacy_2012_1.domain.output.ProfRec profRec) {
        pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(profRec.getQuantity());
        if (iQuantity != null) {
            return new ProfRec(profRec.getName(), profRec.getIOR(), this.fromLegacyIQuant(profRec.getQuantity()), ConvertUtil.c(profRec.getPoint()));
        }
        return null;
    }

    private StatisticMgr fromLegacyStatMgr(pyrosim.legacy_2012_1.domain.output.StatisticMgr statisticMgr, StatisticMgr statisticMgr2) {
        for (IPyroObject iPyroObject : statisticMgr.getMembers()) {
            INamed iNamed;
            pyrosim.legacy_2012_1.domain.INamed iNamed2;
            if (iPyroObject instanceof Composite) {
                iNamed2 = (pyrosim.legacy_2012_1.domain.output.StatisticMgr)iPyroObject;
                iNamed = new StatisticMgr(((NamedPyroObject)iNamed2).getName());
                statisticMgr2.add(this.fromLegacyStatMgr((pyrosim.legacy_2012_1.domain.output.StatisticMgr)iNamed2, (StatisticMgr)iNamed));
                continue;
            }
            iNamed2 = (pyrosim.legacy_2012_1.domain.output.IMeasurementStat)iPyroObject;
            iNamed = this.fromLegacyStat((pyrosim.legacy_2012_1.domain.output.IMeasurementStat)iNamed2);
            assert (iNamed != null);
            if (iNamed != null) {
                statisticMgr2.add(iNamed);
                continue;
            }
            this.addUnableToLoadWarn(iNamed2.getName(), Intl.intl("statistic"));
        }
        return statisticMgr2;
    }

    private IMeasurementStat fromLegacyStat(pyrosim.legacy_2012_1.domain.output.IMeasurementStat iMeasurementStat) {
        AMsrStat aMsrStat = null;
        if (iMeasurementStat instanceof pyrosim.legacy_2012_1.domain.output.GasMsrStat) {
            pyrosim.legacy_2012_1.domain.output.GasMsrStat gasMsrStat = (pyrosim.legacy_2012_1.domain.output.GasMsrStat)iMeasurementStat;
            pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(gasMsrStat.getQuantity());
            if (iQuantity != null) {
                aMsrStat = new GasMsrStat(gasMsrStat.getName(), iQuantity, this.fromLegacyNode(gasMsrStat.getGeom()).flatten().getLocalGeom(), gasMsrStat.getStats());
            }
        } else if (iMeasurementStat instanceof SolidMsrStat) {
            SolidMsrStat solidMsrStat = (SolidMsrStat)iMeasurementStat;
            ArrayList<Surface> arrayList = new ArrayList<Surface>();
            for (pyrosim.legacy_2012_1.domain.boundcond.surf.Surface surface : solidMsrStat.getSurfaces()) {
                arrayList.add((Surface)this.d_delayLoadMap.get(surface).get());
            }
            pyrosim.domain.quantity.IQuantity iQuantity = this.fromLegacyIQuant(solidMsrStat.getQuantity());
            if (iQuantity != null) {
                aMsrStat = new pyrosim.domain.output.SolidMsrStat(solidMsrStat.getName(), iQuantity, this.fromLegacyNode(solidMsrStat.getGeom()).flatten().getLocalGeom(), arrayList, solidMsrStat.getStats());
            }
        }
        return aMsrStat;
    }

    private IGeomNode fromLegacyNode(IGeom iGeom, ITexCoordGenerator iTexCoordGenerator) {
        IGeomNode iGeomNode = this.fromLegacyNode(iGeom);
        IElemSource<Point2d> iElemSource = this.fromLegacyElem(iTexCoordGenerator);
        return iGeomNode.applyUVElements("uvset", (n, iElemSource2) -> iElemSource.getPrimSource((int)n)).prune();
    }

    private IGeomNode fromLegacyNode(IGeom iGeom) {
        if (iGeom instanceof StatGeom.GridGeom) {
            StatGeom.GridGeom gridGeom = (StatGeom.GridGeom)iGeom;
            StatGeom.GridGeom gridGeom2 = new StatGeom.GridGeom(null);
            try {
                this.registerForDelayLoad(gridGeom2, StatGeom.GridGeom.class.getDeclaredField("grid"), gridGeom.grid);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return GeomNodeUtil.newNode(gridGeom2);
        }
        Object object = this.d_dictionary.get(iGeom);
        if (object instanceof thunderheadeng.geometry.objs.IGeom) {
            return GeomNodeUtil.newNode((thunderheadeng.geometry.objs.IGeom)object);
        }
        if (object instanceof IGeomNode) {
            return (IGeomNode)object;
        }
        return null;
    }

    private thunderheadeng.scene3d.geom.IPropsSrc fromLegacyProp(IPropsSrc iPropsSrc) {
        return (thunderheadeng.scene3d.geom.IPropsSrc)this.d_dictionary.get(iPropsSrc);
    }

    private IElemSource<Point2d> fromLegacyElem(ITexCoordGenerator iTexCoordGenerator) {
        return (IElemSource)this.d_dictionary.get(iTexCoordGenerator);
    }

    private Image fromLegacyImage(pyrosim.legacy_2012_1.thunderheadeng.image.Image image) {
        return (Image)this.d_dictionary.get(image);
    }

    private pyrosim.domain.rasterization.RasterizationOptions fromLegacyRaster(RasterizationOptions rasterizationOptions, pyrosim.domain.rasterization.RasterizationOptions rasterizationOptions2) {
        rasterizationOptions2 = new pyrosim.domain.rasterization.RasterizationOptions(rasterizationOptions.immersedBoundary, rasterizationOptions.largeBlocks, rasterizationOptions.mergeIdentical, rasterizationOptions.separateDisconnected, rasterizationOptions.ignoreMergeNames, rasterizationOptions.forceThicken, rasterizationOptions.geomGroups, rasterizationOptions.rasterizeAligned);
        return rasterizationOptions2;
    }

    private MaterialDB fromLegacyMatlDB(TextureDB textureDB, MaterialDB materialDB) {
        for (pyrosim.domain.appearance.Material material : this.d_appearanceCache.getAddedMaterials()) {
            materialDB.add(material);
        }
        return materialDB;
    }

    private pyrosim.domain.appearance.Material toMaterial(Color color, pyrosim.legacy_2012_1.domain.texture.Texture texture, TextureInfo textureInfo) {
        Image image = this.fromLegacyImage(texture.getImage());
        return this.toMaterial(color, image, textureInfo);
    }

    private pyrosim.domain.appearance.Material toMaterial(Color color, IImage iImage, TextureInfo textureInfo) {
        Texture texture = Texture.repeated(iImage, "uvset");
        MatAttrs matAttrs = new MatAttrs(IMatAttrs.DIFFUSE_TEXTURE, texture);
        matAttrs = matAttrs.applyColorToDiffuseAndOpacity(color);
        pyrosim.domain.appearance.Material material = new pyrosim.domain.appearance.Material(textureInfo.getTexID(), matAttrs, ConvertUtil.c(textureInfo.getWidth()), ConvertUtil.c(textureInfo.getHeight()));
        return this.d_appearanceCache.add(material);
    }

    private pyrosim.domain.FDSRun fromLegacyRunConfig(FDSRun fDSRun, pyrosim.domain.FDSRun fDSRun2) {
        if (fDSRun.mode == FDSRun.Mode.SINGLE) {
            fDSRun2 = new pyrosim.domain.FDSRun(FDSRun.Mode.SINGLE, fDSRun.fdsFilepath);
        } else if (fDSRun.mode == FDSRun.Mode.PARALLEL) {
            fDSRun2 = new pyrosim.domain.FDSRun(FDSRun.Mode.PARALLEL, fDSRun.fdsFilepath);
        } else if (fDSRun.mode == FDSRun.Mode.CLUSTER) {
            fDSRun2 = new pyrosim.domain.FDSRun(FDSRun.Mode.CLUSTER, fDSRun.fdsFilepath);
        }
        return fDSRun2;
    }

    private FDSClusterOptions fromLegacyClusterConfig(pyrosim.legacy_2012_1.domain.FDSClusterOptions fDSClusterOptions, FDSClusterOptions fDSClusterOptions2) {
        if (fDSClusterOptions == null) {
            return null;
        }
        fDSClusterOptions2 = new FDSClusterOptions(fDSClusterOptions.lastFDSLocation, fDSClusterOptions.hosts);
        return fDSClusterOptions2;
    }

    private ResultsArchive fromLegacyResultArch(pyrosim.legacy_2012_1.domain.ResultsArchive resultsArchive, ResultsArchive resultsArchive2) {
        for (ResultsArchive.Record record : resultsArchive.getAllRecords()) {
            ResultsArchive.IMethod iMethod = null;
            if (record.method instanceof ResultsArchive.Directory) {
                iMethod = ResultsArchive.DIRECTORY;
            } else if (record.method instanceof ResultsArchive.Uncompressed) {
                iMethod = ResultsArchive.UNCOMPRESSED;
            } else if (record.method instanceof ResultsArchive.Compressed) {
                iMethod = ResultsArchive.COMPRESSED;
            }
            resultsArchive2.addArchive(new ResultsArchive.Record(record.name, iMethod, record.dateCreated));
        }
        return resultsArchive2;
    }

    private void addUnableToLoadWarn(String string, String string2) {
        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unable to load %s %s."), string2, string), String.format(Intl.intl("%s removed from the model."), string)));
    }

    private void warnOnMixFrac(pyrosim.legacy_2012_1.domain.Serialized serialized) {
        if (!serialized.simParams.getMisc().getForceMixFracFlag()) {
            return;
        }
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
        arrayList.add(serialized.simParams);
        arrayList.addAll(serialized.obstructions.flatten());
        arrayList.addAll(serialized.grids.flatten());
        arrayList.addAll(Util.sort(serialized.zones));
        arrayList.addAll(Util.sort(serialized.exSpecs));
        Reaction reaction = serialized.reactions.getActiveReaction();
        if (reaction != null) {
            arrayList.add(reaction);
        }
        arrayList.addAll(serialized.devices.flatten());
        arrayList.add(serialized.boundaryOutput);
        arrayList.add(serialized.plot3d);
        arrayList.addAll(serialized.isosurfaces.flatten());
        arrayList.addAll(serialized.profs.flatten());
        arrayList.addAll(serialized.slices.flatten());
        arrayList.addAll(serialized.msrStats.flatten());
        arrayList.addAll(serialized.hvacSystem.flatten());
        DepSnapshot depSnapshot = FDSRenderer.collectDependedOns(arrayList);
        arrayList.addAll(depSnapshot.getAllDependedOn());
        boolean bl = false;
        boolean bl2 = false;
        for (IPyroObject iPyroObject : arrayList) {
            if (iPyroObject.invokesMixFrac()) {
                bl2 = true;
            }
            if (iPyroObject.isMixFracOnly()) {
                bl = true;
            }
            if (!bl2 || !bl) continue;
            break;
        }
        if (bl && !bl2) {
            this.d_warnings.addWarning(new Warning(Intl.intl("Writing a generic burner surface to force a reaction is no longer required in PyroSim."), Intl.intl("The Force Mixture Fraction Model flag has been removed.")));
        }
    }

    private void sortManagers(Serialized serialized) {
        ArrayList<pyrosim.domain.Composite> arrayList = new ArrayList<pyrosim.domain.Composite>(Hierarchy.flatten(PyroMod.getMembers(serialized, true), pyrosim.domain.Composite.class));
        for (pyrosim.domain.Composite composite : arrayList) {
            Class clazz = composite.getType();
            if (clazz.isAssignableFrom(pyrosim.domain.geom.FDSObject.class) || clazz.isAssignableFrom(Grid.class) || !INamed.class.isAssignableFrom(clazz)) continue;
            List<pyrosim.domain.IPyroObject> list = pyrosim.util.Util.sort(composite.getMembers());
            composite.reorder(list);
        }
    }
}

