/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.SolidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SpecInjList;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class CvtSolid {
    private static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    private static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    private static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    private static final String HRRPUA = "HRRPUA";
    private static final String FUEL_FRACTION = "FUEL_FRACTION";
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String E_COEFFICIENT = "E_COEFFICIENT";
    private static final String BACKING = "BACKING";
    private static final String MASS_FLUX_CRITICAL = "MASS_FLUX_CRITICAL";
    private static final String A = "A";
    private static final String E = "E";
    private static final String TMPWAL = "TMPWAL";
    private static final String TAU_Q = "TAU_Q";
    private static final String RAMP_Q = "RAMP_Q";
    private static final String HEAT_FLUX = "HEAT_FLUX";
    private static final String TMPWAL0 = "TMPWAL0";
    private static final String KS = "KS";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String C_P = "C_P";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String WALL_POINTS = "WALL_POINTS";
    private static final String DX_SOLID = "DX_SOLID";
    private static final String BURN_AWAY = "BURN_AWAY";
    private static final String TMPIGN = "TMPIGN";
    private static final String C_DELTA_RHO = "C_DELTA_RHO";
    private static final String PHASE = "PHASE";
    private static final String MOISTURE_FRACTION = "MOISTURE_FRACTION";
    private static final String POROSITY = "POROSITY";
    private static final String PARTICLES = "PARTICLES";
    private static final String PART_ID = "PART_ID";
    private static final String NPPC = "NPPC";

    private static double getUDVal(String string, UnitDouble unitDouble) {
        int n = Convert.fromLegacyUnitType(pyrosim.legacy_2006_2.domain.Material.getUnitType(string));
        return unitDouble.getValue(SIUS.unit(n));
    }

    private static SolidReaction.Rate getSolidReacRate(pyrosim.legacy_2006_2.domain.Material material, UnitDouble unitDouble, WarningReport warningReport) {
        SolidReaction.Rate rate;
        if (material.isDefined(A) || material.isDefined(E)) {
            UnitDouble unitDouble2 = Convert.getUD(material, A);
            UnitDouble unitDouble3 = Convert.getUD(material, E);
            double d = CvtSolid.getUDVal(A, unitDouble2);
            double d2 = unitDouble.getValue(SI.METER);
            unitDouble2 = SIUS.newud(d /= d2, 50);
            rate = new SolidReaction.Rate(1.0, 0.0, null, new SolidReaction.Rate.AESpec(unitDouble2, unitDouble3));
        } else {
            double d = 0.0;
            UnitDouble unitDouble4 = null;
            if (material.isDefined(TMPIGN)) {
                d = 1.0;
                unitDouble4 = Convert.getUD(material, TMPIGN);
            }
            rate = new SolidReaction.Rate(1.0, d, unitDouble4, new SolidReaction.Rate.RefSpec());
        }
        return rate;
    }

    public static ISurfDesc getDescCharringFuel(pyrosim.legacy_2006_2.domain.Material material, MaterialManager materialManager, ParticleInjection particleInjection, WarningReport warningReport) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        Object object2;
        UnitDouble unitDouble = Convert.getUD(material, HEAT_OF_VAPORIZATION);
        UnitDouble unitDouble2 = material.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(material, HEAT_OF_COMBUSTION) : null;
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(material, true, warningReport);
        UnitDouble unitDouble3 = thermalThickness.d_thickness;
        ThermalProps thermalProps = thermalThickness.d_thermalProps;
        ThermalProps thermalProps2 = Convert.getThermalPropsOfChar(material, true, warningReport);
        Material material2 = new Material(String.format(Intl.intl("%s_CHAR"), material.getName()), new SolidPyrolysis(null, new ArrayList<SolidReaction>(0)), thermalProps2);
        Util.autoRename(materialManager, material2);
        materialManager.add(material2);
        SolidReaction solidReaction = new SolidReaction(CvtSolid.getSolidReacRate(material, unitDouble3, warningReport), new ReacByproducts(0.5, 0.0, 0.5, material2, unitDouble));
        Material material3 = new Material(String.format(Intl.intl("%s_VIRGIN"), material.getName()), new SolidPyrolysis(unitDouble2, Arrays.asList(solidReaction)), thermalProps);
        Util.autoRename(materialManager, material3);
        materialManager.add(material3);
        double d = Convert.getD(material, MOISTURE_FRACTION, 0.0);
        double d2 = 1.0 - d;
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        arrayList.add(new SurfComposition.SurfLayer.SurfComponent(d2, material3));
        if (d > 0.0) {
            object2 = Intl.intl("Water");
            object = new ThermalProps();
            serializable2 = new SolidReaction(new SolidReaction.Rate(1.0, 1.0, new UnitDouble(100.0, SI.CELSIUS), new SolidReaction.Rate.AESpec(SIUS.newud(1.0E20, 50), SIUS.newud(162000.0, 54))), new ReacByproducts(0.0, 1.0, 0.0, null, SIUS.newud(2260.0, 47)));
            serializable = new Material((String)object2, new SolidPyrolysis(null, Arrays.asList(serializable2)), new ThermalProps(new IHeatBasedValue.Constant(SIUS.newud(0.6, 19)), SIUS.newud(1000.0, 4), new IHeatBasedValue.Constant(SIUS.newud(4.19, 11)), 1.0, ((ThermalProps)object).d_absorptionCoeff));
            Material material4 = (Material)materialManager.get((String)object2);
            if (material4 != null && material4.equals(serializable)) {
                serializable = material4;
            } else {
                Util.autoRename(materialManager, serializable);
                materialManager.add((IPyroObject)serializable);
            }
            arrayList.add(new SurfComposition.SurfLayer.SurfComponent(d, (Material)serializable));
        }
        object2 = new SurfComposition.SurfLayer(unitDouble3, arrayList);
        object = (String)material.getValue(BACKING);
        serializable2 = material.isDefined(TMPWAL0) ? Convert.getUD(material, TMPWAL0) : null;
        serializable = new SurfComposition((UnitDouble)serializable2, TimeFunction.newDefault(), Convert.getBacking((String)object), false, null, Arrays.asList(object2));
        boolean bl = Convert.getB(material, BURN_AWAY, false);
        UnitDouble unitDouble4 = Convert.getUD(material, SURFACE_DENSITY, null);
        LayeredSurfDesc layeredSurfDesc = new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, new Fuel.MaterialReac(), (SurfComposition)serializable, null, particleInjection, bl, null, unitDouble4);
        Convert.checkForUnusedMatFieldsFromUnused(material, warningReport, BURNING_RATE_MAX, MASS_FLUX_CRITICAL, FUEL_FRACTION, ALPHA, WALL_POINTS, DX_SOLID);
        warningReport.addWarning(new Warning(String.format(Intl.intl("SURF: %s"), material.getName()), Intl.intl("Converted from a charring fuel.  Please review.")));
        return layeredSurfDesc;
    }

    public static ISurfDesc getDescThermoplastic(pyrosim.legacy_2006_2.domain.Material material, MaterialManager materialManager, ParticleInjection particleInjection, boolean bl, WarningReport warningReport) {
        UnitDouble unitDouble = Convert.getUD(material, HEAT_OF_VAPORIZATION);
        UnitDouble unitDouble2 = material.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(material, HEAT_OF_COMBUSTION) : null;
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(material, bl, warningReport);
        double d = Convert.getD(material, FUEL_FRACTION, 0.0);
        SolidReaction solidReaction = new SolidReaction(CvtSolid.getSolidReacRate(material, thermalThickness.d_thickness, warningReport), new ReacByproducts(d, 0.0, 0.0, null, unitDouble));
        Material material2 = new Material(material.getName() + "_MATL", new SolidPyrolysis(unitDouble2, Arrays.asList(solidReaction)), thermalThickness.d_thermalProps);
        Util.autoRename(materialManager, material2);
        materialManager.add(material2);
        SurfComposition.SurfLayer surfLayer = new SurfComposition.SurfLayer(thermalThickness.d_thickness, Arrays.asList(new SurfComposition.SurfLayer.SurfComponent(1.0, material2)));
        String string = (String)material.getValue(BACKING);
        UnitDouble unitDouble3 = material.isDefined(TMPWAL0) ? Convert.getUD(material, TMPWAL0) : null;
        SurfComposition surfComposition = new SurfComposition(unitDouble3, TimeFunction.newDefault(), Convert.getBacking(string), false, null, Arrays.asList(surfLayer));
        boolean bl2 = Convert.getB(material, BURN_AWAY, false);
        UnitDouble unitDouble4 = Convert.getUD(material, SURFACE_DENSITY, null);
        LayeredSurfDesc layeredSurfDesc = new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, new Fuel.MaterialReac(), surfComposition, null, particleInjection, bl2, null, unitDouble4);
        Convert.checkForUnusedMatFieldsFromUnused(material, warningReport, BURNING_RATE_MAX, MASS_FLUX_CRITICAL, ALPHA, WALL_POINTS, DX_SOLID);
        return layeredSurfDesc;
    }

    public static ISurfDesc getDescForcedHRR(pyrosim.legacy_2006_2.domain.Material material, MaterialManager materialManager, ParticleInjection particleInjection, boolean bl, WarningReport warningReport) {
        String string = (String)material.getValue(BACKING);
        UnitDouble unitDouble = material.isDefined(TMPWAL0) ? Convert.getUD(material, TMPWAL0) : null;
        UnitDouble unitDouble2 = material.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(material, HEAT_OF_COMBUSTION) : null;
        SolidPyrolysis solidPyrolysis = new SolidPyrolysis(unitDouble2, new ArrayList<SolidReaction>(0));
        UnitDouble unitDouble3 = Convert.getUD(material, TMPIGN);
        UnitDouble unitDouble4 = Convert.getUD(material, E_COEFFICIENT);
        UnitDouble unitDouble5 = material.isDefined(HEAT_OF_VAPORIZATION) ? Convert.getUD(material, HEAT_OF_VAPORIZATION) : null;
        UnitDouble unitDouble6 = Convert.getUD(material, HRRPUA);
        TimeFunction timeFunction = Convert.tfFromMaterial(material, TAU_Q, RAMP_Q);
        HeatRelease.HRRType hRRType = new HeatRelease.HRRType(unitDouble6, timeFunction);
        Fuel.ManualReac manualReac = new Fuel.ManualReac(new HeatRelease(hRRType, unitDouble4), unitDouble5, new Fuel.ManualReac.TemperatureIgnite(unitDouble3));
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(material, bl, warningReport);
        Material material2 = new Material(material.getName() + "_MATL", solidPyrolysis, thermalThickness.d_thermalProps);
        Util.autoRename(materialManager, material2);
        materialManager.add(material2);
        List<SurfComposition.SurfLayer.SurfComponent> list = Arrays.asList(new SurfComposition.SurfLayer.SurfComponent(1.0, material2));
        List<SurfComposition.SurfLayer> list2 = Arrays.asList(new SurfComposition.SurfLayer(thermalThickness.d_thickness, list));
        SurfComposition surfComposition = new SurfComposition(unitDouble, TimeFunction.newDefault(), Convert.getBacking(string), false, null, list2);
        SpecInjList specInjList = null;
        boolean bl2 = Convert.getB(material, BURN_AWAY, false);
        UnitDouble unitDouble7 = Convert.getUD(material, SURFACE_DENSITY, null);
        Convert.checkForUnusedMatFieldsFromUnused(material, warningReport, FUEL_FRACTION, POROSITY, ALPHA, WALL_POINTS, DX_SOLID);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, manualReac, surfComposition, specInjList, particleInjection, bl2, null, unitDouble7);
    }

    public static ISurfDesc getDescNonFlammable(pyrosim.legacy_2006_2.domain.Material material, MaterialManager materialManager, ParticleInjection particleInjection, boolean bl, WarningReport warningReport) {
        String string = (String)material.getValue(BACKING);
        UnitDouble unitDouble = material.isDefined(TMPWAL0) ? Convert.getUD(material, TMPWAL0) : null;
        SolidPyrolysis solidPyrolysis = new SolidPyrolysis(null, new ArrayList<SolidReaction>(0));
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(material, bl, warningReport);
        Material material2 = new Material(material.getName() + "_MATL", solidPyrolysis, thermalThickness.d_thermalProps);
        Util.autoRename(materialManager, material2);
        materialManager.add(material2);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        arrayList.add(new SurfComposition.SurfLayer.SurfComponent(1.0, material2));
        ArrayList<SurfComposition.SurfLayer> arrayList2 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList2.add(new SurfComposition.SurfLayer(thermalThickness.d_thickness, arrayList));
        SurfComposition surfComposition = new SurfComposition(unitDouble, TimeFunction.newDefault(), Convert.getBacking(string), false, null, arrayList2);
        Fuel.MaterialReac materialReac = new Fuel.MaterialReac();
        SpecInjList specInjList = null;
        boolean bl2 = Convert.getB(material, BURN_AWAY, false);
        UnitDouble unitDouble2 = Convert.getUD(material, SURFACE_DENSITY, null);
        Convert.checkForUnusedMatFieldsFromUsed(material, warningReport, BACKING, EMISSIVITY, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL0, KS, RAMP_KS, C_P, RAMP_C_P, DELTA, DENSITY, C_DELTA_RHO, BURN_AWAY, SURFACE_DENSITY);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, materialReac, surfComposition, specInjList, particleInjection, bl2, null, unitDouble2);
    }

    public static ISurfDesc getDescHeater(pyrosim.legacy_2006_2.domain.Material material, ParticleInjection particleInjection, WarningReport warningReport) {
        TempRegulation tempRegulation = CvtSolid.getTempRegulation(material, warningReport);
        Convert.checkForUnusedMatFieldsFromUsed(material, warningReport, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL, HEAT_FLUX, TAU_Q, RAMP_Q, EMISSIVITY);
        return new ConstantTempSurfDesc(tempRegulation, particleInjection);
    }

    public static TempRegulation getTempRegulation(pyrosim.legacy_2006_2.domain.Material material, WarningReport warningReport) {
        UnitDouble unitDouble = material.isDefined(TMPWAL) ? Convert.getUD(material, TMPWAL) : null;
        UnitDouble unitDouble2 = Convert.getUD(material, HEAT_FLUX);
        TimeFunction timeFunction = Convert.tfFromMaterial(material, TAU_Q, RAMP_Q);
        double d = Convert.getD(material, EMISSIVITY, 0.0);
        return TempRegulation.newFixedHeatFluxTR(unitDouble, unitDouble2, timeFunction, d);
    }
}

