/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.util.ArrayList;
import org.jscience.physics.units.SI;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.IPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.legacy_2012_1.domain.boundcond.mat.LiquidReaction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.Material;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.mat.ReacByproducts;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Fuel;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISlip;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfComposition;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.WarningReport;

public class CvtLiquid {
    private static final String HEAT_OF_VAPORIZATION = "HEAT_OF_VAPORIZATION";
    private static final String HEAT_OF_COMBUSTION = "HEAT_OF_COMBUSTION";
    private static final String BURNING_RATE_MAX = "BURNING_RATE_MAX";
    private static final String FUEL_FRACTION = "FUEL_FRACTION";
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String BACKING = "BACKING";
    private static final String TMPWAL0 = "TMPWAL0";
    private static final String KS = "KS";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String C_P = "C_P";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String SURFACE_DENSITY = "SURFACE_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String WALL_POINTS = "WALL_POINTS";
    private static final String DX_SOLID = "DX_SOLID";
    private static final String BURN_AWAY = "BURN_AWAY";
    private static final String TMPIGN = "TMPIGN";
    private static final String PHASE = "PHASE";
    private static final String PARTICLES = "PARTICLES";
    private static final String PART_ID = "PART_ID";
    private static final String NPPC = "NPPC";

    public static ISurfDesc getDescLiqFuel(pyrosim.legacy_2006_2.domain.Material material, MaterialManager materialManager, ParticleInjection particleInjection, WarningReport warningReport) {
        UnitDouble unitDouble = Convert.getUD(material, TMPWAL0);
        String string = (String)material.getValue(BACKING);
        UnitDouble unitDouble2 = material.isDefined(HEAT_OF_VAPORIZATION) ? Convert.getUD(material, HEAT_OF_VAPORIZATION) : null;
        UnitDouble unitDouble3 = material.isDefined(HEAT_OF_COMBUSTION) ? Convert.getUD(material, HEAT_OF_COMBUSTION) : null;
        UnitDouble unitDouble4 = material.isDefined(TMPIGN) ? Convert.getUD(material, TMPIGN) : new UnitDouble(100.0, SI.CELSIUS);
        double d = Convert.getD(material, FUEL_FRACTION, 0.0);
        IPyrolysis iPyrolysis = CvtLiquid.getLiquidPyrolysis(unitDouble4, unitDouble2, unitDouble3, d, 0.0);
        Convert.ThermalThickness thermalThickness = Convert.getThermalProps(material, true, warningReport);
        Material material2 = new Material(material.getName() + "_MATL", iPyrolysis, thermalThickness.d_thermalProps);
        materialManager.add(material2);
        ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>();
        arrayList.add(new SurfComposition.SurfLayer.SurfComponent(1.0, material2));
        ArrayList<SurfComposition.SurfLayer> arrayList2 = new ArrayList<SurfComposition.SurfLayer>();
        arrayList2.add(new SurfComposition.SurfLayer(thermalThickness.d_thickness, arrayList));
        SurfComposition surfComposition = new SurfComposition(unitDouble, TimeFunction.newDefault(), Convert.getBacking(string), false, null, arrayList2);
        boolean bl = Convert.getB(material, BURN_AWAY, false);
        UnitDouble unitDouble5 = Convert.getUD(material, SURFACE_DENSITY, null);
        Fuel.MaterialReac materialReac = new Fuel.MaterialReac();
        Convert.checkForUnusedMatFieldsFromUsed(material, warningReport, HEAT_OF_VAPORIZATION, HEAT_OF_COMBUSTION, BACKING, EMISSIVITY, PARTICLES, NPPC, PART_ID, PHASE, TMPWAL0, KS, RAMP_KS, C_P, RAMP_C_P, DELTA, DENSITY, TMPIGN, FUEL_FRACTION, BURN_AWAY, SURFACE_DENSITY);
        return new LayeredSurfDesc(LayeredSurfDesc.Geometry.FLAT, ISlip.DEFAULT, materialReac, surfComposition, null, particleInjection, bl, null, unitDouble5);
    }

    private static IPyrolysis getLiquidPyrolysis(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, double d, double d2) {
        LiquidReaction.Rate rate = new LiquidReaction.Rate(unitDouble);
        if (unitDouble2 == null) {
            unitDouble2 = SIUS.newud(0.0, 46);
        }
        ReacByproducts reacByproducts = new ReacByproducts(d, d2, 0.0, null, unitDouble2);
        LiquidPyrolysis liquidPyrolysis = new LiquidPyrolysis();
        LiquidReaction liquidReaction = new LiquidReaction(rate, reacByproducts);
        return new LiquidPyrolysis(unitDouble3, liquidPyrolysis.d_iniVaporFlux, liquidReaction);
    }
}

