/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.util.Vector;
import pyrosim.io.pyrosimV4V5.Convert;
import pyrosim.io.pyrosimV4V5.CvtSolid;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.AirFlow;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.WarningReport;

public class CvtFanWind {
    private static final String TMPWAL = "TMPWAL";
    private static final String TAU_Q = "TAU_Q";
    private static final String RAMP_Q = "RAMP_Q";
    private static final String VEL = "VEL";
    private static final String VOLUME_FLUX = "VOLUME_FLUX";
    private static final String VEL_T = "VEL_T";
    private static final String TAU_V = "TAU_V";
    private static final String RAMP_V = "RAMP_V";
    private static final String VBC = "VBC";
    private static final String PROFILE = "PROFILE";
    private static final String PLE = "PLE";
    private static final String Z0 = "Z0";

    public static ISurfDesc cvtFanWind(Material material, MaterialManager materialManager, ParticleList particleList, WarningReport warningReport) {
        UnitDouble unitDouble;
        UnitDouble unitDouble2 = unitDouble = material.isDefined(VOLUME_FLUX) ? Convert.getUD(material, VOLUME_FLUX) : Convert.getUD(material, VEL);
        if (unitDouble.getValueNoUnit() < 0.0) {
            return CvtFanWind.createSupply(material, particleList, warningReport);
        }
        return CvtFanWind.createIntake(material, particleList, warningReport);
    }

    public static AirFlow getAirFlow(Material material, WarningReport warningReport) {
        AirFlow.ValRate valRate;
        Object object;
        Vector<UnitDouble> vector = Convert.getVUD(material, VEL_T);
        UnitDouble unitDouble = null;
        UnitDouble unitDouble2 = null;
        if (vector != null) {
            unitDouble = vector.get(0);
            unitDouble2 = vector.get(1);
        } else {
            unitDouble = SIUS.newud(0.0, 8);
            unitDouble2 = SIUS.newud(0.0, 8);
        }
        TimeFunction timeFunction = Convert.tfFromMaterial(material, TAU_V, RAMP_V);
        if (material.isDefined(VEL)) {
            object = Convert.getUD(material, VEL);
            if (((UnitDouble)object).getValueNoUnit() < 0.0) {
                object = ((UnitDouble)object).negate();
            }
            valRate = new AirFlow.NormalVel((UnitDouble)object, unitDouble, unitDouble2, timeFunction, null);
        } else {
            object = Convert.getUD(material, VOLUME_FLUX);
            if (((UnitDouble)object).getValueNoUnit() < 0.0) {
                object = ((UnitDouble)object).negate();
            }
            valRate = new AirFlow.VolumeFlux((UnitDouble)object, unitDouble, unitDouble2, timeFunction, null);
        }
        object = (String)material.getValue(PROFILE);
        AirFlow.IProfile iProfile = null;
        if (object != null && ((String)object).equals("PARABOLIC")) {
            iProfile = new AirFlow.ParabolicProf();
        } else if (object != null && ((String)object).equals("ATMOSPHERIC")) {
            double d = Convert.getD(material, PLE, 0.0);
            UnitDouble unitDouble3 = Convert.getUD(material, Z0);
            iProfile = new AirFlow.AtmosphericProf(d, unitDouble3);
        } else {
            iProfile = new AirFlow.TopHatProf();
        }
        return new AirFlow(valRate, iProfile, null);
    }

    public static ISurfDesc createSupply(Material material, ParticleList particleList, WarningReport warningReport) {
        TempRegulation tempRegulation = CvtSolid.getTempRegulation(material, warningReport);
        AirFlow airFlow = CvtFanWind.getAirFlow(material, warningReport);
        ParticleInjection particleInjection = Convert.getPartInj(material, particleList);
        return new BlowerSurfDesc(tempRegulation, airFlow, particleInjection);
    }

    public static ISurfDesc createIntake(Material material, ParticleList particleList, WarningReport warningReport) {
        AirFlow airFlow = CvtFanWind.getAirFlow(material, warningReport);
        Convert.checkForUnusedMatFieldsFromUnused(material, warningReport, TMPWAL, TAU_Q, RAMP_Q);
        return new InFlowSurfDesc(airFlow);
    }
}

