/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.pyrosimV4V5;

import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.io.pyrosimV4V5.CvtFanWind;
import pyrosim.io.pyrosimV4V5.CvtLiquid;
import pyrosim.io.pyrosimV4V5.CvtSolid;
import pyrosim.legacy_2006_2.DirectionVector;
import pyrosim.legacy_2006_2.Serialized;
import pyrosim.legacy_2006_2.TextureDB;
import pyrosim.legacy_2006_2.UnitBox3D;
import pyrosim.legacy_2006_2.UnitPoint2D;
import pyrosim.legacy_2006_2.domain.AUnalignedFDSObject;
import pyrosim.legacy_2006_2.domain.Activatable;
import pyrosim.legacy_2006_2.domain.AlignedBlock;
import pyrosim.legacy_2006_2.domain.AlignedHole;
import pyrosim.legacy_2006_2.domain.BNDFList;
import pyrosim.legacy_2006_2.domain.BNDFRecord;
import pyrosim.legacy_2006_2.domain.BufferModelImage;
import pyrosim.legacy_2006_2.domain.FDSComposite;
import pyrosim.legacy_2006_2.domain.FDSConvexPoly;
import pyrosim.legacy_2006_2.domain.FileModelImage;
import pyrosim.legacy_2006_2.domain.Floor;
import pyrosim.legacy_2006_2.domain.HeadRecord;
import pyrosim.legacy_2006_2.domain.HeatActivationEvent;
import pyrosim.legacy_2006_2.domain.HeatActivationEventList;
import pyrosim.legacy_2006_2.domain.HeatDetector;
import pyrosim.legacy_2006_2.domain.HeatDetectorList;
import pyrosim.legacy_2006_2.domain.Hole;
import pyrosim.legacy_2006_2.domain.IsofList;
import pyrosim.legacy_2006_2.domain.IsofRecord;
import pyrosim.legacy_2006_2.domain.Material;
import pyrosim.legacy_2006_2.domain.MaterialList;
import pyrosim.legacy_2006_2.domain.MaterialProfile;
import pyrosim.legacy_2006_2.domain.ModelImage;
import pyrosim.legacy_2006_2.domain.PL3DRecord;
import pyrosim.legacy_2006_2.domain.PartList;
import pyrosim.legacy_2006_2.domain.PartRecord;
import pyrosim.legacy_2006_2.domain.PipeRecord;
import pyrosim.legacy_2006_2.domain.RampRecord;
import pyrosim.legacy_2006_2.domain.Reaction;
import pyrosim.legacy_2006_2.domain.Slab;
import pyrosim.legacy_2006_2.domain.SlcfList;
import pyrosim.legacy_2006_2.domain.SlcfRecord;
import pyrosim.legacy_2006_2.domain.SmodList;
import pyrosim.legacy_2006_2.domain.SmodRecord;
import pyrosim.legacy_2006_2.domain.SolidPhaseQuantitiesList;
import pyrosim.legacy_2006_2.domain.SprkList;
import pyrosim.legacy_2006_2.domain.SprkRecord;
import pyrosim.legacy_2006_2.domain.TextureInfo;
import pyrosim.legacy_2006_2.domain.ThcpList;
import pyrosim.legacy_2006_2.domain.ThcpRecord;
import pyrosim.legacy_2006_2.domain.TimeActivationEvent;
import pyrosim.legacy_2006_2.domain.TimeActivationEventList;
import pyrosim.legacy_2006_2.domain.Vent;
import pyrosim.legacy_2006_2.domain.Wall;
import pyrosim.legacy_2006_2.io.FDSInputRecord;
import pyrosim.legacy_2006_2.thunderheadeng.gui.ADomainObject;
import pyrosim.legacy_2006_2.thunderheadeng.scene3d.nativebuffered.Image;
import pyrosim.legacy_2012_1.domain.APyroObject;
import pyrosim.legacy_2012_1.domain.Composite;
import pyrosim.legacy_2012_1.domain.ExSpecList;
import pyrosim.legacy_2012_1.domain.FloorManager;
import pyrosim.legacy_2012_1.domain.GeomUtil;
import pyrosim.legacy_2012_1.domain.Grid;
import pyrosim.legacy_2012_1.domain.GridList;
import pyrosim.legacy_2012_1.domain.IHeatBasedValue;
import pyrosim.legacy_2012_1.domain.INamed;
import pyrosim.legacy_2012_1.domain.IPyroObject;
import pyrosim.legacy_2012_1.domain.SimParams;
import pyrosim.legacy_2012_1.domain.TimeBasedValue;
import pyrosim.legacy_2012_1.domain.TimeFunction;
import pyrosim.legacy_2012_1.domain.boundcond.mat.MaterialManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Backing;
import pyrosim.legacy_2012_1.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.HeatRelease;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ISurfDesc;
import pyrosim.legacy_2012_1.domain.boundcond.surf.ParticleInjection;
import pyrosim.legacy_2012_1.domain.boundcond.surf.PredefSurf;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfDescStatic;
import pyrosim.legacy_2012_1.domain.boundcond.surf.Surface;
import pyrosim.legacy_2012_1.domain.boundcond.surf.SurfaceManager;
import pyrosim.legacy_2012_1.domain.boundcond.surf.TempRegulation;
import pyrosim.legacy_2012_1.domain.controls.AControl;
import pyrosim.legacy_2012_1.domain.controls.ALogicOp;
import pyrosim.legacy_2012_1.domain.controls.ControlBridge;
import pyrosim.legacy_2012_1.domain.controls.ControlMgr;
import pyrosim.legacy_2012_1.domain.controls.CustomCtrl;
import pyrosim.legacy_2012_1.domain.controls.LatchCtrl;
import pyrosim.legacy_2012_1.domain.controls.NotOp;
import pyrosim.legacy_2012_1.domain.controls.OrOp;
import pyrosim.legacy_2012_1.domain.devices.DeviceManager;
import pyrosim.legacy_2012_1.domain.devices.IDevice;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeDetector;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.legacy_2012_1.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.legacy_2012_1.domain.devices.detectors.Timer;
import pyrosim.legacy_2012_1.domain.devices.measurers.AABoxMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.AMeasuringDevc;
import pyrosim.legacy_2012_1.domain.devices.measurers.Clock;
import pyrosim.legacy_2012_1.domain.devices.measurers.FlowMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.GasPointMeasurer;
import pyrosim.legacy_2012_1.domain.devices.measurers.Thermocouple;
import pyrosim.legacy_2012_1.domain.devices.sprayers.DryPipe;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModel;
import pyrosim.legacy_2012_1.domain.devices.sprayers.SprayModelMgr;
import pyrosim.legacy_2012_1.domain.devices.sprayers.Sprinkler;
import pyrosim.legacy_2012_1.domain.geom.FDSObject;
import pyrosim.legacy_2012_1.domain.geom.FreePointLoc;
import pyrosim.legacy_2012_1.domain.geom.IObstruction;
import pyrosim.legacy_2012_1.domain.geom.ModelComposite;
import pyrosim.legacy_2012_1.domain.geom.Obstruction;
import pyrosim.legacy_2012_1.domain.geom.PartCloud;
import pyrosim.legacy_2012_1.domain.managers.Util;
import pyrosim.legacy_2012_1.domain.output.Boundaries;
import pyrosim.legacy_2012_1.domain.output.Isosurface;
import pyrosim.legacy_2012_1.domain.output.IsosurfaceMgr;
import pyrosim.legacy_2012_1.domain.output.PlanarSlice;
import pyrosim.legacy_2012_1.domain.output.Plot3d;
import pyrosim.legacy_2012_1.domain.output.SliceList;
import pyrosim.legacy_2012_1.domain.particle.ConstColoring;
import pyrosim.legacy_2012_1.domain.particle.DropletColoring;
import pyrosim.legacy_2012_1.domain.particle.FuelPartDesc;
import pyrosim.legacy_2012_1.domain.particle.FuelPyrolysis;
import pyrosim.legacy_2012_1.domain.particle.GenericPartDesc;
import pyrosim.legacy_2012_1.domain.particle.IColoring;
import pyrosim.legacy_2012_1.domain.particle.IParticleDesc;
import pyrosim.legacy_2012_1.domain.particle.Output;
import pyrosim.legacy_2012_1.domain.particle.Particle;
import pyrosim.legacy_2012_1.domain.particle.ParticleList;
import pyrosim.legacy_2012_1.domain.particle.Pyrolysis;
import pyrosim.legacy_2012_1.domain.particle.SizeDistribution;
import pyrosim.legacy_2012_1.domain.particle.ThermalProps;
import pyrosim.legacy_2012_1.domain.particle.TracerPartDesc;
import pyrosim.legacy_2012_1.domain.particle.WaterPartDesc;
import pyrosim.legacy_2012_1.domain.quantity.IQuantity;
import pyrosim.legacy_2012_1.domain.quantity.ObjectQuantity;
import pyrosim.legacy_2012_1.domain.quantity.Quantity;
import pyrosim.legacy_2012_1.domain.quantity.StaticQuantity;
import pyrosim.legacy_2012_1.domain.ramp.IRampInput;
import pyrosim.legacy_2012_1.domain.ramp.Ramp;
import pyrosim.legacy_2012_1.domain.ramp.RampInputs;
import pyrosim.legacy_2012_1.domain.reaction.Byproducts;
import pyrosim.legacy_2012_1.domain.reaction.FireSuppression;
import pyrosim.legacy_2012_1.domain.reaction.Fuel;
import pyrosim.legacy_2012_1.domain.reaction.Reaction;
import pyrosim.legacy_2012_1.domain.reaction.ReactionList;
import pyrosim.legacy_2012_1.domain.reaction.Soot;
import pyrosim.legacy_2012_1.domain.signals.IInPin;
import pyrosim.legacy_2012_1.domain.signals.IOutPin;
import pyrosim.legacy_2012_1.domain.tasks.FillGridsWithPartsTask;
import pyrosim.legacy_2012_1.domain.texture.Texture;
import pyrosim.legacy_2012_1.geom.Geometry;
import pyrosim.legacy_2012_1.io.fds.SPKReader;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.Util3D;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AABoxGeom;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AARectangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.AFace;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.BGImageXform;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.ExtrudedPoly;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.LineSeg;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.NGon;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Quad;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.Triangle;
import pyrosim.legacy_2012_1.thunderheadeng.geometry.objs.WallGeom;
import pyrosim.legacy_2012_1.thunderheadeng.image.ImageManager;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitAABox;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitDouble;
import pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint3D;
import pyrosim.legacy_2012_1.thunderheadeng.util.IHasher;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.LinkedIdentityHashSet;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;
import pyrosim.legacy_2012_1.thunderheadeng.util.theHashMap;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;
import pyrosim.legacy_2012_1.unitsystem.SIUS;
import thunderheadeng.util.Warning;
import thunderheadeng.util.WarningReport;

public class Convert {
    private WarningReport<Warning> d_warnings;
    private Map<IOutPin, List<IInPin>> d_ctrlMap = new LinkedHashMap<IOutPin, List<IInPin>>();
    private final File d_dbDir;
    private static final String EMISSIVITY = "EMISSIVITY";
    private static final String KS = "KS";
    private static final String KS_CHAR = "KS_CHAR";
    private static final String RAMP_KS = "RAMP_KS";
    private static final String RAMP_KS_CHAR = "RAMP_KS_CHAR";
    private static final String C_P = "C_P";
    private static final String C_P_CHAR = "C_P_CHAR";
    private static final String RAMP_C_P = "RAMP_C_P";
    private static final String RAMP_C_P_CHAR = "RAMP_C_P_CHAR";
    private static final String DELTA = "DELTA";
    private static final String DENSITY = "DENSITY";
    private static final String CHAR_DENSITY = "CHAR_DENSITY";
    private static final String ALPHA = "ALPHA";
    private static final String C_DELTA_RHO = "C_DELTA_RHO";
    private static final int PP_INERT = 0;
    private static final int PP_ADIABATIC = 1;
    private static final int PP_BURNER = 2;
    private static final int PP_FANWIND = 3;
    private static final int PP_FLAM_SOLID = 4;
    private static final int PP_FLAM_SOLID_CONST = 5;
    private static final int PP_NON_FLAM_SOLID = 6;
    private static final int PP_LIQ_FUEL = 7;
    private static final int PP_CHAR_FUEL = 8;
    private static final int PP_LIQ_THERMOPLASTIC = 9;
    private static final int PP_CHAR_THERMOPLASTIC = 10;
    private static final int PP_UNKNOWN = -1;
    private Map<String, Integer> PP_LOOKUP = this.getPPLookup();
    private static final int BC_FIXED_TEMP = 0;
    private static final int BC_FIXED_FLUX = 1;
    private static final int BC_THERM_THICK = 2;
    private static final int BC_THERM_THIN = 3;
    private static final int BC_UNDEFINED = -1;
    private Map<String, Integer> d_bcMap = Convert.getBCMap();
    private static final int ACTIVATE = 0;
    private static final int DEACTIVATE = 1;
    private final IObjectFilter<Surface> ACCEPT_NONE_FILTER = new IObjectFilter<Surface>(){

        @Override
        public boolean shouldFilter(Surface surface) {
            return true;
        }
    };
    private static final String ANGLE_INCREMENT = "ANGLE_INCREMENT";
    private static final String RADTMP = "RADTMP";
    private static final String KAPPA0 = "KAPPA0";
    private static final String CH4_BANDS = "CH4_BANDS";
    private static final String WIDE_BAND_MODEL = "WIDE_BAND_MODEL";
    private static final String NMIEANG = "NMIEANG";
    private static final String NUMBER_RADIATION_ANGLES = "NUMBER_RADIATION_ANGLES";
    private static final String PATH = "PATH";
    private static final String TIME_STEP_INCREMENT = "TIME_STEP_INCREMENT";
    private final Map<String, IQuantity> d_gasPhaseMap = this.getGasPhaseMap();
    private final Map<String, IQuantity> d_intQuanMap = this.getIntegratedQuantities();
    private Map<String, SPKReader.SPKResult> d_sprkParses = new HashMap<String, SPKReader.SPKResult>();
    private final Map<String, IQuantity> d_solidPhaseMap = this.getSolidPhaseMap();

    public Convert(File file, WarningReport<Warning> warningReport) {
        this.d_dbDir = file;
        this.d_warnings = warningReport;
    }

    public pyrosim.legacy_2012_1.domain.Serialized fromLegacy(pyrosim.legacy_2012_1.domain.Serialized serialized, Serialized serialized2) {
        ModelComposite modelComposite;
        serialized.initDefaults();
        this.fromLegacy(serialized.simParams, serialized2.d_headRecord);
        this.fromLegacy(serialized.textures, serialized2.d_textures);
        this.fromLegacy(serialized.grids, serialized2.d_grids, serialized2.d_synchronized);
        this.fromLegacy(serialized.floors, serialized2.d_floors);
        this.fromLegacy(serialized.particles, serialized2.d_partList, serialized2.d_partDtpar);
        this.fromLegacy(serialized.simParams, serialized2);
        this.fromLegacy(serialized.reactions, serialized2.d_reactions, serialized2.d_reaction, serialized.simParams.getRadiTransport());
        IdentityHashMap<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> identityHashMap = new IdentityHashMap<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector>();
        DryPipe dryPipe = this.fromLegacy(serialized.devices, serialized2.d_pipeRecord);
        this.fromLegacy(serialized.devices, serialized.smokeLinkModels, serialized2.d_smodList);
        this.fromLegacy(serialized.devices, serialized, serialized2.d_thcpList);
        this.fromLegacy(serialized.devices, identityHashMap, serialized.heatLinkModels, serialized2.d_heatDetectors);
        this.fromLegacy(serialized.devices, serialized.particles, serialized.sprkLinkModels, serialized.sprayModels, dryPipe, serialized2.d_sprkList);
        this.fromLegacy(serialized.boundaryOutput, serialized, serialized2.d_bndfList);
        this.fromLegacy(serialized.plot3d, serialized, serialized2.d_pl3dRecord);
        this.fromLegacy(serialized.isosurfaces, serialized, serialized2.d_isofList);
        this.fromLegacy(serialized.slices, serialized, serialized2.d_slcfList);
        serialized.unprocessedRecords = serialized2.d_unprocessedRecords;
        this.fromLegacy(serialized.surfmgr, serialized.matmgr, serialized.particles, serialized2.d_materials);
        serialized.obstructions = modelComposite = this.fromLegacy(serialized2.d_walls, serialized.devices, identityHashMap, serialized2.d_materials, serialized.surfmgr);
        this.extractParticleClouds(serialized.particles, serialized2.d_partList, modelComposite, serialized.grids);
        this.createControls(serialized.controls);
        return serialized;
    }

    public static UnitDouble fromLegacy(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble, int n) {
        if (unitDouble == null) {
            return null;
        }
        Unit unit = SIUS.unit(n);
        if (unitDouble.getUnit() != null) {
            if (unit.isCompatible(unitDouble.getUnit())) {
                return new UnitDouble(unitDouble.getValueNoUnit(), unitDouble.getUnit());
            }
            System.err.println("Trying to convert to an incompatible unit:" + unitDouble.getUnit() + "->" + unit);
            return new UnitDouble(unitDouble.getValueNoUnit(), unit);
        }
        System.err.println("Assuming unit of " + unit);
        return new UnitDouble(unitDouble.getValueNoUnit(), unit);
    }

    public static UnitDouble[] fromLegacy(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble[] unitDoubleArray, int n) {
        if (unitDoubleArray == null) {
            return null;
        }
        UnitDouble[] unitDoubleArray2 = new UnitDouble[unitDoubleArray.length];
        for (int i = 0; i < unitDoubleArray2.length; ++i) {
            unitDoubleArray2[i] = Convert.fromLegacy(unitDoubleArray[i], n);
        }
        return unitDoubleArray2;
    }

    private static UnitPoint3D[] fromLegacy(pyrosim.legacy_2006_2.UnitPoint3D[] unitPoint3DArray, int n) {
        if (unitPoint3DArray == null) {
            return null;
        }
        UnitPoint3D[] unitPoint3DArray2 = new UnitPoint3D[unitPoint3DArray.length];
        for (int i = 0; i < unitPoint3DArray2.length; ++i) {
            unitPoint3DArray2[i] = Convert.fromLegacy(unitPoint3DArray[i], n);
        }
        return unitPoint3DArray2;
    }

    private static UnitPoint3D fromLegacy(pyrosim.legacy_2006_2.UnitPoint3D unitPoint3D, int n) {
        if (unitPoint3D == null) {
            return null;
        }
        Unit unit = SIUS.unit(n);
        Unit unit2 = unitPoint3D.getUnit();
        if (unit2 == null || !unit2.isCompatible(unit)) {
            unit2 = unit;
        }
        Point3d point3d = unitPoint3D.getPoint3dValue(unitPoint3D.getUnit());
        return new UnitPoint3D(point3d, unit2);
    }

    private static pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D fromLegacy(UnitPoint2D unitPoint2D, int n) {
        if (unitPoint2D == null) {
            return null;
        }
        Unit unit = SIUS.unit(n);
        Unit unit2 = unitPoint2D.x.getUnit();
        if (unit2 == null || !unit2.isCompatible(unit)) {
            System.err.println("Trying to convert to an incompatible unit:" + unit2 + "->" + unit);
            unit2 = unit;
        }
        Point2d point2d = unitPoint2D.getP2dValue(unitPoint2D.x.getUnit());
        return new pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D(point2d, unit2);
    }

    public static Grid fromLegacy(pyrosim.legacy_2006_2.domain.Grid grid) {
        if (grid == null) {
            return null;
        }
        UnitPoint3D unitPoint3D = Convert.fromLegacy(grid.getMinPoint(), 0);
        UnitPoint3D unitPoint3D2 = Convert.fromLegacy(grid.getMaxPoint(), 0);
        return new Grid(grid.getName(), unitPoint3D, unitPoint3D2, Convert.fromLegacy(grid.getXDivisions(), 0), Convert.fromLegacy(grid.getYDivisions(), 0), Convert.fromLegacy(grid.getZDivisions(), 0));
    }

    private GridList fromLegacy(GridList gridList, Vector<pyrosim.legacy_2006_2.domain.Grid> vector, boolean bl) {
        gridList.clear();
        for (pyrosim.legacy_2006_2.domain.Grid grid : vector) {
            Grid grid2 = Convert.fromLegacy(grid);
            grid2.setSyncTimeStep(bl);
            gridList.add(grid2);
        }
        return gridList;
    }

    private pyrosim.legacy_2012_1.thunderheadeng.image.Image fromLegacy(String string, Image image) {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image image2 = pyrosim.legacy_2012_1.thunderheadeng.image.Image.load(string, image.d_bytes, image.d_width, image.d_height, image.d_pitch, image.d_redOffset, image.d_greenOffset, image.d_blueOffset);
        if (image2 == null) {
            image2 = pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(string);
        }
        return image2;
    }

    private pyrosim.legacy_2012_1.domain.texture.ModelImage fromLegacy(ModelImage modelImage) {
        pyrosim.legacy_2012_1.thunderheadeng.image.Image image;
        Cloneable cloneable;
        if (modelImage == null) {
            return null;
        }
        if (modelImage instanceof BufferModelImage) {
            cloneable = (BufferModelImage)modelImage;
            image = this.fromLegacy(cloneable.getID(), cloneable.getBaseImage());
        } else {
            cloneable = (FileModelImage)modelImage;
            image = ImageManager.getImage(((FileModelImage)cloneable).getID());
            if (image == null) {
                image = pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(((FileModelImage)cloneable).getID());
            }
        }
        cloneable = Convert.fromLegacy(modelImage.getAnchorModel(), 0);
        UnitDouble unitDouble = Convert.fromLegacy(modelImage.getDistABModel(), 0);
        UnitDouble unitDouble2 = Convert.fromLegacy(modelImage.getZLocationModel(), 0);
        BGImageXform bGImageXform = new BGImageXform(modelImage.getAnchorImage(), new Point3d(((pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D)cloneable).x.getValue(SI.METER), ((pyrosim.legacy_2012_1.thunderheadeng.units.UnitPoint2D)cloneable).y.getValue(SI.METER), unitDouble2.getValue(SI.METER)), modelImage.getAImage(), modelImage.getBImage(), unitDouble.getValue(SI.METER), Double.NaN);
        return new pyrosim.legacy_2012_1.domain.texture.ModelImage(image, bGImageXform, modelImage.getOpacity());
    }

    private FloorManager fromLegacy(FloorManager floorManager, Map<String, Floor> map) {
        floorManager.clear();
        for (String string : map.keySet()) {
            UnitDouble unitDouble;
            Floor floor = map.get(string);
            UnitDouble unitDouble2 = Convert.fromLegacy(floor.getBottom(), 0);
            UnitDouble unitDouble3 = unitDouble2.compareTo(unitDouble = Convert.fromLegacy(floor.getTop(), 0)) <= 0 ? unitDouble2 : unitDouble;
            UnitDouble unitDouble4 = unitDouble.sub(unitDouble2).abs();
            pyrosim.legacy_2012_1.domain.Floor floor2 = new pyrosim.legacy_2012_1.domain.Floor(floor.getName(), unitDouble3, new UnitDouble(0.0, SI.METER), unitDouble4, this.fromLegacy(floor.getBgImage()));
            floorManager.add(floor2);
        }
        return floorManager;
    }

    private pyrosim.legacy_2012_1.domain.texture.TextureDB fromLegacy(pyrosim.legacy_2012_1.domain.texture.TextureDB textureDB, TextureDB textureDB2) {
        for (String string : textureDB2.names()) {
            pyrosim.legacy_2006_2.domain.Texture texture = textureDB2.getTexture(string);
            TextureInfo textureInfo = textureDB2.getDefaultInfo(string);
            Texture texture2 = Convert.fromLegacy(texture);
            pyrosim.legacy_2012_1.domain.texture.TextureInfo textureInfo2 = null;
            if (textureInfo != null) {
                textureInfo2 = new pyrosim.legacy_2012_1.domain.texture.TextureInfo(textureInfo.getTexID());
                textureInfo2.setWidth(Convert.fromLegacy(textureInfo.getWidth(), 0));
                textureInfo2.setHeight(Convert.fromLegacy(textureInfo.getHeight(), 0));
            }
            textureDB.setTexture(string, texture2);
            textureDB.setDefaultInfo(string, textureInfo2);
        }
        return textureDB;
    }

    private static Texture fromLegacy(pyrosim.legacy_2006_2.domain.Texture texture) {
        try {
            pyrosim.legacy_2012_1.thunderheadeng.image.Image image;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (ImageIO.write((RenderedImage)texture.getImage(), "jpg", byteArrayOutputStream) && (image = pyrosim.legacy_2012_1.thunderheadeng.image.Image.load(texture.getImageID(), byteArrayOutputStream.toByteArray())) != null) {
                return new Texture(texture.getImageID(), image);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Texture(texture.getImageID(), pyrosim.legacy_2012_1.thunderheadeng.image.Image.loadUncached(texture.getImageID()));
    }

    private static UnitDouble nonNull(pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble, UnitDouble unitDouble2, int n) {
        return unitDouble != null ? Convert.fromLegacy(unitDouble, n) : unitDouble2;
    }

    private static final Map<String, IColoring> getParticleColoringMap() {
        HashMap<String, IColoring> hashMap = new HashMap<String, IColoring>();
        hashMap.put("none", null);
        hashMap.put("VELOCITY", new DropletColoring(2));
        hashMap.put("TEMPERATURE", new DropletColoring(0));
        hashMap.put("DIAMETER", new DropletColoring(1));
        hashMap.put("RED", new ConstColoring(Color.RED));
        hashMap.put("BLUE", new ConstColoring(Color.BLUE));
        hashMap.put("BLACK", new ConstColoring(Color.BLACK));
        hashMap.put("YELLOW", new ConstColoring(Color.YELLOW));
        hashMap.put("GREEN", new ConstColoring(Color.GREEN));
        hashMap.put("MAGENTA", new ConstColoring(Color.MAGENTA));
        hashMap.put("WHITE", new ConstColoring(Color.WHITE));
        hashMap.put("CYAN", new ConstColoring(Color.CYAN));
        return hashMap;
    }

    private IParticleDesc extractParticleDesc(PartRecord partRecord, pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble, Map<String, IColoring> map) {
        IParticleDesc iParticleDesc;
        int n = partRecord.getMassless() ? 1 : 10;
        int n2 = partRecord.getSample() == -1 ? n : partRecord.getSample();
        Output output = new Output();
        Output output2 = new Output(Convert.nonNull(partRecord.getAge(), output.d_age, 2), unitDouble != null ? Convert.fromLegacy(unitDouble, 2) : output.d_dtInsert, n2);
        if (partRecord.getMassless()) {
            iParticleDesc = new TracerPartDesc(null, output2);
        } else {
            SizeDistribution sizeDistribution = new SizeDistribution();
            SizeDistribution sizeDistribution2 = new SizeDistribution(Convert.nonNull(partRecord.getDiameter(), sizeDistribution.d_medianDiameter, 0), new SizeDistribution.RosinRammler(partRecord.getGamma()));
            ThermalProps thermalProps = new ThermalProps();
            UnitDouble unitDouble2 = partRecord.getInitTempFDS() ? Convert.fromLegacy(partRecord.getInitTemp(), 1) : thermalProps.d_initTemp;
            ThermalProps thermalProps2 = new ThermalProps(Convert.nonNull(partRecord.getDensity(), thermalProps.d_density, 4), Convert.nonNull(partRecord.getSpecificHeat(), thermalProps.d_specificHeat, 11), unitDouble2);
            IColoring iColoring = map.get(partRecord.getQuantity());
            int n3 = partRecord.getDropSec();
            Pyrolysis pyrolysis = new Pyrolysis();
            UnitDouble unitDouble3 = Convert.nonNull(partRecord.getMeltTemp(), pyrolysis.d_meltingTemp, 1);
            UnitDouble unitDouble4 = Convert.nonNull(partRecord.getVapTemp(), pyrolysis.d_vapTemp, 1);
            UnitDouble unitDouble5 = Convert.nonNull(partRecord.getHeatVap(), pyrolysis.d_heatOfVap, 46);
            if (partRecord.getFuel()) {
                FuelPyrolysis fuelPyrolysis = new FuelPyrolysis();
                FuelPyrolysis fuelPyrolysis2 = new FuelPyrolysis(unitDouble3, unitDouble4, unitDouble5, Convert.nonNull(partRecord.getHeatCombust(), fuelPyrolysis.d_heatOfCombustion, 48));
                iParticleDesc = new FuelPartDesc(thermalProps2, fuelPyrolysis2, sizeDistribution2, output2, iColoring, n3);
            } else if (partRecord.getWater()) {
                Pyrolysis pyrolysis2 = Pyrolysis.evapOn(unitDouble3, unitDouble4, unitDouble5, null);
                iParticleDesc = new WaterPartDesc(thermalProps2, pyrolysis2, sizeDistribution2, output2, iColoring, n3);
            } else {
                Pyrolysis pyrolysis3 = Pyrolysis.evapOn(unitDouble3, unitDouble4, unitDouble5, null);
                iParticleDesc = new GenericPartDesc(thermalProps2, pyrolysis3, sizeDistribution2, output2, iColoring, n3);
            }
        }
        return iParticleDesc;
    }

    private ParticleList fromLegacy(ParticleList particleList, PartList partList, pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble) {
        Map<String, IColoring> map = Convert.getParticleColoringMap();
        for (PartRecord partRecord : partList) {
            Particle particle = new Particle(partRecord.getID(), this.extractParticleDesc(partRecord, unitDouble, map));
            particleList.add(particle);
        }
        return particleList;
    }

    private void extractParticleClouds(ParticleList particleList, PartList partList, ModelComposite modelComposite, GridList gridList) {
        for (PartRecord partRecord : partList) {
            if (!partRecord.getInitDropFDS()) continue;
            int n = partRecord.getInitDrop();
            Particle particle = (Particle)particleList.get(partRecord.getID());
            UnitDouble unitDouble = Convert.nonNull(partRecord.getMassVol(), SIUS.newud(1.0, 4), 4);
            boolean bl = partRecord.getStatic();
            FillGridsWithPartsTask fillGridsWithPartsTask = new FillGridsWithPartsTask(null, modelComposite, null, gridList.flatten(), particle, new PartCloud.ConstDropletCount(n), new PartCloud.InsertOnce(unitDouble), bl, false);
            fillGridsWithPartsTask.run();
        }
    }

    private pyrosim.legacy_2012_1.domain.texture.TextureInfo fromLegacy(TextureInfo textureInfo) {
        if (textureInfo == null) {
            return null;
        }
        return new pyrosim.legacy_2012_1.domain.texture.TextureInfo(textureInfo.getTexID(), Convert.fromLegacy(textureInfo.getWidth(), 0), Convert.fromLegacy(textureInfo.getHeight(), 0));
    }

    public static UnitDouble getUD(Material material, String string) {
        return Convert.getUD(material, string, null);
    }

    public static UnitDouble getUD(Material material, String string, UnitDouble unitDouble) {
        pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble2 = Convert.getMatVal(material, string, null);
        if (unitDouble2 != null) {
            int n = Convert.fromLegacyUnitType(Material.getUnitType(string));
            return Convert.fromLegacy(unitDouble2, n);
        }
        return unitDouble;
    }

    public static double getD(Material material, String string, double d) {
        return Convert.getMatVal(material, string, d);
    }

    public static boolean getB(Material material, String string, boolean bl) {
        return Convert.getMatVal(material, string, bl);
    }

    public static int getI(Material material, String string, int n) {
        return Convert.getMatVal(material, string, n);
    }

    public static String getS(Material material, String string, String string2) {
        return Convert.getMatVal(material, string, string2);
    }

    public static <T> T getMatVal(Material material, String string, T t) {
        Object object = material.getValue(string);
        if (object != null) {
            return (T)object;
        }
        object = Material.getDefaultValue(string);
        if (object != null) {
            return (T)object;
        }
        return t;
    }

    public static Vector<UnitDouble> getVUD(Material material, String string) {
        Vector vector = (Vector)material.getValue(string);
        if (vector == null) {
            return null;
        }
        Vector<UnitDouble> vector2 = new Vector<UnitDouble>();
        int n = Convert.fromLegacyUnitType(Material.getUnitType(string));
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)vector.get(i), n));
        }
        return vector2;
    }

    public static IHeatBasedValue hbvFromMaterial(Material material, String string, String string2) {
        if (material.isDefined(string2)) {
            pyrosim.legacy_2006_2.domain.Ramp ramp = (pyrosim.legacy_2006_2.domain.Ramp)material.getValue(string2);
            ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>();
            int n = 0;
            for (RampRecord rampRecord : ramp.getRecords()) {
                n = Convert.fromLegacyUnitType(rampRecord.getFUnit());
                arrayList.add(new Ramp.Entry(Convert.fromLegacy(rampRecord.getT(), RampInputs.HEAT.getUnitType()), Convert.fromLegacy(rampRecord.getF(), n)));
            }
            Ramp ramp2 = new Ramp(arrayList, RampInputs.HEAT, n);
            return new IHeatBasedValue.Custom(ramp2);
        }
        UnitDouble unitDouble = Convert.getUD(material, string);
        return new IHeatBasedValue.Constant(unitDouble);
    }

    public static TimeFunction tfFromMaterial(Material material, String string, String string2) {
        pyrosim.legacy_2006_2.domain.Ramp ramp = (pyrosim.legacy_2006_2.domain.Ramp)material.getValue(string2);
        if (material.isDefined(string)) {
            UnitDouble unitDouble = Convert.getUD(material, string);
            if (unitDouble.getValueNoUnit() >= 0.0) {
                return new TimeFunction.TanH(unitDouble);
            }
            return new TimeFunction.TSquared(unitDouble.negate());
        }
        if (ramp != null && !ramp.getRecords().isEmpty()) {
            ArrayList<Ramp.Entry> arrayList = new ArrayList<Ramp.Entry>();
            int n = 0;
            for (RampRecord rampRecord : ramp.getRecords()) {
                n = Convert.fromLegacyUnitType(rampRecord.getFUnit());
                arrayList.add(new Ramp.Entry(Convert.fromLegacy(rampRecord.getT(), RampInputs.TIME.getUnitType()), Convert.fromLegacy(rampRecord.getF(), n)));
            }
            Ramp ramp2 = new Ramp(arrayList, RampInputs.TIME, n);
            return new TimeFunction.Custom(ramp2);
        }
        return TimeFunction.newDefault();
    }

    private static IRampInput toRampInput(int n) {
        switch (n) {
            case 2: {
                return RampInputs.TIME;
            }
            case 1: {
                return RampInputs.HEAT;
            }
        }
        assert (false);
        return RampInputs.TIME;
    }

    public static ParticleInjection getPartInj(Material material, ParticleList particleList) {
        Serializable serializable;
        Particle particle;
        String string = (String)material.getValue("PART_ID");
        boolean bl = Convert.getB(material, "PARTICLES", false);
        if (bl) {
            particle = (Particle)particleList.get(ParticleList.TRACER);
            if (particle == null || !particle.isMassless()) {
                serializable = new Particle(ParticleList.TRACER, new TracerPartDesc(Color.BLACK, new Output(1)));
                particleList.add((IPyroObject)serializable);
            }
            assert (string == null);
            string = ParticleList.TRACER;
        }
        if (string != null) {
            particle = (Particle)particleList.get(string);
            serializable = particle.getDescription().getOutput();
            int n = Convert.getI(material, "NPPC", 1);
            ParticleInjection particleInjection = new ParticleInjection();
            TimeBasedValue<UnitDouble> timeBasedValue = particle.isMassless() ? null : particleInjection.getMassFlux();
            return new ParticleInjection(particle, n, timeBasedValue, serializable.d_dtInsert);
        }
        return null;
    }

    public static void removeIfDefault(Material material, Set<String> set, String string) {
        Object object;
        Object object2;
        if (set.contains(string) && theUtil.equal(object2 = material.getValue(string), object = Material.getDefaultValue(string))) {
            set.remove(string);
        }
    }

    public ISurfDesc cvtMatBurnerFire(Material material, MaterialManager materialManager, ParticleList particleList, WarningReport warningReport) {
        TimeFunction timeFunction = Convert.tfFromMaterial(material, "TAU_Q", "RAMP_Q");
        UnitDouble unitDouble = Convert.getUD(material, "HRRPUA");
        UnitDouble unitDouble2 = Convert.getUD(material, "E_COEFFICIENT");
        HeatRelease.HRRType hRRType = new HeatRelease.HRRType(unitDouble, timeFunction);
        HeatRelease heatRelease = new HeatRelease(hRRType, unitDouble2);
        TempRegulation tempRegulation = CvtSolid.getTempRegulation(material, warningReport);
        ParticleInjection particleInjection = Convert.getPartInj(material, particleList);
        Convert.checkForUnusedMatFieldsFromUsed(material, warningReport, "HRRPUA", "E_COEFFICIENT", "TAU_Q", "RAMP_Q", "PARTICLES", "PART_ID", "NPPC", "PHASE", "TMPWAL", "HEAT_FLUX", "TAU_Q", "RAMP_Q", EMISSIVITY);
        return new BurnerSurfDesc(tempRegulation, heatRelease, particleInjection);
    }

    public static void checkForUnusedMatFieldsFromUnused(Material material, WarningReport warningReport, String ... stringArray) {
        HashSet<String> hashSet = Sets.fromArrayHS(stringArray);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = material.getValue(string);
            if (object != null && !theUtil.equal(object, Material.getDefaultValue(string))) continue;
            iterator.remove();
        }
        Convert.checkUnusedMatFields(material, warningReport, hashSet);
    }

    public static void checkForUnusedMatFieldsFromUsed(Material material, WarningReport warningReport, String ... stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>(material.getUsedKeysC());
        for (String string : stringArray) {
            treeSet.remove(string);
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object object = material.getValue(string);
            if (!theUtil.equal(object, Material.getDefaultValue(string))) continue;
            iterator.remove();
        }
        Convert.checkUnusedMatFields(material, warningReport, treeSet);
    }

    private static void checkUnusedMatFields(Material material, WarningReport warningReport, Set<String> set) {
        if (!set.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : set) {
                stringBuffer.append(string + ",");
            }
            String string = stringBuffer.substring(0, stringBuffer.length() - 1);
            warningReport.addWarning(new Warning(material.getFDSType() + ":" + material.getName(), Intl.intl("Dropped Record(s): ") + (String)string));
        }
    }

    public static Backing getBacking(String string) {
        if (string != null && string.equalsIgnoreCase("INSULATED")) {
            return new Backing.Insulated();
        }
        if (string != null && string.equalsIgnoreCase("EXPOSED")) {
            return new Backing.Exposed();
        }
        return new Backing.AirGap();
    }

    private static UnitDouble getSteadyStateVal(IHeatBasedValue iHeatBasedValue) {
        if (iHeatBasedValue instanceof IHeatBasedValue.Custom) {
            Ramp ramp = ((IHeatBasedValue.Custom)iHeatBasedValue).value;
            if (ramp.getRecords().isEmpty()) {
                return SIUS.newud(0.0, ramp.getFUnitType());
            }
            return ramp.getRecords().get((int)(ramp.getRecords().size() - 1)).f;
        }
        return ((IHeatBasedValue.Constant)iHeatBasedValue).value;
    }

    private static int getMatUnitType(String string) {
        return Convert.fromLegacyUnitType(Material.getUnitType(string));
    }

    public static ThermalThickness getThermalProps(Material material, boolean bl, WarningReport warningReport) {
        return Convert.getThermalProps(material, bl, KS, RAMP_KS, C_P, RAMP_C_P, DENSITY, null, warningReport);
    }

    public static pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps getThermalPropsOfChar(Material material, boolean bl, WarningReport warningReport) {
        return Convert.getThermalProps((Material)material, (boolean)bl, (String)KS_CHAR, (String)RAMP_KS_CHAR, (String)C_P_CHAR, (String)RAMP_C_P_CHAR, (String)CHAR_DENSITY, (Double)Double.valueOf((double)1.0), (WarningReport)warningReport).d_thermalProps;
    }

    public static ThermalThickness getThermalProps(Material material, boolean bl, String string, String string2, String string3, String string4, String string5, Double d, WarningReport warningReport) {
        UnitDouble unitDouble;
        pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps thermalProps = new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps();
        UnitDouble unitDouble2 = unitDouble = bl ? Convert.getUD(material, DELTA) : new UnitDouble(0.001, SI.METER);
        if (d == null) {
            d = Convert.getD(material, EMISSIVITY, 0.0);
        }
        UnitDouble unitDouble3 = null;
        IHeatBasedValue iHeatBasedValue = null;
        IHeatBasedValue iHeatBasedValue2 = null;
        UnitDouble unitDouble4 = null;
        if (material.isDefined(string) || material.isDefined(string2)) {
            iHeatBasedValue = Convert.hbvFromMaterial(material, string, string2);
        }
        if (material.isDefined(string3) || material.isDefined(string4)) {
            iHeatBasedValue2 = Convert.hbvFromMaterial(material, string3, string4);
        }
        if (material.isDefined(string5)) {
            unitDouble3 = Convert.getUD(material, string5);
        }
        if (material.isDefined(DELTA)) {
            unitDouble4 = Convert.getUD(material, DELTA);
        }
        if (iHeatBasedValue != null && iHeatBasedValue2 != null && unitDouble3 != null && unitDouble4 != null) {
            return new ThermalThickness(new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps(iHeatBasedValue, unitDouble3, iHeatBasedValue2, d, thermalProps.d_absorptionCoeff), unitDouble4);
        }
        if (material.isDefined(C_DELTA_RHO)) {
            if (iHeatBasedValue == null) {
                iHeatBasedValue = thermalProps.d_conductivity;
                if (!bl) {
                    warningReport.addWarning(new Warning(String.format(Intl.intl("MATL: %s_MATL"), material.getName()), String.format(Intl.intl("Conductivity set to default of %s."), iHeatBasedValue.toString())));
                }
            }
            UnitDouble unitDouble5 = Convert.getUD(material, C_DELTA_RHO);
            boolean bl2 = false;
            boolean bl3 = false;
            if (unitDouble4 == null && unitDouble3 == null && iHeatBasedValue2 == null) {
                bl2 = true;
                bl3 = true;
            } else if (unitDouble4 == null && unitDouble3 == null) {
                bl2 = true;
            } else if (unitDouble4 == null && iHeatBasedValue2 == null) {
                bl2 = true;
            } else if (unitDouble3 == null && iHeatBasedValue2 == null) {
                bl3 = true;
            }
            if (bl2) {
                unitDouble4 = unitDouble;
                warningReport.addWarning(new Warning(String.format(Intl.intl("SURF: %s"), material.getName()), String.format(Intl.intl("Thickness set to default of %s."), unitDouble.toString())));
            }
            if (bl3) {
                iHeatBasedValue2 = thermalProps.d_specificHeat;
                warningReport.addWarning(new Warning(String.format(Intl.intl("MATL: %s_MATL"), material.getName()), String.format(Intl.intl("Specific heat set to default of %s."), iHeatBasedValue2.toString())));
            }
            Unit unit = SIUS.unit(Convert.getMatUnitType(C_DELTA_RHO));
            double d2 = unitDouble5.getValue(unit);
            Unit unit2 = SIUS.unit(Convert.getMatUnitType(string3));
            Unit unit3 = SIUS.unit(Convert.getMatUnitType(DELTA));
            Unit unit4 = SIUS.unit(Convert.getMatUnitType(string5));
            if (unitDouble3 == null) {
                double d3 = Convert.getSteadyStateVal(iHeatBasedValue2).getValue(unit2);
                double d4 = unitDouble4.getValue(unit3);
                double d5 = d2 / d3 / d4;
                unitDouble3 = new UnitDouble(d5, unit4);
            } else if (unitDouble4 == null) {
                double d6 = Convert.getSteadyStateVal(iHeatBasedValue2).getValue(unit2);
                double d7 = unitDouble3.getValue(unit4);
                double d8 = d2 / d6 / d7;
                unitDouble4 = new UnitDouble(d8, unit3);
            } else if (iHeatBasedValue2 == null) {
                double d9 = unitDouble3.getValue(unit4);
                double d10 = unitDouble4.getValue(unit3);
                double d11 = d2 / d10 / d9;
                iHeatBasedValue2 = new IHeatBasedValue.Constant(new UnitDouble(d11, unit2));
            }
        } else {
            if (unitDouble3 == null) {
                unitDouble3 = Convert.getUD(material, string5);
            }
            if (iHeatBasedValue == null) {
                iHeatBasedValue = Convert.hbvFromMaterial(material, string, string2);
            }
            if (iHeatBasedValue2 == null) {
                iHeatBasedValue2 = Convert.hbvFromMaterial(material, string3, string4);
            }
            if (unitDouble4 == null) {
                unitDouble4 = unitDouble;
            }
        }
        return new ThermalThickness(new pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps(iHeatBasedValue, unitDouble3, iHeatBasedValue2, d, thermalProps.d_absorptionCoeff), unitDouble4);
    }

    private Map<String, Integer> getPPLookup() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Inert", 0);
        hashMap.put("Adiabatic", 1);
        hashMap.put("Burner Fire", 2);
        hashMap.put("Fan/Wind", 3);
        hashMap.put("Flammable Solid", 4);
        hashMap.put("Flammable Solid (Constant HRR)", 5);
        hashMap.put("Non-Flammable Solid", 6);
        hashMap.put("Liquid Fuel", 7);
        hashMap.put("Charring Fuel", 8);
        hashMap.put("Liquid Thermoplastic", 9);
        hashMap.put("Charring Thermoplastic", 10);
        return hashMap;
    }

    private int getPP(Material material) {
        Integer n;
        MaterialProfile.ProfilePath profilePath = material.getProfilePath().getListPaths().get("Surface Type");
        if (profilePath != null && (n = this.PP_LOOKUP.get(profilePath.getProfileName())) != null) {
            return n;
        }
        return -1;
    }

    private static Map<String, Integer> getBCMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("Thermally Thick", 2);
        hashMap.put("Thermally Thin", 3);
        hashMap.put("Fixed Temperature", 0);
        hashMap.put("Fixed Heat Flux", 1);
        return hashMap;
    }

    private int getBC(Material material) {
        String string = null;
        MaterialProfile.ProfilePath profilePath = material.getProfilePath().getListPaths().get("Surface Type");
        if (profilePath != null && (profilePath = profilePath.getGroupPaths().get("Boundary Conditions")) != null && (profilePath = profilePath.getListPaths().get("Boundary Type")) != null) {
            string = profilePath.getProfileName();
        }
        if (string == null) {
            return -1;
        }
        Integer n = this.d_bcMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    private ISurfDesc getSurfDesc(SurfaceManager surfaceManager, MaterialManager materialManager, ParticleList particleList, Material material) {
        boolean bl;
        String string = material.getName();
        if (Material.isPredefinedMaterial(string)) {
            return ((Surface)surfaceManager.get(string)).getSurfDesc();
        }
        int n = this.getPP(material);
        if (n == 0) {
            return new SurfDescStatic.Inert();
        }
        if (n == 1) {
            return new SurfDescStatic.Adiabatic();
        }
        if (n == 2) {
            return this.cvtMatBurnerFire(material, materialManager, particleList, this.d_warnings);
        }
        if (n == 3) {
            return CvtFanWind.cvtFanWind(material, materialManager, particleList, this.d_warnings);
        }
        if (n == 8) {
            ParticleInjection particleInjection = Convert.getPartInj(material, particleList);
            return CvtSolid.getDescCharringFuel(material, materialManager, particleInjection, this.d_warnings);
        }
        if (n == 7 || n == 9) {
            ParticleInjection particleInjection = Convert.getPartInj(material, particleList);
            return CvtLiquid.getDescLiqFuel(material, materialManager, particleInjection, this.d_warnings);
        }
        int n2 = this.getBC(material);
        if (n == 5 && (n2 == 0 || n2 == 1)) {
            return this.cvtMatBurnerFire(material, materialManager, particleList, this.d_warnings);
        }
        ParticleInjection particleInjection = Convert.getPartInj(material, particleList);
        if (n2 == 0) {
            return CvtSolid.getDescHeater(material, particleInjection, this.d_warnings);
        }
        if (n2 == 1) {
            return CvtSolid.getDescHeater(material, particleInjection, this.d_warnings);
        }
        boolean bl2 = bl = n2 == 2;
        if (n == 5) {
            return CvtSolid.getDescForcedHRR(material, materialManager, particleInjection, bl, this.d_warnings);
        }
        if (n == 6) {
            return CvtSolid.getDescNonFlammable(material, materialManager, particleInjection, bl, this.d_warnings);
        }
        if (n == 4 || n == 10) {
            return CvtSolid.getDescThermoplastic(material, materialManager, particleInjection, bl, this.d_warnings);
        }
        this.d_warnings.addWarning(new Warning(Intl.intl("Unable to convert SURF: I wasn't able to classify that material."), String.format(Intl.intl("Converted to Inert: %s"), material.getName())));
        return new SurfDescStatic.Inert();
    }

    private Surface fromLegacy(SurfaceManager surfaceManager, MaterialManager materialManager, ParticleList particleList, Material material) {
        if (material == null) {
            return null;
        }
        return new Surface(material.getName(), material.getColor(), this.fromLegacy(material.getTextureInfo()), this.getSurfDesc(surfaceManager, materialManager, particleList, material));
    }

    private SurfaceManager fromLegacy(SurfaceManager surfaceManager, MaterialManager materialManager, ParticleList particleList, MaterialList materialList) {
        for (Material material : materialList) {
            Surface surface = this.fromLegacy(surfaceManager, materialManager, particleList, material);
            if (surfaceManager.get(surface.getName()) != null) continue;
            surfaceManager.add(surface);
        }
        return surfaceManager;
    }

    private IPyroObject fromLegacy(pyrosim.legacy_2006_2.domain.FDSObject fDSObject, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        if (fDSObject instanceof FDSComposite) {
            return this.fromLegacy((FDSComposite)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof FDSConvexPoly) {
            return this.fromLegacy((FDSConvexPoly)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof Slab) {
            return this.fromLegacy((Slab)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof Vent) {
            return this.fromLegacy((Vent)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof AlignedBlock) {
            return this.fromLegacy((AlignedBlock)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof AlignedHole) {
            return this.fromLegacy((AlignedHole)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof Hole) {
            return this.fromLegacy((Hole)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        if (fDSObject instanceof Wall) {
            return this.fromLegacy((Wall)fDSObject, deviceManager, map, materialList, surfaceManager);
        }
        assert (false);
        return null;
    }

    private Surface findSurf(MaterialList materialList, SurfaceManager surfaceManager, Material material, IObjectFilter<Surface> iObjectFilter, Map<Material, Surface> map) {
        if (material == null) {
            return (Surface)surfaceManager.get(PredefSurf.INERT.name());
        }
        Surface surface = map.get(material);
        if (surface != null) {
            return surface;
        }
        Surface surface2 = (Surface)surfaceManager.get(material.getName());
        if (surface2 == null) {
            Material material2 = (Material)material.clone();
            for (Material material3 : materialList) {
                material2.taskSetName(material3.getName());
                if (!material3.equals(material2)) continue;
                surface2 = (Surface)surfaceManager.get(material3.getName());
                break;
            }
            if (surface2 == null) {
                surface2 = (Surface)surfaceManager.get(PredefSurf.INERT.name());
            }
            map.put(material, surface2);
        }
        if (iObjectFilter.shouldFilter(surface2)) {
            surface2 = (Surface)surfaceManager.get(PredefSurf.INERT.name());
            map.put(material, surface2);
        }
        assert (surface2 != null);
        return surface2;
    }

    private void setSurfs(pyrosim.legacy_2006_2.domain.FDSObject fDSObject, FDSObject fDSObject2, MaterialList materialList, SurfaceManager surfaceManager, IObjectFilter<Surface> iObjectFilter) {
        if (!(fDSObject2 instanceof IObstruction) && !(fDSObject2 instanceof pyrosim.legacy_2012_1.domain.geom.Vent)) {
            return;
        }
        Surface[] surfaceArray = new Surface[fDSObject.getNumFaces()];
        LinkedIdentityHashMap<Material, Surface> linkedIdentityHashMap = new LinkedIdentityHashMap<Material, Surface>();
        for (int i = 0; i < fDSObject.getNumFaces(); ++i) {
            Surface surface;
            Material object = fDSObject.getMaterial(i);
            surfaceArray[i] = surface = this.findSurf(materialList, surfaceManager, object, iObjectFilter, linkedIdentityHashMap);
        }
        if (surfaceArray.length > 1 && GeomUtil.isUniform(surfaceArray)) {
            surfaceArray = new Surface[]{surfaceArray[0]};
        }
        if (fDSObject2 instanceof IObstruction) {
            ((IObstruction)fDSObject2).setSurfaces(surfaceArray);
        } else if (fDSObject2 instanceof pyrosim.legacy_2012_1.domain.geom.Vent) {
            ((pyrosim.legacy_2012_1.domain.geom.Vent)fDSObject2).setSurface(surfaceArray[0]);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("%1$s cannot use the surface, %2$s."), fDSObject2.getName(), ((Material)entry.getKey()).getName()), String.format(Intl.intl("Using the surface, %s, instead."), ((Surface)entry.getValue()).getName())));
        }
    }

    private void convertEvents(String string, boolean bl, Activatable activatable, IInPin iInPin, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map) {
        List<IInPin> list;
        Cloneable cloneable;
        boolean bl2;
        Object object;
        Iterator iterator;
        Collection<pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> collection;
        boolean bl3 = activatable.getCanBeTriggeredByAnyHeatDetector(0);
        boolean bl4 = activatable.getCanBeTriggeredByAnyHeatDetector(1);
        TimeActivationEventList timeActivationEventList = (TimeActivationEventList)activatable.getEventsOfType(0);
        HeatActivationEventList heatActivationEventList = (HeatActivationEventList)activatable.getEventsOfType(1);
        if (!(timeActivationEventList != null && !timeActivationEventList.getAllEvents().isEmpty() || heatActivationEventList != null && !heatActivationEventList.getAllEvents().isEmpty() || bl3 || bl4)) {
            return;
        }
        OrOp orOp = new OrOp();
        if (timeActivationEventList != null && !timeActivationEventList.getAllEvents().isEmpty()) {
            Object object2;
            collection = new TreeSet<pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector>();
            iterator = timeActivationEventList.getAllEvents().iterator();
            object = (TimeActivationEvent)iterator.next();
            bl2 = ((TimeActivationEvent)object).getAction() == 1;
            collection.add((pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)((Object)Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)((TimeActivationEvent)object).getCriteria(), 2)));
            while (iterator.hasNext()) {
                object2 = (TimeActivationEvent)iterator.next();
                if (((TimeActivationEvent)object).getAction() != ((TimeActivationEvent)object2).getAction()) {
                    collection.add((pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)((Object)Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)((TimeActivationEvent)object2).getCriteria(), 2)));
                }
                object = object2;
            }
            if (collection.size() == 1) {
                object2 = new Timer((UnitDouble)collection.first(), bl2);
                orOp.getInputPin().connect(((Timer)object2).getOutputPins().get(0));
            } else if (collection.size() > 1) {
                object2 = new CustomCtrl(bl2, (SortedSet<UnitDouble>)collection);
                ((CustomCtrl)object2).getInputPin().connect(Clock.INSTANCE.getOutputPins().get(0));
                orOp.getInputPin().connect(((CustomCtrl)object2).getOutputPins().get(0));
            }
        }
        collection = ((APyroObject)deviceManager).flatten(pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector.class);
        iterator = new LinkedIdentityHashSet();
        object = new LinkedIdentityHashSet();
        if (bl3) {
            iterator.addAll(collection);
        }
        if (bl4) {
            object.addAll(collection);
        }
        if (heatActivationEventList != null && !heatActivationEventList.getAllEvents().isEmpty()) {
            for (Object object2 : heatActivationEventList.getAllEvents()) {
                cloneable = (HeatActivationEvent)object2;
                list = (HeatDetector)((HeatActivationEvent)cloneable).getCriteria();
                int n = ((HeatActivationEvent)cloneable).getAction();
                pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector = map.get(list);
                if (n == 0) {
                    iterator.add(heatDetector);
                    continue;
                }
                if (n != 1) continue;
                object.add(heatDetector);
            }
        }
        bl2 = false;
        boolean bl5 = false;
        if (!iterator.isEmpty() || !object.isEmpty()) {
            cloneable = new OrOp();
            if (object.isEmpty()) {
                bl5 = true;
                bl2 = false;
                list = iterator.iterator();
                while (list.hasNext()) {
                    pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)list.next();
                    ((ALogicOp)cloneable).getInputPin().connect(heatDetector.getOutputPins().get(0));
                }
            } else if (iterator.isEmpty()) {
                bl5 = true;
                bl2 = true;
                list = object.iterator();
                while (list.hasNext()) {
                    pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector = (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector)list.next();
                    ((ALogicOp)cloneable).getInputPin().connect(heatDetector.getOutputPins().get(0));
                }
            } else {
                bl5 = false;
                bl2 = false;
                for (pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector : collection) {
                    boolean bl6 = iterator.contains(heatDetector);
                    boolean bl7 = object.contains(heatDetector);
                    IOutPin iOutPin = this.convertHDEvent(heatDetector, bl6, bl7);
                    ((ALogicOp)cloneable).getInputPin().connect(iOutPin);
                }
            }
            list = ((ALogicOp)cloneable).getOutputPins().get(0);
            if (bl5) {
                LatchCtrl latchCtrl = new LatchCtrl();
                latchCtrl.getInputPin().connect((IOutPin)((Object)list));
                list = latchCtrl.getOutputPins().get(0);
            }
            if (bl2) {
                NotOp notOp = new NotOp();
                notOp.getInputPin().connect((IOutPin)((Object)list));
                list = notOp.getOutputPins().get(0);
            }
            orOp.getInputPin().connect((IOutPin)((Object)list));
        }
        iInPin.connect(orOp.getOutputPins().get(0));
        pyrosim.legacy_2012_1.domain.controls.Util.deleteNoops(iInPin);
        if (!iInPin.getConnections().isEmpty()) {
            if (bl) {
                cloneable = iInPin.getConnections().iterator().next();
                list = this.d_ctrlMap.get(cloneable);
                if (list == null) {
                    list = new ArrayList<IInPin>();
                    this.d_ctrlMap.put((IOutPin)cloneable, list);
                }
                list.add(iInPin);
            } else {
                this.d_warnings.addWarning(new Warning(Intl.intl("OPEN vents may not be created or removed."), String.format(Intl.intl("Ignoring events specified for \"%s.\""), string)));
            }
            iInPin.disconnectAll();
        }
    }

    private IOutPin convertHDEvent(pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector, boolean bl, boolean bl2) {
        AControl aControl;
        boolean bl3 = !bl || !bl2;
        boolean bl4 = bl2 && !bl;
        IOutPin iOutPin = heatDetector.getOutputPins().get(0);
        if (bl3) {
            aControl = new LatchCtrl();
            ((LatchCtrl)aControl).getInputPin().connect(iOutPin);
            iOutPin = ((LatchCtrl)aControl).getOutputPins().get(0);
        }
        if (bl4) {
            aControl = new NotOp();
            ((NotOp)aControl).getInputPin().connect(iOutPin);
            iOutPin = ((NotOp)aControl).getOutputPins().get(0);
        }
        return iOutPin;
    }

    private void createControls(ControlMgr controlMgr) {
        for (Map.Entry<IOutPin, List<IInPin>> entry : this.d_ctrlMap.entrySet()) {
            ControlBridge controlBridge = new ControlBridge(Intl.intl("CTRL"));
            Util.autoRename(controlMgr, controlBridge);
            controlBridge.getInputPin().connect(entry.getKey());
            IOutPin iOutPin = controlBridge.getOutputPins().get(0);
            for (IInPin iInPin : entry.getValue()) {
                iInPin.connect(iOutPin);
            }
            controlMgr.add(controlBridge);
        }
    }

    private void setFDSProps(pyrosim.legacy_2006_2.domain.FDSObject fDSObject, FDSObject fDSObject2, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager, IObjectFilter<Surface> iObjectFilter) {
        fDSObject2.setName(fDSObject.getName());
        fDSObject2.setColors(fDSObject.getColor());
        fDSObject2.setVisible(fDSObject.isVisible());
        this.setSurfs(fDSObject, fDSObject2, materialList, surfaceManager, iObjectFilter);
        boolean bl = fDSObject2 instanceof pyrosim.legacy_2012_1.domain.geom.Vent && ((pyrosim.legacy_2012_1.domain.geom.Vent)fDSObject2).getSurface().equals(surfaceManager.get(PredefSurf.OPEN.name()));
        boolean bl2 = !bl;
        this.convertEvents(fDSObject2.getName(), bl2, fDSObject, fDSObject2.getInputPin(), deviceManager, map);
    }

    private ModelComposite fromLegacy(FDSComposite fDSComposite, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        ModelComposite modelComposite = new ModelComposite(fDSComposite.getName());
        for (int i = 0; i < fDSComposite.size(); ++i) {
            IPyroObject iPyroObject = this.fromLegacy(fDSComposite.get(i), deviceManager, map, materialList, surfaceManager);
            if (iPyroObject == null) continue;
            modelComposite.add(iPyroObject);
        }
        return modelComposite;
    }

    private FDSObject fromLegacy(FDSConvexPoly fDSConvexPoly, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        Surface surface = (Surface)surfaceManager.get(PredefSurf.INERT.name());
        UnitPoint3D[] unitPoint3DArray = Convert.fromLegacy(fDSConvexPoly.getPoints(), 0);
        Point3d[] point3dArray = new Point3d[unitPoint3DArray.length];
        for (int i = 0; i < unitPoint3DArray.length; ++i) {
            point3dArray[i] = unitPoint3DArray[i].getPoint3dValue(Geometry.LU);
        }
        AFace aFace = point3dArray.length == 3 ? new Triangle(point3dArray[0], point3dArray[1], point3dArray[2]) : (point3dArray.length == 4 ? new Quad(point3dArray[0], point3dArray[1], point3dArray[2], point3dArray[3]) : new NGon(point3dArray));
        Obstruction obstruction = new Obstruction(fDSConvexPoly.getName(), aFace, new Surface[]{surface});
        this.setFDSProps(fDSConvexPoly, obstruction, deviceManager, map, materialList, surfaceManager, Obstruction.getSurfaceFilter());
        return obstruction;
    }

    private FDSObject fromLegacy(Slab slab, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        Surface surface = (Surface)surfaceManager.get(PredefSurf.INERT.name());
        UnitPoint3D[] unitPoint3DArray = Convert.fromLegacy(slab.getPoints(), 0);
        Point3d[] point3dArray = new Point3d[unitPoint3DArray.length];
        for (int i = 0; i < unitPoint3DArray.length; ++i) {
            point3dArray[i] = unitPoint3DArray[i].getPoint3dValue(Geometry.LU);
        }
        assert (point3dArray.length == 3);
        Vector3d vector3d = Util3D.simplePolygonNormal(Arrays.asList(point3dArray));
        if (vector3d == null) {
            vector3d = new Vector3d(0.0, 0.0, 1.0);
        }
        vector3d.scale(-Convert.fromLegacy(slab.getThickness(), 0).getValue(Geometry.LU));
        ExtrudedPoly extrudedPoly = new ExtrudedPoly(new Triangle(point3dArray[0], point3dArray[1], point3dArray[2]), vector3d);
        Obstruction obstruction = new Obstruction(slab.getName(), extrudedPoly, new Surface[]{surface});
        obstruction.setOptions(2, !slab.isSawtoothed());
        obstruction.setOptions(1, slab.isThickened());
        obstruction.setOptions(4, slab.permitsHole());
        this.setFDSProps(slab, obstruction, deviceManager, map, materialList, surfaceManager, Obstruction.getSurfaceFilter());
        return obstruction;
    }

    private FDSObject fromLegacy(Vent vent, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        Surface surface = (Surface)surfaceManager.get(PredefSurf.INERT.name());
        UnitPoint3D unitPoint3D = Convert.fromLegacy(vent.getMinPoint(), 0);
        UnitPoint3D unitPoint3D2 = Convert.fromLegacy(vent.getMaxPoint(), 0);
        AARectangle aARectangle = AARectangle.construct(unitPoint3D.getPoint3dValue(Geometry.LU), unitPoint3D2.getPoint3dValue(Geometry.LU));
        pyrosim.legacy_2012_1.domain.geom.Vent vent2 = new pyrosim.legacy_2012_1.domain.geom.Vent(vent.getName(), surface, aARectangle);
        Vector3d vector3d = null;
        UnitPoint3D unitPoint3D3 = Convert.fromLegacy(vent.getNormal(), 0);
        if (unitPoint3D3 != null) {
            vector3d = unitPoint3D3.getVector3dValue(SI.METER);
            vector3d.normalize();
        }
        vent2.setNormal(vector3d);
        this.setFDSProps(vent, vent2, deviceManager, map, materialList, surfaceManager, pyrosim.legacy_2012_1.domain.geom.Vent.getSurfaceFilter());
        return vent2;
    }

    private static AABoxGeom constructGeom(pyrosim.legacy_2006_2.UnitPoint3D unitPoint3D, pyrosim.legacy_2006_2.UnitPoint3D unitPoint3D2) {
        UnitPoint3D unitPoint3D3 = Convert.fromLegacy(unitPoint3D, 0);
        UnitPoint3D unitPoint3D4 = Convert.fromLegacy(unitPoint3D2, 0);
        return new AABoxGeom(unitPoint3D3.getPoint3dValue(Geometry.LU), unitPoint3D4.getPoint3dValue(Geometry.LU), 0);
    }

    private FDSObject fromLegacy(AlignedBlock alignedBlock, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        Surface surface = (Surface)surfaceManager.get(PredefSurf.INERT.name());
        AABoxGeom aABoxGeom = Convert.constructGeom(alignedBlock.getMinPoint(), alignedBlock.getMaxPoint());
        Obstruction obstruction = new Obstruction(alignedBlock.getName(), aABoxGeom, new Surface[]{surface});
        obstruction.setOptions(2, !alignedBlock.isSawtoothed());
        obstruction.setOptions(1, alignedBlock.isThickened());
        obstruction.setOptions(4, alignedBlock.permitsHole());
        this.setFDSProps(alignedBlock, obstruction, deviceManager, map, materialList, surfaceManager, Obstruction.getSurfaceFilter());
        return obstruction;
    }

    private FDSObject fromLegacy(AlignedHole alignedHole, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        AABoxGeom aABoxGeom = Convert.constructGeom(alignedHole.getMinPoint(), alignedHole.getMaxPoint());
        pyrosim.legacy_2012_1.domain.geom.Hole hole = new pyrosim.legacy_2012_1.domain.geom.Hole(alignedHole.getName(), aABoxGeom);
        this.setFDSProps(alignedHole, hole, deviceManager, map, materialList, surfaceManager, this.ACCEPT_NONE_FILTER);
        return hole;
    }

    private FDSObject fromLegacy(Hole hole, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        WallGeom wallGeom = Convert.constructGeom(hole);
        pyrosim.legacy_2012_1.domain.geom.Hole hole2 = new pyrosim.legacy_2012_1.domain.geom.Hole(hole.getName(), wallGeom);
        this.setFDSProps(hole, hole2, deviceManager, map, materialList, surfaceManager, this.ACCEPT_NONE_FILTER);
        return hole2;
    }

    private static WallGeom constructGeom(AUnalignedFDSObject aUnalignedFDSObject) {
        Unit unit = Geometry.LU;
        Point2d point2d = Convert.fromLegacy(aUnalignedFDSObject.getStartPoint(), 0).getP2dValue(unit);
        Point2d point2d2 = Convert.fromLegacy(aUnalignedFDSObject.getEndPoint(), 0).getP2dValue(unit);
        double d = Convert.fromLegacy(aUnalignedFDSObject.getBottom(), 0).getValue(unit);
        double d2 = Convert.fromLegacy(aUnalignedFDSObject.getTop(), 0).getValue(unit);
        double d3 = Convert.fromLegacy(aUnalignedFDSObject.getThickness(), 0).getValue(unit);
        LineSeg lineSeg = new LineSeg(new Point3d(point2d.x, point2d.y, d), new Point3d(point2d2.x, point2d2.y, d));
        WallGeom.Alignment alignment = d3 < 0.0 ? WallGeom.Alignment.RIGHT : WallGeom.Alignment.LEFT;
        return new WallGeom(lineSeg, alignment, Math.abs(d3), d2 - d);
    }

    private FDSObject fromLegacy(Wall wall, DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, MaterialList materialList, SurfaceManager surfaceManager) {
        Surface surface = (Surface)surfaceManager.get(PredefSurf.INERT.name());
        WallGeom wallGeom = Convert.constructGeom(wall);
        Obstruction obstruction = new Obstruction(wall.getName(), wallGeom, new Surface[]{surface});
        obstruction.setOptions(2, !wall.isSawtoothed());
        obstruction.setOptions(1, wall.isThickened());
        obstruction.setOptions(4, wall.permitsHole());
        this.setFDSProps(wall, obstruction, deviceManager, map, materialList, surfaceManager, Obstruction.getSurfaceFilter());
        return obstruction;
    }

    private SimParams fromLegacy(SimParams simParams, Serialized serialized) {
        Serializable serializable;
        ADomainObject aDomainObject;
        ADomainObject aDomainObject2;
        BNDFList bNDFList;
        if (serialized.d_simulationType == 0) {
            simParams.getCalculations().setCalcDNS(false);
        } else {
            simParams.getCalculations().setCalcDNS(true);
        }
        simParams.getCalculations().setCalcIsothermal(serialized.d_isothermal);
        if (serialized.d_baroclinic == 0) {
            simParams.getCalculations().setCorrectBaroclinicTorque(false);
        } else {
            simParams.getCalculations().setCorrectBaroclinicTorque(true);
        }
        simParams.getCalculations().setCsmag(serialized.d_smag);
        if (serialized.d_useGasPhaseFireSuppression.booleanValue()) {
            simParams.getCalculations().setGPFlameExtinction(serialized.d_useGasPhaseFireSuppression);
        }
        simParams.getCalculations().setPrandtlNum(serialized.d_prandtl);
        simParams.getCalculations().setSchmidtNum(serialized.d_schmidt);
        if (serialized.d_ambientPressure != null) {
            simParams.getEnvironment().setAmbPressure(Convert.fromLegacy(serialized.d_ambientPressure, 39));
        }
        if (serialized.d_ambientTemp != null) {
            simParams.getEnvironment().setAmbTemp(Convert.fromLegacy(serialized.d_ambientTemp, 1));
        }
        if (serialized.d_initVel != null) {
            simParams.getEnvironment().setAmbVel(Convert.fromLegacy(serialized.d_initVel, 8));
        }
        if (serialized.d_atmTempLapse != null) {
            simParams.getEnvironment().setAtmLapseRate(Convert.fromLegacy(serialized.d_atmTempLapse, 5));
        }
        if (serialized.d_gvec != null) {
            simParams.getEnvironment().setGravityAccel(Convert.fromLegacy(serialized.d_gvec, 6));
        }
        if (!(bNDFList = serialized.d_bndfList).isEmpty()) {
            aDomainObject2 = bNDFList.iterator().next();
            simParams.getFileOutput().setDtBoundaryFile(Convert.fromLegacy(((BNDFRecord)aDomainObject2).getDTSam(), 2));
        }
        if (!((IsofList)(aDomainObject2 = serialized.d_isofList)).isEmpty()) {
            aDomainObject = ((IsofList)aDomainObject2).iterator().next();
            simParams.getFileOutput().setDtIsofFiles(Convert.fromLegacy(((IsofRecord)aDomainObject).getDtsam(), 2));
        }
        if (serialized.d_partDtsam != null) {
            simParams.getFileOutput().setDtParticleFiles(Convert.fromLegacy(serialized.d_partDtsam, 2));
        }
        if (serialized.d_pl3dRecord.getDTSam() != null) {
            simParams.getFileOutput().setDtPlot3dFile(Convert.fromLegacy(serialized.d_pl3dRecord.getDTSam(), 2));
        }
        if (serialized.d_dtcore != null) {
            simParams.getFileOutput().setDtRestartFile(Convert.fromLegacy(serialized.d_dtcore, 2));
        }
        if (!((SlcfList)(aDomainObject = serialized.d_slcfList)).isEmpty()) {
            serializable = ((SlcfList)aDomainObject).iterator().next();
            simParams.getFileOutput().setDtSliceFiles(Convert.fromLegacy(((SlcfRecord)serializable).getDtsam(), 2));
        }
        simParams.getFileOutput().setNumOutputFrames(serialized.d_numFrames);
        simParams.getFileOutput().setVisualize3dSmoke(!serialized.d_smokeOff);
        simParams.getParticles().setMaxParticlesPerMesh(serialized.d_partMaxDrop);
        simParams.getParticles().setPourousFloor(!serialized.d_notPorousFloor);
        simParams.getRadiTransport().setAngleIncrement(serialized.d_radi.getInt(ANGLE_INCREMENT));
        if (serialized.d_radi.getUD(RADTMP) != null) {
            simParams.getRadiTransport().setAssumedRadSourceTemp(Convert.fromLegacy(serialized.d_radi.getUD(RADTMP), 1));
        }
        if (serialized.d_radi.getUD(KAPPA0) != null) {
            simParams.getRadiTransport().setConstAbsorptionCoef(Convert.fromLegacy(serialized.d_radi.getUD(KAPPA0), 13));
        }
        simParams.getRadiTransport().setIncludeExtraFuelBands(serialized.d_radi.getBool(CH4_BANDS));
        simParams.getRadiTransport().setNonGrayGasAssumption(serialized.d_radi.getBool(WIDE_BAND_MODEL));
        simParams.getRadiTransport().setNumPolarAngles(serialized.d_radi.getInt(NMIEANG));
        simParams.getRadiTransport().setNumSolidAngles(serialized.d_radi.getInt(NUMBER_RADIATION_ANGLES));
        serializable = Convert.fromLegacy(serialized.d_radi.getUD(PATH), 0);
        if (serializable != null && ((UnitDouble)serializable).getValueNoUnit() != 0.0) {
            simParams.getRadiTransport().setRadCalcPathLen((UnitDouble)serializable);
        }
        simParams.getRadiTransport().setRadiationOn(!serialized.d_radSolverOff);
        simParams.getRadiTransport().setTimeStepInc(serialized.d_radi.getInt(TIME_STEP_INCREMENT));
        if (serialized.d_simulationEndTime != null) {
            simParams.getTime().setStopTime(Convert.fromLegacy(serialized.d_simulationEndTime, 2));
        }
        if (serialized.d_initialTimeStep != null) {
            simParams.getTime().setInitTimeStep(Convert.fromLegacy(serialized.d_initialTimeStep, 2));
        }
        if (serialized.d_incompressible) {
            this.d_warnings.addWarning(new Warning("INCOMPRESSIBLE not supported in FDS5", "Dropped"));
        }
        if (serialized.d_outsideTemp != null && !serialized.d_outsideTemp.equals(FDSInputRecord.DEF_OUTSIDE_TEMP)) {
            this.d_warnings.addWarning(new Warning("TMP0 (outside temp) not supported in FDS5", "Dropped"));
        }
        if (serialized.d_charVel != null && !serialized.d_charVel.equals(FDSInputRecord.DEF_CHARACTERISTIC_VELOCITY)) {
            this.d_warnings.addWarning(new Warning("Characteristic velocity not converted", "Dropped"));
        }
        if (serialized.d_gaugeTemp != null && !serialized.d_gaugeTemp.equals(FDSInputRecord.DEF_GAUGE_TEMPERATURE)) {
            this.d_warnings.addWarning(new Warning("Default gauge temperature not converted", "Dropped"));
        }
        if (serialized.d_sprkDtspar != null && !serialized.d_sprkDtspar.equals(FDSInputRecord.DEF_DTSPAR)) {
            this.d_warnings.addWarning(new Warning("DTSPAR not supported in FDS5", "Dropped"));
        }
        if (serialized.d_partNpps != null && !serialized.d_partNpps.equals(FDSInputRecord.DEF_NPPS)) {
            this.d_warnings.addWarning(new Warning("NPPS not supported in FDS5", "Dropped"));
        }
        return simParams;
    }

    private ObjectQuantity getSpecMsr(ExSpecList.MixFrac mixFrac, Quantity quantity) {
        return quantity.create(mixFrac.spec);
    }

    private static StaticQuantity newQuant(Quantity quantity) {
        return quantity.create();
    }

    private static ObjectQuantity newQuant(IPyroObject iPyroObject, Quantity quantity) {
        return quantity.create(iPyroObject);
    }

    private Map<String, IQuantity> getGasPhaseMap() {
        HashMap<String, IQuantity> hashMap = new HashMap<String, IQuantity>();
        hashMap.put(DENSITY, Convert.newQuant(Quantity.DENSITY));
        hashMap.put("TEMPERATURE", Convert.newQuant(Quantity.TEMPERATURE));
        hashMap.put("THERMOCOUPLE", Convert.newQuant(Quantity.THERMOCOUPLE));
        hashMap.put("U-VELOCITY", Convert.newQuant(Quantity.U_VELOCITY));
        hashMap.put("V-VELOCITY", Convert.newQuant(Quantity.V_VELOCITY));
        hashMap.put("W-VELOCITY", Convert.newQuant(Quantity.W_VELOCITY));
        hashMap.put("VELOCITY", Convert.newQuant(Quantity.VELOCITY));
        hashMap.put("PRESSURE", Convert.newQuant(Quantity.PRESSURE));
        hashMap.put("H", Convert.newQuant(Quantity.H));
        hashMap.put("HRRPUV", Convert.newQuant(Quantity.HRRPUV));
        hashMap.put("MIXTURE_FRACTION", Convert.newQuant(Quantity.MIXTURE_FRACTION));
        hashMap.put("DYNAMIC_VISCOSITY", Convert.newQuant(Quantity.VISCOSITY));
        hashMap.put("DIVERGENCE", Convert.newQuant(Quantity.DIVERGENCE));
        hashMap.put("WATER VAPOR", this.getSpecMsr(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_MASS_FRACTION));
        hashMap.put("ABSORPTION_COEFFICIENT", Convert.newQuant(Quantity.ABSORPTION_COEFFICIENT));
        hashMap.put("oxygen", this.getSpecMsr(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("oxygen mass friction", this.getSpecMsr(ExSpecList.MixFrac.OXYGEN, Quantity.SPEC_MASS_FRACTION));
        hashMap.put("fuel", this.getSpecMsr(ExSpecList.MixFrac.FUEL, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("nitrogen", this.getSpecMsr(ExSpecList.MixFrac.NITROGEN, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("water vapor", this.getSpecMsr(ExSpecList.MixFrac.WATER_VAPOR, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("carbon dioxide", this.getSpecMsr(ExSpecList.MixFrac.CARBON_DIOXIDE, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("carbon monoxide", this.getSpecMsr(ExSpecList.MixFrac.CARBON_MONOXIDE, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("soot volume fraction", this.getSpecMsr(ExSpecList.MixFrac.SOOT, Quantity.SPEC_VOLUME_FRACTION));
        hashMap.put("soot density", this.getSpecMsr(ExSpecList.MixFrac.SOOT, Quantity.SPEC_DENSITY));
        hashMap.put("extinction coefficient", Convert.newQuant(Quantity.EXTINCTION_COEFFICIENT));
        hashMap.put("visibility", Convert.newQuant(Quantity.VISIBILITY));
        return hashMap;
    }

    private Map<String, IQuantity> getIntegratedQuantities() {
        HashMap<String, IQuantity> hashMap = new HashMap<String, IQuantity>();
        hashMap.put("VOLUME FLOW", Convert.newQuant(Quantity.VOLUME_FLOW));
        hashMap.put("MASS FLOW", Convert.newQuant(Quantity.MASS_FLOW));
        hashMap.put("HEAT FLOW", Convert.newQuant(Quantity.HEAT_FLOW));
        hashMap.put("HRR", Convert.newQuant(Quantity.HRR));
        return hashMap;
    }

    private List<IQuantity> getGasPhaseMsrs(String string, pyrosim.legacy_2012_1.domain.Serialized serialized, String string2) {
        IQuantity iQuantity = this.d_gasPhaseMap.get(string);
        if (iQuantity != null) {
            return Arrays.asList(iQuantity);
        }
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>();
        if (string.equals("DROPLET_FLUX_X")) {
            for (Particle particle : serialized.particles.flatten()) {
                if (particle.isMassless()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_MASS_FLUX_X));
            }
        } else if (string.equals("DROPLET_FLUX_Y")) {
            for (Particle particle : serialized.particles.flatten()) {
                if (particle.isMassless()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_MASS_FLUX_Y));
            }
        } else if (string.equals("DROPLET_FLUX_Z")) {
            for (Particle particle : serialized.particles.flatten()) {
                if (particle.isMassless()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_MASS_FLUX_Z));
            }
        } else if (string.equals("WMPUV")) {
            for (Particle particle : serialized.particles.flatten()) {
                if (!particle.isWater()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_MPUV));
            }
        }
        if (arrayList.isEmpty()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unsupported %1$s Quantity: %2$s"), string2, string), String.format(Intl.intl("%s quantity dropped."), string2)));
        }
        return arrayList;
    }

    private DeviceManager fromLegacy(DeviceManager deviceManager, pyrosim.legacy_2012_1.domain.Serialized serialized, ThcpList thcpList) {
        ArrayList<AMeasuringDevc> arrayList = new ArrayList<AMeasuringDevc>(thcpList.size());
        for (ThcpRecord cloneable : thcpList) {
            Object object;
            Object object2;
            List<IQuantity> list;
            String string = cloneable.getLabel();
            FreePointLoc freePointLoc = new FreePointLoc(Convert.fromLegacy(cloneable.getLocation(), 0));
            String string2 = cloneable.getGasPhaseQuantity();
            if (string2.equals("THERMOCOUPLE")) {
                arrayList.add(new Thermocouple(string, freePointLoc));
                continue;
            }
            if (string2.equalsIgnoreCase("VOLUME FLOW") || string2.equalsIgnoreCase("MASS FLOW") || string2.equalsIgnoreCase("HEAT FLOW")) {
                list = this.d_intQuanMap.get(string2);
                object2 = new FlowMeasurer(cloneable.getLabel(), (IQuantity)((Object)list), this.box2AARect(cloneable.d_xb), 2);
                arrayList.add((AMeasuringDevc)object2);
                continue;
            }
            if (string2.equalsIgnoreCase("HRR")) {
                list = cloneable.d_xb;
                object2 = new UnitPoint3D(Convert.fromLegacy(((UnitBox3D)((Object)list)).minX, 0), Convert.fromLegacy(((UnitBox3D)((Object)list)).minY, 0), Convert.fromLegacy(((UnitBox3D)((Object)list)).minZ, 0));
                UnitPoint3D unitPoint3D = new UnitPoint3D(Convert.fromLegacy(((UnitBox3D)((Object)list)).maxX, 0), Convert.fromLegacy(((UnitBox3D)((Object)list)).maxY, 0), Convert.fromLegacy(((UnitBox3D)((Object)list)).maxZ, 0));
                object = new UnitAABox((UnitPoint3D)object2, unitPoint3D);
                AABoxMeasurer aABoxMeasurer = new AABoxMeasurer(cloneable.getLabel(), Convert.newQuant(Quantity.HRR), (UnitAABox)object);
                arrayList.add(aABoxMeasurer);
                continue;
            }
            list = this.getGasPhaseMsrs(string2, serialized, Intl.intl("Thermocouple"));
            if (list.size() > 1) {
                for (IQuantity iQuantity : list) {
                    object = string + "_" + string2;
                    arrayList.add(new GasPointMeasurer((String)object, iQuantity, freePointLoc));
                }
                continue;
            }
            if (list.isEmpty()) continue;
            arrayList.add(new GasPointMeasurer(string, list.iterator().next(), freePointLoc));
        }
        for (IDevice iDevice : arrayList) {
            Util.autoRename(deviceManager, iDevice);
            deviceManager.add(iDevice);
        }
        return deviceManager;
    }

    private AARectangle box2AARect(UnitBox3D unitBox3D) {
        UnitPoint3D unitPoint3D = new UnitPoint3D(Convert.fromLegacy(unitBox3D.minX, 0), Convert.fromLegacy(unitBox3D.minY, 0), Convert.fromLegacy(unitBox3D.minZ, 0));
        UnitPoint3D unitPoint3D2 = new UnitPoint3D(Convert.fromLegacy(unitBox3D.maxX, 0), Convert.fromLegacy(unitBox3D.maxY, 0), Convert.fromLegacy(unitBox3D.maxZ, 0));
        return AARectangle.construct(unitPoint3D.getPoint3dValue(Geometry.LU), unitPoint3D2.getPoint3dValue(Geometry.LU));
    }

    private static <T extends IPyroObject> Map<T, T> newModelLookup(IHasher<T> iHasher, Composite<? extends T> composite) {
        theHashMap<T, IPyroObject> theHashMap2 = new theHashMap<T, IPyroObject>(iHasher);
        for (IPyroObject iPyroObject : composite.flatten()) {
            theHashMap2.put(iPyroObject, iPyroObject);
        }
        return theHashMap2;
    }

    private static <T extends INamed> T lookupModel(T t, Map<T, T> map, Composite<T> composite) {
        INamed iNamed = (INamed)composite.get(t.getName());
        if (iNamed != null && t.equals(iNamed)) {
            return (T)iNamed;
        }
        INamed iNamed2 = (INamed)map.get(t);
        if (iNamed2 != null) {
            return (T)iNamed2;
        }
        Util.autoRename(composite, t);
        composite.add(t);
        map.put(t, t);
        return t;
    }

    private DeviceManager fromLegacy(DeviceManager deviceManager, SmokeLinkModelMgr smokeLinkModelMgr, SmodList smodList) {
        Map<SmokeLinkModel, SmokeLinkModel> map = Convert.newModelLookup(new SmokeLinkHasher(), smokeLinkModelMgr);
        for (SmodRecord smodRecord : smodList) {
            Object object;
            int n = smodRecord.getType();
            String string = smodRecord.getUniqueID();
            UnitDouble unitDouble = Convert.fromLegacy(smodRecord.getObscuration(), 31);
            FreePointLoc freePointLoc = new FreePointLoc(Convert.fromLegacy(smodRecord.getLocation(), 0));
            SmokeLinkModel.ISpec iSpec = null;
            if (1 == n) {
                double d = Convert.fromLegacy(smodRecord.getCAlphaC(), 28).getValueNoUnit();
                double d2 = Convert.fromLegacy(smodRecord.getCBetaC(), 28).getValueNoUnit();
                double d3 = Convert.fromLegacy(smodRecord.getCAlphaE(), 28).getValueNoUnit();
                double d4 = Convert.fromLegacy(smodRecord.getCBetaE(), 28).getValueNoUnit();
                iSpec = new SmokeLinkModel.Cleary(d, d2, d3, d4);
            } else if (0 == n) {
                object = Convert.fromLegacy(smodRecord.getLength(), 0);
                iSpec = new SmokeLinkModel.Heskestad((UnitDouble)object);
            }
            assert (iSpec != null);
            object = String.format(Intl.intl("%s Model"), string);
            SmokeLinkModel smokeLinkModel = new SmokeLinkModel((String)object, unitDouble, null, iSpec);
            smokeLinkModel = Convert.lookupModel(smokeLinkModel, map, smokeLinkModelMgr);
            deviceManager.add(new SmokeDetector(string, smokeLinkModel, freePointLoc));
        }
        return deviceManager;
    }

    private DeviceManager fromLegacy(DeviceManager deviceManager, Map<HeatDetector, pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector> map, HeatLinkModelMgr heatLinkModelMgr, HeatDetectorList heatDetectorList) {
        Map<HeatLinkModel, HeatLinkModel> map2 = Convert.newModelLookup(new HeatLinkHasher(), heatLinkModelMgr);
        for (HeatDetector heatDetector : heatDetectorList) {
            String string = heatDetector.getUniqueID();
            UnitDouble unitDouble = Convert.fromLegacy(heatDetector.getRTI(), 3);
            UnitDouble unitDouble2 = Convert.fromLegacy(heatDetector.getActivationTemp(), 1);
            HeatLinkModel heatLinkModel = new HeatLinkModel(string, unitDouble, unitDouble2);
            heatLinkModel = Convert.lookupModel(heatLinkModel, map2, heatLinkModelMgr);
            FreePointLoc freePointLoc = new FreePointLoc(Convert.fromLegacy(heatDetector.getLocation(), 0));
            pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector heatDetector2 = new pyrosim.legacy_2012_1.domain.devices.detectors.HeatDetector(string, heatLinkModel, freePointLoc);
            deviceManager.add(heatDetector2);
            map.put(heatDetector, heatDetector2);
        }
        return deviceManager;
    }

    private DryPipe fromLegacy(DeviceManager deviceManager, PipeRecord pipeRecord) {
        UnitDouble unitDouble;
        UnitDouble unitDouble2 = Convert.fromLegacy(pipeRecord.getPressure(), 39);
        if (unitDouble2 != null && unitDouble2.getValueNoUnit() != 0.0) {
            this.d_warnings.addWarning(new Warning("PIPE: Unable to convert pipe pressure (" + unitDouble2.toString() + ")", "Pipe pressure data ignored."));
        }
        if ((unitDouble = Convert.fromLegacy(pipeRecord.getDelay(), 2)).getValueNoUnit() > 0.0) {
            DryPipe dryPipe = new DryPipe(Intl.intl("DRYPIPE"), unitDouble);
            deviceManager.add(dryPipe);
            return dryPipe;
        }
        return null;
    }

    private DeviceManager fromLegacy(DeviceManager deviceManager, ParticleList particleList, SprinklerLinkModelMgr sprinklerLinkModelMgr, SprayModelMgr sprayModelMgr, DryPipe dryPipe, SprkList sprkList) {
        Map<SprinklerLinkModel, SprinklerLinkModel> map = Convert.newModelLookup(new SprkLinkHasher(), sprinklerLinkModelMgr);
        Map<SprayModel, SprayModel> map2 = Convert.newModelLookup(new SprayModelHasher(), sprayModelMgr);
        Map<Particle, Particle> map3 = Convert.newModelLookup(new ParticleHasher(), particleList);
        for (SprkRecord sprkRecord : sprkList) {
            Object object5;
            Object object2;
            Object object3;
            String string = sprkRecord.getLabel();
            String string2 = sprkRecord.getMake();
            String string3 = sprkRecord.getPartID();
            Object object4 = object3 = string3 == null ? null : (Particle)particleList.get(string3);
            if (object3 != null && ((Particle)object3).isMassless()) {
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Sprinkler particle, %s, is massless."), string3), Intl.intl("Using particle specified in sprinkler make file.")));
                object3 = null;
            }
            UnitPoint3D unitPoint3D = Convert.fromLegacy(sprkRecord.getXYZ(), 0);
            DirectionVector directionVector = sprkRecord.getOrientation();
            Vector3d vector3d = new Vector3d(directionVector.x, directionVector.y, directionVector.z);
            UnitDouble unitDouble = Convert.fromLegacy(sprkRecord.getRotation(), 29);
            FreePointLoc freePointLoc = new FreePointLoc(unitPoint3D, vector3d, unitDouble);
            SprayModel sprayModel = null;
            SprinklerLinkModel sprinklerLinkModel = null;
            File file = null;
            if (this.d_dbDir != null && this.d_dbDir.exists()) {
                file = new File(this.d_dbDir, string2 + ".spk");
            }
            if (file != null && file.exists()) {
                object2 = this.d_sprkParses.get(string2);
                if (object2 != null) {
                    sprayModel = ((SPKReader.SPKResult)object2).d_sprayModel;
                    sprinklerLinkModel = ((SPKReader.SPKResult)object2).d_linkModel;
                } else {
                    object5 = new SPKReader();
                    try {
                        object2 = ((SPKReader)object5).parse(file.getAbsolutePath(), 0.0);
                        sprayModel = ((SPKReader.SPKResult)object2).d_sprayModel;
                        sprinklerLinkModel = ((SPKReader.SPKResult)object2).d_linkModel;
                        sprayModel.setName(string2);
                        if (object3 != null) {
                            sprayModel.setParticle((Particle)object3);
                        }
                        this.d_sprkParses.put(string2, (SPKReader.SPKResult)object2);
                    }
                    catch (Exception exception) {
                        this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Error in sprinkler file, %1$s:  \n%2$s"), file.getAbsolutePath(), exception.getMessage()), Intl.intl("Using default sprinkler properties.")));
                    }
                }
            } else {
                object2 = file != null ? file.getAbsolutePath() : string2 + ".spk";
                this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Could not find sprinkler file, %s."), object2), Intl.intl("Using default sprinkler properties.")));
            }
            if (sprayModel == null || sprinklerLinkModel == null) {
                if (object3 == null) {
                    for (Object object5 : particleList.flatten()) {
                        if (!((Particle)object5).isWater()) continue;
                        object3 = object5;
                        break;
                    }
                    if (object3 == null) {
                        object3 = new Particle(Intl.intl("Water"), new WaterPartDesc());
                    }
                }
                sprayModel = new SprayModel(String.format(Intl.intl("%s_SPRAY"), string), (Particle)object3);
                sprinklerLinkModel = new SprinklerLinkModel(String.format(Intl.intl("%s_LINK"), string));
            }
            object2 = sprayModel.getParticle();
            object2 = Convert.lookupModel(object2, map3, particleList);
            sprayModel.setParticle((Particle)object2);
            sprayModel = Convert.lookupModel(sprayModel, map2, sprayModelMgr);
            sprinklerLinkModel = Convert.lookupModel(sprinklerLinkModel, map, sprinklerLinkModelMgr);
            object5 = new Sprinkler(string, sprayModel, new Sprinkler.TraditionalModel(sprinklerLinkModel), freePointLoc);
            if (dryPipe != null) {
                ((Sprinkler)object5).setDryPipe(dryPipe);
            }
            deviceManager.add((IPyroObject)object5);
        }
        return deviceManager;
    }

    private SimParams fromLegacy(SimParams simParams, HeadRecord headRecord) {
        if (headRecord.getTitle() != null) {
            simParams.setJobTitle(headRecord.getTitle());
        }
        return simParams;
    }

    public static int fromLegacyUnitType(int n) {
        if (n == 14) {
            return 50;
        }
        if (n == 16) {
            return 52;
        }
        return n;
    }

    private static UnitDouble getUnitDouble(pyrosim.legacy_2006_2.domain.Reaction reaction, String string, UnitDouble unitDouble) {
        pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble2 = (pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)reaction.getValue(string);
        Reaction.ValueInfo valueInfo = pyrosim.legacy_2006_2.domain.Reaction.getValueInfo(string);
        if (unitDouble2 != null) {
            return Convert.fromLegacy(unitDouble2, Convert.fromLegacyUnitType(valueInfo.d_unitType));
        }
        if (valueInfo != null && valueInfo.d_defaultValue != null) {
            return Convert.fromLegacy(valueInfo.d_defaultValue, Convert.fromLegacyUnitType(valueInfo.d_unitType));
        }
        return unitDouble;
    }

    private static double getDouble(pyrosim.legacy_2006_2.domain.Reaction reaction, String string, double d) {
        Object object = reaction.getValue(string);
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object != null) {
            return Convert.fromLegacy((pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble)object, 28).getValueNoUnit();
        }
        Reaction.ValueInfo valueInfo = pyrosim.legacy_2006_2.domain.Reaction.getValueInfo(string);
        if (valueInfo != null && valueInfo.d_defaultValue != null) {
            return valueInfo.d_defaultValue.getValueNoUnit();
        }
        return d;
    }

    private ReactionList fromLegacy(ReactionList reactionList, pyrosim.legacy_2006_2.domain.ReactionList reactionList2, String string, SimParams.RadiationTransport radiationTransport) {
        for (pyrosim.legacy_2006_2.domain.Reaction reaction : reactionList2) {
            Reaction reaction2 = new Reaction(reaction.getName());
            FireSuppression fireSuppression = this.convertReacSupp(reaction);
            Fuel fuel = this.convertReacFuel(reaction);
            Byproducts byproducts = this.convertReacByp(reaction, fuel);
            reaction2.setFuel(fuel);
            reaction2.setSuppression(fireSuppression);
            reaction2.setByproducts(byproducts);
            reactionList.add(reaction2);
        }
        Iterator<pyrosim.legacy_2006_2.domain.Reaction> iterator = string != null ? (Reaction)reactionList.get(string) : null;
        reactionList.taskSetActiveReaction((Reaction)((Object)iterator)).run();
        if (iterator != null) {
            double d = Convert.getDouble(reactionList2.get(string), "RADIATIVE_FRACTION", 0.0);
            radiationTransport.setRadiativeLossFraction(d);
        }
        return reactionList;
    }

    private FireSuppression convertReacSupp(pyrosim.legacy_2006_2.domain.Reaction reaction) {
        FireSuppression fireSuppression = new FireSuppression();
        double d = Convert.getDouble(reaction, "X_O2_LL", fireSuppression.d_limitingOxygenIndex);
        UnitDouble unitDouble = Convert.getUnitDouble(reaction, "CRITICAL_FLAME_TEMPERATURE", fireSuppression.d_criticalFlameTemp);
        return new FireSuppression(d, unitDouble);
    }

    private Fuel convertReacFuel(pyrosim.legacy_2006_2.domain.Reaction reaction) {
        double d = Convert.getDouble(reaction, "NU_H2O", 0.0);
        double d2 = Convert.getDouble(reaction, "NU_O2", 0.0);
        double d3 = Convert.getDouble(reaction, "NU_CO2", 0.0);
        double d4 = 2.0 * d;
        double d5 = d3;
        double d6 = 2.0 * (d5 - d2 + d4 / 4.0);
        double d7 = Convert.getDouble(reaction, "FUEL_N2", 0.0);
        double d8 = d7 * 2.0;
        double d9 = Convert.getDouble(reaction, "Y_O2_INFTY", 0.0);
        double d10 = Convert.getDouble(reaction, "Y_F_INLET", 0.0);
        double d11 = 1.0;
        double d12 = 12.0;
        double d13 = 16.0;
        double d14 = 14.0;
        double d15 = d4 * d11 + d5 * d12 + d6 * d13 + d8 * d14;
        double d16 = Convert.getUnitDouble(reaction, "MW_FUEL", null).getValue(SI.GRAM.divide(SI.MOLE));
        if (Math.abs(d15 - d16) > 0.1) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("REAC:%1$s"), reaction.getName()), String.format(Intl.intl("Converted stoichiometry does not add to molecular weight of %1$g."), d16)));
        }
        return new Fuel(d5, d4, d6, d8, 0.0, null, d9, d10);
    }

    private Byproducts convertReacByp(pyrosim.legacy_2006_2.domain.Reaction reaction, Fuel fuel) {
        double d;
        double d2 = Convert.getDouble(reaction, "SOOT_YIELD", 0.0);
        if (reaction.isDefined("CO_YIELD")) {
            d = Convert.getDouble(reaction, "CO_YIELD", 0.0);
        } else {
            double d3 = Convert.getUnitDouble(reaction, "MW_FUEL", null).getValue(SI.GRAM.divide(SI.MOLE));
            double d4 = Convert.getDouble(reaction, "NU_FUEL", 0.0);
            double d5 = fuel.d_carbon;
            d = 12.0 * d5 / (d3 * d4) * 0.0014 + 0.37 * d2;
        }
        Soot soot = new Soot();
        Soot soot2 = null;
        if (d2 > 0.0) {
            UnitDouble unitDouble = Convert.getUnitDouble(reaction, "MASS_EXTINCTION_COEFFICIENT", soot.d_massExtCoeff);
            double d6 = Convert.getDouble(reaction, "VISIBILITY_FACTOR", soot.d_visFactor);
            UnitDouble unitDouble2 = Convert.getUnitDouble(reaction, "MAXIMUM_VISIBILITY", soot.d_maxVisibility);
            soot2 = new Soot(soot.d_hydrogenFrac, unitDouble2, unitDouble, d6);
        }
        Byproducts.OxygenEnergy oxygenEnergy = new Byproducts.OxygenEnergy();
        UnitDouble unitDouble = Convert.getUnitDouble(reaction, "EPUMO2", oxygenEnergy.d_epumo2);
        Byproducts byproducts = new Byproducts();
        return new Byproducts(d, byproducts.d_h2Yield, d2, soot2, new Byproducts.OxygenEnergy(unitDouble, true));
    }

    private Map<String, IQuantity> getSolidPhaseMap() {
        HashMap<String, IQuantity> hashMap = new HashMap<String, IQuantity>();
        hashMap.put(SolidPhaseQuantitiesList.RADIATIVE_FLUX.getName(), Convert.newQuant(Quantity.RADIATIVE_FLUX));
        hashMap.put(SolidPhaseQuantitiesList.CONVECTIVE_FLUX.getName(), Convert.newQuant(Quantity.CONVECTIVE_FLUX));
        hashMap.put(SolidPhaseQuantitiesList.HEAT_FLUX.getName(), Convert.newQuant(Quantity.HEAT_FLUX));
        hashMap.put(SolidPhaseQuantitiesList.GAUGE_HEAT_FLUX.getName(), Convert.newQuant(Quantity.GAUGE_HEAT_FLUX));
        hashMap.put(SolidPhaseQuantitiesList.INCIDENT_HEAT_FLUX.getName(), Convert.newQuant(Quantity.INCIDENT_HEAT_FLUX));
        hashMap.put(SolidPhaseQuantitiesList.WALL_TEMPERATURE.getName(), Convert.newQuant(Quantity.WALL_TEMPERATURE));
        hashMap.put(SolidPhaseQuantitiesList.INSIDE_WALL_TEMPERATURE.getName(), Convert.newQuant(Quantity.INSIDE_WALL_TEMPERATURE));
        hashMap.put(SolidPhaseQuantitiesList.BURNING_RATE.getName(), Convert.newQuant(Quantity.BURNING_RATE));
        hashMap.put(SolidPhaseQuantitiesList.PRESSURE_COEFFICIENT.getName(), Convert.newQuant(Quantity.PRESSURE_COEFFICIENT));
        return hashMap;
    }

    private List<IQuantity> getSolidPhaseMsrs(String string, pyrosim.legacy_2012_1.domain.Serialized serialized, String string2) {
        IQuantity iQuantity = this.d_solidPhaseMap.get(string);
        if (iQuantity != null) {
            return Arrays.asList(iQuantity);
        }
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>();
        if (string.equals(SolidPhaseQuantitiesList.WMPUA.getName())) {
            for (Particle particle : serialized.particles.flatten()) {
                if (!particle.isWater()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_MPUA));
            }
        } else if (string.equals(SolidPhaseQuantitiesList.WCPUA.getName())) {
            for (Particle particle : serialized.particles.flatten()) {
                if (!particle.isWater()) continue;
                arrayList.add(Convert.newQuant(particle, Quantity.PART_CPUA));
            }
        }
        if (arrayList.isEmpty()) {
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Unsupported %1$s Quantity: %2$s"), string2, string), String.format(Intl.intl("%s quantity dropped."), string2)));
        }
        return arrayList;
    }

    private Boundaries fromLegacy(Boundaries boundaries, pyrosim.legacy_2012_1.domain.Serialized serialized, BNDFList bNDFList) {
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>();
        for (BNDFRecord bNDFRecord : bNDFList) {
            String string = bNDFRecord.getQuantity();
            arrayList.addAll(this.getSolidPhaseMsrs(string, serialized, Intl.intl("Boundary")));
        }
        if (!arrayList.isEmpty()) {
            boundaries.setQuantities(arrayList);
        }
        return boundaries;
    }

    private Plot3d fromLegacy(Plot3d plot3d, pyrosim.legacy_2012_1.domain.Serialized serialized, PL3DRecord pL3DRecord) {
        String[] stringArray = pL3DRecord.getQuantities();
        ArrayList<IQuantity> arrayList = new ArrayList<IQuantity>();
        for (int i = 0; i < stringArray.length; ++i) {
            List<IQuantity> list = this.getGasPhaseMsrs(stringArray[i], serialized, Intl.intl("Plot3D"));
            if (list.isEmpty()) continue;
            IQuantity iQuantity = list.iterator().next();
            arrayList.add(iQuantity);
            if (list.size() <= 1) continue;
            ObjectQuantity objectQuantity = (ObjectQuantity)iQuantity;
            Object t = objectQuantity.objects[0];
            this.d_warnings.addWarning(new Warning(String.format(Intl.intl("Cannot add all new Plot3D quantities for the old quantity, %s, due to limited Plot3D size."), stringArray[i]), String.format(Intl.intl("Only adding quantity for object, \"%s.\""), pyrosim.legacy_2012_1.util.Util.getName(t))));
        }
        plot3d.setQuantities(arrayList);
        return plot3d;
    }

    private IsosurfaceMgr fromLegacy(IsosurfaceMgr isosurfaceMgr, pyrosim.legacy_2012_1.domain.Serialized serialized, IsofList isofList) {
        ArrayList<Isosurface> arrayList = new ArrayList<Isosurface>();
        for (IsofRecord isofRecord : isofList) {
            String string = isofRecord.getGasPhaseQuantity();
            Vector vector = isofRecord.getValues();
            List<IQuantity> list = this.getGasPhaseMsrs(string, serialized, Intl.intl("Isosurface"));
            if (list.isEmpty()) continue;
            int n = list.iterator().next().get().unitType;
            ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>();
            for (pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble : vector) {
                arrayList2.add(Convert.fromLegacy(unitDouble, n));
            }
            for (IQuantity iQuantity : list) {
                arrayList.add(new Isosurface(iQuantity, arrayList2));
            }
        }
        isosurfaceMgr.addAll(arrayList);
        return isosurfaceMgr;
    }

    private SliceList fromLegacy(SliceList sliceList, pyrosim.legacy_2012_1.domain.Serialized serialized, SlcfList slcfList) {
        ArrayList<PlanarSlice> arrayList = new ArrayList<PlanarSlice>();
        for (SlcfRecord slcfRecord : slcfList) {
            String string = slcfRecord.getGasPhaseQuantity();
            String string2 = slcfRecord.getPlane();
            pyrosim.legacy_2006_2.thunderheadeng.units.UnitDouble unitDouble = slcfRecord.getValue();
            boolean bl = slcfRecord.getUseVector();
            int n = 0;
            if (string2.compareTo("PBY") == 0) {
                n = 1;
            } else if (string2.compareTo("PBZ") == 0) {
                n = 2;
            }
            UnitDouble unitDouble2 = Convert.fromLegacy(unitDouble, 0);
            List<IQuantity> list = this.getGasPhaseMsrs(string, serialized, Intl.intl("Slice"));
            for (IQuantity iQuantity : list) {
                arrayList.add(new PlanarSlice(n, unitDouble2, iQuantity, bl));
            }
        }
        sliceList.addAll(arrayList);
        return sliceList;
    }

    private static class ParticleHasher
    implements IHasher<Particle> {
        private static final long serialVersionUID = -9116519426979874883L;

        private ParticleHasher() {
        }

        @Override
        public boolean equal(Particle particle, Object object) {
            return particle.propEquals(object);
        }

        @Override
        public int hash(Object object) {
            return object instanceof Particle ? ((Particle)object).propHash() : object.hashCode();
        }
    }

    private static class SprayModelHasher
    implements IHasher<SprayModel> {
        private static final long serialVersionUID = 1464529085164440650L;

        private SprayModelHasher() {
        }

        @Override
        public boolean equal(SprayModel sprayModel, Object object) {
            return sprayModel.propEquals(object);
        }

        @Override
        public int hash(Object object) {
            return object instanceof SprayModel ? ((SprayModel)object).propHash() : object.hashCode();
        }
    }

    private static class SprkLinkHasher
    implements IHasher<SprinklerLinkModel> {
        private static final long serialVersionUID = -8885859096348427403L;

        private SprkLinkHasher() {
        }

        @Override
        public boolean equal(SprinklerLinkModel sprinklerLinkModel, Object object) {
            return sprinklerLinkModel.propEquals(object);
        }

        @Override
        public int hash(Object object) {
            return object instanceof SprinklerLinkModel ? ((SprinklerLinkModel)object).propHash() : object.hashCode();
        }
    }

    private static class SmokeLinkHasher
    implements IHasher<SmokeLinkModel> {
        private static final long serialVersionUID = -4675213479638304632L;

        private SmokeLinkHasher() {
        }

        @Override
        public boolean equal(SmokeLinkModel smokeLinkModel, Object object) {
            return smokeLinkModel.propEquals(object);
        }

        @Override
        public int hash(Object object) {
            return object instanceof SmokeLinkModel ? ((SmokeLinkModel)object).propHash() : object.hashCode();
        }
    }

    private static class HeatLinkHasher
    implements IHasher<HeatLinkModel> {
        private static final long serialVersionUID = -7409016088485187926L;

        private HeatLinkHasher() {
        }

        @Override
        public boolean equal(HeatLinkModel heatLinkModel, Object object) {
            return heatLinkModel.propEquals(object);
        }

        @Override
        public int hash(Object object) {
            return object instanceof HeatLinkModel ? ((HeatLinkModel)object).propHash() : object.hashCode();
        }
    }

    public static class ThermalThickness {
        public final pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps d_thermalProps;
        public final UnitDouble d_thickness;

        public ThermalThickness(pyrosim.legacy_2012_1.domain.boundcond.mat.ThermalProps thermalProps, UnitDouble unitDouble) {
            this.d_thermalProps = thermalProps;
            this.d_thickness = unitDouble;
        }
    }
}

