/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.APyroObject;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.util.Lists;

public class ZoneRenderer
extends AFDS6Renderer {
    private Map<Zone, Integer> d_zoneIxes = new IdentityHashMap<Zone, Integer>();
    private Set<Leak> d_renderedLeaks = new HashSet<Leak>();
    private Map<Zone, List<Leak>> d_leaks = new IdentityHashMap<Zone, List<Leak>>();

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Zone.class);
        set.add(Leak.class);
    }

    public Integer indexOf(Zone zone) {
        if (zone.isOuter()) {
            return 0;
        }
        return this.d_zoneIxes.get(zone);
    }

    private void mapZoneLeak(Zone zone, Leak leak) {
        List<Leak> list = this.d_leaks.get(zone);
        if (list == null) {
            list = new ArrayList<Leak>();
            this.d_leaks.put(zone, list);
        }
        list.add(leak);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        for (IPyroObject iPyroObject : collection) {
            APyroObject aPyroObject;
            if (iPyroObject instanceof Leak) {
                aPyroObject = (Leak)iPyroObject;
                this.mapZoneLeak(((Leak)aPyroObject).zone1, (Leak)aPyroObject);
                this.mapZoneLeak(((Leak)aPyroObject).zone2, (Leak)aPyroObject);
                continue;
            }
            if (!(iPyroObject instanceof Zone) || ((Zone)(aPyroObject = (Zone)iPyroObject)).isOuter()) continue;
            this.d_zoneIxes.put((Zone)aPyroObject, this.d_zoneIxes.size() + 1);
        }
        return super.render(iFDSRecordRenderer, collection);
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        if (iPyroObject instanceof Leak) {
            return true;
        }
        if (!(iPyroObject instanceof Zone) || ((Zone)iPyroObject).isOuter()) {
            return false;
        }
        Zone zone = (Zone)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("ZONE");
        fDSRenderRecord.setValue("ID", zone.getName());
        UnitAABox unitAABox = GeomUtil.getUnitBounds(zone);
        ZoneRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        List<Object> list = Lists.filled(this.d_zoneIxes.size() + 1, null);
        List<Leak> list2 = this.d_leaks.get(zone);
        if (list2 != null) {
            for (Leak leak : list2) {
                Zone zone2;
                Integer n;
                if (!this.d_renderedLeaks.add(leak) || (n = this.indexOf(zone2 = leak.otherZone(zone))) == null) continue;
                list.set(n, leak.area);
            }
        }
        fDSRenderRecord.setValue("LEAK_AREA", list, false);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

