/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.ramp.Ramp;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.common.GeomUtil;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.RTree;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;

public class VentRenderer
extends AFDS6Renderer {
    private final ExSpecRenderer d_specRend;
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;
    private final Map<Vent, String> d_ventNames;
    private final NameGenerator d_nameGen;
    private RTree<Grid> d_grids;
    private final Map<Vent, Integer> d_ventIxes = new LinkedIdentityHashMap<Vent, Integer>();
    private int d_ventIx = 0;

    public VentRenderer(PinConnectionRenderer pinConnectionRenderer, FDSNameMap fDSNameMap, ExSpecRenderer exSpecRenderer, Map<Vent, String> map) {
        this.d_pinConns = pinConnectionRenderer;
        this.d_nameMap = fDSNameMap;
        this.d_specRend = exSpecRenderer;
        this.d_ventNames = map;
        this.d_nameGen = new NameGenerator(Intl.intl("Vent"), 2, false);
        this.d_grids = new RTree();
    }

    public Map<Vent, Integer> getVentIxes() {
        return this.d_ventIxes;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Grid.class);
        set.add(Vent.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        this.d_grids.clear();
        for (Grid grid : (Collection)iFDSRecordRenderer.props().getRasterGridSupplier().apply(collection)) {
            this.d_grids.insert(grid.getBounds(), grid);
        }
        return super.render(iFDSRecordRenderer, theUtil.filter(collection, Vent.class));
    }

    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        if (!(iPyroObject instanceof Vent)) {
            return false;
        }
        Vent vent = (Vent)iPyroObject;
        String string = this.d_nameGen.generateValidName(vent.getName());
        this.d_nameGen.registerName(string);
        this.d_ventNames.put(vent, string);
        return true;
    }

    private Vent.VentGeom snapGeom(Vent.VentGeom ventGeom) {
        Grid[] gridArray = new Grid[]{null};
        IsectArea[] isectAreaArray = new IsectArea[]{new IsectArea(0.0, 0.0)};
        this.d_grids.find(new AABoxTest(ventGeom.getBoundingBox(new AABox()), 1.0E-6), (grid, containment) -> {
            IsectArea isectArea = VentRenderer.getIsectArea(grid, ventGeom);
            if (isectArea == null) {
                return;
            }
            if (isectArea.area > isectAreaArray[0].area) {
                isectAreaArray[0] = isectArea;
                gridArray[0] = grid;
            }
        });
        if (gridArray[0] == null) {
            return ventGeom;
        }
        return new Vent.VentGeom(new AARectangle(ventGeom.d_plane, isectAreaArray[0].snapLoc, ventGeom.d_minx, ventGeom.d_miny, ventGeom.d_maxx, ventGeom.d_maxy, ventGeom.flipped), ventGeom.normal, ventGeom.centerPoint, ventGeom.louver, ventGeom.radius);
    }

    private static IsectArea getIsectArea(Grid grid, Vent.VentGeom ventGeom) {
        double[] dArray;
        double d;
        double d2;
        AABox aABox = grid.getBounds();
        switch (ventGeom.d_plane) {
            case 0: {
                d2 = aABox.getMinX();
                d = aABox.getMaxX();
                dArray = new double[]{aABox.getMinY(), aABox.getMinZ(), aABox.getMaxY(), aABox.getMaxZ()};
                break;
            }
            case 1: {
                d2 = aABox.getMinY();
                d = aABox.getMaxY();
                dArray = new double[]{aABox.getMinX(), aABox.getMinZ(), aABox.getMaxX(), aABox.getMaxZ()};
                break;
            }
            default: {
                d2 = aABox.getMinZ();
                d = aABox.getMaxZ();
                dArray = new double[]{aABox.getMinX(), aABox.getMinY(), aABox.getMaxX(), aABox.getMaxY()};
            }
        }
        boolean bl = theUtil.eq(ventGeom.d_planeVal, d2, 1.0E-6);
        boolean bl2 = theUtil.eq(ventGeom.d_planeVal, d, 1.0E-6);
        if (bl || bl2) {
            double d3;
            double d4 = Double.min(ventGeom.d_maxx, dArray[2]);
            double d5 = Double.max(ventGeom.d_minx, dArray[0]);
            double d6 = Double.min(ventGeom.d_maxy, dArray[3]);
            double d7 = Double.max(ventGeom.d_miny, dArray[1]);
            if (d5 < d4 && d7 < d6 && (d3 = (d4 - d5) * (d6 - d7)) > 1.0E-6) {
                return new IsectArea(d3, bl ? d2 : d);
            }
        }
        return null;
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        boolean bl;
        Object object;
        Vent vent = (Vent)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("VENT");
        if (this.d_ventNames.containsKey(vent)) {
            object = this.d_ventNames.get(vent);
            fDSRenderRecord.setValue("ID", object);
        } else {
            fDSRenderRecord.setValue("ID", vent.getName());
        }
        fDSRenderRecord.setComment(vent.getDesc());
        object = vent.getSurface();
        fDSRenderRecord.setValue("SURF_ID", vent.getSurface().getName());
        Vent.VentGeom ventGeom = this.snapGeom(vent.getVentGeom());
        AABox aABox = ventGeom.getBoundingBox(new AABox());
        VentRenderer.renderAABox(fDSRenderRecord, "XB", aABox);
        int n = GeomUtil.toFDSVec(vent.getNormal());
        if (n != 0) {
            fDSRenderRecord.setValue("IOR", n, true);
        }
        Color color = VentRenderer.resolveSurfaceColor(vent.getColors()[0], (Surface)object);
        VentRenderer.renderColor(fDSRenderRecord, vent.isVisible(), color, "RGB", "COLOR", "TRANSPARENCY");
        VentRenderer.renderTextureOrigin(fDSRenderRecord, "TEXTURE_ORIGIN", vent, vent.getTextureOrigin());
        fDSRenderRecord.setValue("OUTLINE", vent.getOptions(1), false);
        VentRenderer.renderEvac(fDSRenderRecord, "EVACUATION", "MESH_ID", vent.getEvac());
        boolean bl2 = false;
        if (vent.getFireSpreadRate() != null) {
            fDSRenderRecord.setValue("SPREAD_RATE", vent.getFireSpreadRate());
            bl2 = true;
        }
        if (vent.getRadius() != null) {
            fDSRenderRecord.setValue("RADIUS", vent.getRadius(), false);
            bl2 = true;
        }
        boolean bl3 = vent.getFireSpreadRate() != null && vent.getFireSpreadRate().getValueNoUnit() > 0.0;
        boolean bl4 = bl = vent.getRadius() != null && vent.getRadius().getValueNoUnit() > 0.0;
        if (vent.getCenterPoint() != null && (bl3 || bl)) {
            VentRenderer.renderLoc(fDSRenderRecord, "XYZ", vent.getCenterPoint(), true);
        } else if (bl2) {
            VentRenderer.renderLoc(fDSRenderRecord, "XYZ", new UnitPoint3D((aABox.getMaxX() + aABox.getMinX()) / 2.0, (aABox.getMaxY() + aABox.getMinY()) / 2.0, (aABox.getMaxZ() + aABox.getMinZ()) / 2.0, Geometry.LU), true);
        }
        HashMap<String, Ramp> hashMap = new HashMap<String, Ramp>();
        this.renderOpenProps(fDSRenderRecord, vent, hashMap);
        this.renderLouver(fDSRenderRecord, vent.getLouver());
        VentRenderer.renderCustomFDSProps(fDSRenderRecord, vent);
        if (!((NamedPyroObject)object).getName().equals("OPEN") && !((NamedPyroObject)object).getName().equals("MIRROR")) {
            this.d_pinConns.markForInputRetrieval(vent.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
            this.d_pinConns.renderConnections(iFDSRecordRenderer, vent);
        } else {
            iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        }
        this.d_ventIxes.put(vent, this.d_ventIx);
        ++this.d_ventIx;
        RampRenderer.render(iFDSRecordRenderer, hashMap, this.d_pinConns);
        return true;
    }

    private void renderLouver(FDSRenderRecord fDSRenderRecord, Vector3d vector3d) {
        if (vector3d == null) {
            return;
        }
        FDSArray<Double> fDSArray = new FDSArray<Double>(vector3d.x, vector3d.y, vector3d.z);
        fDSRenderRecord.setValue("UVW", fDSArray);
    }

    private void renderOpenProps(FDSRenderRecord fDSRenderRecord, Vent vent, Map<String, Ramp> map) {
        if (vent.getOpenProps() == null) {
            return;
        }
        Vent.OpenProps openProps = vent.getOpenProps();
        fDSRenderRecord.setValue("TMP_EXTERIOR", openProps.temp, false);
        fDSRenderRecord.setValue("DYNAMIC_PRESSURE", openProps.pressure.val, false);
        if (((UnitDouble)openProps.pressure.val).getValueNoUnit() > 0.0) {
            VentRenderer.renderTimeFunc(fDSRenderRecord, this.d_nameMap, map, vent.getName(), openProps.pressure.func, "PRESSURE_RAMP", null);
        }
    }

    private static class IsectArea {
        public final double area;
        public final double snapLoc;

        public IsectArea(double d, double d2) {
            this.area = d;
            this.snapLoc = d2;
        }
    }
}

