/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.appearance.Material;
import pyrosim.domain.boundcond.surf.AirDuct;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BlowerSurfDesc;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.ConstantTempSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.GeneralSurfDesc;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISurfDesc;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.LeakSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SpeciesInjection;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.boundcond.surf.ZonePath;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.zones.Zone;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.ZoneRenderer;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.geom.MatChannel;
import thunderheadeng.scene3d.geom.Texture;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;

public class SurfaceRenderer
extends AFDS6Renderer {
    private static Set<String> s_fdsPredefNames = Sets.fromArrayHS("INERT", "MIRROR", "OPEN", "HVAC", "PERIODIC");
    private final FDSNameMap d_nameMap;
    private final ExSpecRenderer d_specRenderer;
    private final ZoneRenderer d_zoneRenderer;
    private final PinConnectionRenderer d_pinConns;
    private final Map<IImage, String> d_imgFNMap;
    private Surface d_defaultSurface;

    public SurfaceRenderer(FDSNameMap fDSNameMap, ExSpecRenderer exSpecRenderer, ZoneRenderer zoneRenderer, PinConnectionRenderer pinConnectionRenderer, Map<IImage, String> map) {
        this.d_specRenderer = exSpecRenderer;
        this.d_nameMap = fDSNameMap;
        this.d_zoneRenderer = zoneRenderer;
        this.d_pinConns = pinConnectionRenderer;
        this.d_imgFNMap = map;
        this.d_defaultSurface = null;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Surface.class);
        set.add(SimParams.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Serializable serializable;
        if (iPyroObject.getClass().equals(SimParams.class)) {
            SimParams simParams = (SimParams)iPyroObject;
            this.d_defaultSurface = simParams.getMisc().getSurfDefault();
            return true;
        }
        Surface surface = (Surface)iPyroObject;
        if (s_fdsPredefNames.contains(surface.getName())) {
            return false;
        }
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("SURF");
        fDSRenderRecord.setValue("ID", surface.getName());
        String string = surface.getFYI().trim();
        if (string.length() > 0) {
            fDSRenderRecord.setValue("FYI", string);
        }
        Color color = surface.getColor();
        SurfaceRenderer.renderColor(fDSRenderRecord, true, color, "RGB", "COLOR", "TRANSPARENCY");
        this.renderDefault(fDSRenderRecord, surface);
        Material material = surface.getAppearance();
        if (material != null && material.getAttributes().getTexture(MatChannel.DIFFUSE) != null) {
            serializable = material.getAttributes().getTexture(MatChannel.DIFFUSE);
            String string2 = this.d_imgFNMap.get(((Texture)serializable).image);
            if (string2 == null) {
                string2 = new File(((Texture)serializable).image.getFilename()).getName();
            }
            fDSRenderRecord.setValue("TEXTURE_MAP", string2);
            fDSRenderRecord.setValue("TEXTURE_WIDTH", material.getWidth(), false);
            fDSRenderRecord.setValue("TEXTURE_HEIGHT", material.getHeight(), false);
        }
        serializable = new HashMap<String, Ramp>();
        this.render(fDSRenderRecord, (Map<String, Ramp>)((Object)serializable), surface, surface.getSurfDesc());
        SurfaceRenderer.renderCustomFDSProps(fDSRenderRecord, surface);
        iFDSRecordRenderer.props().pushProps();
        iFDSRecordRenderer.props().setRenderMultiLine(true);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        iFDSRecordRenderer.props().popProps();
        RampRenderer.render(iFDSRecordRenderer, serializable, this.d_pinConns);
        return true;
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, ISurfDesc iSurfDesc) {
        if (iSurfDesc instanceof SurfDescStatic.Inert) {
            this.render(fDSRenderRecord, (SurfDescStatic.Inert)iSurfDesc);
        } else if (iSurfDesc instanceof SurfDescStatic.Adiabatic) {
            this.render(fDSRenderRecord, (SurfDescStatic.Adiabatic)iSurfDesc);
        } else if (iSurfDesc instanceof BurnerSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (BurnerSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof LayeredSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (LayeredSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof GeneralSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (GeneralSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof ConstantTempSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (ConstantTempSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof InFlowSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (InFlowSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof BlowerSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (BlowerSurfDesc)iSurfDesc);
        } else if (iSurfDesc instanceof LeakSurfDesc) {
            this.render(fDSRenderRecord, map, surface, (LeakSurfDesc)iSurfDesc);
        }
    }

    private void render(FDSRenderRecord fDSRenderRecord, SurfDescStatic.Inert inert) {
    }

    private void render(FDSRenderRecord fDSRenderRecord, SurfDescStatic.Adiabatic adiabatic) {
        fDSRenderRecord.setValue("ADIABATIC", true);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, LeakSurfDesc leakSurfDesc) {
        this.renderZoneConnection(fDSRenderRecord, "LEAK_PATH", leakSurfDesc.d_leak);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, BurnerSurfDesc burnerSurfDesc) {
        this.renderHeatRelease(fDSRenderRecord, map, surface, burnerSurfDesc.d_heatRelease);
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, burnerSurfDesc.d_temperature, true);
        this.renderParticlInj(fDSRenderRecord, map, surface, burnerSurfDesc.d_partInj);
        this.renderGeometry(fDSRenderRecord, burnerSurfDesc.d_geometry);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, GeneralSurfDesc generalSurfDesc) {
        this.renderAirFlow(fDSRenderRecord, map, surface, generalSurfDesc.d_airflow, false);
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, generalSurfDesc.d_tempReg, false);
        this.renderParticlInj(fDSRenderRecord, map, surface, generalSurfDesc.d_partInj);
        this.renderSpecInjs(fDSRenderRecord, map, surface, generalSurfDesc.d_specInj);
        this.renderGeometry(fDSRenderRecord, generalSurfDesc.d_geometry);
        this.renderHeatRelease(fDSRenderRecord, map, surface, generalSurfDesc.d_heatRelease);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, ConstantTempSurfDesc constantTempSurfDesc) {
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, constantTempSurfDesc.d_tempReg, true);
        this.renderParticlInj(fDSRenderRecord, map, surface, constantTempSurfDesc.d_partInj);
        this.renderGeometry(fDSRenderRecord, constantTempSurfDesc.d_geometry);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, InFlowSurfDesc inFlowSurfDesc) {
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, inFlowSurfDesc.d_temperature, false);
        this.renderAirFlow(fDSRenderRecord, map, surface, inFlowSurfDesc.d_airFlow, false);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, BlowerSurfDesc blowerSurfDesc) {
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, blowerSurfDesc.d_tempReg, false);
        this.renderAirFlow(fDSRenderRecord, map, surface, blowerSurfDesc.d_airFlow, true);
        this.renderParticlInj(fDSRenderRecord, map, surface, blowerSurfDesc.d_partInj);
        this.renderGeometry(fDSRenderRecord, blowerSurfDesc.d_geometry);
    }

    private void render(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, LayeredSurfDesc layeredSurfDesc) {
        this.renderZoneConnection(fDSRenderRecord, "LEAK_PATH", layeredSurfDesc.d_leakPath);
        SurfaceRenderer.renderTempRegulation(fDSRenderRecord, this.d_nameMap, map, surface, layeredSurfDesc.d_temperature, false);
        this.renderReaction(fDSRenderRecord, map, surface, layeredSurfDesc.d_iReac);
        fDSRenderRecord.setValue("BURN_AWAY", layeredSurfDesc.d_burnAway, false);
        this.renderSurfComp(fDSRenderRecord, map, surface, layeredSurfDesc.d_surfComp);
        this.renderParticlInj(fDSRenderRecord, map, surface, layeredSurfDesc.d_partInj);
        this.renderSpecInjs(fDSRenderRecord, map, surface, layeredSurfDesc.d_specInj);
        this.renderGeometry(fDSRenderRecord, layeredSurfDesc.d_geometry);
    }

    private void renderDefault(FDSRenderRecord fDSRenderRecord, Surface surface) {
        if (surface.equals(this.d_defaultSurface)) {
            fDSRenderRecord.setValue("DEFAULT", true);
        }
    }

    private void renderGeometry(FDSRenderRecord fDSRenderRecord, IGeometry iGeometry) {
        if (iGeometry instanceof IGeometry.Default) {
            return;
        }
        if (iGeometry instanceof IGeometry.Cartesian) {
            IGeometry.Cartesian cartesian = (IGeometry.Cartesian)iGeometry;
            fDSRenderRecord.setValue("GEOMETRY", "CARTESIAN");
            fDSRenderRecord.setValue("LENGTH", cartesian.length);
            fDSRenderRecord.setValue("WIDTH", cartesian.width);
            FDSArray<UnitDouble> fDSArray = new FDSArray<UnitDouble>(new int[]{FDS6Const.SURF_LAYER_DIMENSIONS[0]});
            fDSArray.set(cartesian.thickness, new int[]{0});
            if (cartesian.thickness != null) {
                fDSRenderRecord.setValue("THICKNESS", fDSArray);
            }
        } else if (iGeometry instanceof IGeometry.Cylindrical) {
            IGeometry.Cylindrical cylindrical = (IGeometry.Cylindrical)iGeometry;
            fDSRenderRecord.setValue("GEOMETRY", "CYLINDRICAL");
            this.renderSimpleVariant(fDSRenderRecord, "LENGTH", cylindrical.lengthVar);
            if (cylindrical.innerRadius != null) {
                fDSRenderRecord.setValue("INNER_RADIUS", cylindrical.innerRadius);
            } else if (cylindrical.radius != null) {
                fDSRenderRecord.setValue("RADIUS", cylindrical.radius);
            }
        } else if (iGeometry instanceof IGeometry.Spherical) {
            IGeometry.Spherical spherical = (IGeometry.Spherical)iGeometry;
            fDSRenderRecord.setValue("GEOMETRY", "SPHERICAL");
            if (spherical.innerRadius != null) {
                fDSRenderRecord.setValue("INNER_RADIUS", spherical.innerRadius);
            } else if (spherical.radius != null) {
                fDSRenderRecord.setValue("RADIUS", spherical.radius);
            }
        }
    }

    private void renderSpecInjs(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, SpecInjList specInjList) {
        if (specInjList == null) {
            return;
        }
        Collection<SpeciesInjection> collection = specInjList.getInjections();
        Object[] objectArray = new Object[collection.size()];
        UnitDouble[] unitDoubleArray = new UnitDouble[collection.size()];
        String[] stringArray = new String[collection.size()];
        String[] stringArray2 = new String[collection.size()];
        int n = 0;
        for (SpeciesInjection speciesInjection : specInjList.getInjections()) {
            this.renderSpecInj(speciesInjection, n, surface, map, objectArray, unitDoubleArray, stringArray, stringArray2);
            ++n;
        }
        String string = specInjList.injType == 0 ? "MASS_FLUX" : "MASS_FRACTION";
        fDSRenderRecord.setValue(string, Arrays.asList(objectArray), false);
        fDSRenderRecord.setValue("SPEC_ID", Arrays.asList(stringArray), false);
        fDSRenderRecord.setValue("RAMP_MF", Arrays.asList(stringArray2), false);
        fDSRenderRecord.setValue("TAU_MF", Arrays.asList(unitDoubleArray), false);
    }

    private void renderSpecInj(SpeciesInjection speciesInjection, int n, Surface surface, Map<String, Ramp> map, Object[] objectArray, UnitDouble[] unitDoubleArray, String[] stringArray, String[] stringArray2) {
        objectArray[n] = speciesInjection.val;
        stringArray[n] = speciesInjection.species.getName();
        if (speciesInjection.func instanceof TimeFunction.TanH) {
            unitDoubleArray[n] = (UnitDouble)((TimeFunction.TanH)speciesInjection.func).val;
        } else if (speciesInjection.func instanceof TimeFunction.TSquared) {
            UnitDouble unitDouble = (UnitDouble)((TimeFunction.TSquared)speciesInjection.func).val;
            unitDoubleArray[n] = unitDouble.negate();
        } else {
            Ramp ramp = (Ramp)((TimeFunction.Custom)speciesInjection.func).val;
            String string = RampRenderer.createID(this.d_nameMap, surface.getName(), "RAMP_MF");
            map.put(string, ramp);
            stringArray2[n] = string;
        }
    }

    private void renderParticlInj(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, ParticleInjection particleInjection) {
        if (particleInjection == null || particleInjection.getParticle() == null) {
            return;
        }
        fDSRenderRecord.setValue("PART_ID", particleInjection.getParticle().getName());
        fDSRenderRecord.setValue("NPPC", particleInjection.d_numPartsPerCell, false);
        if (particleInjection.getMassFlux() != null && ((UnitDouble)particleInjection.getMassFlux().val).getValueNoUnit() != 0.0) {
            fDSRenderRecord.setValue("PARTICLE_MASS_FLUX", particleInjection.getMassFlux().val, false);
            SurfaceRenderer.renderTimeFunc(fDSRenderRecord, this.d_nameMap, map, surface.getName(), particleInjection.getMassFlux().func, "RAMP_PART", "TAU_PART");
        }
        fDSRenderRecord.setValue("DT_INSERT", particleInjection.d_dtInsert, false);
    }

    private void renderBacking(FDSRenderRecord fDSRenderRecord, Backing backing) {
        String string = null;
        if (backing instanceof Backing.AirGap) {
            string = "VOID";
            fDSRenderRecord.setValue("TMP_BACK", ((Backing.AirGap)backing).d_airTemp, false);
        } else if (backing instanceof Backing.Exposed) {
            string = "EXPOSED";
        } else if (backing instanceof Backing.Insulated) {
            string = "INSULATED";
        }
        fDSRenderRecord.setValue("BACKING", string, false);
    }

    private void renderHeatRelease(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, HeatRelease heatRelease) {
        String string = heatRelease.d_type instanceof HeatRelease.HRRType ? "HRRPUA" : "MLRPUA";
        SurfaceRenderer.renderTVal(fDSRenderRecord, this.d_nameMap, map, surface.getName(), heatRelease.d_type, string, "RAMP_Q", "TAU_Q", true);
        fDSRenderRecord.setValue("E_COEFFICIENT", heatRelease.d_extingCoeff, false);
    }

    public static void renderTempRegulation(FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, Surface surface, TempRegulation tempRegulation, boolean bl) {
        if (tempRegulation.d_logarithmic) {
            fDSRenderRecord.setValue("HEAT_TRANSFER_MODEL", "LOGLAW");
        } else if (tempRegulation.d_htCoef != null) {
            fDSRenderRecord.setValue("HEAT_TRANSFER_COEFFICIENT", tempRegulation.d_htCoef);
        }
        if (tempRegulation.isAdiabaticTR()) {
            fDSRenderRecord.setValue("ADIABATIC", true);
        } else if (tempRegulation.isNetHeatFluxTR()) {
            fDSRenderRecord.setValue("NET_HEAT_FLUX", tempRegulation.d_thermalBCs.d_netHeatFlux);
            fDSRenderRecord.setValue("EMISSIVITY", tempRegulation.d_thermalBCs.d_emissivity, false);
        } else if (tempRegulation.isGrossFluxTR()) {
            fDSRenderRecord.setValue("TMP_FRONT", tempRegulation.d_thermalBCs.d_temperature, bl);
            fDSRenderRecord.setValue("EMISSIVITY", tempRegulation.d_thermalBCs.d_emissivity, false);
            fDSRenderRecord.setValue("CONVECTIVE_HEAT_FLUX", tempRegulation.d_thermalBCs.d_heatFlux, false);
            String string = "RAMP_T";
            String string2 = "TAU_T";
            if (tempRegulation.d_thermalBCs.d_heatFlux.getValueNoUnit() != 0.0) {
                string = "RAMP_Q";
                string2 = "TAU_Q";
            }
            SurfaceRenderer.renderTimeFunc(fDSRenderRecord, fDSNameMap, map, surface.getName(), tempRegulation.d_thermalBCs.d_rampup, string, string2);
        } else if (tempRegulation.isFixedTempTR()) {
            fDSRenderRecord.setValue("TMP_FRONT", tempRegulation.d_thermalBCs.d_temperature);
            fDSRenderRecord.setValue("EMISSIVITY", tempRegulation.d_thermalBCs.d_emissivity, false);
        } else if (tempRegulation.isCalcTempTR()) {
            fDSRenderRecord.setValue("EMISSIVITY", tempRegulation.d_thermalBCs.d_emissivity, false);
        }
    }

    private void renderAirDuct(FDSRenderRecord fDSRenderRecord, AirDuct airDuct) {
        if (airDuct == null) {
            return;
        }
        Zone[] zoneArray = airDuct.d_ductPath.getZones();
        if (zoneArray[0] == null || zoneArray[1] == null) {
            return;
        }
    }

    private void renderZoneConnection(FDSRenderRecord fDSRenderRecord, String string, ZonePath zonePath) {
        if (zonePath == null) {
            return;
        }
        Zone[] zoneArray = zonePath.getZones();
        if (zoneArray[0] == null || zoneArray[1] == null) {
            return;
        }
        Integer[] integerArray = new Integer[]{this.d_zoneRenderer.indexOf(zoneArray[0]), this.d_zoneRenderer.indexOf(zoneArray[1])};
        FDSArray<Integer> fDSArray = new FDSArray<Integer>((T[])integerArray);
        fDSRenderRecord.setValue(string, fDSArray);
    }

    private void renderAirFlow(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, AirFlow airFlow, boolean bl) {
        Serializable serializable;
        Object object;
        if (airFlow.d_rate instanceof AirFlow.ValRate) {
            object = airFlow.d_rate instanceof AirFlow.NormalVel ? "VEL" : (airFlow.d_rate instanceof AirFlow.VolumeFlux ? "VOLUME_FLOW" : "MASS_FLUX_TOTAL");
            serializable = (AirFlow.ValRate)airFlow.d_rate;
            if (bl) {
                fDSRenderRecord.setValue((String)object, serializable.val.negate(), true);
            } else {
                fDSRenderRecord.setValue((String)object, serializable.val, true);
            }
        }
        SurfaceRenderer.renderTimeFunc(fDSRenderRecord, this.d_nameMap, map, surface.getName(), airFlow.d_rate.func, "RAMP_V", "TAU_V");
        object = new FDSArray<Object>(airFlow.d_rate.tanVelU, airFlow.d_rate.tanVelV);
        fDSRenderRecord.setValue("VEL_T", object, false);
        if (airFlow.d_profile instanceof AirFlow.TopHatProf) {
            fDSRenderRecord.setValue("PROFILE", FDS6Const.TOP_HAT, false);
        } else if (airFlow.d_profile instanceof AirFlow.ParabolicProf) {
            fDSRenderRecord.setValue("PROFILE", "PARABOLIC", false);
        } else if (airFlow.d_profile instanceof AirFlow.AtmosphericProf) {
            fDSRenderRecord.setValue("PROFILE", "ATMOSPHERIC", false);
            serializable = (AirFlow.AtmosphericProf)airFlow.d_profile;
            fDSRenderRecord.setValue("PLE", ((AirFlow.AtmosphericProf)serializable).d_exponent, false);
            fDSRenderRecord.setValue("Z0", ((AirFlow.AtmosphericProf)serializable).d_origin, false);
        }
        if (bl) {
            this.renderSpecInjs(fDSRenderRecord, map, surface, airFlow.d_rate.specInj);
        }
    }

    private void renderReaction(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, Fuel.IReaction iReaction) {
        if (iReaction instanceof Fuel.MaterialReac) {
            return;
        }
        Fuel.ManualReac manualReac = (Fuel.ManualReac)iReaction;
        this.renderHeatRelease(fDSRenderRecord, map, surface, manualReac.d_heatRelease);
        fDSRenderRecord.setValue("HEAT_OF_VAPORIZATION", manualReac.d_heatOfVap, true);
        if (manualReac.d_ignition instanceof Fuel.ManualReac.TemperatureIgnite) {
            fDSRenderRecord.setValue("IGNITION_TEMPERATURE", ((Fuel.ManualReac.TemperatureIgnite)manualReac.d_ignition).d_temperature, true);
        }
    }

    private void renderSurfComp(FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, Surface surface, SurfComposition surfComposition) {
        fDSRenderRecord.setValue("TMP_INNER", surfComposition.d_initInnerTemp, false);
        SurfaceRenderer.renderTimeFunc(fDSRenderRecord, this.d_nameMap, map, surface.getName(), surfComposition.d_tempRamp, "RAMP_T", "TAU_T");
        this.renderBacking(fDSRenderRecord, surfComposition.d_backing);
        FDSArray<String> fDSArray = new FDSArray<String>(FDS6Const.SURF_LAYER_DIMENSIONS);
        FDSArray<Double> fDSArray2 = new FDSArray<Double>(FDS6Const.SURF_LAYER_DIMENSIONS);
        FDSArray<UnitDouble> fDSArray3 = new FDSArray<UnitDouble>(new int[]{FDS6Const.SURF_LAYER_DIMENSIONS[0]});
        int[] nArray = new int[2];
        for (int i = 0; i < surfComposition.d_layers.size(); ++i) {
            SurfComposition.SurfLayer surfLayer = surfComposition.d_layers.get(i);
            fDSArray3.set(surfLayer.d_thickness, new int[]{i});
            nArray[0] = i;
            int n = 0;
            for (SurfComposition.SurfLayer.SurfComponent surfComponent : surfLayer.getComponents()) {
                nArray[1] = n++;
                fDSArray2.set(surfComponent.d_massFraction, nArray);
                fDSArray.set(surfComponent.d_material.getName(), nArray);
            }
        }
        fDSRenderRecord.setValue("MATL_ID", fDSArray);
        fDSRenderRecord.setValue("MATL_MASS_FRACTION", fDSArray2, false);
        fDSRenderRecord.setValue("THICKNESS", fDSArray3);
        fDSRenderRecord.setValue("LAYER_DIVIDE", surfComposition.d_layerDivide, false);
    }
}

