/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.AirFlow;
import pyrosim.domain.boundcond.surf.Backing;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.HeatRelease;
import pyrosim.domain.boundcond.surf.IGeometry;
import pyrosim.domain.boundcond.surf.ISlip;
import pyrosim.domain.boundcond.surf.InFlowSurfDesc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.ParticleInjection;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.boundcond.surf.SurfComposition;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.TempRegulation;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6ParsingInfo;
import pyrosim.io.fds.v6.parsers.MaterialParser;
import pyrosim.io.fds.v6.parsers.ParticleParser;
import pyrosim.io.fds.v6.parsers.PinConnParser;
import pyrosim.io.fds.v6.parsers.SurfaceParser;
import pyrosim.io.fds.v6.parsers.ZoneParser;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.MaterialRenderer;
import pyrosim.io.fds.v6.renderers.ParticleRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.SurfaceRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class SurfaceRenderTest
extends ParseTest {
    private PyroMod d_mod;
    private FDSNameMap d_nameMap;
    private ExSpecRenderer d_specRenderer;
    private SurfaceRenderer d_surfRenderer;
    private FDSStringRenderer d_fdsRenderProps;
    private FDS6ParsingInfo d_pinfo;
    private SurfaceParser d_surfParser;

    public SurfaceRenderTest(String string) {
        super(string, FDS6Const.getRecordSpecs());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.d_mod = new PyroMod();
        this.d_nameMap = new FDSNameMap();
        PinConnectionRenderer pinConnectionRenderer = new PinConnectionRenderer(this.d_nameMap);
        this.d_specRenderer = new ExSpecRenderer(this.d_nameMap, pinConnectionRenderer);
        this.d_surfRenderer = new SurfaceRenderer(this.d_nameMap, this.d_specRenderer, null, pinConnectionRenderer, Collections.EMPTY_MAP);
        this.d_fdsRenderProps = new FDSStringRenderer(new FDSRenderProps());
        this.d_pinfo = new FDS6ParsingInfo(null, this.d_mod, this.d_mod);
        ZoneParser zoneParser = new ZoneParser(this.d_pinfo);
        this.d_surfParser = new SurfaceParser(this.d_pinfo, zoneParser);
    }

    public void testSurfaceRenderer_Inert() {
        Surface surface = new Surface("SURF02");
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_surfRenderer.render((IFDSRecordRenderer)this.d_fdsRenderProps, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(this.d_fdsRenderProps.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof SurfDescStatic.Inert));
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    public void testSurfaceRenderer_Adiabatic() {
        Surface surface = new Surface("SURF02", new Color(5, 5, 5), null, new SurfDescStatic.Adiabatic());
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_surfRenderer.render((IFDSRecordRenderer)this.d_fdsRenderProps, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(this.d_fdsRenderProps.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)surface.getSurfDesc().equals(surface2.getSurfDesc()));
            SurfaceRenderTest.assertEquals((Object)new Color(5, 5, 5), (Object)surface2.getColor());
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    public void testSurfaceRenderer_Layered() {
        Material material = new Material("MAT");
        this.d_mod.getMaterialMgr().add(material);
        Material material2 = new Material("MAT02");
        this.d_mod.getMaterialMgr().add(material2);
        Material material3 = new Material("MAT03");
        this.d_mod.getMaterialMgr().add(material3);
        FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
        FDSStringRenderer fDSStringRenderer2 = new FDSStringRenderer(new FDSRenderProps());
        PinConnectionRenderer pinConnectionRenderer = new PinConnectionRenderer(this.d_nameMap);
        MaterialRenderer materialRenderer = new MaterialRenderer(this.d_nameMap, pinConnectionRenderer);
        materialRenderer.render((IFDSRecordRenderer)fDSStringRenderer2, (IPyroObject)material);
        FDSStringRenderer fDSStringRenderer3 = new FDSStringRenderer(new FDSRenderProps());
        materialRenderer.render((IFDSRecordRenderer)fDSStringRenderer3, (IPyroObject)material2);
        FDSStringRenderer fDSStringRenderer4 = new FDSStringRenderer(new FDSRenderProps());
        materialRenderer.render((IFDSRecordRenderer)fDSStringRenderer4, (IPyroObject)material3);
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            MaterialParser materialParser = new MaterialParser(this.d_pinfo);
            materialParser.process(this.parseRecord(fDSStringRenderer2.toString()));
            materialParser.process(this.parseRecord(fDSStringRenderer3.toString()));
            materialParser.process(this.parseRecord(fDSStringRenderer4.toString()));
            HeatRelease.HRRType hRRType = new HeatRelease.HRRType(new UnitDouble(88.0, SIUS.unit(22)), TimeFunction.newDefault());
            HeatRelease heatRelease = new HeatRelease(hRRType, new UnitDouble(21.5, SIUS.unit(21)));
            Fuel.ManualReac manualReac = new Fuel.ManualReac(heatRelease, new UnitDouble(22.0, SIUS.unit(46)), new Fuel.ManualReac.ImmediateIgnite());
            ArrayList<SurfComposition.SurfLayer.SurfComponent> arrayList = new ArrayList<SurfComposition.SurfLayer.SurfComponent>(1);
            arrayList.add(new SurfComposition.SurfLayer.SurfComponent(1.0, material));
            ArrayList<SurfComposition.SurfLayer> arrayList2 = new ArrayList<SurfComposition.SurfLayer>(2);
            arrayList2.add(new SurfComposition.SurfLayer(new UnitDouble(2.2, SIUS.unit(0)), arrayList));
            SurfComposition surfComposition = new SurfComposition(new UnitDouble(20.0, SI.CELSIUS), TimeFunction.newDefault(), Backing.newDefault(), null, arrayList2);
            SpecInjList specInjList = new SpecInjList();
            Surface surface = new Surface("SURF02", new Color(7, 7, 7), null, new LayeredSurfDesc(IGeometry.DEFAULT, ISlip.NO_SLIP, manualReac, surfComposition, specInjList, null, false, null, TempRegulation.newDefault()));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof LayeredSurfDesc));
            SurfaceRenderTest.assertEquals((Object)new Color(7, 7, 7), (Object)surface2.getColor());
            LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)2.2, (Object)layeredSurfDesc.d_surfComp.d_layers.get((int)0).d_thickness.getValue(SIUS.unit(0)));
            SurfaceRenderTest.assertEquals((String)"MAT", (String)layeredSurfDesc.d_surfComp.d_layers.get((int)0).getComponents().iterator().next().d_material.getName());
            SurfaceRenderTest.assertEquals((Object)1.0, (Object)layeredSurfDesc.d_surfComp.d_layers.get((int)0).getComponents().iterator().next().d_massFraction);
            SurfaceRenderTest.assertEquals((Object)20.0, (Object)layeredSurfDesc.d_surfComp.d_initInnerTemp.getValue(SIUS.unit(1)));
            SurfaceRenderTest.assertEquals((Object)TimeFunction.newDefault(), (Object)layeredSurfDesc.d_surfComp.d_tempRamp);
            SurfaceRenderTest.assertEquals((Object)Backing.newDefault(), (Object)layeredSurfDesc.d_surfComp.d_backing);
            SurfaceRenderTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.ManualReac));
            SurfaceRenderTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type instanceof HeatRelease.HRRType));
            SurfaceRenderTest.assertEquals((Object)88.0, (Object)((UnitDouble)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type.val).getValue(SIUS.unit(22)));
            SurfaceRenderTest.assertEquals((Object)21.5, (Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_extingCoeff.getValue(SIUS.unit(21)));
            SurfaceRenderTest.assertEquals((Object)22.0, (Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatOfVap.getValue(SIUS.unit(46)));
            SurfaceRenderTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_ignition instanceof Fuel.ManualReac.ImmediateIgnite));
            HeatRelease.MLRType mLRType = new HeatRelease.MLRType(new UnitDouble(77.0, SIUS.unit(44)), TimeFunction.newDefault());
            heatRelease = new HeatRelease(mLRType, new UnitDouble(20.0, SIUS.unit(21)));
            manualReac = new Fuel.ManualReac(heatRelease, new UnitDouble(23.0, SIUS.unit(46)), new Fuel.ManualReac.ImmediateIgnite());
            arrayList = new ArrayList(3);
            arrayList.add(new SurfComposition.SurfLayer.SurfComponent(1.0, material2));
            arrayList2 = new ArrayList(2);
            arrayList2.add(new SurfComposition.SurfLayer(new UnitDouble(2.2, SIUS.unit(0)), arrayList));
            surfComposition = new SurfComposition(new UnitDouble(20.0, SI.CELSIUS), TimeFunction.newDefault(), Backing.newDefault(), null, arrayList2);
            specInjList = new SpecInjList();
            surface = new Surface("SURF03", new Color(7, 7, 7), null, new LayeredSurfDesc(IGeometry.DEFAULT, ISlip.FREE_SLIP, manualReac, surfComposition, specInjList, null, false, null, TempRegulation.newDefault()));
            fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof LayeredSurfDesc));
            SurfaceRenderTest.assertEquals((Object)new Color(7, 7, 7), (Object)surface2.getColor());
            layeredSurfDesc = (LayeredSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)2.2, (Object)layeredSurfDesc.d_surfComp.d_layers.get((int)0).d_thickness.getValue(SIUS.unit(0)));
            SurfaceRenderTest.assertEquals((String)"MAT02", (String)layeredSurfDesc.d_surfComp.d_layers.get((int)0).getComponents().iterator().next().d_material.getName());
            SurfaceRenderTest.assertEquals((Object)1.0, (Object)layeredSurfDesc.d_surfComp.d_layers.get((int)0).getComponents().iterator().next().d_massFraction);
            SurfaceRenderTest.assertEquals((Object)20.0, (Object)layeredSurfDesc.d_surfComp.d_initInnerTemp.getValue(SIUS.unit(1)));
            SurfaceRenderTest.assertEquals((Object)TimeFunction.newDefault(), (Object)layeredSurfDesc.d_surfComp.d_tempRamp);
            SurfaceRenderTest.assertTrue((boolean)(layeredSurfDesc.d_iReac instanceof Fuel.ManualReac));
            SurfaceRenderTest.assertTrue((boolean)(((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type instanceof HeatRelease.MLRType));
            SurfaceRenderTest.assertEquals((Object)77.0, (Object)((UnitDouble)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatRelease.d_type.val).getValue(SIUS.unit(44)));
            SurfaceRenderTest.assertEquals((Object)23.0, (Object)((Fuel.ManualReac)layeredSurfDesc.d_iReac).d_heatOfVap.getValue(SIUS.unit(46)));
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    public void testSurfaceRenderer_Intake() {
        FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
        TimeFunction timeFunction = new TimeFunction.TanH(new UnitDouble(15.0, SI.SECOND));
        AirFlow.NormalVel normalVel = new AirFlow.NormalVel(new UnitDouble(16.0, SIUS.unit(8)), new UnitDouble(51.0, SIUS.unit(8)), new UnitDouble(52.0, SIUS.unit(8)), timeFunction, null);
        AirFlow airFlow = new AirFlow(normalVel, new AirFlow.ParabolicProf());
        Surface surface = new Surface("SURF02", new Color(7, 7, 7), null, new InFlowSurfDesc(airFlow, TempRegulation.newDefault()));
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof InFlowSurfDesc));
            InFlowSurfDesc inFlowSurfDesc = (InFlowSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)51.0, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelU.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)52.0, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelV.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)timeFunction, (Object)inFlowSurfDesc.d_airFlow.d_rate.func);
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.ParabolicProf));
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.NormalVel));
            SurfaceRenderTest.assertEquals((Object)16.0, (Object)((AirFlow.NormalVel)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(8)));
            fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
            timeFunction = new TimeFunction.TanH(new UnitDouble(15.0, SI.SECOND));
            AirFlow.VolumeFlux volumeFlux = new AirFlow.VolumeFlux(new UnitDouble(17.0, SIUS.unit(24)), new UnitDouble(51.5, SIUS.unit(8)), new UnitDouble(52.5, SIUS.unit(8)), timeFunction, null);
            airFlow = new AirFlow(volumeFlux, new AirFlow.AtmosphericProf(0.4, new UnitDouble(12.0, SI.METER)));
            surface = new Surface("SURF03", new Color(7, 7, 7), null, new InFlowSurfDesc(airFlow, TempRegulation.newDefault()));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof InFlowSurfDesc));
            inFlowSurfDesc = (InFlowSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)51.5, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelU.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)52.5, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelV.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)timeFunction, (Object)inFlowSurfDesc.d_airFlow.d_rate.func);
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.AtmosphericProf));
            SurfaceRenderTest.assertEquals((Object)0.4, (Object)((AirFlow.AtmosphericProf)inFlowSurfDesc.d_airFlow.d_profile).d_exponent);
            SurfaceRenderTest.assertEquals((Object)12.0, (Object)((AirFlow.AtmosphericProf)inFlowSurfDesc.d_airFlow.d_profile).d_origin.getValue(SI.METER));
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.VolumeFlux));
            SurfaceRenderTest.assertEquals((Object)17.0, (Object)((AirFlow.VolumeFlux)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(24)));
            fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
            timeFunction = new TimeFunction.TSquared(new UnitDouble(11.0, SI.SECOND));
            AirFlow.TotalMassFlux totalMassFlux = new AirFlow.TotalMassFlux(new UnitDouble(17.0, SIUS.unit(45)), new UnitDouble(51.5, SIUS.unit(8)), new UnitDouble(52.5, SIUS.unit(8)), timeFunction, null);
            airFlow = new AirFlow(totalMassFlux, new AirFlow.AtmosphericProf(0.4, new UnitDouble(12.0, SI.METER)));
            surface = new Surface("SURF04", new Color(7, 7, 7), null, new InFlowSurfDesc(airFlow, TempRegulation.newDefault()));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 3), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF04");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof InFlowSurfDesc));
            inFlowSurfDesc = (InFlowSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)51.5, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelU.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)52.5, (Object)inFlowSurfDesc.d_airFlow.d_rate.tanVelV.getValue(SIUS.unit(8)));
            SurfaceRenderTest.assertEquals((Object)timeFunction, (Object)inFlowSurfDesc.d_airFlow.d_rate.func);
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_profile instanceof AirFlow.AtmosphericProf));
            SurfaceRenderTest.assertEquals((Object)0.4, (Object)((AirFlow.AtmosphericProf)inFlowSurfDesc.d_airFlow.d_profile).d_exponent);
            SurfaceRenderTest.assertEquals((Object)12.0, (Object)((AirFlow.AtmosphericProf)inFlowSurfDesc.d_airFlow.d_profile).d_origin.getValue(SI.METER));
            SurfaceRenderTest.assertTrue((boolean)(inFlowSurfDesc.d_airFlow.d_rate instanceof AirFlow.TotalMassFlux));
            SurfaceRenderTest.assertEquals((Object)17.0, (Object)((AirFlow.TotalMassFlux)inFlowSurfDesc.d_airFlow.d_rate).val.getValue(SIUS.unit(45)));
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    public void testSurfaceRenderer_Burner_no_part_inj() {
        FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
        UnitDouble unitDouble = new UnitDouble(1.0, SIUS.unit(21));
        UnitDouble unitDouble2 = new UnitDouble(2.0, SIUS.unit(22));
        TimeFunction.TanH tanH = new TimeFunction.TanH(new UnitDouble(3.0, SI.SECOND));
        HeatRelease.HRRType hRRType = new HeatRelease.HRRType(unitDouble2, (TimeFunction)tanH);
        HeatRelease heatRelease = new HeatRelease(hRRType, unitDouble);
        Surface surface = new Surface("SURF02", new Color(7, 7, 7), null, new BurnerSurfDesc(heatRelease, null, TempRegulation.newDefault(), IGeometry.DEFAULT));
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof BurnerSurfDesc));
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)unitDouble, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff);
            SurfaceRenderTest.assertEquals((Object)unitDouble2, (Object)burnerSurfDesc.d_heatRelease.d_type.val);
            SurfaceRenderTest.assertEquals((Object)tanH, (Object)burnerSurfDesc.d_heatRelease.d_type.func);
            fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
            UnitDouble unitDouble3 = new UnitDouble(11.0, SIUS.unit(21));
            UnitDouble unitDouble4 = new UnitDouble(12.0, SIUS.unit(44));
            TimeFunction.TSquared tSquared = new TimeFunction.TSquared(new UnitDouble(13.0, SI.SECOND));
            HeatRelease.MLRType mLRType = new HeatRelease.MLRType(unitDouble4, (TimeFunction)tSquared);
            HeatRelease heatRelease2 = new HeatRelease(mLRType, unitDouble3);
            surface = new Surface("SURF03", new Color(7, 7, 7), null, new BurnerSurfDesc(heatRelease2, null, TempRegulation.newDefault(), IGeometry.DEFAULT));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)unitDouble3, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff);
            SurfaceRenderTest.assertEquals((Object)unitDouble4, (Object)burnerSurfDesc.d_heatRelease.d_type.val);
            SurfaceRenderTest.assertEquals((Object)tSquared, (Object)burnerSurfDesc.d_heatRelease.d_type.func);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    public void testSurfaceRenderer_Burner_w_part_inj() {
        FDSStringRenderer fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
        UnitDouble unitDouble = new UnitDouble(1.0, SIUS.unit(21));
        UnitDouble unitDouble2 = new UnitDouble(2.0, SIUS.unit(22));
        TimeFunction.TanH tanH = new TimeFunction.TanH(new UnitDouble(3.0, SI.SECOND));
        HeatRelease.HRRType hRRType = new HeatRelease.HRRType(unitDouble2, (TimeFunction)tanH);
        HeatRelease heatRelease = new HeatRelease(hRRType, unitDouble);
        ExSpec exSpec = new ExSpec("SPEC01", 1);
        this.d_mod.getExSpecList().add(exSpec);
        Particle particle = new Particle("PART01", Particle.Type.LIQUID, new Output(10), null);
        particle.setSpecies(exSpec);
        this.d_mod.getPartList().add(particle);
        UnitDouble unitDouble3 = new UnitDouble(21.2, SIUS.unit(45));
        TimeBasedValue<UnitDouble> timeBasedValue = new TimeBasedValue<UnitDouble>(unitDouble3, TimeFunction.newDefault());
        ParticleInjection particleInjection = new ParticleInjection(particle, 21, timeBasedValue, null);
        FDSStringRenderer fDSStringRenderer2 = new FDSStringRenderer(new FDSRenderProps());
        FDSNameMap fDSNameMap = new FDSNameMap();
        fDSNameMap.mapToName("PART", particle);
        ParticleRenderer particleRenderer = new ParticleRenderer(fDSNameMap, null);
        particleRenderer.render((IFDSRecordRenderer)fDSStringRenderer2, (IPyroObject)particle);
        Surface surface = new Surface("SURF02", new Color(7, 7, 7), null, new BurnerSurfDesc(heatRelease, particleInjection, TempRegulation.newDefault(), IGeometry.DEFAULT));
        try {
            int n = this.d_mod.getSurfaceMgr().flatten().size();
            ParticleParser particleParser = new ParticleParser(this.d_pinfo, new PinConnParser(this.d_pinfo));
            particleParser.process(this.parseRecord(fDSStringRenderer2.toString()));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 1), (int)this.d_mod.getSurfaceMgr().flatten().size());
            Surface surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF02");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof BurnerSurfDesc));
            BurnerSurfDesc burnerSurfDesc = (BurnerSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)unitDouble, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff);
            SurfaceRenderTest.assertEquals((Object)unitDouble2, (Object)burnerSurfDesc.d_heatRelease.d_type.val);
            SurfaceRenderTest.assertEquals((Object)tanH, (Object)burnerSurfDesc.d_heatRelease.d_type.func);
            SurfaceRenderTest.assertEquals((Object)particleInjection, (Object)burnerSurfDesc.d_partInj);
            ExSpec exSpec2 = new ExSpec("SPEC02", 1);
            this.d_mod.getExSpecList().add(exSpec2);
            Particle particle2 = new Particle("PART02", Particle.Type.LIQUID, new Output(10), null);
            particle.setSpecies(exSpec);
            this.d_mod.getPartList().add(particle2);
            fDSStringRenderer = new FDSStringRenderer(new FDSRenderProps());
            UnitDouble unitDouble4 = new UnitDouble(11.0, SIUS.unit(21));
            UnitDouble unitDouble5 = new UnitDouble(12.0, SIUS.unit(44));
            TimeFunction.TSquared tSquared = new TimeFunction.TSquared(new UnitDouble(13.0, SI.SECOND));
            HeatRelease.MLRType mLRType = new HeatRelease.MLRType(unitDouble5, (TimeFunction)tSquared);
            HeatRelease heatRelease2 = new HeatRelease(mLRType, unitDouble4);
            surface = new Surface("SURF03", new Color(7, 7, 7), null, new BurnerSurfDesc(heatRelease2, null, TempRegulation.newDefault(), IGeometry.DEFAULT));
            this.d_surfRenderer.render((IFDSRecordRenderer)fDSStringRenderer, (IPyroObject)surface);
            SurfaceRenderTest.assertTrue((boolean)this.d_surfParser.process(this.parseRecord(fDSStringRenderer.toString(), true)));
            SurfaceRenderTest.assertEquals((int)(n + 2), (int)this.d_mod.getSurfaceMgr().flatten().size());
            surface2 = (Surface)this.d_mod.getSurfaceMgr().get("SURF03");
            SurfaceRenderTest.assertTrue((boolean)(surface2.getSurfDesc() instanceof BurnerSurfDesc));
            burnerSurfDesc = (BurnerSurfDesc)surface2.getSurfDesc();
            SurfaceRenderTest.assertEquals((Object)unitDouble4, (Object)burnerSurfDesc.d_heatRelease.d_extingCoeff);
            SurfaceRenderTest.assertEquals((Object)unitDouble5, (Object)burnerSurfDesc.d_heatRelease.d_type.val);
            SurfaceRenderTest.assertEquals((Object)tSquared, (Object)burnerSurfDesc.d_heatRelease.d_type.func);
        }
        catch (FDSRecordFormatException fDSRecordFormatException) {
            SurfaceRenderTest.fail();
        }
    }

    static {
        new PyroSim();
    }
}

