/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.output.GasMsrStat;
import pyrosim.domain.output.IMeasurementStat;
import pyrosim.domain.output.SolidMsrStat;
import pyrosim.domain.output.StatGeom;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.common.StatisticMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.units.UnitPoint3D;

public class StatisticsRenderer
extends AFDS6Renderer {
    private final QuantityMap d_msrMap;
    private final FDSNameMap d_nameMap;

    public StatisticsRenderer(QuantityMap quantityMap, FDSNameMap fDSNameMap) {
        this.d_msrMap = quantityMap;
        this.d_nameMap = fDSNameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(IMeasurementStat.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        IMeasurementStat iMeasurementStat = (IMeasurementStat)iPyroObject;
        if (iMeasurementStat instanceof SolidMsrStat) {
            return this.renderSolidStat(iFDSRecordRenderer, (SolidMsrStat)iMeasurementStat);
        }
        assert (iMeasurementStat instanceof GasMsrStat);
        return this.renderGasStat(iFDSRecordRenderer, (GasMsrStat)iMeasurementStat);
    }

    private FDSRenderRecord newStatRecord(String string, IMeasurementStat iMeasurementStat, String string2) {
        String string3 = this.d_nameMap.generateName("DEVC", string);
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("DEVC");
        fDSRenderRecord.setValue("ID", string3);
        this.d_msrMap.renderQuantity(fDSRenderRecord, "QUANTITY", "PART_ID", "SPEC_ID", "MATL_ID", "DUCT_ID", "NODE_ID", iMeasurementStat.getQuantity());
        if (!string2.equals("STEADY STATE") && !string2.equals("LINE RMS")) {
            fDSRenderRecord.setValue("STATISTICS", string2);
        } else if (string2.equals("LINE RMS")) {
            fDSRenderRecord.setValue("STATISTICS", StatisticMap.getFDSVal(0x8000000));
        }
        IGeom iGeom = iMeasurementStat.getGeom().flatten().getLocalGeom();
        AABox aABox = iGeom.getBoundingBox(new AABox());
        if (iGeom instanceof StatGeom.LinearArrayGeom) {
            StatisticsRenderer.renderXB(fDSRenderRecord, "XB", aABox.getMin(), aABox.getMax());
            fDSRenderRecord.setValue("POINTS", ((StatGeom.LinearArrayGeom)iGeom).d_numPoints);
        } else if (aABox.getMin().equals(aABox.getMax())) {
            Point3d point3d = aABox.getCenter();
            StatisticsRenderer.renderLoc(fDSRenderRecord, "XYZ", new UnitPoint3D(point3d, Geometry.LU));
        } else {
            StatisticsRenderer.renderXB(fDSRenderRecord, "XB", aABox.getMin(), aABox.getMax());
        }
        StatisticsRenderer.renderCustomFDSProps(fDSRenderRecord, iMeasurementStat);
        return fDSRenderRecord;
    }

    private boolean renderGasStat(IFDSRecordRenderer iFDSRecordRenderer, GasMsrStat gasMsrStat) {
        boolean bl = false;
        for (Integer n : gasMsrStat.getStats()) {
            String string = StatisticMap.getFDSVal(n);
            String string2 = gasMsrStat.getName() + "_" + string;
            FDSRenderRecord fDSRenderRecord = this.newStatRecord(string2, gasMsrStat, string);
            iFDSRecordRenderer.render(fDSRenderRecord, gasMsrStat);
            bl = true;
        }
        return bl;
    }

    private boolean renderSolidStat(IFDSRecordRenderer iFDSRecordRenderer, SolidMsrStat solidMsrStat) {
        if (solidMsrStat.getSurfaces().size() == 0) {
            return this.renderSolidStat(iFDSRecordRenderer, null, solidMsrStat);
        }
        boolean bl = false;
        for (Surface surface : solidMsrStat.getSurfaces()) {
            bl |= this.renderSolidStat(iFDSRecordRenderer, surface, solidMsrStat);
        }
        return bl;
    }

    private boolean renderSolidStat(IFDSRecordRenderer iFDSRecordRenderer, Surface surface, SolidMsrStat solidMsrStat) {
        boolean bl = false;
        for (Integer n : solidMsrStat.getStats()) {
            String string = StatisticMap.getFDSVal(n);
            String string2 = solidMsrStat.getName();
            if (surface != null) {
                string2 = string2 + "_" + surface.getName();
            }
            string2 = string2 + "_" + string;
            FDSRenderRecord fDSRenderRecord = this.newStatRecord(string2, solidMsrStat, string);
            if (surface != null) {
                fDSRenderRecord.setValue("SURF_ID", surface.getName());
            }
            iFDSRecordRenderer.render(fDSRenderRecord, solidMsrStat);
            bl = true;
        }
        return bl;
    }
}

