/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.Slice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;

public class SliceRenderer
extends AFDS6Renderer {
    private final QuantityMap d_quantityMap;

    public SliceRenderer(QuantityMap quantityMap) {
        this.d_quantityMap = quantityMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Slice.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Slice slice = (Slice)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("SLCF");
        this.d_quantityMap.renderQuantity(fDSRenderRecord, "QUANTITY", "PART_ID", "SPEC_ID", null, null, null, slice.getQuantity());
        fDSRenderRecord.setValue("VECTOR", slice.includeFlowVector(), false);
        fDSRenderRecord.setValue("CELL_CENTERED", slice.isCellCentered(), false);
        if (slice instanceof PlanarSlice) {
            String string;
            PlanarSlice planarSlice = (PlanarSlice)slice;
            switch (planarSlice.getPlane()) {
                case 0: {
                    string = "PBX";
                    break;
                }
                case 1: {
                    string = "PBY";
                    break;
                }
                case 2: {
                    string = "PBZ";
                    break;
                }
                default: {
                    assert (false);
                    string = "";
                }
            }
            fDSRenderRecord.setValue(string, planarSlice.getLocation());
        } else if (slice instanceof VolumeSlice) {
            VolumeSlice volumeSlice = (VolumeSlice)slice;
            UnitAABox unitAABox = GeomUtil.getUnitBounds(volumeSlice);
            SliceRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
            fDSRenderRecord.setValue("FYI", volumeSlice.getName());
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

