/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IPropertySet;

public class SimParamsRenderer
extends AFDS6Renderer {
    private final QuantityMap d_msrMap;
    private final Map<String, Ramp> d_rampsUsed;
    private final FDSNameMap d_uniqueNameMap;
    private final List<Reaction> d_activeReacs;
    private SimParams.Misc d_misc;

    public SimParamsRenderer(QuantityMap quantityMap, FDSNameMap fDSNameMap) {
        this.d_msrMap = quantityMap;
        this.d_rampsUsed = new HashMap<String, Ramp>();
        this.d_uniqueNameMap = fDSNameMap;
        this.d_activeReacs = new ArrayList<Reaction>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(SimParams.class);
        set.add(Reaction.class);
    }

    @Override
    public void fillSingletonRecords(SingletonRecords singletonRecords, Collection<? extends IPyroObject> collection) {
        super.fillSingletonRecords(singletonRecords, collection);
        if (this.d_misc != null) {
            this.fillSuppression(singletonRecords.combRec, this.d_misc);
        }
    }

    @Override
    public void fillSingletonRecords(SingletonRecords singletonRecords, IPyroObject iPyroObject) {
        if (iPyroObject instanceof Reaction) {
            Reaction reaction = (Reaction)iPyroObject;
            if (reaction.isActive()) {
                this.d_activeReacs.add(reaction);
            }
            return;
        }
        SimParams simParams = (SimParams)iPyroObject;
        this.d_misc = simParams.getMisc();
        singletonRecords.headRec.setValue("TITLE", simParams.getJobTitle(), false);
        SimParams.Time time = simParams.getTime();
        singletonRecords.timeRec.setValue("T_BEGIN", time.getStartTime(), false);
        singletonRecords.timeRec.setValue("T_END", time.getStopTime(), false);
        singletonRecords.timeRec.setValue("DT", time.getInitTimeStep(), false);
        singletonRecords.timeRec.setValue("LOCK_TIME_STEP", time.lockTimeSteps(), false);
        singletonRecords.timeRec.setValue("RESTRICT_TIME_STEP", time.restrictTimeSteps(), false);
        singletonRecords.timeRec.setValue("WALL_INCREMENT", time.getWallIncrement(), false);
        SimParams.Environment environment = simParams.getEnvironment();
        this.renderVectorVariant(singletonRecords.miscRec, "GVEC", "RAMP_GX", "RAMP_GY", "RAMP_GZ", "GRAVITYX", "GRAVITYY", "GRAVITYZ", environment.getGravityX(), environment.getGravityY(), environment.getGravityZ(), new UnitPoint3D(1.0, 1.0, 1.0, SI.METER.divide(SI.SECOND.pow(2))));
        singletonRecords.miscRec.setValue("GROUND_LEVEL", environment.getGroundLevel(), false);
        singletonRecords.miscRec.setValue("HUMIDITY", environment.getRelHumidity(), false);
        singletonRecords.miscRec.setValue("P_INF", environment.getAmbPressure(), false);
        singletonRecords.miscRec.setValue("TMPA", environment.getAmbTemp(), false);
        singletonRecords.miscRec.setValue("Y_CO2_INFTY", environment.getAmbMFCO2(), false);
        singletonRecords.miscRec.setValue("Y_O2_INFTY", environment.getAmbMFO2(), false);
        singletonRecords.miscRec.setValue("MAXIMUM_VISIBILITY", environment.getMaxVisibility(), false);
        singletonRecords.miscRec.setValue("VISIBILITY_FACTOR", environment.getVisibilityFactor(), false);
        SimParams.Particles particles = simParams.getParticles();
        singletonRecords.miscRec.setValue("POROUS_FLOOR", particles.isPourousFloor(), false);
        singletonRecords.miscRec.setValue("ALLOW_UNDERSIDE_PARTICLES", particles.getAllowUndersideDroplets(), false);
        singletonRecords.dumpRec.setValue("MAXIMUM_PARTICLES", particles.getMaxParticlesPerMesh(), false);
        SimParams.Calculations calculations = simParams.getCalculations();
        singletonRecords.miscRec.setValue("CFL_MIN", calculations.getCflRange()[0], false);
        singletonRecords.miscRec.setValue("CFL_MAX", calculations.getCflRange()[1], false);
        singletonRecords.miscRec.setValue("C_SMAGORINSKY", calculations.getCsmag(), false);
        SimParams.Calculations.SimulationMode simulationMode = calculations.getSimMode();
        singletonRecords.miscRec.setValue("SIMULATION_MODE", simulationMode.simpleName, false);
        if (simulationMode.equals((Object)SimParams.Calculations.SimulationMode.LES) || simulationMode.equals((Object)SimParams.Calculations.SimulationMode.VLES) || simulationMode.equals((Object)SimParams.Calculations.SimulationMode.SVLES)) {
            singletonRecords.miscRec.setValue("PR", calculations.getPrandtlNum(), false);
            singletonRecords.miscRec.setValue("SC", calculations.getSchmidtNum(), false);
            singletonRecords.combRec.setValue("INITIAL_UNMIXED_FRACTION", calculations.getInitUnmixedFraction(), false);
        }
        if (!calculations.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.AUTO)) {
            if (calculations.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.TRUE)) {
                singletonRecords.miscRec.setValue("BAROCLINIC", true);
            } else if (calculations.getBaroclinicState().equals((Object)SimParams.Calculations.BaroclinicState.FALSE)) {
                singletonRecords.miscRec.setValue("BAROCLINIC", false);
            }
        }
        singletonRecords.miscRec.setValue("VN_MIN", calculations.getVnRange()[0], false);
        singletonRecords.miscRec.setValue("VN_MAX", calculations.getVnRange()[1], false);
        SimParams.RadiationTransport radiationTransport = simParams.getRadiTransport();
        if (radiationTransport.isRadiationOn()) {
            singletonRecords.radiRec.setValue("ANGLE_INCREMENT", radiationTransport.getAngleIncrement(), false);
            singletonRecords.radiRec.setValue("KAPPA0", radiationTransport.getConstAbsorptionCoef(), false);
            singletonRecords.radiRec.setValue("NMIEANG", radiationTransport.getNumPolarAngles(), false);
            singletonRecords.radiRec.setValue("NUMBER_RADIATION_ANGLES", radiationTransport.getNumSolidAngles(), false);
            singletonRecords.radiRec.setValue("PATH_LENGTH", radiationTransport.getRadCalcPathLen(), false);
            singletonRecords.radiRec.setValue("RADTMP", radiationTransport.getAssumedRadSourceTemp(), false);
            singletonRecords.radiRec.setValue("TIME_STEP_INCREMENT", radiationTransport.getTimeStepInc(), false);
            singletonRecords.radiRec.setValue("WIDE_BAND_MODEL", radiationTransport.isNonGrayGasAssumption(), false);
        } else {
            singletonRecords.radiRec.setValue("RADIATION", radiationTransport.isRadiationOn(), false);
        }
        SimParams.FileOutput fileOutput = simParams.getFileOutput();
        singletonRecords.dumpRec.setValue("COLUMN_DUMP_LIMIT", fileOutput.isLimitCSVColumns(), false);
        singletonRecords.dumpRec.setValue("DT_BNDF", fileOutput.getDtBoundaryFile(), false);
        singletonRecords.dumpRec.setValue("DT_DEVC", fileOutput.getDtDeviceFiles(), false);
        singletonRecords.dumpRec.setValue("DT_HRR", fileOutput.getDtHeatReleaseRateFiles(), false);
        singletonRecords.dumpRec.setValue("DT_ISOF", fileOutput.getDtIsofFiles(), false);
        singletonRecords.dumpRec.setValue("DT_MASS", fileOutput.getDtMassFiles(), false);
        singletonRecords.dumpRec.setValue("DT_PART", fileOutput.getDtParticleFiles(), false);
        singletonRecords.dumpRec.setValue("DT_PL3D", fileOutput.getDtPlot3dFile(), false);
        singletonRecords.dumpRec.setValue("DT_PROF", fileOutput.getDtProfileDumpInterval(), false);
        singletonRecords.dumpRec.setValue("DT_RESTART", fileOutput.getDtRestartFile(), false);
        singletonRecords.dumpRec.setValue("DT_SLCF", fileOutput.getDtSliceFiles(), false);
        singletonRecords.dumpRec.setValue("DT_SL3D", fileOutput.getDtSlice3dFiles(), false);
        singletonRecords.dumpRec.setValue("NFRAMES", fileOutput.getNumOutputFrames(), false);
        singletonRecords.dumpRec.setValue("MASS_FILE", fileOutput.isWriteSpeciesMassFile(), false);
        singletonRecords.dumpRec.setValue("WRITE_XYZ", fileOutput.getDtPlot3dFile() != null, false);
        singletonRecords.dumpRec.setValue("SMOKE3D", fileOutput.isVisualize3dSmoke(), false);
        singletonRecords.dumpRec.setValue("SUPPRESS_DIAGNOSTICS", fileOutput.isSuppressDiagnostics(), false);
        if (fileOutput.getSmokeQuantity() != null) {
            this.d_msrMap.renderQuantity(singletonRecords.dumpRec, "SMOKE3D_QUANTITY", null, "SMOKE3D_SPEC_ID", null, null, null, fileOutput.getSmokeQuantity());
        }
        SimParams.Misc misc = simParams.getMisc();
        SimParamsRenderer.setUP3DValue(singletonRecords.miscRec, "TEXTURE_ORIGIN", misc.getTextureOrigin());
        singletonRecords.miscRec.setValue("RESTART", misc.getAndClearResume(), false);
        this.fillWindRecords(singletonRecords.windRec, simParams.getWind());
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.timeRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.dumpRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.miscRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.radiRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.presRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.windRec, simParams);
        SimParamsRenderer.renderCustomFDSProps(singletonRecords.combRec, simParams);
    }

    private static void setUP3DValue(FDSRenderRecord fDSRenderRecord, String string, UnitPoint3D unitPoint3D) {
        FDSArray<Object> fDSArray = new FDSArray<Object>(unitPoint3D.xu(), unitPoint3D.yu(), unitPoint3D.zu());
        fDSRenderRecord.setValue(string, fDSArray, false);
    }

    @Override
    public void doneRendering(IFDSRecordRenderer iFDSRecordRenderer) {
        super.doneRendering(iFDSRecordRenderer);
        RampRenderer.render(iFDSRecordRenderer, this.d_rampsUsed, null);
    }

    private void fillWindRecords(FDSRenderRecord fDSRenderRecord, SimParams.Wind wind) {
        fDSRenderRecord.setValue("LAPSE_RATE", wind.get(SimParams.Wind.LAPSE_RATE), false);
        this.renderGeneralVariant(fDSRenderRecord, null, "RAMP_TMP0_Z", "WIND", wind.get(SimParams.Wind.TMP0Z_RAMP));
        fDSRenderRecord.setValue("GROUND_LEVEL", wind.get(SimParams.Wind.GROUND_LEVEL), false);
        fDSRenderRecord.setValue("L", wind.get(SimParams.Wind.L), false);
        fDSRenderRecord.setValue("Z_0", wind.get(SimParams.Wind.Z0), false);
        fDSRenderRecord.setValue("THETA_STAR", wind.get(SimParams.Wind.THETASTAR), false);
        fDSRenderRecord.setValue("U_STAR", wind.get(SimParams.Wind.USTAR), false);
        fDSRenderRecord.setValue("Z_REF", wind.get(SimParams.Wind.ZREF), false);
        switch (wind.get(SimParams.Wind.INITSPEEDOPT)) {
            case SPEED: {
                fDSRenderRecord.setValue("SPEED", wind.get(SimParams.Wind.SPEED), false);
                fDSRenderRecord.setValue("DIRECTION", wind.get(SimParams.Wind.DIRECTION), false);
                break;
            }
            case UV: {
                fDSRenderRecord.setValue("U0", wind.get(SimParams.Wind.U0), false);
                fDSRenderRecord.setValue("V0", wind.get(SimParams.Wind.V0), false);
            }
        }
        fDSRenderRecord.setValue("W0", wind.get(SimParams.Wind.W0), false);
        BiConsumer<String, IPropertySet.Prop> biConsumer = (string, prop) -> this.renderGeneralVariant(fDSRenderRecord, null, (String)string, "WIND", (Variant)wind.get(prop));
        biConsumer.accept("RAMP_SPEED", SimParams.Wind.SPEED_RAMP);
        biConsumer.accept("RAMP_DIRECTION", SimParams.Wind.DIRECTION_RAMP);
        biConsumer.accept("RAMP_U0_T", SimParams.Wind.U0T);
        biConsumer.accept("RAMP_V0_T", SimParams.Wind.V0T);
        biConsumer.accept("RAMP_W0_T", SimParams.Wind.W0T);
        biConsumer.accept("RAMP_U0_Z", SimParams.Wind.U0Z);
        biConsumer.accept("RAMP_V0_Z", SimParams.Wind.V0Z);
        biConsumer.accept("RAMP_W0_Z", SimParams.Wind.W0Z);
        UnitPoint3D unitPoint3D = new UnitPoint3D(0.0, 0.0, 0.0, SI.PASCAL.divide(SI.METER));
        this.renderVectorVariant(fDSRenderRecord, "FORCE_VECTOR", "RAMP_FVX_T", "RAMP_FVY_T", "RAMP_FVZ_T", "WIND", "WIND", "WIND", wind.get(SimParams.Wind.FORCEX), wind.get(SimParams.Wind.FORCEY), wind.get(SimParams.Wind.FORCEZ), unitPoint3D);
    }

    private void fillSuppression(FDSRenderRecord fDSRenderRecord, SimParams.Misc misc) {
        boolean bl = true;
        if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.AUTO)) {
            bl = this.d_activeReacs.size() <= 1;
        } else if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.TRUE)) {
            bl = true;
        } else if (misc.getSuppression().equals((Object)SimParams.Misc.SUPPRESSION.FALSE)) {
            bl = false;
        }
        fDSRenderRecord.setValue("SUPPRESSION", bl, false);
    }

    private void renderGeneralVariant(FDSRenderRecord fDSRenderRecord, String string, String string2, String string3, Variant variant) {
        if (variant.isConstant()) {
            fDSRenderRecord.setValue(string, variant.val, false);
        }
        if (variant.isRamp()) {
            this.renderRamp(fDSRenderRecord, (Ramp)variant.val, string2, string3);
        }
    }

    private void renderVectorVariant(FDSRenderRecord fDSRenderRecord, String string, String string2, String string3, String string4, String string5, String string6, String string7, Variant variant, Variant variant2, Variant variant3, UnitPoint3D unitPoint3D) {
        UnitPoint3D unitPoint3D2;
        Serializable serializable;
        if (variant.isDefault() && variant2.isDefault() && variant3.isDefault()) {
            return;
        }
        FDSRecordSpec.ArrayFld arrayFld = (FDSRecordSpec.ArrayFld)fDSRenderRecord.getSpec().fields.get(string);
        if (arrayFld.initialValue != null) {
            serializable = (FDSArray)arrayFld.initialValue;
            unitPoint3D2 = new UnitPoint3D((UnitDouble)((FDSArray)serializable).get(0), (UnitDouble)((FDSArray)serializable).get(1), (UnitDouble)((FDSArray)serializable).get(2));
        } else {
            serializable = (UnitDouble)arrayFld.elementChecker.initialValue;
            unitPoint3D2 = new UnitPoint3D((UnitDouble)serializable, (UnitDouble)serializable, (UnitDouble)serializable);
        }
        serializable = this.renderVectorVariantComp(fDSRenderRecord, string2, string5, variant, unitPoint3D.xu(), unitPoint3D2.xu());
        UnitDouble unitDouble = this.renderVectorVariantComp(fDSRenderRecord, string3, string6, variant2, unitPoint3D.yu(), unitPoint3D2.yu());
        UnitDouble unitDouble2 = this.renderVectorVariantComp(fDSRenderRecord, string4, string7, variant3, unitPoint3D.zu(), unitPoint3D2.zu());
        if (!(((UnitDouble)serializable).equals(unitPoint3D2.xu()) && unitDouble.equals(unitPoint3D2.yu()) && unitDouble2.equals(unitPoint3D2.zu()))) {
            SimParamsRenderer.setUP3DValue(fDSRenderRecord, string, new UnitPoint3D((UnitDouble)serializable, unitDouble, unitDouble2));
        }
    }

    private UnitDouble renderVectorVariantComp(FDSRenderRecord fDSRenderRecord, String string, String string2, Variant variant, UnitDouble unitDouble, UnitDouble unitDouble2) {
        if (variant.isConstant()) {
            return (UnitDouble)variant.val;
        }
        if (variant.isRamp()) {
            this.renderRamp(fDSRenderRecord, (Ramp)variant.val, string, string2);
            return unitDouble;
        }
        if (variant.isFractionalRamp()) {
            Variant.FractionalRamp fractionalRamp = (Variant.FractionalRamp)variant.val;
            this.renderRamp(fDSRenderRecord, fractionalRamp.fractionalRamp, string, string2);
            return fractionalRamp.constInput;
        }
        return unitDouble2;
    }

    private void renderRamp(FDSRenderRecord fDSRenderRecord, Ramp ramp, String string, String string2) {
        String string3 = RampRenderer.createID(this.d_uniqueNameMap, string2, string);
        this.d_rampsUsed.put(string3, ramp);
        fDSRenderRecord.setValue(string, string3, false);
    }
}

