/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import junit.framework.TestCase;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.boundcond.surf.SurfDescStatic;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.SimParamsRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class SimParamsRenderTest
extends TestCase {
    public SimParamsRenderTest(String string) {
        super(string);
    }

    private void assertLotsOfNull(FDSRenderRecord fDSRenderRecord, String ... stringArray) {
        for (String string : stringArray) {
            SimParamsRenderTest.assertNull(fDSRenderRecord.get(string));
        }
    }

    public void test_default_recMISC() {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        SimParams simParams = new SimParams(surfaceManager);
        SimParamsRenderer simParamsRenderer = new SimParamsRenderer(new QuantityMap(), new FDSNameMap());
        SingletonRecords singletonRecords = new SingletonRecords();
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        FDSRenderRecord fDSRenderRecord = singletonRecords.miscRec;
        SimParamsRenderTest.assertEquals((String)"MISC", (String)fDSRenderRecord.getType());
        this.assertLotsOfNull(fDSRenderRecord, "BAROCLINIC", "CFL_MAX", "CFL_MIN", "C_SMAGORINSKY", "DNS", "GVEC", "HUMIDITY", "PR", "P_INF", "POROUS_FLOOR", "RESTART", "RESTART", "SC", "TEXTURE_ORIGIN", "TMPA", "U0", "V0", "W0", "VN_MAX", "VN_MIN");
    }

    public void test_default_recDUMP() {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        SimParams simParams = new SimParams(surfaceManager);
        SimParamsRenderer simParamsRenderer = new SimParamsRenderer(new QuantityMap(), new FDSNameMap());
        SingletonRecords singletonRecords = new SingletonRecords();
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        FDSRenderRecord fDSRenderRecord = singletonRecords.dumpRec;
        SimParamsRenderTest.assertEquals((String)"DUMP", (String)fDSRenderRecord.getType());
        this.assertLotsOfNull(fDSRenderRecord, "DT_BNDF", "DT_DEVC", "DT_HRR", "DT_ISOF", "DT_MASS", "DT_PART", "DT_PL3D", "DT_PROF", "DT_SLCF", "MAXIMUM_PARTICLES", "NFRAMES", "PLOT3D_QUANTITY", "RENDER_FILE", "SMOKE3D", "MASS_FILE", "WRITE_XYZ");
    }

    public void test_default_recRADI() {
        SingletonRecords singletonRecords = new SingletonRecords();
        FDSRenderRecord fDSRenderRecord = singletonRecords.radiRec;
        SimParamsRenderTest.assertEquals((String)"RADI", (String)fDSRenderRecord.getType());
        this.assertLotsOfNull(fDSRenderRecord, "ANGLE_INCREMENT", "KAPPA0", "NMIEANG", "NUMBER_RADIATION_ANGLES", "PATH_LENGTH", "RADIATIVE_FRACTION", "RADTMP", "TIME_STEP_INCREMENT", "WIDE_BAND_MODEL");
    }

    public void test_rec_FileOn() {
        Cloneable cloneable2;
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        SimParams simParams = new SimParams(surfaceManager);
        SimParamsRenderer simParamsRenderer = new SimParamsRenderer(new QuantityMap(), new FDSNameMap());
        SingletonRecords singletonRecords = new SingletonRecords();
        SimParams.FileOutput fileOutput = simParams.getFileOutput();
        SimParams.Particles particles = simParams.getParticles();
        SimParams.Time time = simParams.getTime();
        SimParams.Environment environment = simParams.getEnvironment();
        SimParams.Calculations calculations = simParams.getCalculations();
        SimParams.RadiationTransport radiationTransport = simParams.getRadiTransport();
        SimParams.Misc misc = simParams.getMisc();
        fileOutput.setDtBoundaryFile(new UnitDouble(6.0, SI.SECOND));
        fileOutput.setDtDeviceFiles(new UnitDouble(7.0, SI.SECOND));
        fileOutput.setDtHeatReleaseRateFiles(new UnitDouble(8.0, SI.SECOND));
        fileOutput.setDtIsofFiles(new UnitDouble(9.0, SI.SECOND));
        fileOutput.setDtMassFiles(new UnitDouble(5.0, SI.SECOND));
        fileOutput.setDtParticleFiles(new UnitDouble(10.0, SI.SECOND));
        fileOutput.setDtPlot3dFile(new UnitDouble(14.0, SI.SECOND));
        fileOutput.setDtProfileDumpInterval(new UnitDouble(11.0, SI.SECOND));
        fileOutput.setDtRestartFile(new UnitDouble(12.0, SI.SECOND));
        fileOutput.setDtSliceFiles(new UnitDouble(13.0, SI.SECOND));
        fileOutput.setLimitCSVColumns(true);
        fileOutput.setNumOutputFrames(4);
        fileOutput.setVisualize3dSmoke(true);
        fileOutput.setWriteSpeciesMassFile(true);
        particles.setMaxParticlesPerMesh(25);
        time.setInitTimeStep(new UnitDouble(3.0, SI.SECOND));
        time.setStopTime(new UnitDouble(2.0, SI.SECOND));
        environment.setAmbTemp(new UnitDouble(15.0, SI.CELSIUS));
        environment.setAmbPressure(new UnitDouble(16.0, SI.PASCAL));
        environment.setRelHumidity(new UnitDouble(18.0, NonSI.PERCENT));
        environment.setGravityAccel(Variant.constant(22.0, SI.METER.divide(SI.SECOND.pow(2))), Variant.constant(23.0, SI.METER.divide(SI.SECOND.pow(2))), Variant.constant(24.0, SI.METER.divide(SI.SECOND.pow(2))));
        calculations.setSimMode(SimParams.Calculations.SimulationMode.VLES);
        calculations.setCflRange(27.0, 28.0);
        calculations.setBaroclinicState(SimParams.Calculations.BaroclinicState.FALSE);
        calculations.setCsmag(26.0);
        calculations.setPrandtlNum(32.0);
        calculations.setSchmidtNum(31.0);
        calculations.setVnRange(29.0, 30.0);
        radiationTransport.setAngleIncrement(34);
        radiationTransport.setAssumedRadSourceTemp(new UnitDouble(37.0, SI.CELSIUS));
        radiationTransport.setConstAbsorptionCoef(new UnitDouble(38.0, SI.METER.pow(-1)));
        radiationTransport.setNonGrayGasAssumption(true);
        radiationTransport.setNumPolarAngles(36);
        radiationTransport.setNumSolidAngles(35);
        radiationTransport.setRadCalcPathLen(new UnitDouble(40.0, SI.METER));
        radiationTransport.setRadiationOn(true);
        radiationTransport.setTimeStepInc(33);
        Surface surface = null;
        for (Cloneable cloneable2 : surfaceManager.flatten()) {
            if (!(((Surface)cloneable2).getSurfDesc() instanceof SurfDescStatic.Adiabatic)) continue;
            surface = cloneable2;
            break;
        }
        misc.setSurfDefault(surface);
        misc.setTextureOrigin(new UnitPoint3D(41.0, 42.0, 43.0, SI.METER));
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        FDSRenderRecord fDSRenderRecord = singletonRecords.dumpRec;
        cloneable2 = singletonRecords.miscRec;
        FDSRenderRecord fDSRenderRecord2 = singletonRecords.timeRec;
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_BNDF"), (Object)fileOutput.getDtBoundaryFile());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_DEVC"), (Object)fileOutput.getDtDeviceFiles());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_HRR"), (Object)fileOutput.getDtHeatReleaseRateFiles());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_ISOF"), (Object)fileOutput.getDtIsofFiles());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_MASS"), (Object)fileOutput.getDtMassFiles());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_PART"), (Object)fileOutput.getDtParticleFiles());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_PL3D"), (Object)fileOutput.getDtPlot3dFile());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_PROF"), (Object)fileOutput.getDtProfileDumpInterval());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_RESTART"), (Object)fileOutput.getDtRestartFile());
        SimParamsRenderTest.assertEquals(fDSRenderRecord.get("DT_SLCF"), (Object)fileOutput.getDtSliceFiles());
        SimParamsRenderTest.assertEquals((boolean)((Boolean)fDSRenderRecord.get("MASS_FILE")), (boolean)fileOutput.isWriteSpeciesMassFile());
        SimParamsRenderTest.assertEquals((int)((Integer)fDSRenderRecord.get("MAXIMUM_PARTICLES")), (int)particles.getMaxParticlesPerMesh());
        SimParamsRenderTest.assertEquals(fDSRenderRecord2.get("DT"), (Object)time.getInitTimeStep());
        SimParamsRenderTest.assertEquals(fDSRenderRecord2.get("T_END"), (Object)time.getStopTime());
        SimParamsRenderTest.assertEquals(((FDSRecord)cloneable2).get("HUMIDITY"), (Object)environment.getRelHumidity());
        SimParamsRenderTest.assertEquals(((FDSRecord)cloneable2).get("P_INF"), (Object)environment.getAmbPressure());
        SimParamsRenderTest.assertEquals(((FDSRecord)cloneable2).get("TMPA"), (Object)environment.getAmbTemp());
        SimParamsRenderTest.assertEquals(((FDSArray)((FDSRecord)cloneable2).get("GVEC")).get(0), (Object)environment.getGravityX().val);
        SimParamsRenderTest.assertEquals(((FDSArray)((FDSRecord)cloneable2).get("GVEC")).get(1), (Object)environment.getGravityY().val);
        SimParamsRenderTest.assertEquals(((FDSArray)((FDSRecord)cloneable2).get("GVEC")).get(2), (Object)environment.getGravityZ().val);
    }

    public void test_FileOff() {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        SimParams simParams = new SimParams(surfaceManager);
        SimParamsRenderer simParamsRenderer = new SimParamsRenderer(new QuantityMap(), new FDSNameMap());
        SingletonRecords singletonRecords = new SingletonRecords();
        SimParams.FileOutput fileOutput = simParams.getFileOutput();
        SimParams.Particles particles = simParams.getParticles();
        SimParams.Calculations calculations = simParams.getCalculations();
        SimParams.RadiationTransport radiationTransport = simParams.getRadiTransport();
        fileOutput.setLimitCSVColumns(false);
        fileOutput.setVisualize3dSmoke(false);
        fileOutput.setWriteSpeciesMassFile(false);
        particles.setPourousFloor(false);
        calculations.setBaroclinicState(SimParams.Calculations.BaroclinicState.FALSE);
        radiationTransport.setRadiationOn(false);
        radiationTransport.setAngleIncrement(25);
        radiationTransport.setAngleIncrement(34);
        radiationTransport.setAssumedRadSourceTemp(new UnitDouble(37.0, SI.CELSIUS));
        radiationTransport.setConstAbsorptionCoef(new UnitDouble(38.0, SI.METER.pow(-1)));
        radiationTransport.setNonGrayGasAssumption(true);
        radiationTransport.setNumPolarAngles(36);
        radiationTransport.setNumSolidAngles(35);
        radiationTransport.setRadCalcPathLen(new UnitDouble(40.0, SI.METER));
        radiationTransport.setTimeStepInc(33);
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        FDSRenderRecord fDSRenderRecord = singletonRecords.dumpRec;
        FDSRenderRecord fDSRenderRecord2 = singletonRecords.miscRec;
        FDSRenderRecord fDSRenderRecord3 = singletonRecords.radiRec;
        FDSRenderRecord fDSRenderRecord4 = singletonRecords.timeRec;
        SimParamsRenderTest.assertEquals((boolean)((Boolean)fDSRenderRecord.get("SMOKE3D")), (boolean)fileOutput.isVisualize3dSmoke());
        SimParamsRenderTest.assertNull(fDSRenderRecord4.get("SYNCHRONIZE"));
        SimParamsRenderTest.assertEquals((boolean)((Boolean)fDSRenderRecord2.get("POROUS_FLOOR")), (boolean)particles.isPourousFloor());
        SimParamsRenderTest.assertEquals((boolean)((Boolean)fDSRenderRecord.get("COLUMN_DUMP_LIMIT", true)), (boolean)fileOutput.isLimitCSVColumns());
        SimParamsRenderTest.assertEquals((boolean)((Boolean)fDSRenderRecord2.get("BAROCLINIC")), (boolean)calculations.getBaroclinicState().getFDSRepresentation(calculations.getSimMode()));
        SimParamsRenderTest.assertEquals(fDSRenderRecord4.get("T_END"), (Object)simParams.getTime().getStopTime());
        this.assertLotsOfNull(fDSRenderRecord4, "DT");
        this.assertLotsOfNull(fDSRenderRecord2, "CFL_MAX", "CFL_MIN", "C_SMAGORINSKY", "DNS", "GVEC", "HUMIDITY", "PR", "P_INF", "RESTART", "SC", "TEXTURE_ORIGIN", "TMPA", "U0", "V0", "W0", "VN_MAX", "VN_MIN");
        this.assertLotsOfNull(fDSRenderRecord, "DT_BNDF", "DT_DEVC", "DT_HRR", "DT_ISOF", "DT_MASS", "DT_PART", "DT_PL3D", "DT_PROF", "DT_SLCF", "MAXIMUM_PARTICLES", "NFRAMES", "PLOT3D_QUANTITY", "RENDER_FILE", "MASS_FILE", "WRITE_XYZ");
        this.assertLotsOfNull(fDSRenderRecord3, "ANGLE_INCREMENT", "KAPPA0", "NMIEANG", "NUMBER_RADIATION_ANGLES", "PATH_LENGTH", "RADIATIVE_FRACTION", "RADTMP", "TIME_STEP_INCREMENT", "WIDE_BAND_MODEL");
        this.assertLotsOfNull(fDSRenderRecord2, new String[0]);
    }

    public void test_CalcDNS() {
        SurfaceManager surfaceManager = new SurfaceManager();
        surfaceManager.addPredefined();
        SimParams simParams = new SimParams(surfaceManager);
        SimParamsRenderer simParamsRenderer = new SimParamsRenderer(new QuantityMap(), new FDSNameMap());
        SingletonRecords singletonRecords = new SingletonRecords();
        SimParams.Calculations calculations = simParams.getCalculations();
        calculations.setSimMode(SimParams.Calculations.SimulationMode.DNS);
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        simParamsRenderer.fillSingletonRecords(singletonRecords, (IPyroObject)simParams);
        FDSRenderRecord fDSRenderRecord = singletonRecords.miscRec;
        SimParamsRenderTest.assertEquals((String)((String)fDSRenderRecord.get("SIMULATION_MODE")), (String)calculations.getSimMode().simpleName);
    }

    static {
        new PyroSim();
    }
}

