/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.theUtil;

public class ReactionRenderer
extends AFDS6Renderer {
    private final List<ExSpec> d_renderedSpec = new ArrayList<ExSpec>();

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Reaction.class);
        set.add(ExSpec.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        this.d_renderedSpec.addAll(theUtil.filter(collection, ExSpec.class));
        return super.render(iFDSRecordRenderer, theUtil.filter(collection, Reaction.class));
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Reaction reaction = (Reaction)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("REAC");
        fDSRenderRecord.setValue("ID", reaction.getName());
        fDSRenderRecord.setValue("FYI", reaction.getFYI(), false);
        if (reaction.getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
            this.renderSimple(fDSRenderRecord, reaction);
        } else if (reaction.getReacType().equals((Object)Reaction.ReacType.COMPLEX)) {
            this.renderComplex(fDSRenderRecord, reaction);
        }
        ReactionRenderer.renderCustomFDSProps(fDSRenderRecord, reaction);
        iFDSRecordRenderer.props().pushProps();
        iFDSRecordRenderer.props().setRenderMultiLine(true);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        iFDSRecordRenderer.props().popProps();
        return true;
    }

    private void renderComplex(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        if (reaction.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
            fDSRenderRecord.setValue("HEAT_OF_COMBUSTION", reaction.getHeatOfCombustion().val, false);
        }
        fDSRenderRecord.setValue("FUEL", reaction.getFuel().getName());
        Map<ExSpec, Double> map = reaction.getComplexStoichiometry();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        map.entrySet().stream().sorted((entry, entry2) -> ((Double)entry.getValue()).compareTo((Double)entry2.getValue())).forEachOrdered(entry -> {
            arrayList.add(((ExSpec)entry.getKey()).getName());
            arrayList2.add(entry.getValue());
        });
        fDSRenderRecord.setValue("SPEC_ID_NU", arrayList);
        fDSRenderRecord.setValue("NU", arrayList2);
    }

    private void renderSimple(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        this.renderFuel(fDSRenderRecord, reaction);
        if (reaction.allowSuppression()) {
            this.renderSuppression(fDSRenderRecord, reaction);
        }
        this.renderByProducts(fDSRenderRecord, reaction);
    }

    private void renderFuel(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        if (reaction.getFuel() != null) {
            fDSRenderRecord.setValue("FUEL", reaction.getFuel().getName());
        } else {
            String string = reaction.getName() + "_" + Intl.intl("FUEL");
            NameGenerator nameGenerator = new NameGenerator("");
            for (ExSpec exSpec : this.d_renderedSpec) {
                nameGenerator.registerName(exSpec.getName());
            }
            nameGenerator.registerNames(ExSpecList.PREDEFINED.keySet());
            String string2 = nameGenerator.generateValidName(string);
            nameGenerator.registerName(string2);
            fDSRenderRecord.setValue("FUEL", string2);
        }
        int n = (int)reaction.getC();
        int n2 = (int)reaction.getH();
        int n3 = (int)reaction.getO();
        int n4 = (int)reaction.getN();
        if ((double)n == reaction.getC() && (double)n2 == reaction.getH() && (double)n3 == reaction.getO() && (double)n4 == reaction.getN()) {
            this.renderFormulaString(fDSRenderRecord, n, n2, n3, n4);
        } else {
            this.renderFormulaReals(fDSRenderRecord, reaction);
        }
    }

    private void renderFormulaString(FDSRenderRecord fDSRenderRecord, int n, int n2, int n3, int n4) {
        String string;
        String string2 = "";
        if (n > 0) {
            string = String.format("C%d", n);
            String string3 = string2 = string2.length() > 0 ? string2.concat(string) : string;
        }
        if (n2 > 0) {
            string = String.format("H%d", n2);
            String string4 = string2 = string2.length() > 0 ? string2.concat(string) : string;
        }
        if (n3 > 0) {
            string = String.format("O%d", n3);
            String string5 = string2 = string2.length() > 0 ? string2.concat(string) : string;
        }
        if (n4 > 0) {
            string = String.format("N%d", n4);
            String string6 = string2 = string2.length() > 0 ? string2.concat(string) : string;
        }
        if (!string2.isEmpty()) {
            fDSRenderRecord.setValue("FORMULA", string2);
        }
    }

    private void renderFormulaReals(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        fDSRenderRecord.setValue("C", reaction.getC(), false);
        fDSRenderRecord.setValue("H", reaction.getH(), false);
        fDSRenderRecord.setValue("O", reaction.getO(), false);
        fDSRenderRecord.setValue("N", reaction.getN(), false);
    }

    private void renderSuppression(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        fDSRenderRecord.setValue("CRITICAL_FLAME_TEMPERATURE", reaction.getCritFlameTemp(), false);
        if (reaction.getAutoIgnitionTemp().getType() == Variant.Type.CONSTANT) {
            fDSRenderRecord.setValue("AUTO_IGNITION_TEMPERATURE", reaction.getAutoIgnitionTemp().val, false);
        }
    }

    private void renderByProducts(FDSRenderRecord fDSRenderRecord, Reaction reaction) {
        fDSRenderRecord.setValue("SOOT_H_FRACTION", reaction.getSootHFraction(), false);
        fDSRenderRecord.setValue("CO_YIELD", reaction.getCOYield(), false);
        fDSRenderRecord.setValue("SOOT_YIELD", reaction.getSootYield(), false);
        if (reaction.getEnergyType() == Reaction.EnergyRelease.EPUMO2) {
            fDSRenderRecord.setValue("EPUMO2", reaction.getEpumo2(), false);
        } else if (reaction.getHeatOfCombustion().getType() == Variant.Type.CONSTANT) {
            fDSRenderRecord.setValue("HEAT_OF_COMBUSTION", reaction.getHeatOfCombustion().val, false);
        }
        if (reaction.getRadiativeFraction().getType() != Variant.Type.DEFAULT) {
            fDSRenderRecord.setValue("RADIATIVE_FRACTION", (UnitDouble)reaction.getRadiativeFraction().val);
        }
        fDSRenderRecord.setValue("IDEAL", reaction.isIdeal(), false);
    }

    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        return !(iPyroObject instanceof ExSpec);
    }
}

