/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Map;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.unitsystem.SIUS;

public class RampRenderer {
    public static boolean render(IFDSRecordRenderer iFDSRecordRenderer, Map<String, Ramp> map, PinConnectionRenderer pinConnectionRenderer) {
        boolean bl = false;
        for (Map.Entry<String, Ramp> entry : map.entrySet()) {
            if (!RampRenderer.render(iFDSRecordRenderer, entry.getKey(), entry.getValue(), pinConnectionRenderer)) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean render(IFDSRecordRenderer iFDSRecordRenderer, String string, Ramp ramp, PinConnectionRenderer pinConnectionRenderer) {
        Unit unit = SIUS.unit(ramp.getTUnitType());
        Unit unit2 = SIUS.unit(ramp.getFUnitType());
        boolean bl = true;
        for (Ramp.Entry entry : ramp.getRecords()) {
            FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("RAMP");
            fDSRenderRecord.setValue("ID", string);
            fDSRenderRecord.setValue(ramp.getInput().getTVar(), entry.t.getValue(unit));
            fDSRenderRecord.setValue("F", entry.f.getValue(unit2));
            if (ramp.getInput() instanceof SignalInput && bl) {
                SignalInput signalInput = (SignalInput)ramp.getInput();
                String string2 = pinConnectionRenderer.getID(signalInput.input);
                if (string2 != null) {
                    fDSRenderRecord.setValue("DEVC_ID", string2, false);
                } else {
                    String string3 = String.format("Unable to render RAMP(%s). PinConnection not found.", string);
                    System.err.println(string3);
                    return false;
                }
            }
            iFDSRecordRenderer.render(fDSRenderRecord, null);
            bl = false;
        }
        return !ramp.getRecords().isEmpty();
    }

    public static String createID(FDSNameMap fDSNameMap, String string, String string2) {
        String string3 = string + "_" + string2;
        String string4 = fDSNameMap.generateName("RAMP", string3);
        return string4;
    }
}

