/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import org.jscience.physics.units.SI;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.Util;
import pyrosim.io.fds.v6.renderers.ProfRenderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ProfRendererTest
extends ParseTest {
    private FDSStringRenderer d_renderer;
    private ProfRenderer d_rend;

    public ProfRendererTest() {
        super(FDS6Const.getRecordSpecs());
        QuantityMap quantityMap = new QuantityMap();
        this.d_rend = new ProfRenderer(quantityMap, null);
    }

    public void setUp() {
        this.d_renderer = new FDSStringRenderer(new FDSRenderProps());
    }

    public void test_default() throws FDSRecordFormatException {
        ProfRec profRec = new ProfRec("test", 1, Quantity.INSIDE_WALL_TEMPERATURE.create(), new UnitPoint3D(1.0, 2.0, 3.0, SI.METER));
        this.d_rend.render((IFDSRecordRenderer)this.d_renderer, (IPyroObject)profRec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_renderer.toString());
        ProfRendererTest.assertEquals((String)"PROF", (String)fDSParseRecord.getType());
        Util.assertDefined(fDSParseRecord, "ID", "IOR", "XYZ", "QUANTITY");
        ProfRendererTest.assertEquals((String)"test", (String)fDSParseRecord.getString("ID"));
        ProfRendererTest.assertEquals((int)1, (int)fDSParseRecord.getInteger("IOR"));
        ProfRendererTest.assertEquals((String)"INSIDE WALL TEMPERATURE", (String)fDSParseRecord.getString("QUANTITY"));
        FDSArray fDSArray = fDSParseRecord.getArray("XYZ", true);
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)fDSArray.get(0), (UnitDouble)fDSArray.get(1), (UnitDouble)fDSArray.get(2));
        ProfRendererTest.assertEquals((Object)1.0, (Object)unitPoint3D.x());
        ProfRendererTest.assertEquals((Object)2.0, (Object)unitPoint3D.y());
        ProfRendererTest.assertEquals((Object)3.0, (Object)unitPoint3D.z());
    }
}

