/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.output.ProfRec;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.MaterialRenderer;

public class ProfRenderer
extends AFDS6Renderer {
    private final QuantityMap d_mmap;
    private final MaterialRenderer d_matRenderer;

    public ProfRenderer(QuantityMap quantityMap, MaterialRenderer materialRenderer) {
        this.d_mmap = quantityMap;
        this.d_matRenderer = materialRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(ProfRec.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Object t;
        ProfRec profRec = (ProfRec)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("PROF");
        IQuantity iQuantity = profRec.getQuantity();
        if (iQuantity instanceof ObjectQuantity && (t = ((ObjectQuantity)iQuantity).objects[0]) instanceof Material && !this.d_matRenderer.wasRendered((Material)t)) {
            return false;
        }
        fDSRenderRecord.setValue("ID", profRec.getName());
        ProfRenderer.renderLoc(fDSRenderRecord, "XYZ", profRec.getPoint());
        fDSRenderRecord.setValue("IOR", profRec.getIOR());
        this.d_mmap.renderQuantity(fDSRenderRecord, "QUANTITY", null, null, null, null, null, iQuantity);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

