/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.SimParams;
import pyrosim.domain.output.Plot3d;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import thunderheadeng.units.UnitDouble;

public class Plot3dRenderer
extends AFDS6Renderer {
    private final QuantityMap d_measurementsMap;

    public Plot3dRenderer(QuantityMap quantityMap) {
        this.d_measurementsMap = quantityMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(SimParams.class);
        set.add(Plot3d.class);
    }

    @Override
    public void fillSingletonRecords(SingletonRecords singletonRecords, Collection<? extends IPyroObject> collection) {
        boolean bl = false;
        IPyroObject iPyroObject = null;
        for (IPyroObject iPyroObject2 : collection) {
            if (iPyroObject2 instanceof SimParams) {
                SimParams simParams = (SimParams)iPyroObject2;
                boolean bl2 = bl = simParams.getFileOutput().getDtPlot3dFile() != null;
            }
            if (!(iPyroObject2 instanceof Plot3d)) continue;
            iPyroObject = iPyroObject2;
        }
        if (bl && iPyroObject != null) {
            this.fillSingletonRecords(singletonRecords, iPyroObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillSingletonRecords(SingletonRecords singletonRecords, IPyroObject iPyroObject) {
        Serializable serializable;
        Object object;
        Plot3d plot3d = (Plot3d)iPyroObject;
        FDSRenderRecord fDSRenderRecord = singletonRecords.dumpRec;
        Set<IQuantity> set = plot3d.getQuantities();
        if (set.isEmpty()) {
            UnitDouble unitDouble = plot3d.getDomain() != null ? ((PyroMod)plot3d.getDomain()).getSimParams().getTime().getStopTime().add(new UnitDouble(1000.0, SI.SECOND)) : new UnitDouble(100000.0, SI.SECOND);
            fDSRenderRecord.setValue("DT_PL3D", unitDouble);
            return;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(5);
        ArrayList<void> arrayList3 = new ArrayList<void>(5);
        ArrayList<String> arrayList4 = new ArrayList<String>(5);
        ArrayList<ObjectQuantity> arrayList5 = new ArrayList<ObjectQuantity>(5);
        for (IQuantity arrayList6 : set) {
            void var12_16;
            arrayList2.add(this.d_measurementsMap.getFDSName(arrayList6.get()));
            Object var12_17 = null;
            object = null;
            if (arrayList6 instanceof ObjectQuantity) {
                serializable = (ObjectQuantity)arrayList6;
                if (((ObjectQuantity)serializable).objects[0] instanceof ExSpec) {
                    String string = ((ExSpec)((ObjectQuantity)serializable).objects[0]).getName();
                } else if (((ObjectQuantity)serializable).objects[0] instanceof Particle) {
                    object = ((Particle)((ObjectQuantity)serializable).objects[0]).getName();
                }
            }
            arrayList3.add(var12_16);
            arrayList4.add((String)object);
            serializable = null;
            if (arrayList6.get().equals((Object)Quantity.VELOCITY)) {
                serializable = Plot3dRenderer.renderVelocitySign(plot3d.getVelocitySign());
            }
            arrayList5.add((ObjectQuantity)serializable);
        }
        int n = 0;
        for (String string : arrayList2) {
            if (!FDS6Const.DEF_PLOT3D_QUANTITIES.contains(string)) continue;
            ++n;
        }
        if (n == FDS6Const.DEF_PLOT3D_QUANTITIES.size()) {
            return;
        }
        ArrayList<Integer> arrayList = arrayList2.size() == 2 ? new ArrayList<Integer>(Arrays.asList(3, 2, 1, 4, 0)) : new ArrayList<Integer>(Arrays.asList(4, 3, 2, 1, 0));
        FDSArray<Object> fDSArray = new FDSArray<Object>(null, null, null, null, null);
        object = new FDSArray<Object>(null, null, null, null, null);
        serializable = new FDSArray<Object>(null, null, null, null, null);
        FDSArray<Object> fDSArray2 = new FDSArray<Object>(null, null, null, null, null);
        this.fillArray(fDSArray, arrayList, Quantity.U_VELOCITY, 1, arrayList2, arrayList3, arrayList4, arrayList5);
        this.fillArray(fDSArray, arrayList, Quantity.V_VELOCITY, 2, arrayList2, arrayList3, arrayList4, arrayList5);
        this.fillArray(fDSArray, arrayList, Quantity.W_VELOCITY, 3, arrayList2, arrayList3, arrayList4, arrayList5);
        for (int i = 0; i < arrayList2.size() && !arrayList.isEmpty(); ++i) {
            Integer n2 = arrayList.remove(arrayList.size() - 1);
            fDSArray.set((int)n2, (Object[])new String[]{arrayList2.get(i)});
            ((FDSArray)object).set((int)n2, (String)arrayList3.get(i));
            ((FDSArray)serializable).set(n2, (String)arrayList4.get(i));
            fDSArray2.set((int)n2, (Object[])new Integer[]{(Integer)arrayList5.get(i)});
        }
        fDSRenderRecord.setValue("PLOT3D_QUANTITY", fDSArray);
        fDSRenderRecord.setValue("PLOT3D_SPEC_ID", object);
        fDSRenderRecord.setValue("PLOT3D_PART_ID", serializable);
        fDSRenderRecord.setValue("PLOT3D_VELO_INDEX", fDSArray2, false);
    }

    private void fillArray(FDSArray<String> fDSArray, ArrayList<Integer> arrayList, Quantity quantity, int n, ArrayList<String> arrayList2, ArrayList<?> ... arrayListArray) {
        String string = this.d_measurementsMap.getFDSName(quantity);
        int n2 = arrayList2.indexOf(string);
        if (n2 >= 0) {
            arrayList2.remove(n2);
            for (ArrayList<?> arrayList3 : arrayListArray) {
                arrayList3.remove(n2);
            }
            fDSArray.set(n, (String[])new String[]{string});
            arrayList.remove(new Integer(n));
        }
    }
}

