/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class PinConnectionRenderer
extends AFDS6Renderer {
    private final FDSNameMap d_nameMap;
    private final Map<IOutPin, OutputRetrieval> d_outPinMap = new HashMap<IOutPin, OutputRetrieval>();
    private final List<InputRetrieval> d_inPinRetrievals = new ArrayList<InputRetrieval>();

    public PinConnectionRenderer(FDSNameMap fDSNameMap) {
        this.d_nameMap = fDSNameMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(IPyroObject.class);
    }

    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        return bl;
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        return this.renderConnections(iFDSRecordRenderer, null);
    }

    public Pair<FDSRenderRecord, Boolean> generateRecord(String string, String string2, IOutPin ... iOutPinArray) {
        return this.generateRecord(string, string2, false, iOutPinArray);
    }

    public Pair<FDSRenderRecord, Boolean> generateRecord(String string, String string2, boolean bl, IOutPin ... iOutPinArray) {
        assert (string.equals("CTRL") || string.equals("DEVC"));
        assert (iOutPinArray.length > 0);
        OutputRetrieval outputRetrieval = this.d_outPinMap.get(iOutPinArray[0]);
        if (outputRetrieval != null) {
            return new Pair<FDSRenderRecord, Boolean>(outputRetrieval.rec, false);
        }
        ISignalSource iSignalSource = iOutPinArray[0].getAttachedSource();
        String string3 = PinConnectionRenderer.getOutPinName(iOutPinArray, string, bl);
        String string4 = this.d_nameMap.generateName(string, string3);
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord(string);
        fDSRenderRecord.setValue(string2, string4);
        outputRetrieval = new OutputRetrieval(fDSRenderRecord, string, string4);
        for (IOutPin iOutPin : iOutPinArray) {
            assert (iOutPin.getAttachedSource() == iSignalSource);
            this.d_outPinMap.put(iOutPin, outputRetrieval);
        }
        return new Pair<FDSRenderRecord, Boolean>(fDSRenderRecord, true);
    }

    public String getID(IOutPin iOutPin) {
        if (this.d_outPinMap.containsKey(iOutPin)) {
            return this.d_outPinMap.get((Object)iOutPin).id;
        }
        return null;
    }

    public void markForInputRetrieval(IInPin iInPin, FDSRenderRecord fDSRenderRecord, String string, String string2) {
        this.d_inPinRetrievals.add(new InputRetrieval(iInPin, fDSRenderRecord, string, string2));
    }

    public boolean renderConnections(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        for (InputRetrieval inputRetrieval : this.d_inPinRetrievals) {
            Object object;
            List<OutputRetrieval> list = this.getConnectedPinRecords(inputRetrieval.pin);
            if (list.size() > 1) {
                assert (inputRetrieval.ctrlInputKey.equals(inputRetrieval.devcInputKey));
                object = this.getConnectedIDs(list);
                inputRetrieval.rec.setValue(inputRetrieval.ctrlInputKey, object);
            } else if (list.size() == 1) {
                object = list.iterator().next();
                String string = ((OutputRetrieval)object).recType.equals("CTRL") ? inputRetrieval.ctrlInputKey : inputRetrieval.devcInputKey;
                Object object2 = inputRetrieval.rec.getSpec().fields.get(string) instanceof FDSRecordSpec.ListFld ? Arrays.asList(((OutputRetrieval)object).id) : ((OutputRetrieval)object).id;
                inputRetrieval.rec.setValue(string, object2);
            }
            object = iPyroObject == null ? inputRetrieval.pin.getAttachedSink() : iPyroObject;
            iFDSRecordRenderer.render(inputRetrieval.rec, (IPyroObject)object);
        }
        boolean bl = !this.d_inPinRetrievals.isEmpty();
        this.d_inPinRetrievals.clear();
        return bl;
    }

    private List<String> getConnectedIDs(List<OutputRetrieval> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list.size());
        for (OutputRetrieval outputRetrieval : list) {
            linkedHashSet.add(outputRetrieval.id);
        }
        return new ArrayList<String>(linkedHashSet);
    }

    private List<OutputRetrieval> getConnectedPinRecords(IInPin iInPin) {
        Set<IOutPin> set = PinConnectionRenderer.finalizeInputs(iInPin);
        ArrayList<OutputRetrieval> arrayList = new ArrayList<OutputRetrieval>(set.size());
        for (IOutPin iOutPin : set) {
            OutputRetrieval outputRetrieval = this.d_outPinMap.get(iOutPin);
            if (outputRetrieval == null) continue;
            arrayList.add(outputRetrieval);
        }
        return arrayList;
    }

    public static Set<IOutPin> finalizeInputs(IInPin iInPin) {
        LinkedIdentityHashSet<IOutPin> linkedIdentityHashSet = new LinkedIdentityHashSet<IOutPin>();
        PinConnectionRenderer.finalizeInputs(iInPin, linkedIdentityHashSet);
        return linkedIdentityHashSet;
    }

    public static void finalizeInputs(IInPin iInPin, Set<IOutPin> set) {
        Set<? extends IOutPin> set2 = iInPin.getConnections();
        for (IOutPin iOutPin : set2) {
            if (iOutPin.getAttachedSource() instanceof IControl && ((IControl)iOutPin.getAttachedSource()).isWire()) {
                IControl iControl = (IControl)iOutPin.getAttachedSource();
                boolean bl = false;
                for (IOutPin iOutPin2 : iControl.getInputPin().getConnections()) {
                    if (!iInPin.isCompatible(iOutPin2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                PinConnectionRenderer.finalizeInputs(iControl.getInputPin(), set);
                continue;
            }
            set.add(iOutPin);
        }
    }

    public static String getOutPinName(IOutPin[] iOutPinArray, String string, boolean bl) {
        String string2;
        ISignalSource iSignalSource = iOutPinArray[0].getAttachedSource();
        string2 = iSignalSource instanceof INamed ? (string2 = ((INamed)((Object)iSignalSource)).getName()) : string;
        List<? extends IOutPin> list = iSignalSource.getOutputPins();
        if (list.size() > iOutPinArray.length || bl) {
            string2 = string2 + "->" + iOutPinArray[0].getName();
        }
        return string2;
    }

    private static class InputRetrieval {
        public final IInPin pin;
        public final FDSRenderRecord rec;
        public final String ctrlInputKey;
        public final String devcInputKey;

        public InputRetrieval(IInPin iInPin, FDSRenderRecord fDSRenderRecord, String string, String string2) {
            this.pin = iInPin;
            this.rec = fDSRenderRecord;
            this.ctrlInputKey = string;
            this.devcInputKey = string2;
        }
    }

    private static class OutputRetrieval {
        public final FDSRenderRecord rec;
        public final String recType;
        public final String id;

        public OutputRetrieval(FDSRenderRecord fDSRenderRecord, String string, String string2) {
            this.rec = fDSRenderRecord;
            this.recType = string;
            this.id = string2;
        }
    }
}

