/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Pers;
import pyrosim.domain.evac.PersList;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Sets;

public class PersRenderer
extends AFDS6Renderer {
    public static Pers DEFAULTS = new Pers("__defaults__");
    public static Collection<String> DIST_PROPS = new HashSet<String>(Sets.fromArrayHS("DET_EVAC_DIST", "DET_MEAN", "DET_PARA", "DET_PARA2", "DET_LOW", "DET_HIGH", "PRE_EVAC_DIST", "PRE_MEAN", "PRE_PARA", "PRE_PARA2", "PRE_LOW", "PRE_HIGH", "DIAMETER_DIST", "DIA_MEAN", "DIA_PARA", "DIA_PARA2", "DIA_LOW", "DIA_HIGH", "VELOCITY_DIST", "VEL_MEAN", "VEL_PARA", "VEL_PARA2", "VEL_LOW", "VEL_HIGH", "TAU_EVAC_DIST", "TAU_MEAN", "TAU_PARA", "TAU_PARA2", "TAU_LOW", "TAU_HIGH"));
    public static Collection<String> LOOSE_PROPS = new HashSet<String>(Sets.fromArrayHS("ID", "FYI", "DEFAULT_PROPERTIES", "FCONST_A", "FCONST_B", "L_NON_SP", "C_YOUNG", "KAPPA", "D_TORSO_MEAN", "D_SHOULDER_MEAN", "TAU_ROT", "M_INERTIA"));
    public static Collection<String> GLOBAL_PROPS = new HashSet<String>(Sets.fromArrayHS("FAC_A_WALL", "FAC_B_WALL", "LAMBDA_WALL", "FC_DAMPING", "V_ANGULAR", "NOISEME", "NOISETH", "NOISECM", "HUMAN_SMOKE_HEIGHT", "TDET_SMOKE_DENS", "FED_DOOR_CRIT", "SMOKE_MIN_SPEED", "DENS_INIT", "EVAC_DT_MAX", "EVAC_DT_MIN", "NOT_RANDOM", "COLOR_METHOD", "OUTPUT_SPEED", "OUTPUT_FED", "OUTPUT_CONTACT_FORCE", "OUTPUT_TOTAL_FORCE"));
    public static Collection<String> GLOBAL_PROPS_SPECIAL = new HashSet<String>(Sets.fromArrayHS("AVATAR_COLOR", "AVATAR_RGB", "DEAD_COLOR", "DEAD_RGB"));
    private final PersList d_persList;

    public PersRenderer(PersList persList) {
        this.d_persList = persList;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Pers.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Pers pers = (Pers)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("PERS");
        String string = (String)pers.getProp("DEFAULT_PROPERTIES");
        Pers pers2 = DEFAULTS;
        if (string != null) {
            pers2 = PersList.PREDEFINED.get(string);
            assert (pers2 != null);
        }
        fDSRenderRecord.setValue("ID", pers.getName());
        String string2 = (String)pers.getProp("FYI");
        if (string2 != null && !string2.isEmpty()) {
            fDSRenderRecord.setValue("FYI", pers.getProp("FYI"));
        }
        fDSRenderRecord.setValue("DEFAULT_PROPERTIES", string != null ? string : "null");
        Collection<String> collection = Pers.diff(DIST_PROPS, pers2, pers);
        this.addDistRec(fDSRenderRecord, pers, collection, "DET_EVAC_DIST", "DET_MEAN", "DET_PARA", "DET_PARA2", "DET_LOW", "DET_HIGH");
        this.addDistRec(fDSRenderRecord, pers, collection, "PRE_EVAC_DIST", "PRE_MEAN", "PRE_PARA", "PRE_PARA2", "PRE_LOW", "PRE_HIGH");
        this.addDistRec(fDSRenderRecord, pers, collection, "DIAMETER_DIST", "DIA_MEAN", "DIA_PARA", "DIA_PARA2", "DIA_LOW", "DIA_HIGH");
        this.addDistRec(fDSRenderRecord, pers, collection, "VELOCITY_DIST", "VEL_MEAN", "VEL_PARA", "VEL_PARA2", "VEL_LOW", "VEL_HIGH");
        this.addDistRec(fDSRenderRecord, pers, collection, "TAU_EVAC_DIST", "TAU_MEAN", "TAU_PARA", "TAU_PARA2", "TAU_LOW", "TAU_HIGH");
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(LOOSE_PROPS);
        hashSet.removeAll(Arrays.asList("ID", "FYI", "DEFAULT_PROPERTIES"));
        collection = Pers.diff(hashSet, pers2, pers);
        for (String string3 : hashSet) {
            if (!collection.contains(string3)) continue;
            fDSRenderRecord.setValue(string3, pers.getProp(string3));
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }

    private void addDistRec(FDSRenderRecord fDSRenderRecord, Pers pers, Collection<String> collection, String string, String string2, String string3, String string4, String string5, String string6) {
        int n = (Integer)pers.getProp(string);
        UnitDouble unitDouble = (UnitDouble)pers.getProp(string2);
        UnitDouble unitDouble2 = (UnitDouble)pers.getProp(string5);
        UnitDouble unitDouble3 = (UnitDouble)pers.getProp(string6);
        Double d = (Double)pers.getProp(string3);
        Double d2 = (Double)pers.getProp(string4);
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (!this.changed(collection, string, string2)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string2, unitDouble);
                break;
            }
            case 1: {
                if (!this.changed(collection, string, string5, string6)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string5, unitDouble2);
                fDSRenderRecord.setValue(string6, unitDouble3);
                break;
            }
            case 2: {
                if (!this.changed(collection, string, string2, string3, string5, string6)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string2, unitDouble);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string5, unitDouble2);
                fDSRenderRecord.setValue(string6, unitDouble3);
                break;
            }
            case 3: {
                if (!this.changed(collection, string, string3, string4)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string4, d2);
                break;
            }
            case 4: {
                if (!this.changed(collection, string, string2, string3)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string2, unitDouble);
                fDSRenderRecord.setValue(string3, d);
                break;
            }
            case 5: {
                if (!this.changed(collection, string, string2, string3, string6)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string2, unitDouble);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string6, unitDouble3);
                break;
            }
            case 6: {
                if (!this.changed(collection, string, string3, string4)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string4, d2);
                break;
            }
            case 7: {
                if (!this.changed(collection, string, string2, string5, string6)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string2, unitDouble);
                fDSRenderRecord.setValue(string5, unitDouble2);
                fDSRenderRecord.setValue(string6, unitDouble3);
                break;
            }
            case 8: {
                if (!this.changed(collection, string, string3, string4)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string4, d2);
                break;
            }
            case 9: {
                if (!this.changed(collection, string, string3, string4)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string3, d);
                fDSRenderRecord.setValue(string4, d2);
                break;
            }
            case 10: {
                if (!this.changed(collection, string, string3)) break;
                fDSRenderRecord.setValue(string, n);
                fDSRenderRecord.setValue(string3, d);
            }
        }
    }

    private boolean changed(Collection<String> collection, String ... stringArray) {
        for (String string : stringArray) {
            if (!collection.contains(string)) continue;
            return true;
        }
        return false;
    }
}

