/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.particle.ConstColoring;
import pyrosim.domain.particle.DropletColoring;
import pyrosim.domain.particle.IColoring;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.common.ParticleQuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;

public class ParticleRenderer
extends AFDS6UniqueRenderer {
    private final PinConnectionRenderer d_pinConns;

    public ParticleRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer) {
        super(fDSNameMap);
        this.d_pinConns = pinConnectionRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Particle.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Particle particle = (Particle)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("PART");
        String string = this.getNameMap().mapToName("PART", particle);
        fDSRenderRecord.setValue("ID", string);
        fDSRenderRecord.setValue("FYI", particle.getFYI(), false);
        ParticleRenderer.renderCoreParams(fDSRenderRecord, particle);
        ParticleRenderer.renderCustomFDSProps(fDSRenderRecord, particle);
        if (particle.getInputPin().getConnections().isEmpty()) {
            iFDSRecordRenderer.props().pushProps();
            iFDSRecordRenderer.props().setRenderMultiLine(true);
            iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
            iFDSRecordRenderer.props().popProps();
        } else {
            this.d_pinConns.markForInputRetrieval(particle.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        }
        return true;
    }

    public static void renderCoreParams(FDSRenderRecord fDSRenderRecord, Particle particle) {
        fDSRenderRecord.setValue("STATIC", particle.isStatic(), false);
        switch (particle.getType()) {
            case TRACER: {
                ParticleRenderer.renderTracer(fDSRenderRecord, particle);
                break;
            }
            case LIQUID: {
                ParticleRenderer.renderLiquid(fDSRenderRecord, particle);
                break;
            }
            case SOLID: {
                ParticleRenderer.renderSolid(fDSRenderRecord, particle);
            }
        }
    }

    private static void renderTracer(FDSRenderRecord fDSRenderRecord, Particle particle) {
        fDSRenderRecord.setValue("MASSLESS", true, true);
        ParticleRenderer.renderGeneric(fDSRenderRecord, particle, 1);
    }

    private static void renderLiquid(FDSRenderRecord fDSRenderRecord, Particle particle) {
        if (particle.getSpecies() != null) {
            fDSRenderRecord.setValue("SPEC_ID", particle.getSpecies().getName());
        }
        ParticleRenderer.renderGeneric(fDSRenderRecord, particle);
    }

    private static void renderSolid(FDSRenderRecord fDSRenderRecord, Particle particle) {
        if (particle.getSurface() != null) {
            fDSRenderRecord.setValue("SURF_ID", particle.getSurface().getName());
        }
        String string = null;
        if (particle.getDragType() == Particle.Drag.SPHERE) {
            string = "SPHERE";
        } else if (particle.getDragType() == Particle.Drag.CYLINDER) {
            string = "CYLINDER";
        } else if (particle.getDragType() == Particle.Drag.SCREEN) {
            string = "SCREEN";
        } else {
            fDSRenderRecord.setValue("DRAG_COEFFICIENT", particle.getDragCoef());
        }
        if (string != null) {
            fDSRenderRecord.setValue("DRAG_LAW", string, false);
        }
        fDSRenderRecord.setValue("DENSE_VOLUME_FRACTION", particle.getDenseVolumeFraction(), false);
        ParticleRenderer.renderSizeDistribution(fDSRenderRecord, particle);
        ParticleRenderer.renderGeneric(fDSRenderRecord, particle);
    }

    private static void renderGeneric(FDSRenderRecord fDSRenderRecord, Particle particle) {
        ParticleRenderer.renderGeneric(fDSRenderRecord, particle, 10);
    }

    private static void renderGeneric(FDSRenderRecord fDSRenderRecord, Particle particle, int n) {
        ParticleRenderer.renderSizeDistribution(fDSRenderRecord, particle);
        ParticleRenderer.renderColoring(fDSRenderRecord, particle.getColoring());
        ParticleRenderer.renderOutput(fDSRenderRecord, particle.getOutput(), n);
    }

    private static void renderSizeDistribution(FDSRenderRecord fDSRenderRecord, Particle particle) {
        if (particle.getType() == Particle.Type.SOLID) {
            return;
        }
        if (particle.getDiameter().isConstant()) {
            fDSRenderRecord.setValue("DIAMETER", particle.getDiameter().val, false);
        }
        if (particle.getDistribution() == Particle.Distribution.CONST) {
            fDSRenderRecord.setValue("MONODISPERSE", true, false);
            return;
        }
        fDSRenderRecord.setValue("MINIMUM_DIAMETER", particle.getMinDiameter(), false);
        fDSRenderRecord.setValue("MAXIMUM_DIAMETER", particle.getMaxDiameter(), false);
        switch (particle.getDistribution()) {
            case ROSIN: {
                fDSRenderRecord.setValue("DISTRIBUTION", "ROSIN-RAMMLER", false);
                fDSRenderRecord.setValue("GAMMA_D", particle.getGammaD(), false);
                break;
            }
            case LOGNORMAL: {
                fDSRenderRecord.setValue("DISTRIBUTION", "LOGNORMAL", false);
                fDSRenderRecord.setValue("SIGMA_D", particle.getSigmaD(), false);
                break;
            }
            case ROSINLOGNORMAL: {
                fDSRenderRecord.setValue("GAMMA_D", particle.getGammaD(), false);
            }
        }
    }

    private static void renderColoring(FDSRenderRecord fDSRenderRecord, IColoring iColoring) {
        if (iColoring == null) {
            return;
        }
        if (iColoring instanceof ConstColoring) {
            ParticleRenderer.renderColor(fDSRenderRecord, true, ((ConstColoring)iColoring).color, "RGB", "COLOR", null);
        } else if (iColoring instanceof DropletColoring) {
            Set<Integer> set = ((DropletColoring)iColoring).d_properties;
            ArrayList<String> arrayList = new ArrayList<String>(set.size());
            for (Integer n : set) {
                arrayList.add(ParticleQuantityMap.getFDSVal(n));
            }
            fDSRenderRecord.setValue("QUANTITIES", arrayList, false);
        }
    }

    private static void renderOutput(FDSRenderRecord fDSRenderRecord, Output output, int n) {
        fDSRenderRecord.setValue("AGE", output.d_age, false);
        if (output.d_samplingFactor != n) {
            fDSRenderRecord.setValue("SAMPLING_FACTOR", output.d_samplingFactor, false);
        }
    }
}

