/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6UniqueRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.units.UnitPoint3D;

public class PartCloudRenderer
extends AFDS6UniqueRenderer {
    private final PinConnectionRenderer d_pinConns;

    public PartCloudRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer) {
        super(fDSNameMap);
        this.d_pinConns = pinConnectionRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(PartCloud.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        PartCloud partCloud = (PartCloud)iPyroObject;
        if (partCloud.getParticle() == null) {
            return false;
        }
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("INIT");
        fDSRenderRecord.setValue("ID", partCloud.getName());
        fDSRenderRecord.setComment(partCloud.getDesc());
        fDSRenderRecord.setValue("PART_ID", partCloud.getParticle().getName());
        IGeom iGeom = partCloud.getPartCloudGeom();
        PartCloudRenderer.renderCount(fDSRenderRecord, partCloud, partCloud.getInitDrops());
        PartCloudRenderer.renderInsertion(fDSRenderRecord, partCloud.getParticle(), partCloud.getInsertion(), iGeom);
        PartCloudRenderer.renderGeom(fDSRenderRecord, partCloud, iGeom);
        PartCloudRenderer.renderCustomFDSProps(fDSRenderRecord, partCloud);
        if (partCloud.getInsertion() instanceof PartCloud.InsertPeriodically) {
            this.d_pinConns.markForInputRetrieval(partCloud.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
            this.d_pinConns.renderConnections(iFDSRecordRenderer, partCloud);
        } else {
            iFDSRecordRenderer.render(fDSRenderRecord, partCloud);
        }
        return true;
    }

    private static void renderGeom(FDSRenderRecord fDSRenderRecord, PartCloud partCloud, IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            AABoxGeom aABoxGeom = (AABoxGeom)iGeom;
            PartCloudRenderer.renderXB(fDSRenderRecord, "XB", aABoxGeom.min, aABoxGeom.max);
        } else if (iGeom instanceof Point) {
            Point point = (Point)iGeom;
            PartCloudRenderer.renderLoc(fDSRenderRecord, "XYZ", new UnitPoint3D(point.loc, Geometry.LU));
        }
    }

    private static void renderCount(FDSRenderRecord fDSRenderRecord, PartCloud partCloud, PartCloud.IDropletCount iDropletCount) {
        if (iDropletCount instanceof PartCloud.PerCellCount) {
            PartCloud.PerCellCount perCellCount = (PartCloud.PerCellCount)iDropletCount;
            fDSRenderRecord.setValue("N_PARTICLES_PER_CELL", perCellCount.partPerCell, false);
            fDSRenderRecord.setValue("CELL_CENTERED", perCellCount.cellCentered, false);
        } else {
            fDSRenderRecord.setValue("N_PARTICLES", iDropletCount.getNumDrops(partCloud), false);
        }
    }

    private static void renderInsertion(FDSRenderRecord fDSRenderRecord, Particle particle, PartCloud.IInsertion iInsertion, IGeom iGeom) {
        boolean bl = particle.isType(Particle.Type.TRACER);
        if (iInsertion instanceof PartCloud.InsertOnce) {
            PartCloud.InsertOnce insertOnce = (PartCloud.InsertOnce)iInsertion;
            if (!bl && !(iGeom instanceof Point)) {
                fDSRenderRecord.setValue("MASS_PER_VOLUME", insertOnce.massPerVolume, false);
            }
        } else if (iInsertion instanceof PartCloud.InsertPeriodically) {
            PartCloud.InsertPeriodically insertPeriodically = (PartCloud.InsertPeriodically)iInsertion;
            fDSRenderRecord.setValue("DT_INSERT", insertPeriodically.dt, true);
            if (!bl) {
                fDSRenderRecord.setValue("MASS_PER_TIME", insertPeriodically.massPerTime, true);
            }
        }
    }
}

