/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDSObjRenderer;
import pyrosim.io.fds.v6.renderers.IObstructionRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;

public class ObstructionRenderer
extends AFDSObjRenderer<IObstruction>
implements IObstructionRenderer {
    private final PinConnectionRenderer d_pinConns;
    private final Map<IObstruction, List<Integer>> d_obstIxes = new LinkedIdentityHashMap<IObstruction, List<Integer>>();
    private int d_obstIx = 0;

    public ObstructionRenderer(FDSRasterization fDSRasterization, PinConnectionRenderer pinConnectionRenderer) {
        super(fDSRasterization);
        this.d_pinConns = pinConnectionRenderer;
    }

    @Override
    public Map<IObstruction, List<Integer>> getObstIxes() {
        return this.d_obstIxes;
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, AABoxGeom aABoxGeom, Collection<IObstruction> collection, FaceProps[] facePropsArray) {
        Color[] colorArray = new Color[facePropsArray.length];
        Surface[] surfaceArray = new Surface[facePropsArray.length];
        for (int i = 0; i < facePropsArray.length; ++i) {
            colorArray[i] = facePropsArray[i].color;
            surfaceArray[i] = facePropsArray[i].surface;
        }
        return this.renderBlock(iFDSRecordRenderer, aABoxGeom, collection, colorArray, surfaceArray);
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, IObstruction iObstruction) {
        return this.renderBlock(iFDSRecordRenderer, iObstruction.getGeom().flatten().getLocalGeom(), Collections.singleton(iObstruction), iObstruction.getColors(), iObstruction.getSurfaces());
    }

    public boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, IGeom iGeom, Collection<IObstruction> collection, Color[] colorArray, Surface[] surfaceArray) {
        IObstruction iObstruction2 = collection.iterator().next();
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("OBST");
        fDSRenderRecord.setValue("ID", iObstruction2.getName());
        fDSRenderRecord.setComment(iObstruction2.getDesc());
        ObstructionRenderer.renderAABox(fDSRenderRecord, "XB", iGeom.getBoundingBox(new AABox()));
        ObstructionRenderer.renderEvac(fDSRenderRecord, "EVACUATION", "MESH_ID", iObstruction2.getEvac());
        Color color = ObstructionRenderer.resolveSurfaceColor(colorArray[0], surfaceArray[0]);
        ObstructionRenderer.renderColor(fDSRenderRecord, iObstruction2.isVisible(), color, "RGB", "COLOR", "TRANSPARENCY");
        fDSRenderRecord.setValue("PERMIT_HOLE", iObstruction2.getOptions(4), false);
        fDSRenderRecord.setValue("THICKEN", iObstruction2.getOptions(1), false);
        fDSRenderRecord.setValue("ALLOW_VENT", iObstruction2.getOptions(8), false);
        fDSRenderRecord.setValue("BNDF_OBST", iObstruction2.getOptions(16), false);
        fDSRenderRecord.setValue("OUTLINE", iObstruction2.getOptions(32), false);
        fDSRenderRecord.setValue("REMOVABLE", iObstruction2.getOptions(64), false);
        UnitDouble unitDouble = iObstruction2.getBulkDensity();
        if (unitDouble != null) {
            fDSRenderRecord.setValue("BULK_DENSITY", unitDouble, false);
        }
        ObstructionRenderer.fillMaterialRecords(iGeom, surfaceArray, fDSRenderRecord);
        ObstructionRenderer.renderTextureOrigin(fDSRenderRecord, "TEXTURE_ORIGIN", iObstruction2, iObstruction2.getTextureOrigin());
        ObstructionRenderer.renderCustomFDSProps(fDSRenderRecord, iObstruction2);
        this.d_pinConns.markForInputRetrieval(iObstruction2.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        this.d_pinConns.renderConnections(iFDSRecordRenderer, iObstruction2);
        for (IObstruction iObstruction3 : collection) {
            this.d_obstIxes.computeIfAbsent(iObstruction3, iObstruction -> new ArrayList()).add(this.d_obstIx);
        }
        ++this.d_obstIx;
        return true;
    }

    protected static void fillMaterialRecords(IGeom iGeom, Surface[] surfaceArray, FDSRenderRecord fDSRenderRecord) {
        if (surfaceArray.length == 1 || pyrosim.domain.GeomUtil.isUniform(surfaceArray)) {
            fDSRenderRecord.setValue("SURF_ID", surfaceArray[0].getName());
            return;
        }
        assert (surfaceArray.length == 6);
        if (pyrosim.domain.GeomUtil.isUniform(surfaceArray = ObstructionRenderer.swizzleSurfs(iGeom, surfaceArray))) {
            fDSRenderRecord.setValue("SURF_ID", surfaceArray[0].getName());
            return;
        }
        if (surfaceArray[0] == surfaceArray[1] && surfaceArray[0] == surfaceArray[2] && surfaceArray[0] == surfaceArray[3]) {
            FDSArray<Object> fDSArray = new FDSArray<Object>(surfaceArray[5].getName(), surfaceArray[0].getName(), surfaceArray[4].getName());
            fDSRenderRecord.setValue("SURF_IDS", fDSArray);
        } else {
            FDSArray<Object> fDSArray = new FDSArray<Object>(surfaceArray[0].getName(), surfaceArray[1].getName(), surfaceArray[2].getName(), surfaceArray[3].getName(), surfaceArray[4].getName(), surfaceArray[5].getName());
            fDSRenderRecord.setValue("SURF_ID6", fDSArray);
        }
    }

    private static Surface[] swizzleSurfs(IGeom iGeom, Surface[] surfaceArray) {
        int n;
        int[] nArray = ObstructionRenderer.getFDSFaceNormals(iGeom);
        if (nArray == null) {
            return surfaceArray;
        }
        assert (nArray.length == surfaceArray.length);
        Surface[] surfaceArray2 = new Surface[surfaceArray.length];
        for (n = 0; n < surfaceArray2.length; ++n) {
            int n2 = nArray[n];
            if (n2 == 0) continue;
            surfaceArray2[ObstructionRenderer.getFDSIndex((int)n2)] = surfaceArray[n];
        }
        for (n = 0; n < surfaceArray2.length; ++n) {
            if (surfaceArray2[n] != null) continue;
            surfaceArray2[n] = surfaceArray[0];
        }
        return surfaceArray2;
    }

    private static int getFDSIndex(int n) {
        switch (n) {
            case -1: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case -2: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case -3: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    private static int[] getFDSFaceNormals(IGeom iGeom) {
        if (iGeom instanceof AABoxGeom) {
            return ObstructionRenderer.getFDSFaceNormals((AABoxGeom)iGeom);
        }
        return ObstructionRenderer.getGeneralFDSFaceNormals(iGeom);
    }

    private static int[] getGeneralFDSFaceNormals(IGeom iGeom) {
        AABox aABox = iGeom.getBoundingBox(new AABox());
        Point3d point3d = aABox.getCenter();
        List list = GeomUtil.explode(iGeom, IFace.class);
        assert (list.size() == 6);
        Vector3d[] vector3dArray = new Vector3d[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            assert (list.get(i) instanceof IPolygon);
            IPolygon iPolygon = (IPolygon)list.get(i);
            Vector3d vector3d = iPolygon.getNormal(true);
            if (vector3d.lengthSquared() > 0.0) {
                Plane3d plane3d = new Plane3d(vector3d, iPolygon.getPoint(0, 0));
                if (plane3d.dot(point3d) > 0.0) {
                    vector3d = Util3D.negate(vector3d);
                }
                vector3dArray[i] = vector3d;
                continue;
            }
            vector3dArray[i] = null;
        }
        int[] nArray = new int[vector3dArray.length];
        for (int i = 0; i < vector3dArray.length; ++i) {
            nArray[i] = vector3dArray[i] == null ? 0 : pyrosim.io.fds.v6.common.GeomUtil.toFDSVec(vector3dArray[i]);
        }
        return nArray;
    }

    private static int[] getFDSFaceNormals(AABoxGeom aABoxGeom) {
        int[] nArray = aABoxGeom.getIndexToNameFaceOrder();
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = ObstructionRenderer.boxNameToFDSVec(nArray[i]);
        }
        return nArray2;
    }

    private static int boxNameToFDSVec(int n) {
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return -3;
            }
            case 5: {
                return 3;
            }
        }
        return 0;
    }
}

