/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.IHeatBasedValue;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.IPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidPyrolysis;
import pyrosim.domain.boundcond.mat.LiquidReaction;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.mat.SolidPyrolysis;
import pyrosim.domain.boundcond.mat.SolidReaction;
import pyrosim.domain.boundcond.mat.ThermalProps;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Lists;

public class MaterialRenderer
extends AFDS6Renderer {
    private final Set<Material> d_renderedMats;
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;

    public MaterialRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer) {
        this.d_nameMap = fDSNameMap;
        this.d_renderedMats = new IdentityHashSet<Material>();
        this.d_pinConns = pinConnectionRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Material.class);
    }

    public boolean wasRendered(Material material) {
        return this.d_renderedMats.contains(material);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Material material = (Material)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("MATL");
        fDSRenderRecord.setValue("ID", material.getName());
        String string = material.getFYI().trim();
        if (string.length() > 0) {
            fDSRenderRecord.setValue("FYI", string);
        }
        HashMap<String, Ramp> hashMap = new HashMap<String, Ramp>();
        this.writeThermalProps(iFDSRecordRenderer, material, fDSRenderRecord, hashMap);
        this.writePyrolysis(fDSRenderRecord, material.getPyrolysis());
        MaterialRenderer.renderCustomFDSProps(fDSRenderRecord, material);
        iFDSRecordRenderer.props().pushProps();
        iFDSRecordRenderer.props().setRenderMultiLine(true);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        iFDSRecordRenderer.props().popProps();
        RampRenderer.render(iFDSRecordRenderer, hashMap, this.d_pinConns);
        this.d_renderedMats.add(material);
        return true;
    }

    private void writeThermalProps(IFDSRecordRenderer iFDSRecordRenderer, Material material, FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map) {
        ThermalProps thermalProps = material.getThermalProps();
        this.writeTempDepVal(material, fDSRenderRecord, map, "SPECIFIC_HEAT", "SPECIFIC_HEAT_RAMP", thermalProps.d_specificHeat);
        this.writeTempDepVal(material, fDSRenderRecord, map, "CONDUCTIVITY", "CONDUCTIVITY_RAMP", thermalProps.d_conductivity);
        fDSRenderRecord.setValue("DENSITY", thermalProps.d_density, false);
        fDSRenderRecord.setValue("ABSORPTION_COEFFICIENT", thermalProps.d_absorptionCoeff, false);
        fDSRenderRecord.setValue("EMISSIVITY", thermalProps.d_emissivity, false);
    }

    private void writePyrolysis(FDSRenderRecord fDSRenderRecord, IPyrolysis iPyrolysis) {
        if (iPyrolysis instanceof SolidPyrolysis) {
            this.writeSolidPyrolysis(fDSRenderRecord, (SolidPyrolysis)iPyrolysis);
        } else if (iPyrolysis instanceof LiquidPyrolysis) {
            this.writeLiquidPyrolysis(fDSRenderRecord, (LiquidPyrolysis)iPyrolysis);
        }
    }

    private void writeSolidPyrolysis(FDSRenderRecord fDSRenderRecord, SolidPyrolysis solidPyrolysis) {
        if (solidPyrolysis.d_heatOfCombustion != null) {
            fDSRenderRecord.setValue("HEAT_OF_COMBUSTION", solidPyrolysis.d_heatOfCombustion, false);
        }
        fDSRenderRecord.setValue("N_REACTIONS", solidPyrolysis.getReactions().size(), false);
        ArrayList<SolidReaction.Rate> arrayList = new ArrayList<SolidReaction.Rate>(solidPyrolysis.getReactions().size());
        ArrayList<ReacByproducts> arrayList2 = new ArrayList<ReacByproducts>(solidPyrolysis.getReactions().size());
        for (SolidReaction solidReaction : solidPyrolysis.getReactions()) {
            arrayList2.add(solidReaction.d_byproducts);
            arrayList.add(solidReaction.d_rate);
        }
        this.writeReacByproducts(fDSRenderRecord, arrayList2);
        this.writeSolidReacRates(fDSRenderRecord, arrayList);
    }

    private void writeLiquidPyrolysis(FDSRenderRecord fDSRenderRecord, LiquidPyrolysis liquidPyrolysis) {
        LiquidReaction liquidReaction = liquidPyrolysis.d_reaction;
        if (liquidPyrolysis.d_heatOfCombust != null) {
            fDSRenderRecord.setValue("HEAT_OF_COMBUSTION", liquidPyrolysis.d_heatOfCombust, false);
        }
        this.writeReacByproducts(fDSRenderRecord, Arrays.asList(liquidReaction.d_byproducts));
        this.writeLiquidReacRate(fDSRenderRecord, liquidReaction.d_rate);
    }

    private void writeReacByproducts(FDSRenderRecord fDSRenderRecord, List<ReacByproducts> list) {
        List<Object> list2 = Lists.filled(list.size(), null);
        FDSArray<String> fDSArray = new FDSArray<String>(new int[]{20, 10});
        FDSArray<String> fDSArray2 = new FDSArray<String>(new int[]{20, 10});
        FDSArray<Double> fDSArray3 = new FDSArray<Double>(new int[]{20, 10});
        FDSArray<Double> fDSArray4 = new FDSArray<Double>(new int[]{20, 10});
        int[] nArray = new int[2];
        for (int i = 0; i < list.size(); ++i) {
            ReacByproducts reacByproducts = list.get(i);
            if (reacByproducts.d_heat != null) {
                list2.set(i, reacByproducts.d_heat);
            }
            nArray[1] = i;
            int n = 0;
            int n2 = 0;
            for (ReacByproducts.Residue residue : reacByproducts.getResidues()) {
                if (residue.d_type instanceof Material) {
                    nArray[0] = n++;
                    fDSArray.set(residue.d_type.getName(), nArray);
                    fDSArray3.set(residue.d_fraction, nArray);
                    continue;
                }
                nArray[0] = n2++;
                fDSArray2.set(residue.d_type.getName(), nArray);
                fDSArray4.set(residue.d_fraction, nArray);
            }
        }
        fDSRenderRecord.setValue("HEAT_OF_REACTION", list2, false);
        fDSRenderRecord.setValue("MATL_ID", fDSArray);
        fDSRenderRecord.setValue("NU_MATL", fDSArray3, false);
        fDSRenderRecord.setValue("SPEC_ID", fDSArray2);
        fDSRenderRecord.setValue("NU_SPEC", fDSArray4, false);
    }

    private void writeSolidReacRates(FDSRenderRecord fDSRenderRecord, List<SolidReaction.Rate> list) {
        List<Object> list2 = Lists.filled(list.size(), null);
        List<Object> list3 = Lists.filled(list.size(), null);
        List<Object> list4 = Lists.filled(list.size(), null);
        List<Object> list5 = Lists.filled(list.size(), null);
        List<Object> list6 = Lists.filled(list.size(), null);
        List<Object> list7 = Lists.filled(list.size(), null);
        List<Object> list8 = Lists.filled(list.size(), null);
        List<Object> list9 = Lists.filled(list.size(), null);
        FDSRecordSpec.ListFld listFld = (FDSRecordSpec.ListFld)fDSRenderRecord.getSpec().fields.get("HEATING_RATE");
        FDSRecordSpec.ListFld listFld2 = (FDSRecordSpec.ListFld)fDSRenderRecord.getSpec().fields.get("PYROLYSIS_RANGE");
        for (int i = 0; i < list.size(); ++i) {
            SolidReaction.Rate.ISpecification iSpecification;
            SolidReaction.Rate rate = list.get(i);
            if (rate.d_tempExponent != 0.0) {
                list2.set(i, rate.d_tempExponent);
                list3.set(i, rate.d_thresholdTemp);
            }
            if (rate.d_massFracExponent != 1.0) {
                list4.set(i, rate.d_massFracExponent);
            }
            if (rate.d_spec instanceof SolidReaction.Rate.AESpec) {
                iSpecification = (SolidReaction.Rate.AESpec)rate.d_spec;
                list5.set(i, iSpecification.d_a);
                list6.set(i, iSpecification.d_e);
                continue;
            }
            assert (rate.d_spec instanceof SolidReaction.Rate.RefSpec);
            iSpecification = (SolidReaction.Rate.RefSpec)rate.d_spec;
            list7.set(i, ((SolidReaction.Rate.RefSpec)iSpecification).d_refTemp);
            if (!((SolidReaction.Rate.RefSpec)iSpecification).d_heatingRate.equals(listFld.elementChecker.initialValue)) {
                list8.set(i, ((SolidReaction.Rate.RefSpec)iSpecification).d_heatingRate);
            }
            if (((SolidReaction.Rate.RefSpec)iSpecification).d_pyrolysisRange.equals(listFld2.elementChecker.initialValue)) continue;
            list9.set(i, ((SolidReaction.Rate.RefSpec)iSpecification).d_pyrolysisRange);
        }
        fDSRenderRecord.setValue("N_T", list2, false);
        fDSRenderRecord.setValue("THRESHOLD_TEMPERATURE", list3, false);
        fDSRenderRecord.setValue("N_S", list4, false);
        fDSRenderRecord.setValue("A", list5, false);
        fDSRenderRecord.setValue("E", list6, false);
        fDSRenderRecord.setValue("REFERENCE_TEMPERATURE", list7, false);
        fDSRenderRecord.setValue("HEATING_RATE", list8, false);
        fDSRenderRecord.setValue("PYROLYSIS_RANGE", list9, false);
    }

    private void writeLiquidReacRate(FDSRenderRecord fDSRenderRecord, LiquidReaction.Rate rate) {
        fDSRenderRecord.setValue("BOILING_TEMPERATURE", rate.d_boilingTemp, true);
    }

    private void writeTempDepVal(Material material, FDSRenderRecord fDSRenderRecord, Map<String, Ramp> map, String string, String string2, IHeatBasedValue iHeatBasedValue) {
        if (iHeatBasedValue instanceof IHeatBasedValue.Constant) {
            fDSRenderRecord.setValue(string, ((IHeatBasedValue.Constant)iHeatBasedValue).value, false);
        } else {
            assert (iHeatBasedValue instanceof IHeatBasedValue.Custom);
            String string3 = RampRenderer.createID(this.d_nameMap, material.getName(), string2);
            map.put(string3, ((IHeatBasedValue.Custom)iHeatBasedValue).value);
            fDSRenderRecord.setValue(string2, string3, false);
        }
    }
}

