/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class IsofRenderer
extends AFDS6Renderer {
    private final QuantityMap d_quantityMap;

    public IsofRenderer(QuantityMap quantityMap) {
        this.d_quantityMap = quantityMap;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Isosurface.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Isosurface isosurface = (Isosurface)iPyroObject;
        List<UnitDouble> list = isosurface.getContours();
        Unit unit = SIUS.unit(isosurface.getQuantity().get().unitType);
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("ISOF");
        this.d_quantityMap.renderQuantity(fDSRenderRecord, "QUANTITY", null, "SPEC_ID", null, null, null, isosurface.getQuantity());
        ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
        for (UnitDouble unitDouble : list) {
            arrayList.add(unitDouble.getValue(unit));
        }
        fDSRenderRecord.setValue("VALUE", arrayList);
        if (isosurface.getQuantity().get().equals((Object)Quantity.VELOCITY)) {
            Integer n = IsofRenderer.renderVelocitySign(isosurface.getVelocitySign());
            fDSRenderRecord.setValue("VELO_INDEX", n, false);
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

