/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.InitRegion;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.units.UnitDouble;

public class InitRenderer
extends AFDS6Renderer {
    private final ExSpecRenderer d_specRenderer;
    private final PinConnectionRenderer d_pinConns;

    public InitRenderer(ExSpecRenderer exSpecRenderer, PinConnectionRenderer pinConnectionRenderer) {
        this.d_specRenderer = exSpecRenderer;
        this.d_pinConns = pinConnectionRenderer;
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(InitRegion.class);
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        InitRegion initRegion = (InitRegion)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("INIT");
        fDSRenderRecord.setValue("ID", initRegion.getName());
        fDSRenderRecord.setComment(initRegion.getDesc());
        fDSRenderRecord.setValue("DENSITY", initRegion.getDensity());
        fDSRenderRecord.setValue("TEMPERATURE", initRegion.getTemperature());
        this.renderSpecFracs(fDSRenderRecord, initRegion);
        AABoxGeom aABoxGeom = initRegion.getBoxGeom();
        InitRenderer.renderXB(fDSRenderRecord, "XB", aABoxGeom.min, aABoxGeom.max);
        InitRenderer.renderCustomFDSProps(fDSRenderRecord, initRegion);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }

    private void renderSpecFracs(FDSRenderRecord fDSRenderRecord, InitRegion initRegion) {
        Map<ExSpec, UnitDouble> map = initRegion.getExtraSpecies();
        if (map.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<UnitDouble> arrayList2 = new ArrayList<UnitDouble>();
        for (Map.Entry<ExSpec, UnitDouble> entry : map.entrySet()) {
            arrayList.add(entry.getKey().getName());
            arrayList2.add(entry.getValue());
        }
        Object object = "";
        if (initRegion.getExtraSpeciesType().equals((Object)InitRegion.SpecFractionType.MASS_FRACTION)) {
            object = "MASS_FRACTION";
        } else if (initRegion.getExtraSpeciesType().equals((Object)InitRegion.SpecFractionType.VOLUME_FRACTION)) {
            object = "VOLUME_FRACTION";
        }
        assert (!((String)object).isEmpty());
        fDSRenderRecord.setValue("SPEC_ID", arrayList);
        fDSRenderRecord.setValue((String)object, arrayList2);
    }
}

