/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacLeak;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.domain.ramp.Ramp;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class HvacRenderer
extends AFDS6Renderer {
    private static final String LEAK_AMBIENT = "AMBIENT";
    private final FDSNameMap d_uniqueNameMap;
    private final PinConnectionRenderer d_pinConnRenderer;
    private final Map<Vent, String> d_ventNames;
    private final Map<String, Ramp> d_rampsUsed;
    private final List<HvacDuctLoss> d_ductLosses;
    private final List<HvacDuct> d_ducts;

    public HvacRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer, Map<Vent, String> map) {
        this.d_uniqueNameMap = fDSNameMap;
        this.d_pinConnRenderer = pinConnectionRenderer;
        this.d_ventNames = map;
        this.d_rampsUsed = new HashMap<String, Ramp>();
        this.d_ductLosses = new ArrayList<HvacDuctLoss>();
        this.d_ducts = new ArrayList<HvacDuct>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(HvacComponent.class);
        set.add(HvacDuctLoss.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        this.d_ductLosses.addAll(theUtil.filter(collection, HvacDuctLoss.class));
        this.d_ducts.addAll(theUtil.filter(collection, HvacDuct.class));
        boolean bl = false;
        for (HvacComponent hvacComponent : theUtil.filter(collection, HvacComponent.class)) {
            bl |= this.render(iFDSRecordRenderer, hvacComponent);
        }
        this.doneRendering(iFDSRecordRenderer);
        return bl;
    }

    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, HvacComponent hvacComponent) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("HVAC");
        fDSRenderRecord.setValue("ID", hvacComponent.getName());
        fDSRenderRecord.setValue("TYPE_ID", hvacComponent.getProp("TYPE_ID"));
        if (hvacComponent instanceof HvacAircoil && !this.renderAircoil(iFDSRecordRenderer, fDSRenderRecord, this.d_uniqueNameMap, this.d_rampsUsed, (HvacAircoil)hvacComponent)) {
            return false;
        }
        if (hvacComponent instanceof HvacDuct && !this.renderDuct(iFDSRecordRenderer, fDSRenderRecord, this.d_uniqueNameMap, this.d_rampsUsed, (HvacDuct)hvacComponent)) {
            return false;
        }
        if (hvacComponent instanceof HvacFan && !this.renderFan(iFDSRecordRenderer, fDSRenderRecord, this.d_uniqueNameMap, this.d_rampsUsed, (HvacFan)hvacComponent)) {
            return false;
        }
        if (hvacComponent instanceof HvacFilter && !this.renderFilter(iFDSRecordRenderer, fDSRenderRecord, this.d_uniqueNameMap, this.d_rampsUsed, (HvacFilter)hvacComponent)) {
            return false;
        }
        if (hvacComponent instanceof HvacLeak && !this.renderLeak(iFDSRecordRenderer, fDSRenderRecord, (HvacLeak)hvacComponent)) {
            return false;
        }
        return !(hvacComponent instanceof HvacNode) || this.renderNode(iFDSRecordRenderer, fDSRenderRecord, (HvacNode)hvacComponent);
    }

    private boolean renderDuct(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, HvacDuct hvacDuct) {
        Object object;
        HvacDuct.Shape shape = (HvacDuct.Shape)((Object)hvacDuct.getProp("opt_shape"));
        switch (shape) {
            case CIRCULAR: {
                fDSRenderRecord.setValue("DIAMETER", hvacDuct.getProp("DIAMETER"), true);
                break;
            }
            case NON_CIRCULAR: {
                fDSRenderRecord.setValue("AREA", hvacDuct.getProp("AREA"), true);
                fDSRenderRecord.setValue("PERIMETER", hvacDuct.getProp("PERIMETER"), true);
            }
        }
        HvacDuct.AirflowObj airflowObj = (HvacDuct.AirflowObj)((Object)hvacDuct.getProp("opt_none_damper_fan"));
        switch (airflowObj) {
            case DAMPER: {
                fDSRenderRecord.setValue("DAMPER", true, false);
                break;
            }
            case VOLFLOW: {
                HvacRenderer.renderTVal(fDSRenderRecord, fDSNameMap, map, hvacDuct.getName(), hvacDuct.getVolflow(), "VOLUME_FLOW", "RAMP_ID", "TAU_VF", true);
                break;
            }
            case FAN: {
                object = (NamedPyroObject)hvacDuct.getProp("FAN_ID");
                fDSRenderRecord.setValue("FAN_ID", ((NamedPyroObject)object).getName());
                break;
            }
            case AIRCOIL: {
                object = (NamedPyroObject)hvacDuct.getProp("AIRCOIL_ID");
                fDSRenderRecord.setValue("AIRCOIL_ID", ((NamedPyroObject)object).getName());
                break;
            }
        }
        object = (List)hvacDuct.getProp("LOSS");
        assert (object != null);
        assert (object.size() == 2);
        fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray((List<UnitDouble>)object, 2));
        List list = (List)hvacDuct.getProp("NODE_ID");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HvacNode hvacNode : list) {
            if (hvacNode == null) continue;
            arrayList.add(hvacNode.getName());
        }
        fDSRenderRecord.setValue("NODE_ID", arrayList);
        fDSRenderRecord.setValue("REVERSE", hvacDuct.getProp("REVERSE"), false);
        HvacDuct.FrictionType frictionType = (HvacDuct.FrictionType)((Object)hvacDuct.getProp("opt_friction_type"));
        if (frictionType.equals((Object)HvacDuct.FrictionType.EXPLICIT)) {
            fDSRenderRecord.setValue("ROUGHNESS", hvacDuct.getProp("ROUGHNESS"), true);
        } else if (frictionType.equals((Object)HvacDuct.FrictionType.COMPUTED_FRICTION)) {
            fDSRenderRecord.setValue("ROUGHNESS", new UnitDouble(0.0, SI.METER), true);
        }
        fDSRenderRecord.setValue("LENGTH", hvacDuct.getFinalLength(), false);
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacDuct);
        this.d_pinConnRenderer.markForInputRetrieval(hvacDuct.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(iFDSRecordRenderer, hvacDuct);
        return true;
    }

    private boolean renderFan(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, HvacFan hvacFan) {
        List list = (List)hvacFan.getProp("LOSS");
        fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray(list, 1));
        HvacRenderer.renderTimeFunc(fDSRenderRecord, fDSNameMap, map, hvacFan.getName(), hvacFan.getTauFunc(), null, "TAU_FAN");
        int n = (Integer)hvacFan.getProp("opt_fan_model");
        if (n == HvacFan.FAN_MODEL_QUADRATIC) {
            fDSRenderRecord.setValue("MAX_FLOW", hvacFan.getProp("MAX_FLOW"));
            fDSRenderRecord.setValue("MAX_PRESSURE", hvacFan.getProp("MAX_PRESSURE"));
        } else if (n == HvacFan.FAN_MODEL_PRESDROP) {
            this.renderVariant(iFDSRecordRenderer, fDSRenderRecord, fDSNameMap, map, hvacFan.getName(), hvacFan.getPressureFlow(), null, "RAMP_ID");
        } else if (n == HvacFan.FAN_MODEL_VOLFLOW) {
            fDSRenderRecord.setValue("VOLUME_FLOW", hvacFan.getProp("VOLUME_FLOW"));
        }
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacFan);
        this.d_pinConnRenderer.markForInputRetrieval(hvacFan.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(iFDSRecordRenderer, hvacFan);
        return true;
    }

    private boolean renderNode(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, HvacNode hvacNode) {
        HvacFilter hvacFilter;
        List<UnitDouble> list;
        IFilteredCollection<HvacDuct> iFilteredCollection = theUtil.filter(this.d_ducts, HvacUtil.getConnectedDuctsFilter(hvacNode));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (HvacDuct serializable2 : iFilteredCollection) {
            if (serializable2 == null) continue;
            arrayList.add(serializable2.getName());
        }
        fDSRenderRecord.setValue("DUCT_ID", arrayList);
        HvacNode.NodeType nodeType = hvacNode.getFinalNodeType(iFilteredCollection.size());
        switch (nodeType) {
            case AMBIENT: {
                fDSRenderRecord.setValue(LEAK_AMBIENT, true, true);
                break;
            }
            case VENT: {
                Vent vent = hvacNode.getVent();
                assert (vent != null);
                list = this.d_ventNames.get(vent);
                if (list == null) {
                    System.err.printf("HVAC Vent not assigned a unique name: %s%n", vent.getName());
                    list = vent.getName();
                }
                fDSRenderRecord.setValue("VENT_ID", list);
                break;
            }
        }
        if (nodeType != HvacNode.NodeType.VENT) {
            UnitPoint3D unitPoint3D = (UnitPoint3D)hvacNode.getProp("XYZ");
            assert (unitPoint3D != null);
            HvacRenderer.renderLoc(fDSRenderRecord, "XYZ", unitPoint3D);
        }
        if ((hvacFilter = hvacNode.getFilter()) != null) {
            fDSRenderRecord.setValue("FILTER_ID", hvacFilter.getName());
        }
        if (nodeType.terminal) {
            list = hvacNode.getTerminalLoss();
            fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray(list, 2), false);
        } else {
            list = this.getLossList(hvacNode, iFilteredCollection);
            if (list != null && list.size() > 0) {
                fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray(list, iFilteredCollection.size()), false);
            }
        }
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacNode);
        iFDSRecordRenderer.render(fDSRenderRecord, hvacNode);
        return true;
    }

    protected List<UnitDouble> getLossList(HvacNode hvacNode, Collection<HvacDuct> collection) {
        boolean bl = false;
        ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>(collection.size() * collection.size());
        for (HvacDuct hvacDuct : collection) {
            for (HvacDuct hvacDuct2 : collection) {
                UnitDouble unitDouble;
                IFilteredCollection<HvacDuctLoss> iFilteredCollection = theUtil.filter(this.d_ductLosses, HvacUtil.getDuctLossFilter(hvacNode, hvacDuct2, hvacDuct));
                UnitDouble unitDouble2 = unitDouble = iFilteredCollection.isEmpty() ? null : ((HvacDuctLoss)iFilteredCollection.iterator().next()).getLoss(hvacDuct2);
                if (unitDouble != null && theUtil.eq0(unitDouble.getValue(Unit.ONE), 1.0E-9)) {
                    unitDouble = null;
                }
                bl |= unitDouble != null;
                arrayList.add(unitDouble);
            }
        }
        return bl ? arrayList : null;
    }

    private static FDSArray<UnitDouble> convertLossListToArray(List<UnitDouble> list, int n) {
        FDSArray<UnitDouble> fDSArray = new FDSArray<UnitDouble>(FDS6Const.HVAC_LOSS_DIMENSIONS);
        Iterator<UnitDouble> iterator = list.iterator();
        for (int i = 0; i < list.size() / n; ++i) {
            int n2 = 0;
            while (n2 < n) {
                UnitDouble unitDouble = iterator.next();
                if (unitDouble != null && theUtil.eq0(unitDouble.getValueNoUnit(), 1.0E-9)) {
                    unitDouble = null;
                }
                fDSArray.set(unitDouble, new int[]{n2++, i});
            }
        }
        assert (!iterator.hasNext());
        return fDSArray;
    }

    private boolean renderAircoil(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, HvacAircoil hvacAircoil) {
        HvacAircoil.Model model = (HvacAircoil.Model)((Object)hvacAircoil.getProp("opt_aircoil_model"));
        switch (model) {
            case COOLANT: {
                fDSRenderRecord.setValue("COOLANT_SPECIFIC_HEAT", hvacAircoil.getProp("COOLANT_SPECIFIC_HEAT"));
                fDSRenderRecord.setValue("COOLANT_MASS_FLOW", hvacAircoil.getProp("COOLANT_MASS_FLOW"));
                fDSRenderRecord.setValue("COOLANT_TEMPERATURE", hvacAircoil.getProp("COOLANT_TEMPERATURE"));
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(hvacAircoil.getProp("EFFICIENCY"));
                fDSRenderRecord.setValue("EFFICIENCY", arrayList);
                break;
            }
            case FIXEDQ: {
                TimeBasedValue<UnitDouble> timeBasedValue = hvacAircoil.getFixedQ();
                HvacRenderer.renderTVal(fDSRenderRecord, fDSNameMap, map, hvacAircoil.getName(), timeBasedValue, "FIXED_Q", "RAMP_ID", "TAU_AC", false);
                break;
            }
        }
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacAircoil);
        this.d_pinConnRenderer.markForInputRetrieval(hvacAircoil.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        this.d_pinConnRenderer.renderConnections(iFDSRecordRenderer, hvacAircoil);
        return true;
    }

    private boolean renderFilter(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, FDSNameMap fDSNameMap, Map<String, Ramp> map, HvacFilter hvacFilter) {
        Object object;
        HvacFilter.LossModel lossModel = (HvacFilter.LossModel)((Object)hvacFilter.getProp("opt_loss_ramp"));
        switch (lossModel) {
            case LINEAR: {
                object = (List)hvacFilter.getProp("LOSS");
                fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray((List<UnitDouble>)object, 1));
                fDSRenderRecord.setValue("CLEAN_LOSS", hvacFilter.getProp("CLEAN_LOSS"));
                break;
            }
            case CUSTOM: {
                assert (hvacFilter.getCustomLoss().isRamp());
                object = RampRenderer.createID(fDSNameMap, hvacFilter.getName(), "RAMP_ID");
                map.put((String)object, (Ramp)hvacFilter.getCustomLoss().val);
                fDSRenderRecord.setValue("RAMP_ID", object, false);
                break;
            }
        }
        fDSRenderRecord.setValue("LOADING", hvacFilter.getProp("LOADING"));
        fDSRenderRecord.setValue("LOADING_MULTIPLIER", hvacFilter.getProp("LOADING_MULTIPLIER"));
        fDSRenderRecord.setValue("EFFICIENCY", hvacFilter.getProp("EFFICIENCY"));
        object = (List)hvacFilter.getProp("SPEC_ID");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (object.size() > 0) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ExSpec exSpec = (ExSpec)iterator.next();
                arrayList.add(exSpec.getName());
            }
            fDSRenderRecord.setValue("SPEC_ID", arrayList);
        }
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacFilter);
        iFDSRecordRenderer.render(fDSRenderRecord, hvacFilter);
        return true;
    }

    private boolean renderLeak(IFDSRecordRenderer iFDSRecordRenderer, FDSRenderRecord fDSRenderRecord, HvacLeak hvacLeak) {
        HvacRenderer.renderLeakVent(fDSRenderRecord, hvacLeak.getVent1(), "VENT_ID");
        HvacRenderer.renderLeakVent(fDSRenderRecord, hvacLeak.getVent2(), "VENT2_ID");
        fDSRenderRecord.setValue("AREA", hvacLeak.getLeakArea(), false);
        fDSRenderRecord.setValue("LEAK_ENTHALPY", hvacLeak.isEnthalpyCalc(), false);
        fDSRenderRecord.setValue("LOSS", HvacRenderer.convertLossListToArray((List)hvacLeak.getProp("LOSS"), 1), false);
        HvacRenderer.renderCustomFDSProps(fDSRenderRecord, hvacLeak);
        iFDSRecordRenderer.render(fDSRenderRecord, hvacLeak);
        return true;
    }

    private static void renderLeakVent(FDSRenderRecord fDSRenderRecord, Vent vent, String string) {
        String string2 = vent == null ? LEAK_AMBIENT : vent.getName();
        fDSRenderRecord.setValue(string, string2);
    }

    @Override
    public void doneRendering(IFDSRecordRenderer iFDSRecordRenderer) {
        super.doneRendering(iFDSRecordRenderer);
        RampRenderer.render(iFDSRecordRenderer, this.d_rampsUsed, this.d_pinConnRenderer);
    }
}

