/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDSObjRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class HoleRenderer
extends AFDSObjRenderer<IHole> {
    public static final double EXPANSION_SCALE = 0.1;
    private final PinConnectionRenderer d_pinConns;
    private final List<Pair<Grid, AABox>> d_grids;

    public HoleRenderer(FDSRasterization fDSRasterization, PinConnectionRenderer pinConnectionRenderer) {
        super(fDSRasterization);
        this.d_pinConns = pinConnectionRenderer;
        this.d_grids = new ArrayList<Pair<Grid, AABox>>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(IHole.class);
        set.add(Grid.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        for (Grid grid : theUtil.filter(collection, Grid.class)) {
            if (grid.getXDivisions().length == 0 || grid.getYDivisions().length == 0 || grid.getZDivisions().length == 0) continue;
            this.d_grids.add(new Pair<Grid, AABox>(grid, HoleRenderer.getGridTestBounds(grid)));
        }
        return super.render(iFDSRecordRenderer, theUtil.filter(collection, IHole.class));
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, AABoxGeom aABoxGeom, Collection<IHole> collection, FaceProps[] facePropsArray) {
        Color[] colorArray = new Color[facePropsArray.length];
        for (int i = 0; i < facePropsArray.length; ++i) {
            colorArray[i] = facePropsArray[i].color;
        }
        return this.renderBlock(iFDSRecordRenderer, (IGeom)aABoxGeom, collection.iterator().next(), colorArray);
    }

    @Override
    protected boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, IHole iHole) {
        return this.renderBlock(iFDSRecordRenderer, iHole.getGeom().flatten().getLocalGeom(), iHole, iHole.getColors());
    }

    private boolean renderBlock(IFDSRecordRenderer iFDSRecordRenderer, IGeom iGeom, IHole iHole, Color[] colorArray) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("HOLE");
        fDSRenderRecord.setValue("ID", iHole.getName());
        fDSRenderRecord.setComment(iHole.getDesc());
        iGeom = this.finalizeGeom(iFDSRecordRenderer.props(), iGeom);
        HoleRenderer.renderAABox(fDSRenderRecord, "XB", iGeom.getBoundingBox(new AABox()));
        HoleRenderer.renderEvac(fDSRenderRecord, "EVACUATION", "MESH_ID", iHole.getEvac());
        HoleRenderer.renderColor(fDSRenderRecord, iHole.isVisible(), colorArray[0], "RGB", "COLOR", "TRANSPARENCY");
        HoleRenderer.renderCustomFDSProps(fDSRenderRecord, iHole);
        this.d_pinConns.markForInputRetrieval(iHole.getInputPin(), fDSRenderRecord, "CTRL_ID", "DEVC_ID");
        this.d_pinConns.renderConnections(iFDSRecordRenderer, iHole);
        return true;
    }

    private IGeom finalizeGeom(FDSRenderProps fDSRenderProps, IGeom iGeom) {
        int n;
        AABox aABox = iGeom.getBoundingBox(new AABox());
        double[] dArray = new double[6];
        Arrays.fill(dArray, Double.MAX_VALUE);
        boolean bl = false;
        for (Pair<Grid, AABox> pair : this.d_grids) {
            Grid grid = (Grid)pair.v1;
            AABox aABox2 = (AABox)pair.v2;
            if (!aABox.test((AABox)aABox2, (double)1.0E-9).positive) continue;
            AABox aABox3 = grid.getBounds();
            bl |= this.testExpansion(dArray, 0, aABox.getMinX(), aABox3.getMinX(), grid.getXDivisions());
            bl |= this.testExpansion(dArray, 1, aABox.getMaxX(), aABox3.getMaxX(), grid.getXDivisions());
            bl |= this.testExpansion(dArray, 2, aABox.getMinY(), aABox3.getMinY(), grid.getYDivisions());
            bl |= this.testExpansion(dArray, 3, aABox.getMaxY(), aABox3.getMaxY(), grid.getYDivisions());
            bl |= this.testExpansion(dArray, 4, aABox.getMinZ(), aABox3.getMinZ(), grid.getZDivisions());
            bl |= this.testExpansion(dArray, 5, aABox.getMaxZ(), aABox3.getMaxZ(), grid.getZDivisions());
        }
        if (!bl || !fDSRenderProps.expandBoundaryHoles()) {
            return iGeom;
        }
        Object object = new double[]{aABox.getMinX(), aABox.getMaxX(), aABox.getMinY(), aABox.getMaxY(), aABox.getMinZ(), aABox.getMaxZ()};
        for (n = 0; n < dArray.length; ++n) {
            double d = dArray[n];
            if (d == Double.MAX_VALUE) continue;
            if (n % 2 == 0) {
                Object object2 = object;
                int n2 = n;
                object2[n2] = object2[n2] - d;
                continue;
            }
            Object object3 = object;
            int n3 = n;
            object3[n3] = object3[n3] + d;
        }
        n = iGeom instanceof AABoxGeom ? (int)((AABoxGeom)iGeom).swizzle : 0;
        return new AABoxGeom(new Point3d((double)object[0], (double)object[2], (double)object[4]), new Point3d((double)object[1], (double)object[3], (double)object[5]), n);
    }

    private boolean testExpansion(double[] dArray, int n, double d, double d2, UnitDouble[] unitDoubleArray) {
        if (n % 2 == 0) {
            double d3 = unitDoubleArray[0].getValue(Geometry.LU);
            if (d < d2 + d3 * 0.5 && d > d2 - d3 * 0.1) {
                double d4 = d - (d2 - d3 * 0.1);
                if (d4 < dArray[n]) {
                    dArray[n] = d4;
                }
                return true;
            }
        } else {
            double d5 = unitDoubleArray[unitDoubleArray.length - 1].getValue(Geometry.LU);
            if (d > d2 - d5 * 0.5 && d < d2 + d5 * 0.1) {
                double d6 = d2 + d5 * 0.1 - d;
                if (d6 < dArray[n]) {
                    dArray[n] = d6;
                }
                return true;
            }
        }
        return false;
    }

    private static AABox getGridTestBounds(Grid grid) {
        AABox aABox = grid.getBounds();
        AABox aABox2 = new AABox(aABox.getMinX() + grid.getXDivisions()[0].getValue(Geometry.LU) * 0.5, aABox.getMinY() + grid.getYDivisions()[0].getValue(Geometry.LU) * 0.5, aABox.getMinZ() + grid.getZDivisions()[0].getValue(Geometry.LU) * 0.5, aABox.getMaxX() - grid.getXDivisions()[grid.getXDivisions().length - 1].getValue(Geometry.LU) * 0.5, aABox.getMaxY() - grid.getYDivisions()[grid.getYDivisions().length - 1].getValue(Geometry.LU) * 0.5, aABox.getMaxZ() - grid.getZDivisions()[grid.getZDivisions().length - 1].getValue(Geometry.LU) * 0.5);
        return aABox2;
    }
}

