/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.gui.grid.RegularGridCreator;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class GridRenderer
extends AFDS6Renderer {
    private int d_gridIx = 0;

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Grid.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Grid grid = (Grid)iPyroObject;
        this.writeMeshRecord(iFDSRecordRenderer, grid);
        if (!RegularGridCreator.isUniform(grid.getXDivisions())) {
            this.writeTRNRecords(iFDSRecordRenderer, grid, "TRNX", grid.getMinPoint().xu(), grid.getMaxPoint().xu(), grid.getXDivisions());
        }
        if (!RegularGridCreator.isUniform(grid.getYDivisions())) {
            this.writeTRNRecords(iFDSRecordRenderer, grid, "TRNY", grid.getMinPoint().yu(), grid.getMaxPoint().yu(), grid.getYDivisions());
        }
        if (!RegularGridCreator.isUniform(grid.getZDivisions())) {
            this.writeTRNRecords(iFDSRecordRenderer, grid, "TRNZ", grid.getMinPoint().zu(), grid.getMaxPoint().zu(), grid.getZDivisions());
        }
        ++this.d_gridIx;
        return true;
    }

    private void writeMeshRecord(IFDSRecordRenderer iFDSRecordRenderer, Grid grid) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("MESH");
        fDSRenderRecord.setValue("ID", grid.getName());
        fDSRenderRecord.setValue("FYI", grid.getFYI(), false);
        GridRenderer.renderColor(fDSRenderRecord, true, grid.getColor(), "RGB", "COLOR", null);
        FDSArray<Object> fDSArray = new FDSArray<Object>(grid.getXDivisions().length, grid.getYDivisions().length, grid.getZDivisions().length);
        fDSRenderRecord.setValue("IJK", fDSArray);
        GridRenderer.renderXB(fDSRenderRecord, "XB", grid.getMinPoint(), grid.getMaxPoint());
        if (grid.getEvacuation()) {
            fDSRenderRecord.setValue("EVACUATION", grid.getEvacuation());
            fDSRenderRecord.setValue("EVAC_HUMANS", grid.getEvacHumans(), false);
            fDSRenderRecord.setValue("EVAC_Z_OFFSET", grid.getEvacZOffset(), true);
        }
        GridRenderer.renderCustomFDSProps(fDSRenderRecord, grid);
        iFDSRecordRenderer.render(fDSRenderRecord, grid);
    }

    private void writeTRNRecords(IFDSRecordRenderer iFDSRecordRenderer, Grid grid, String string, UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble[] unitDoubleArray) {
        if (unitDoubleArray.length <= 0) {
            return;
        }
        double[] dArray = new double[unitDoubleArray.length];
        Unit unit = SIUS.getInstance().getLengthUnit();
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            dArray[i] = unitDoubleArray[i].getValue(unit);
        }
        double d = unitDouble.getValue(unit);
        double d2 = unitDouble2.getValue(unit);
        double d3 = (d2 - d) / (double)dArray.length;
        double d4 = 1.0;
        double d5 = dArray[0];
        double d6 = d + d5;
        double d7 = d;
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] == d5) {
                d4 += 1.0;
            } else {
                double d8 = d7 + d4 * d3;
                FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord(string);
                fDSRenderRecord.setComment(grid.getName());
                fDSRenderRecord.setValue("CC", new UnitDouble(d8, unit));
                fDSRenderRecord.setValue("PC", new UnitDouble(d6, unit));
                fDSRenderRecord.setValue("MESH_NUMBER", this.d_gridIx + 1);
                iFDSRecordRenderer.render(fDSRenderRecord, grid);
                d4 = 1.0;
                d5 = dArray[i];
                d7 = d8;
            }
            d6 += dArray[i];
        }
    }
}

