/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.geom.Geometry;
import pyrosim.io.fds.FDSArray;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.IObstructionRenderer;
import pyrosim.io.fds.v6.renderers.ObstructionRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.IdentityXform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomRenderer
extends AFDS6Renderer
implements IObstructionRenderer {
    public static final int MAX_ID_LENGTH = 30;
    private final PinConnectionRenderer d_pinRenderer;
    private final ObstructionRenderer d_obstRend;
    private RenderInfo d_ri;
    private static final FDSTransform FDS_IDENTITY = new FDSTransform();

    public GeomRenderer(FDSRasterization fDSRasterization, PinConnectionRenderer pinConnectionRenderer) {
        this.d_pinRenderer = pinConnectionRenderer;
        this.d_obstRend = new ObstructionRenderer(fDSRasterization, pinConnectionRenderer);
    }

    @Override
    public Map<IObstruction, List<Integer>> getObstIxes() {
        return this.d_obstRend.getObstIxes();
    }

    private static boolean hasTransform(FDSRenderRecord fDSRenderRecord) {
        return fDSRenderRecord.contains("AZIM") || fDSRenderRecord.contains("ELEV") || fDSRenderRecord.contains("GAXIS") || fDSRenderRecord.contains("GROTATE") || fDSRenderRecord.contains("SCALE") || fDSRenderRecord.contains("XYZ") || fDSRenderRecord.contains("XYZ0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        this.d_ri = new RenderInfo();
        boolean bl = super.render(iFDSRecordRenderer, collection);
        RenderInfo renderInfo = this.d_ri;
        iFDSRecordRenderer.props().pushProps();
        iFDSRecordRenderer.props().setRenderMultiLine(true);
        try {
            RecordInfo recordInfo;
            FDSRenderRecord fDSRenderRecord;
            Iterator<Map.Entry<FDSRenderRecord, RecordInfo>> iterator = renderInfo.records.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<FDSRenderRecord, RecordInfo> entry = iterator.next();
                fDSRenderRecord = entry.getKey();
                recordInfo = entry.getValue();
                if (!recordInfo.compOnly || recordInfo.referencedBy.size() != 1 || renderInfo.records.get((Object)recordInfo.referencedBy.get((int)0)).referencing.size() != 1 || GeomRenderer.hasTransform(fDSRenderRecord) && GeomRenderer.hasTransform(recordInfo.referencedBy.get(0))) continue;
                iterator.remove();
                FDSRenderRecord fDSRenderRecord2 = recordInfo.referencedBy.get(0);
                RecordInfo recordInfo2 = renderInfo.records.get(fDSRenderRecord2);
                recordInfo2.referencing = recordInfo.referencing;
                fDSRenderRecord2.setValue("GEOM_IDS", null);
                for (Map.Entry<String, Object> entry2 : fDSRenderRecord.getProperties().entrySet()) {
                    if (fDSRenderRecord2.contains(entry2.getKey())) continue;
                    fDSRenderRecord2.setValue(entry2.getKey(), entry2.getValue());
                }
            }
            for (Map.Entry<FDSRenderRecord, RecordInfo> entry : renderInfo.records.entrySet()) {
                fDSRenderRecord = entry.getKey();
                recordInfo = entry.getValue();
                fDSRenderRecord.setValue("COMPONENT_ONLY", recordInfo.compOnly, false);
                iFDSRecordRenderer.render(fDSRenderRecord, recordInfo.obst);
            }
        }
        finally {
            iFDSRecordRenderer.props().popProps();
        }
        this.d_ri = new RenderInfo();
        return bl |= this.d_obstRend.render(iFDSRecordRenderer, renderInfo.toRasterize);
    }

    @Override
    protected boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Cloneable cloneable;
        IObstruction iObstruction = (IObstruction)iPyroObject;
        if (!iObstruction.getOptions(128)) {
            this.d_ri.toRasterize.add(iObstruction);
            return true;
        }
        RenderInfo renderInfo = this.d_ri;
        String string = this.nextName(iObstruction.getName());
        int n = iObstruction.getNumFaces();
        Pair<FDSRenderRecord, RasterizeGeom> pair = this.constructGeomRecords(iObstruction, iObstruction.getGeom(), Arrays.asList(GeomUtil.matchPrimCount(iObstruction.getSurfaces(), Surface.class, false, n)), Arrays.asList(GeomUtil.matchPrimCount(iObstruction.getColors(), Color.class, false, n)));
        FDSRenderRecord fDSRenderRecord = (FDSRenderRecord)pair.v1;
        RasterizeGeom rasterizeGeom = (RasterizeGeom)pair.v2;
        if (rasterizeGeom != null && rasterizeGeom.isEmpty()) {
            rasterizeGeom = null;
        }
        if (fDSRenderRecord == null && rasterizeGeom == null) {
            return false;
        }
        if (fDSRenderRecord != null) {
            cloneable = this.newRec(string, iObstruction, Collections.singletonList(fDSRenderRecord));
            fDSRenderRecord = cloneable;
            renderInfo.records.get((Object)fDSRenderRecord).compOnly = false;
        }
        if (rasterizeGeom != null) {
            if (fDSRenderRecord == null) {
                renderInfo.toRasterize.add(iObstruction);
            } else {
                cloneable = (IObstruction)iObstruction.clone();
                ArrayList<IGeom> arrayList = new ArrayList<IGeom>(rasterizeGeom.geoms.size());
                for (Pair<TransformInfo, IGeom> pair2 : rasterizeGeom.geoms) {
                    arrayList.add(((IGeom)pair2.v2).transform((TransformInfo)pair2.v1, 0));
                }
                cloneable.setGeom(GeomNodeUtil.newNode(thunderheadeng.geometry.objs.GeomUtil.group(arrayList)));
                cloneable.setSurfaces(GeomUtil.optimize(theUtil.toArray(rasterizeGeom.surfs, Surface.class)));
                cloneable.setColors(GeomUtil.optimize(theUtil.toArray(rasterizeGeom.colors, Color.class)));
                renderInfo.toRasterize.add((IObstruction)cloneable);
            }
        }
        return true;
    }

    private static int addXform(FDSTransform fDSTransform, ITransform iTransform, int n) {
        if (iTransform instanceof IdentityXform) {
            return n;
        }
        if (iTransform instanceof ScaleXform) {
            if (n > 0) {
                throw new RuntimeException();
            }
            ScaleXform scaleXform = (ScaleXform)iTransform;
            fDSTransform.scale = new Double[]{scaleXform.x, scaleXform.y, scaleXform.z};
            return 1;
        }
        if (iTransform instanceof RotateXform) {
            if (n > 1) {
                throw new RuntimeException();
            }
            RotateXform rotateXform = (RotateXform)iTransform;
            AxisAngle4d axisAngle4d2 = rotateXform.getAxisAngle();
            Vector3d vector3d2 = new Vector3d(axisAngle4d2.x, axisAngle4d2.y, axisAngle4d2.z);
            Util3D.safeNormalize(vector3d2, 0.0);
            fDSTransform.gaxis = new Double[]{vector3d2.x, vector3d2.y, vector3d2.z};
            fDSTransform.grotate = new UnitDouble(-axisAngle4d2.angle, SI.RADIAN);
            return 2;
        }
        if (iTransform instanceof TranslateXform) {
            if (n > 2) {
                throw new RuntimeException();
            }
            TranslateXform translateXform = (TranslateXform)iTransform;
            fDSTransform.xyz = new UnitDouble[]{new UnitDouble(translateXform.x, Geometry.LU), new UnitDouble(translateXform.y, Geometry.LU), new UnitDouble(translateXform.z, Geometry.LU)};
            return 3;
        }
        if (iTransform instanceof MatrixXform) {
            MatrixXform matrixXform = (MatrixXform)iTransform;
            AxisAngle4d[] axisAngle4dArray = new AxisAngle4d[]{null};
            Vector3d[] vector3dArray = new Vector3d[]{null};
            Vector3d[] vector3dArray2 = new Vector3d[]{null};
            Integer[] integerArray = new Integer[]{0};
            thunderheadeng.geometry.objs.GeomUtil.decompose(matrixXform.xform, 1.0E-9, vector3d -> {
                integerArray[0] = integerArray[0] + 1;
                vector3dArray[0] = vector3d;
            }, axisAngle4d -> {
                integerArray[0] = integerArray[0] + 1;
                axisAngle4dArray[0] = axisAngle4d;
            }, vector3d -> {
                integerArray[0] = integerArray[0] + 1;
                vector3dArray[0] = vector3d;
            });
            if (integerArray[0] != 3) {
                throw new RuntimeException();
            }
            n = GeomRenderer.addXform(fDSTransform, TransformUtil.scale(vector3dArray2[0].x, vector3dArray2[0].y, vector3dArray2[0].z), n);
            n = GeomRenderer.addXform(fDSTransform, TransformUtil.rotate(axisAngle4dArray[0]), n);
            n = GeomRenderer.addXform(fDSTransform, TransformUtil.translate(vector3dArray[0].x, vector3dArray[0].y, vector3dArray[0].z), n);
            return n;
        }
        throw new RuntimeException();
    }

    private static FDSTransform getFDSTransform(TransformInfo transformInfo) {
        if (transformInfo.isIdentity()) {
            return FDS_IDENTITY;
        }
        try {
            FDSTransform fDSTransform = new FDSTransform();
            Integer[] integerArray = new Integer[]{0};
            TransformUtil.iterateFirstToLast(transformInfo.xform.optimize(), iTransform -> {
                integerArray[0] = GeomRenderer.addXform(fDSTransform, iTransform, integerArray[0]);
            });
            return fDSTransform;
        }
        catch (Throwable throwable) {
            if (transformInfo.xform instanceof MatrixXform) {
                System.err.println("Non-standard transform");
                return null;
            }
            Matrix4d matrix4d = transformInfo.xform.toMatrix(false);
            return GeomRenderer.getFDSTransform(new MatrixXform(matrix4d).getInfo());
        }
    }

    private Pair<FDSRenderRecord, RasterizeGeom> constructGeomRecords(IObstruction iObstruction, IGeomNode iGeomNode, List<Surface> list, List<Color> list2) {
        List<Surface> list3 = GeomRenderer.optimizeSurfList(list);
        Pair<FDSRenderRecord, RasterizeGeom> pair = this.d_ri.geomNodeRecords.get(new Pair<IGeomNode, List<Surface>>(iGeomNode, list3));
        if (pair != null) {
            return pair;
        }
        FDSTransform fDSTransform = GeomRenderer.getFDSTransform(iGeomNode.getLocalTransform().getInfo());
        if (fDSTransform == null) {
            iGeomNode = iGeomNode.flatten();
            fDSTransform = FDS_IDENTITY;
        }
        ArrayList<FDSRenderRecord> arrayList = new ArrayList<FDSRenderRecord>();
        RasterizeGeom rasterizeGeom = new RasterizeGeom(iGeomNode.getLocalTransform().getInfo());
        IGeom iGeom = iGeomNode.getLocalGeom();
        int n = iGeom.getNumPrims(7);
        Pair<FDSRenderRecord, RasterizeGeom> pair2 = this.constructGeomRecords(iObstruction, iGeom, list.subList(0, n), list2.subList(0, n));
        if (pair2.v1 != null) {
            arrayList.add((FDSRenderRecord)pair2.v1);
        }
        if (pair2.v2 != null) {
            rasterizeGeom.add((RasterizeGeom)pair2.v2);
        }
        int n2 = n;
        for (IGeomNode object2 : iGeomNode.getChildren()) {
            int n3 = object2.getNumPrims(7);
            Pair<FDSRenderRecord, RasterizeGeom> pair3 = this.constructGeomRecords(iObstruction, object2, list.subList(n2, n2 + n3), list2.subList(n2, n2 + n3));
            if (pair3.v1 != null) {
                arrayList.add((FDSRenderRecord)pair3.v1);
            }
            if (pair3.v2 != null) {
                rasterizeGeom.add((RasterizeGeom)pair3.v2);
            }
            n2 += n3;
        }
        Object object = null;
        if (!arrayList.isEmpty()) {
            if (arrayList.size() == 1 && iGeomNode.getLocalTransform().isIdentity()) {
                this.generateName(iObstruction, (FDSRenderRecord)arrayList.get(0));
                object = (FDSRenderRecord)arrayList.get(0);
            } else {
                String string = this.nextName(iObstruction.getName());
                object = this.newRec(string, iObstruction, arrayList);
                ((FDSRecord)object).setValue("ID", string);
                ((FDSRecord)object).setValue("SCALE", new FDSArray<Double>(fDSTransform.scale), false);
                ((FDSRecord)object).setValue("GAXIS", new FDSArray<Double>(fDSTransform.gaxis), false);
                ((FDSRecord)object).setValue("GROTATE", fDSTransform.grotate, false);
                ((FDSRecord)object).setValue("XYZ", new FDSArray<UnitDouble>(fDSTransform.xyz), false);
            }
        }
        this.d_ri.geomNodeRecords.put(new Pair<IGeomNode, List<Surface>>(iGeomNode, list3), new Pair<Iterator<? extends IGeomNode>, RasterizeGeom>((Iterator<? extends IGeomNode>)object, rasterizeGeom));
        return new Pair<Object, RasterizeGeom>(object, rasterizeGeom);
    }

    private String nextName(String string) {
        return this.d_ri.nameMap.generateName("GEOM", string, 30);
    }

    private String generateName(IObstruction iObstruction, FDSRenderRecord fDSRenderRecord) {
        String string = fDSRenderRecord.getString("ID");
        if (string == null) {
            string = this.nextName(iObstruction.getName() + "_part");
            fDSRenderRecord.setValue("ID", string);
        }
        return string;
    }

    private List<String> generateNames(IObstruction iObstruction, Collection<FDSRenderRecord> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FDSRenderRecord fDSRenderRecord : collection) {
            arrayList.add(this.generateName(iObstruction, fDSRenderRecord));
        }
        return arrayList;
    }

    private Pair<FDSRenderRecord, RasterizeGeom> constructGeomRecords(IObstruction iObstruction, IGeom iGeom, List<Surface> list, List<Color> list2) {
        int n = iGeom.getNumPrims(7);
        if (n == 0) {
            return new Pair<Object, Object>(null, null);
        }
        List<Surface> list3 = GeomRenderer.optimizeSurfList(list);
        Pair<FDSRenderRecord, RasterizeGeom> pair = this.d_ri.geomRecords.get(new Pair<IGeom, List<Surface>>(iGeom, list3));
        if (pair != null) {
            return pair;
        }
        if (iGeom instanceof GeomGroup) {
            GeomGroup geomGroup = (GeomGroup)iGeom;
            RasterizeGeom rasterizeGeom = new RasterizeGeom(TransformUtil.IDENTITY_INFO);
            ArrayList<FDSRenderRecord> arrayList = new ArrayList<FDSRenderRecord>();
            int n2 = 0;
            for (IGeom iGeom2 : geomGroup.children) {
                int n3 = iGeom2.getNumPrims(7);
                Pair<FDSRenderRecord, RasterizeGeom> surface2 = this.constructGeomRecords(iObstruction, iGeom2, list.subList(n2, n2 + n3), list2.subList(n2, n2 + n3));
                if (surface2.v1 != null) {
                    arrayList.add((FDSRenderRecord)surface2.v1);
                }
                if (surface2.v2 != null) {
                    rasterizeGeom.add((RasterizeGeom)surface2.v2);
                }
                n2 += n3;
            }
            Object object = null;
            if (!arrayList.isEmpty()) {
                object = this.newRec(null, iObstruction, arrayList);
            }
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(iGeom, list3), new Pair<Object, RasterizeGeom>(object, rasterizeGeom));
            return new Pair<Object, RasterizeGeom>(object, rasterizeGeom);
        }
        if (iGeom.isShell()) {
            RasterizeGeom rasterizeGeom = new RasterizeGeom(n, TransformUtil.IDENTITY_INFO);
            rasterizeGeom.geoms.add(new Pair<TransformInfo, IGeom>(TransformUtil.IDENTITY_INFO, iGeom));
            rasterizeGeom.surfs.addAll(list);
            rasterizeGeom.colors.addAll(list2);
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(iGeom, list3), new Pair<Object, RasterizeGeom>(null, rasterizeGeom));
            return new Pair<Object, RasterizeGeom>(null, rasterizeGeom);
        }
        Iterator<Surface> iterator = list.iterator();
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList arrayList = new ArrayList();
        IFaceConsumer iFaceConsumer = (point3d, point3d2, point3d3, surface) -> {
            int n = GeomRenderer.indexOf(linkedHashMap, point3d);
            int n2 = GeomRenderer.indexOf(linkedHashMap, point3d2);
            int n3 = GeomRenderer.indexOf(linkedHashMap, point3d3);
            if (n == n2 || n == n3 || n2 == n3) {
                return;
            }
            arrayList.add(n);
            arrayList.add(n2);
            arrayList.add(n3);
            arrayList.add(GeomRenderer.indexOf(linkedIdentityHashMap, surface.getName()));
        };
        for (IPrimitive serializable2 : thunderheadeng.geometry.objs.GeomUtil.explodeToTypes(iGeom, 7)) {
            IManipulatable iManipulatable;
            Surface surface2 = iterator.next();
            if (!(serializable2 instanceof IFace)) continue;
            Serializable serializable = (IFace)serializable2;
            if (serializable instanceof Triangle) {
                iManipulatable = (Triangle)serializable2;
                iFaceConsumer.add(iManipulatable.p1, iManipulatable.p2, iManipulatable.p3, surface2);
                continue;
            }
            iManipulatable = serializable.triangulate(0.1);
            Point3d[] point3dArray = ((Mesh)iManipulatable).vertices;
            int[] nArray = ((Mesh)iManipulatable).indices;
            for (int i = 0; i < ((Mesh)iManipulatable).indices.length; i += 3) {
                iFaceConsumer.add(point3dArray[nArray[i + 0]], point3dArray[nArray[i + 1]], point3dArray[nArray[i + 2]], surface2);
            }
        }
        if (arrayList.isEmpty()) {
            this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(iGeom, list3), new Pair<Object, Object>(null, null));
            return new Pair<Object, Object>(null, null);
        }
        FDSRenderRecord fDSRenderRecord = this.newRec(null, iObstruction, Collections.emptyList());
        fDSRenderRecord.setValue("SURF_ID", new ArrayList(linkedIdentityHashMap.keySet()));
        ArrayList<Double> arrayList2 = new ArrayList<Double>(linkedHashMap.size() * 3);
        for (Serializable serializable : linkedHashMap.keySet()) {
            arrayList2.add(((Point3d)serializable).x);
            arrayList2.add(((Point3d)serializable).y);
            arrayList2.add(((Point3d)serializable).z);
        }
        fDSRenderRecord.setValue("VERTS", arrayList2);
        fDSRenderRecord.setValue("FACES", arrayList);
        this.d_ri.geomRecords.put(new Pair<IGeom, List<Surface>>(iGeom, list3), new Pair<Object, Object>(fDSRenderRecord, null));
        return new Pair<Object, Object>(fDSRenderRecord, null);
    }

    private FDSRenderRecord newRec(String string, IObstruction iObstruction, List<FDSRenderRecord> list) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("GEOM");
        this.d_ri.records.put(fDSRenderRecord, new RecordInfo(iObstruction, list));
        if (string != null) {
            fDSRenderRecord.setValue("ID", string);
        }
        if (!list.isEmpty()) {
            fDSRenderRecord.setValue("GEOM_IDS", this.generateNames(iObstruction, list));
        }
        for (FDSRenderRecord fDSRenderRecord2 : list) {
            this.d_ri.records.get((Object)fDSRenderRecord2).referencedBy.add(fDSRenderRecord);
        }
        return fDSRenderRecord;
    }

    private static List<Surface> optimizeSurfList(List<Surface> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        if (theUtil.isUniform(list)) {
            return Collections.singletonList(list.iterator().next());
        }
        return list;
    }

    private static <T> int indexOf(Map<T, Integer> map, T t) {
        Integer n = map.get(t);
        if (n == null) {
            n = map.size() + 1;
            map.put(t, n);
        }
        return n;
    }

    private static class RecordInfo {
        public boolean compOnly = true;
        public final IObstruction obst;
        public List<FDSRenderRecord> referencing;
        public final List<FDSRenderRecord> referencedBy = new ArrayList<FDSRenderRecord>();

        public RecordInfo(IObstruction iObstruction, List<FDSRenderRecord> list) {
            this.obst = iObstruction;
            this.referencing = list;
        }
    }

    private static class RenderInfo {
        public final FDSNameMap nameMap = new FDSNameMap();
        public final List<IObstruction> toRasterize = new ArrayList<IObstruction>();
        public final Map<Pair<IGeom, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>> geomRecords = new HashMap<Pair<IGeom, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>>();
        public final Map<Pair<IGeomNode, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>> geomNodeRecords = new HashMap<Pair<IGeomNode, List<Surface>>, Pair<FDSRenderRecord, RasterizeGeom>>();
        public final Map<FDSRenderRecord, RecordInfo> records = new LinkedIdentityHashMap<FDSRenderRecord, RecordInfo>();

        private RenderInfo() {
        }
    }

    private static class RasterizeGeom {
        public final List<Pair<TransformInfo, IGeom>> geoms = new ArrayList<Pair<TransformInfo, IGeom>>();
        public final List<Surface> surfs;
        public final List<Color> colors;
        public TransformInfo defti = TransformUtil.IDENTITY_INFO;

        public RasterizeGeom(TransformInfo transformInfo) {
            this.surfs = new ArrayList<Surface>();
            this.colors = new ArrayList<Color>();
            this.defti = transformInfo;
        }

        public RasterizeGeom(int n, TransformInfo transformInfo) {
            this.surfs = new ArrayList<Surface>(n);
            this.colors = new ArrayList<Color>(n);
            this.defti = transformInfo;
        }

        public boolean isEmpty() {
            return this.geoms.isEmpty();
        }

        public void add(RasterizeGeom rasterizeGeom) {
            this.add(this.defti, rasterizeGeom);
        }

        public void add(TransformInfo transformInfo, RasterizeGeom rasterizeGeom) {
            for (Pair<TransformInfo, IGeom> pair : rasterizeGeom.geoms) {
                this.geoms.add(new Pair(transformInfo.concatenate(((TransformInfo)pair.v1).xform), pair.v2));
            }
            this.surfs.addAll(rasterizeGeom.surfs);
            this.colors.addAll(rasterizeGeom.colors);
        }
    }

    private static interface IFaceConsumer {
        public void add(Point3d var1, Point3d var2, Point3d var3, Surface var4);
    }

    private static class FDSTransform {
        private static final UnitDouble ZERO = new UnitDouble(0.0, SI.METER);
        public Double[] scale = new Double[]{1.0, 1.0, 1.0};
        public Double[] gaxis = new Double[]{0.0, 0.0, 0.0};
        public UnitDouble grotate = new UnitDouble(0.0, NonSI.DEGREE_ANGLE);
        public UnitDouble[] xyz = new UnitDouble[]{ZERO, ZERO, ZERO};

        private FDSTransform() {
        }
    }
}

