/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;

public class FDSNameMap {
    private final Map<IPyroObject, String> d_objNameMap = new IdentityHashMap<IPyroObject, String>();
    private final Map<String, Set<String>> d_fdsTypeUsedNameMap = new HashMap<String, Set<String>>();

    public FDSNameMap() {
        HashSet hashSet = new HashSet();
        this.d_fdsTypeUsedNameMap.put("DEVC", hashSet);
        this.d_fdsTypeUsedNameMap.put("CTRL", hashSet);
    }

    public String mapToName(String string, INamed iNamed) {
        return this.mapToName(string, iNamed, iNamed.getName());
    }

    public String mapToName(String string, IPyroObject iPyroObject2, String string2) {
        return this.d_objNameMap.computeIfAbsent(iPyroObject2, iPyroObject -> this.generateName(string, string2));
    }

    public String generateName(String string, String string2) {
        return this.generateName(string, string2, Integer.MAX_VALUE);
    }

    public String generateName(String string, String string2, int n) {
        String string3;
        Set<String> set = this.d_fdsTypeUsedNameMap.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.d_fdsTypeUsedNameMap.put(string, set);
        }
        if (string2.length() > n) {
            string2 = string2.substring(0, n);
        }
        if (set.contains(string3 = string2)) {
            int n2 = 2;
            int n3 = 1;
            int n4 = 10;
            if (string2.length() + 1 > n) {
                string2 = string2.substring(0, n - 1);
            }
            while (!string2.isEmpty() && set.contains(string3)) {
                string3 = string2 + n2++;
                if (n2 < n4) continue;
                n4 *= 10;
                if (string2.length() + ++n3 <= n) continue;
                string2 = string2.substring(0, n - n3);
            }
        }
        set.add(string3);
        return string3;
    }

    @Test
    public void testDuplicateNames() {
        int n;
        FDSNameMap fDSNameMap = new FDSNameMap();
        Supplier<String> supplier = () -> fDSNameMap.generateName("rec", "abcd", 3);
        Assert.assertEquals((Object)"abc", (Object)supplier.get());
        Assert.assertEquals((Object)"ab2", (Object)supplier.get());
        Assert.assertEquals((Object)"ab3", (Object)supplier.get());
        Assert.assertEquals((Object)"ab4", (Object)supplier.get());
        Assert.assertEquals((Object)"ab5", (Object)supplier.get());
        Assert.assertEquals((Object)"ab6", (Object)supplier.get());
        Assert.assertEquals((Object)"ab7", (Object)supplier.get());
        Assert.assertEquals((Object)"ab8", (Object)supplier.get());
        Assert.assertEquals((Object)"ab9", (Object)supplier.get());
        Assert.assertEquals((Object)"a10", (Object)supplier.get());
        Assert.assertEquals((Object)"a11", (Object)supplier.get());
        Assert.assertEquals((Object)"a12", (Object)supplier.get());
        Assert.assertEquals((Object)"a13", (Object)supplier.get());
        for (n = 14; n < 50; ++n) {
            supplier.get();
        }
        Assert.assertEquals((Object)"a50", (Object)supplier.get());
        for (n = 51; n < 100; ++n) {
            supplier.get();
        }
        Assert.assertEquals((Object)"a99", (Object)supplier.get());
        Assert.assertEquals((Object)"a99", (Object)supplier.get());
        FDSNameMap fDSNameMap2 = new FDSNameMap();
        supplier = () -> fDSNameMap2.generateName("rec", "abcd");
        Assert.assertEquals((Object)"abcd", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd2", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd3", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd4", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd5", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd6", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd7", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd8", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd9", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd10", (Object)supplier.get());
        Assert.assertEquals((Object)"abcd11", (Object)supplier.get());
        for (int i = 12; i < 1456; ++i) {
            supplier.get();
        }
        Assert.assertEquals((Object)"abcd1456", (Object)supplier.get());
    }

    public String getName(IPyroObject iPyroObject) {
        String string = this.d_objNameMap.get(iPyroObject);
        assert (string != null);
        return string;
    }
}

