/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.rasterization.FDSRasterization;
import pyrosim.io.fds.FDSPrintRenderer;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.QuantityMap;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.BoundariesRenderer;
import pyrosim.io.fds.v6.renderers.ControlRenderer;
import pyrosim.io.fds.v6.renderers.DeviceRenderer;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.GeomRenderer;
import pyrosim.io.fds.v6.renderers.GridRenderer;
import pyrosim.io.fds.v6.renderers.HoleRenderer;
import pyrosim.io.fds.v6.renderers.HvacRenderer;
import pyrosim.io.fds.v6.renderers.IFDS6Renderer;
import pyrosim.io.fds.v6.renderers.IObstructionRenderer;
import pyrosim.io.fds.v6.renderers.InitRenderer;
import pyrosim.io.fds.v6.renderers.IsofRenderer;
import pyrosim.io.fds.v6.renderers.MaterialRenderer;
import pyrosim.io.fds.v6.renderers.ObstructionRenderer;
import pyrosim.io.fds.v6.renderers.PartCloudRenderer;
import pyrosim.io.fds.v6.renderers.ParticleRenderer;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.Plot3dRenderer;
import pyrosim.io.fds.v6.renderers.ProfRenderer;
import pyrosim.io.fds.v6.renderers.ReactionRenderer;
import pyrosim.io.fds.v6.renderers.SimParamsRenderer;
import pyrosim.io.fds.v6.renderers.SingletonRecords;
import pyrosim.io.fds.v6.renderers.SliceRenderer;
import pyrosim.io.fds.v6.renderers.StatisticsRenderer;
import pyrosim.io.fds.v6.renderers.SurfaceRenderer;
import pyrosim.io.fds.v6.renderers.VentRenderer;
import pyrosim.io.fds.v6.renderers.ZoneRenderer;
import thunderheadeng.image.IImage;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class FDS6Renderer
extends FDSRenderer {
    public FDS6Renderer(PyroMod pyroMod, FDSRenderProps fDSRenderProps) {
        super(pyroMod, fDSRenderProps);
    }

    public static List<? extends IFDS6Renderer> createRenderers(PyroMod pyroMod, IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection, Map<IImage, String> map) {
        QuantityMap quantityMap = new QuantityMap();
        FDSNameMap fDSNameMap = new FDSNameMap();
        PinConnectionRenderer pinConnectionRenderer = new PinConnectionRenderer(fDSNameMap);
        ExSpecRenderer exSpecRenderer = new ExSpecRenderer(fDSNameMap, pinConnectionRenderer);
        MaterialRenderer materialRenderer = new MaterialRenderer(fDSNameMap, pinConnectionRenderer);
        ControlRenderer controlRenderer = new ControlRenderer(fDSNameMap, pinConnectionRenderer);
        ZoneRenderer zoneRenderer = new ZoneRenderer();
        ArrayList<AFDS6Renderer> arrayList = new ArrayList<AFDS6Renderer>();
        arrayList.add(new SimParamsRenderer(quantityMap, fDSNameMap));
        arrayList.add(new Plot3dRenderer(quantityMap));
        arrayList.add(new GridRenderer());
        arrayList.add(zoneRenderer);
        arrayList.add(exSpecRenderer);
        arrayList.add(new ParticleRenderer(fDSNameMap, pinConnectionRenderer));
        arrayList.add(new ReactionRenderer());
        arrayList.add(controlRenderer);
        arrayList.add(new DeviceRenderer(fDSNameMap, pinConnectionRenderer, quantityMap, controlRenderer));
        arrayList.add(pinConnectionRenderer);
        arrayList.add(materialRenderer);
        arrayList.add(new SurfaceRenderer(fDSNameMap, exSpecRenderer, zoneRenderer, pinConnectionRenderer, map));
        arrayList.add(new PartCloudRenderer(fDSNameMap, pinConnectionRenderer));
        arrayList.add(new InitRenderer(exSpecRenderer, pinConnectionRenderer));
        FDSRasterization fDSRasterization = FDS6Renderer.createRasterization(pyroMod, iFDSRecordRenderer, collection);
        if (!pyroMod.getRastOptions().immersedBoundary) {
            arrayList.add(new ObstructionRenderer(fDSRasterization, pinConnectionRenderer));
        } else {
            arrayList.add(new GeomRenderer(fDSRasterization, pinConnectionRenderer));
        }
        arrayList.add(new HoleRenderer(fDSRasterization, pinConnectionRenderer));
        IdentityHashMap<Vent, String> identityHashMap = new IdentityHashMap<Vent, String>();
        arrayList.add(new VentRenderer(pinConnectionRenderer, fDSNameMap, exSpecRenderer, identityHashMap));
        arrayList.add(new HvacRenderer(fDSNameMap, pinConnectionRenderer, identityHashMap));
        arrayList.add(new BoundariesRenderer(quantityMap, fDSNameMap));
        arrayList.add(new IsofRenderer(quantityMap));
        arrayList.add(new ProfRenderer(quantityMap, materialRenderer));
        arrayList.add(new SliceRenderer(quantityMap));
        arrayList.add(new StatisticsRenderer(quantityMap, fDSNameMap));
        return arrayList;
    }

    public RenderResult renderFileForVersion(FDSRenderer.Filenames filenames, Collection<? extends IPyroObject> collection, DepSnapshot depSnapshot, FDSPrintRenderer fDSPrintRenderer, Map<IImage, String> map) throws IOException {
        PyroMod pyroMod = this.getModel();
        SingletonRecords singletonRecords = new SingletonRecords();
        singletonRecords.headRec.setValue("CHID", filenames.chid);
        singletonRecords.dumpRec.setValue("RENDER_FILE", filenames.ge1);
        fDSPrintRenderer.getWriter().println(filenames.fds);
        if (System.getProperty("minfds") == null) {
            fDSPrintRenderer.getWriter().println("Generated by PyroSim - Version 2018.3.1210");
            fDSPrintRenderer.getWriter().println(DateFormat.getDateTimeInstance().format(new Date()));
        }
        fDSPrintRenderer.getWriter().println();
        String string = pyroMod.getUnprocessedRecords();
        if (string != null && string.length() > 0) {
            fDSPrintRenderer.getWriter().println("-------------User Section (not generated by PyroSim)-------------");
            fDSPrintRenderer.getWriter().println();
            fDSPrintRenderer.getWriter().print(string);
            fDSPrintRenderer.getWriter().println();
            fDSPrintRenderer.getWriter().println();
            fDSPrintRenderer.getWriter().println("--------------------PyroSim-generated Section--------------------");
            fDSPrintRenderer.getWriter().println();
        }
        RenderResult renderResult = this.renderObjects(fDSPrintRenderer, collection, depSnapshot, singletonRecords, map);
        fDSPrintRenderer.getWriter().println();
        FDS6Renderer.printFileTail(fDSPrintRenderer);
        fDSPrintRenderer.getWriter().close();
        return renderResult;
    }

    @Override
    protected void renderFileForVersion(File file, Collection<? extends IPyroObject> collection, DepSnapshot depSnapshot) throws IOException {
        boolean bl;
        boolean bl2;
        boolean bl3;
        FDSRenderer.Filenames filenames = new FDSRenderer.Filenames(file);
        PyroMod pyroMod = this.getModel();
        LinkedHashSet<? extends IPyroObject> linkedHashSet = new LinkedHashSet<IPyroObject>(collection);
        linkedHashSet.addAll(depSnapshot.getAllDependedOn());
        Map<IImage, String> map = FDS6Renderer.copyImages(pyroMod.getAppearances(), filenames.dir, linkedHashSet);
        boolean bl4 = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1);
        if (bl4) {
            FDS6Renderer.writeGE1(filenames.dir, filenames.ge1, pyroMod, map);
        }
        if (bl3 = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS)) {
            FDS6Renderer.writeViews(filenames.dir, filenames.views, pyroMod.getViews());
        }
        if (bl2 = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEFLOORS)) {
            FDS6Renderer.writeFloors(filenames.dir, filenames.floors, pyroMod.getFloorManager());
        }
        if (bl = PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITESMVINI)) {
            FDS6Renderer.write(filenames.dir, filenames.ini, bl4, collection);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        FDSRenderProps fDSRenderProps = this.getProps();
        FDSPrintRenderer fDSPrintRenderer = new FDSPrintRenderer(printWriter, fDSRenderProps);
        RenderResult renderResult = this.renderFileForVersion(filenames, collection, depSnapshot, fDSPrintRenderer, map);
        Map<IObstruction, List<Integer>> map2 = Collections.emptyMap();
        Map<Vent, Integer> map3 = Collections.emptyMap();
        for (IFDS6Renderer iFDS6Renderer : renderResult.renderers) {
            if (iFDS6Renderer instanceof IObstructionRenderer) {
                map2 = ((IObstructionRenderer)iFDS6Renderer).getObstIxes();
                continue;
            }
            if (!(iFDS6Renderer instanceof VentRenderer)) continue;
            map3 = ((VentRenderer)iFDS6Renderer).getVentIxes();
        }
        if (PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM)) {
            boolean bl5 = fDSRenderProps.getLinkPyroGeom();
            FDS6Renderer.writeGeom(filenames.dir, filenames.geom, pyroMod, renderResult.allObjs, bl5, map2, map3, false);
        }
    }

    private static void printFileTail(IFDSRecordRenderer iFDSRecordRenderer) {
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("TAIL");
        iFDSRecordRenderer.render(fDSRenderRecord, null);
    }

    @Override
    public void renderObjects(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection, DepSnapshot depSnapshot, Map<IImage, String> map) {
        this.renderObjects(iFDSRecordRenderer, collection, depSnapshot, new SingletonRecords(), map);
    }

    protected RenderResult renderObjects(IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection, DepSnapshot depSnapshot, SingletonRecords singletonRecords, Map<IImage, String> map) {
        PyroMod pyroMod = this.getModel();
        ArrayList<? extends IPyroObject> arrayList = new ArrayList<IPyroObject>(collection);
        List<? extends IFDS6Renderer> list = FDS6Renderer.createRenderers(pyroMod, iFDSRecordRenderer, arrayList, map);
        LinkedIdentityHashSet linkedIdentityHashSet = new LinkedIdentityHashSet();
        IdentityHashSet identityHashSet = new IdentityHashSet();
        identityHashSet.addAll(depSnapshot.getAllDependedOn());
        identityHashSet.removeAll(arrayList);
        for (IFDS6Renderer iFDS6Renderer : list) {
            Iterator<IPyroObject> iterator = FDS6Renderer.filterColl(depSnapshot.getAllDependedOn(), iFDS6Renderer, false).iterator();
            while (iterator.hasNext()) {
                IPyroObject iPyroObject;
                boolean bl = !identityHashSet.contains(iPyroObject = iterator.next());
                boolean bl2 = iFDS6Renderer.markDependency(depSnapshot, iPyroObject, bl);
                if (!bl2 || bl) continue;
                linkedIdentityHashSet.add(iPyroObject);
            }
        }
        arrayList.addAll(linkedIdentityHashSet);
        iFDSRecordRenderer.props().pushProps();
        for (IFDS6Renderer iFDS6Renderer : list) {
            FDS6Renderer.fillSingletons(singletonRecords, iFDS6Renderer, arrayList);
        }
        for (FDSRenderRecord fDSRenderRecord : singletonRecords.allRecs) {
            if (fDSRenderRecord.empty()) continue;
            iFDSRecordRenderer.render(fDSRenderRecord, null);
        }
        iFDSRecordRenderer.renderEmptyLine();
        for (IFDS6Renderer iFDS6Renderer : list) {
            FDS6Renderer.renderRecords(iFDSRecordRenderer, iFDS6Renderer, arrayList);
        }
        iFDSRecordRenderer.props().popProps();
        return new RenderResult(arrayList, list);
    }

    private static void fillSingletons(SingletonRecords singletonRecords, IFDS6Renderer iFDS6Renderer, Collection<? extends IPyroObject> collection) {
        Collection<IPyroObject> collection2 = FDS6Renderer.filterColl(collection, iFDS6Renderer, false);
        if (!collection2.isEmpty()) {
            iFDS6Renderer.fillSingletonRecords(singletonRecords, collection2);
        }
    }

    private static void renderRecords(IFDSRecordRenderer iFDSRecordRenderer, IFDS6Renderer iFDS6Renderer, Collection<? extends IPyroObject> collection) {
        Collection<IPyroObject> collection2 = FDS6Renderer.filterColl(collection, iFDS6Renderer, true);
        if (!collection2.isEmpty() && iFDS6Renderer.render(iFDSRecordRenderer, collection2)) {
            iFDSRecordRenderer.renderEmptyLine();
        }
    }

    private static FDSRasterization createRasterization(PyroMod pyroMod, IFDSRecordRenderer iFDSRecordRenderer, Collection<? extends IPyroObject> collection) {
        FDSRasterization fDSRasterization = new FDSRasterization(pyroMod, (Collection)iFDSRecordRenderer.props().getRasterGridSupplier().apply(collection));
        return fDSRasterization;
    }

    private static Collection<IPyroObject> filterColl(Collection<? extends IPyroObject> collection, IFDS6Renderer iFDS6Renderer, boolean bl) {
        HashSet hashSet = new HashSet();
        iFDS6Renderer.getPyroTypes(hashSet);
        IFilteredCollection iFilteredCollection = theUtil.filter(collection, new TypeFilter(hashSet));
        if (bl) {
            return iFDS6Renderer.sortPyroObjects(iFilteredCollection);
        }
        return iFilteredCollection;
    }

    public static String getProperCHID(String string) {
        return FDSRenderer.getProperCHID(string, 40);
    }

    public static class RenderResult {
        public final Collection<? extends IPyroObject> allObjs;
        public final List<? extends IFDS6Renderer> renderers;

        public RenderResult(Collection<? extends IPyroObject> collection, List<? extends IFDS6Renderer> list) {
            this.allObjs = collection;
            this.renderers = list;
        }
    }
}

