/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.awt.Color;
import java.io.Serializable;
import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Exit;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class ExitRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Exit.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Grid grid;
        Grid grid2;
        Serializable serializable;
        Exit exit = (Exit)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("EXIT");
        fDSRenderRecord.setValue("ID", exit.getName());
        fDSRenderRecord.setValue("FYI", exit.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])exit.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        ExitRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        Boolean bl = (Boolean)exit.getProp("COUNT_ONLY");
        fDSRenderRecord.setValue("COUNT_ONLY", bl, false);
        Color color = (Color)exit.getProp("RGB");
        ExitRenderer.renderColor(fDSRenderRecord, true, color, "RGB", "COLOR", null);
        UnitDouble[] unitDoubleArray2 = (UnitDouble[])exit.getProp("XYZ");
        if (unitDoubleArray2 != null) {
            serializable = new UnitPoint3D(unitDoubleArray2[0], unitDoubleArray2[1], unitDoubleArray2[2]);
            AFDS6Renderer.renderLoc(fDSRenderRecord, "XYZ", (UnitPoint3D)serializable);
        }
        serializable = (Integer)exit.getProp("IOR");
        fDSRenderRecord.setValue("IOR", serializable, false);
        Grid grid3 = (Grid)exit.getProp("MESH_ID");
        if (grid3 != null) {
            fDSRenderRecord.setValue("MESH_ID", grid3.getName());
        }
        if ((grid2 = (Grid)exit.getProp("VENT_FFIELD")) != null) {
            fDSRenderRecord.setValue("VENT_FFIELD", grid2.getName());
        }
        if ((grid = (Grid)exit.getProp("FLOW_FIELD_ID")) != null) {
            fDSRenderRecord.setValue("FLOW_FIELD_ID", grid.getName());
        }
        UnitDouble unitDouble = (UnitDouble)exit.getProp("TIME_OPEN");
        fDSRenderRecord.setValue("TIME_OPEN", unitDouble);
        UnitDouble unitDouble2 = (UnitDouble)exit.getProp("TIME_CLOSE");
        fDSRenderRecord.setValue("TIME_CLOSE", unitDouble2);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

