/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import org.jscience.physics.units.Unit;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSRecordFormatException;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSStringRenderer;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.ParseTest;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.Util;
import pyrosim.io.fds.v6.renderers.ExSpecRenderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class ExSpecRendererTest
extends ParseTest {
    private FDSStringRenderer d_props;
    private ExSpecRenderer d_rend;

    public ExSpecRendererTest() {
        super(FDS6Const.getRecordSpecs());
    }

    public void setUp() throws Exception {
        super.setUp();
        FDSNameMap fDSNameMap = new FDSNameMap();
        PinConnectionRenderer pinConnectionRenderer = new PinConnectionRenderer(fDSNameMap);
        this.d_rend = new ExSpecRenderer(fDSNameMap, pinConnectionRenderer);
        this.d_props = new FDSStringRenderer(new FDSRenderProps());
    }

    public void test_predefinedSpecies() throws FDSRecordFormatException {
        ExSpec exSpec = new ExSpec("test", 0);
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        ExSpecRendererTest.assertEquals((String)"SPEC", (String)fDSParseRecord.getType());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "MW", "CONDUCTIVITY", "DIFFUSIVITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID");
        ExSpecRendererTest.assertEquals((String)"test", (String)fDSParseRecord.getString("ID"));
    }

    public void test_predefinedSpeciesInitMassFraction() throws FDSRecordFormatException {
        ExSpec exSpec = new ExSpec("test", 0);
        exSpec.setMassFrac0(0.3);
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MW", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID", "MASS_FRACTION_0");
        ExSpecRendererTest.assertEquals((double)0.3, (double)fDSParseRecord.getDouble("MASS_FRACTION_0"), (double)0.0);
    }

    public void test_predefinedSpeciesInitMassFractionDefault() throws FDSRecordFormatException {
        ExSpec exSpec = new ExSpec("test", 0);
        exSpec.setMassFrac0(0.0);
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "MW", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID");
    }

    public void test_predefinedSpeciesWithExtraStuffItDoesNotNeed() throws FDSRecordFormatException {
        Unit unit = SIUS.getInstance().getMolecularWeightUnit();
        ExSpec exSpec = new ExSpec("test", 0);
        exSpec.setMolecularWeight(new UnitDouble(1.2, unit));
        exSpec.getPrimParams().setSigmaLJ(0.2, true);
        exSpec.getPrimParams().setEpsilonKLJ(0.1, true);
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "MW", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID");
    }

    public void test_customSpecies() throws FDSRecordFormatException {
        ExSpec exSpec = new ExSpec("test", 1);
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "MW", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID");
    }

    public void test_customSpeciesWithMolWt() throws FDSRecordFormatException {
        Unit unit = SIUS.getInstance().getMolecularWeightUnit();
        ExSpec exSpec = new ExSpec("test", 1);
        exSpec.setMolecularWeight(new UnitDouble(10.0, unit));
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID", "MW");
        ExSpecRendererTest.assertEquals((Object)new UnitDouble(10.0, unit), (Object)fDSParseRecord.getUnitDouble("MW"));
    }

    public void test_customSpeciesWithDefaultMolWt() throws FDSRecordFormatException {
        Unit unit = SIUS.getInstance().getMolecularWeightUnit();
        ExSpec exSpec = new ExSpec("test", 1);
        exSpec.setMolecularWeight(new UnitDouble(29.0, unit));
        this.d_rend.render((IFDSRecordRenderer)this.d_props, (IPyroObject)exSpec);
        FDSParseRecord fDSParseRecord = this.parseRecord(this.d_props.toString());
        Util.assertNotDefined(fDSParseRecord, "MASS_FRACTION_0", "MW", "CONDUCTIVITY", "DIFFUSIVITY", "VISCOSITY", "SIGMALJ", "EPSILONKLJ");
        Util.assertDefined(fDSParseRecord, "ID");
    }
}

