/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.ReacByproducts;
import pyrosim.domain.boundcond.surf.SpecInjList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.variant.Variant;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import pyrosim.io.fds.v6.renderers.FDSNameMap;
import pyrosim.io.fds.v6.renderers.PinConnectionRenderer;
import pyrosim.io.fds.v6.renderers.RampRenderer;
import thunderheadeng.util.Lists;

public class ExSpecRenderer
extends AFDS6Renderer {
    private final FDSNameMap d_nameMap;
    private final PinConnectionRenderer d_pinConns;
    private boolean d_simpleReacDefined;
    private boolean d_complexReacDefined;
    private Map<ExSpec, Double> d_stoichiometryMap;
    private final List<ExSpec> d_requiresExplicit;
    private final List<ExSpec> d_lumpedComponentOnly;

    public ExSpecRenderer(FDSNameMap fDSNameMap, PinConnectionRenderer pinConnectionRenderer) {
        this.d_nameMap = fDSNameMap;
        this.d_pinConns = pinConnectionRenderer;
        this.d_simpleReacDefined = false;
        this.d_complexReacDefined = false;
        this.d_stoichiometryMap = new LinkedHashMap<ExSpec, Double>();
        this.d_requiresExplicit = new ArrayList<ExSpec>();
        this.d_lumpedComponentOnly = new ArrayList<ExSpec>();
    }

    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(ExSpec.class);
        set.add(Reaction.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        if (iPyroObject instanceof Reaction) {
            Reaction.ReacType reacType = ((Reaction)iPyroObject).getReacType();
            this.d_stoichiometryMap = ((Reaction)iPyroObject).getComplexStoichiometry();
            this.d_simpleReacDefined = reacType.equals((Object)Reaction.ReacType.SIMPLE);
            this.d_complexReacDefined = reacType.equals((Object)Reaction.ReacType.COMPLEX);
            return true;
        }
        ExSpec exSpec = (ExSpec)iPyroObject;
        if (exSpec.getType() == 4) {
            return false;
        }
        if (!ExSpecList.shouldRenderExplicit(exSpec, this.d_simpleReacDefined, this.d_complexReacDefined, this.d_requiresExplicit.contains(exSpec))) {
            return false;
        }
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("SPEC");
        fDSRenderRecord.setValue("ID", exSpec.getName());
        fDSRenderRecord.setValue("FYI", exSpec.getFYI(), false);
        fDSRenderRecord.setValue("MASS_FRACTION_0", exSpec.getMassFrac0(), false);
        fDSRenderRecord.setValue("BACKGROUND", exSpec.isBackgroundSpec(), false);
        if (exSpec.getType() == 1) {
            String string;
            Variant variant;
            if (exSpec.getWtType() == 2) {
                fDSRenderRecord.setValue("FORMULA", exSpec.getChemFormula());
            } else if (exSpec.getWtType() == 1) {
                fDSRenderRecord.setValue("MW", exSpec.getMolecularWeight(), false);
            }
            HashMap<String, Ramp> hashMap = new HashMap<String, Ramp>();
            ExSpec.PrimitiveParams primitiveParams = exSpec.getPrimParams();
            if (primitiveParams.isDiffusivitySet()) {
                variant = primitiveParams.getDiffusivity();
                if (variant.isConstant()) {
                    fDSRenderRecord.setValue("DIFFUSIVITY", variant.val, false);
                } else if (variant.isRamp()) {
                    string = RampRenderer.createID(this.d_nameMap, exSpec.getName(), "RAMP_D");
                    hashMap.put(string, (Ramp)variant.val);
                    fDSRenderRecord.setValue("RAMP_D", string, false);
                }
            }
            if (primitiveParams.isViscositySet()) {
                variant = primitiveParams.getViscosity();
                if (variant.isConstant()) {
                    fDSRenderRecord.setValue("VISCOSITY", variant.val, false);
                } else if (variant.isRamp()) {
                    string = RampRenderer.createID(this.d_nameMap, exSpec.getName(), "RAMP_MU");
                    hashMap.put(string, (Ramp)variant.val);
                    fDSRenderRecord.setValue("RAMP_MU", string, false);
                }
            }
            if (primitiveParams.isSigmaLJSet()) {
                fDSRenderRecord.setValue("SIGMALJ", primitiveParams.getSigmaLJ(), false);
            }
            if (primitiveParams.isEpsilonKLJSet()) {
                fDSRenderRecord.setValue("EPSILONKLJ", primitiveParams.getEpsilonKLJ(), false);
            }
            if (primitiveParams.getRadCalSurrogate().length() > 0) {
                fDSRenderRecord.setValue("RADCAL_ID", primitiveParams.getRadCalSurrogate(), false);
            }
            if (primitiveParams.isAerosol()) {
                fDSRenderRecord.setValue("AEROSOL", primitiveParams.isAerosol(), false);
                fDSRenderRecord.setValue("DENSITY_SOLID", primitiveParams.getDensitySolid(), false);
                fDSRenderRecord.setValue("CONDUCTIVITY_SOLID", primitiveParams.getConductivitySolid(), false);
                fDSRenderRecord.setValue("MEAN_DIAMETER", primitiveParams.getMeanDiameter(), false);
            }
            if (primitiveParams.isSpecHeatSet()) {
                variant = primitiveParams.getSpecHeat();
                if (variant.isConstant()) {
                    fDSRenderRecord.setValue("SPECIFIC_HEAT", variant.val, false);
                } else if (variant.isRamp()) {
                    string = RampRenderer.createID(this.d_nameMap, exSpec.getName(), "RAMP_CP");
                    hashMap.put(string, (Ramp)variant.val);
                    fDSRenderRecord.setValue("RAMP_CP", string, false);
                }
            }
            if (primitiveParams.isRefTempSet()) {
                fDSRenderRecord.setValue("REFERENCE_TEMPERATURE", primitiveParams.getRefTemp(), false);
            }
            if (primitiveParams.isRefEnthalpySet()) {
                assert (primitiveParams.getRefEnthalpy().isConstant());
                fDSRenderRecord.setValue("REFERENCE_ENTHALPY", primitiveParams.getRefEnthalpy().val, false);
            }
            if (primitiveParams.isDensityLiquidSet()) {
                assert (primitiveParams.getDensityLiquid().isConstant());
                fDSRenderRecord.setValue("DENSITY_LIQUID", primitiveParams.getDensityLiquid().val, false);
            }
            if (primitiveParams.isSpecHeatLiquidSet()) {
                variant = primitiveParams.getSpecHeatLiquid();
                if (variant.isConstant()) {
                    fDSRenderRecord.setValue("SPECIFIC_HEAT_LIQUID", variant.val, false);
                } else if (variant.isRamp()) {
                    string = RampRenderer.createID(this.d_nameMap, exSpec.getName(), "RAMP_CP_L");
                    hashMap.put(string, (Ramp)variant.val);
                    fDSRenderRecord.setValue("RAMP_CP_L", string, false);
                }
            }
            if (primitiveParams.isVapTempSet()) {
                assert (primitiveParams.getVapTemp().isConstant());
                fDSRenderRecord.setValue("VAPORIZATION_TEMPERATURE", primitiveParams.getVapTemp().val, false);
            }
            if (primitiveParams.isMeltingTempSet()) {
                assert (primitiveParams.getMeltTemp().isConstant());
                fDSRenderRecord.setValue("MELTING_TEMPERATURE", primitiveParams.getMeltTemp().val, false);
            }
            if (primitiveParams.isHoVaporizationSet()) {
                assert (primitiveParams.getHoVaporization().isConstant());
                fDSRenderRecord.setValue("HEAT_OF_VAPORIZATION", primitiveParams.getHoVaporization().val, false);
            }
            if (primitiveParams.isEoFormationSet()) {
                assert (primitiveParams.getEoFormation().isConstant());
                fDSRenderRecord.setValue("ENTHALPY_OF_FORMATION", primitiveParams.getEoFormation().val, false);
            }
            if (primitiveParams.isHVRefTempSet()) {
                assert (primitiveParams.getHVRefTemp().isConstant());
                fDSRenderRecord.setValue("H_V_REFERENCE_TEMPERATURE", primitiveParams.getHVRefTemp().val, false);
            }
            RampRenderer.render(iFDSRecordRenderer, hashMap, this.d_pinConns);
        } else if (exSpec.getType() == 2 || exSpec.getType() == 3) {
            int n = exSpec.getComposition().entrySet().size();
            List<Object> list = Lists.filled(n, null);
            List<Object> list2 = Lists.filled(n, null);
            int n2 = 0;
            for (Map.Entry<ExSpec, Double> entry : exSpec.getComposition().entrySet()) {
                list.set(n2, entry.getKey().getName());
                list2.set(n2, entry.getValue());
                ++n2;
            }
            fDSRenderRecord.setValue("SPEC_ID", list, false);
            if (exSpec.getType() == 2) {
                fDSRenderRecord.setValue("MASS_FRACTION", list2, false);
            } else {
                fDSRenderRecord.setValue("VOLUME_FRACTION", list2, false);
            }
        }
        boolean bl = false;
        if (exSpec.getLumpedComponentOnlyRule().equals((Object)ExSpec.LUMPED_RULE.AUTO)) {
            if (this.d_simpleReacDefined || this.d_complexReacDefined) {
                bl = this.isLumpedCompOnly_auto(exSpec);
            }
        } else if (exSpec.getLumpedComponentOnlyRule().equals((Object)ExSpec.LUMPED_RULE.TRUE)) {
            bl = true;
        }
        fDSRenderRecord.setValue("LUMPED_COMPONENT_ONLY", bl, false);
        ExSpecRenderer.renderCustomFDSProps(fDSRenderRecord, exSpec);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }

    private boolean isLumpedCompOnly_auto(ExSpec exSpec) {
        boolean bl;
        boolean bl2 = exSpec.getType() == 0 || exSpec.getType() == 1;
        boolean bl3 = this.d_lumpedComponentOnly.contains(exSpec);
        boolean bl4 = exSpec.getCustomFDSProps().isEmpty();
        boolean bl5 = ExSpecList.LUMPED_AIR_COMPS.contains(exSpec.getName());
        boolean bl6 = ExSpecList.LUMPED_PRODUCT_COMPS.contains(exSpec.getName());
        boolean bl7 = bl5 || bl6;
        boolean bl8 = bl = this.d_complexReacDefined && this.d_stoichiometryMap.containsKey(exSpec);
        if (bl || exSpec.isBackgroundSpec()) {
            return false;
        }
        if (bl3 && bl2 && bl4) {
            return true;
        }
        if (!this.d_requiresExplicit.contains(exSpec) && exSpec.getMassFrac0() <= 0.0) {
            if (this.d_simpleReacDefined && bl7 && bl4) {
                return true;
            }
            if (bl5 && bl4) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean markDependency(DepSnapshot depSnapshot, IPyroObject iPyroObject, boolean bl) {
        if (!(iPyroObject instanceof ExSpec)) {
            return false;
        }
        ExSpec exSpec = (ExSpec)iPyroObject;
        if (exSpec.getMassFrac0() > 0.0) {
            return true;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (Dependency dependency : depSnapshot.getDependents(iPyroObject)) {
            if (dependency.source instanceof Reaction) {
                if (((Reaction)dependency.source).getReacType().equals((Object)Reaction.ReacType.SIMPLE)) {
                    if (!ExSpecList.equalsPredefinedSpecies(exSpec) || !((Reaction)dependency.source).isActive()) continue;
                    return false;
                }
                if (!((Reaction)dependency.source).isActive()) continue;
                bl2 = true;
                continue;
            }
            if (dependency.source instanceof Particle || dependency.source instanceof HvacFilter || dependency.source instanceof ReacByproducts || dependency.source instanceof SpecInjList || dependency.source instanceof InitRegion || dependency.source instanceof SmokeDetector) {
                bl3 = true;
                bl2 = true;
                continue;
            }
            if (dependency.source instanceof ExSpec) {
                bl4 = true;
                bl2 = true;
                continue;
            }
            bl2 = true;
        }
        if (bl3) {
            this.d_requiresExplicit.add(exSpec);
        } else if (bl4) {
            this.d_lumpedComponentOnly.add(exSpec);
        }
        return bl2;
    }

    @Override
    public Collection<IPyroObject> sortPyroObjects(Collection<IPyroObject> collection) {
        if (collection.isEmpty()) {
            return collection;
        }
        ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>(collection);
        Collections.sort(arrayList, (iPyroObject, iPyroObject2) -> {
            if (iPyroObject instanceof Reaction && iPyroObject2 instanceof Reaction) {
                return Integer.compare(System.identityHashCode(iPyroObject), System.identityHashCode(iPyroObject2));
            }
            if (iPyroObject instanceof Reaction && iPyroObject2 instanceof ExSpec) {
                return -1;
            }
            if (iPyroObject instanceof ExSpec && iPyroObject2 instanceof Reaction) {
                return 1;
            }
            if (iPyroObject instanceof ExSpec && iPyroObject2 instanceof ExSpec) {
                return ((ExSpec)iPyroObject).compareTo((ExSpec)iPyroObject2);
            }
            return 0;
        });
        return arrayList;
    }
}

