/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Evss;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvssRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Evss.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Evss evss = (Evss)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("EVSS");
        fDSRenderRecord.setValue("ID", evss.getName());
        fDSRenderRecord.setValue("FYI", evss.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])evss.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        EvssRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        fDSRenderRecord.setValue("IOR", evss.getProp("IOR"), false);
        Grid grid = (Grid)evss.getProp("MESH_ID");
        if (grid != null) {
            fDSRenderRecord.setValue("MESH_ID", grid.getName());
        }
        fDSRenderRecord.setValue("HEIGHT", evss.getProp("HEIGHT"), false);
        fDSRenderRecord.setValue("HEIGHT0", evss.getProp("HEIGHT0"), false);
        fDSRenderRecord.setValue("FAC_V0_UP", evss.getProp("FAC_V0_UP"), false);
        fDSRenderRecord.setValue("FAC_V0_DOWN", evss.getProp("FAC_V0_DOWN"), false);
        fDSRenderRecord.setValue("FAC_V0_HORI", evss.getProp("FAC_V0_HORI"), false);
        fDSRenderRecord.setValue("ESC_SPEED", evss.getProp("ESC_SPEED"), false);
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

