/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.io.fds.v6.renderers;

import java.util.Set;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.evac.Evac;
import pyrosim.domain.evac.Evho;
import pyrosim.domain.evac.Pers;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.IFDSRecordRenderer;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.renderers.AFDS6Renderer;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class EvhoRenderer
extends AFDS6Renderer {
    @Override
    public void getPyroTypes(Set<Class<? extends IPyroObject>> set) {
        set.add(Evho.class);
    }

    @Override
    public boolean render(IFDSRecordRenderer iFDSRecordRenderer, IPyroObject iPyroObject) {
        Evac evac;
        Pers pers;
        Evho evho = (Evho)iPyroObject;
        FDSRenderRecord fDSRenderRecord = FDS6Const.newRenderRecord("EVHO");
        fDSRenderRecord.setValue("ID", evho.getName());
        fDSRenderRecord.setValue("FYI", evho.getProp("FYI"), false);
        UnitDouble[] unitDoubleArray = (UnitDouble[])evho.getProp("XB");
        UnitAABox unitAABox = new UnitAABox(new UnitPoint3D(unitDoubleArray[0], unitDoubleArray[2], unitDoubleArray[4]), new UnitPoint3D(unitDoubleArray[1], unitDoubleArray[3], unitDoubleArray[5]));
        EvhoRenderer.renderXB(fDSRenderRecord, "XB", unitAABox.getMin(), unitAABox.getMax());
        Grid grid = (Grid)evho.getProp("MESH_ID");
        if (grid != null) {
            fDSRenderRecord.setValue("MESH_ID", grid.getName());
        }
        if ((pers = (Pers)evho.getProp("PERS_ID")) != null) {
            fDSRenderRecord.setValue("PERS_ID", pers.getName());
        }
        if ((evac = (Evac)evho.getProp("EVAC_ID")) != null) {
            fDSRenderRecord.setValue("EVAC_ID", evac.getName());
        }
        iFDSRecordRenderer.render(fDSRenderRecord, iPyroObject);
        return true;
    }
}

